<?php
use Carbon\Carbon;

function humanReadableTime($datetime)
{
    $carbonDate = Carbon::parse($datetime);
    $now = Carbon::now();

    $diffInSeconds = $now->diffInSeconds($carbonDate);
    $diffInMinutes = $now->diffInMinutes($carbonDate);
    $diffInHours = $now->diffInHours($carbonDate);
    $diffInDays = $now->diffInDays($carbonDate);
    $diffInYears = $now->diffInYears($carbonDate);

    if ($diffInSeconds < 60) {
        return $diffInSeconds . 's';
    } elseif ($diffInMinutes < 60) {
        return $diffInMinutes . 'm';
    } elseif ($diffInHours < 24) {
        return $diffInHours . 'hr';
    } elseif ($diffInDays < 365) {
        return $diffInDays . 'd';
    } else {
        return $diffInYears . 'y';
    }
}