<?php

namespace App\Http\Controllers;
use DB;
use App\Quotation;
use Illuminate\Http\Request;
use App\Patients;
use App\Doctors;
use Session;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Csv;
use Symfony\Component\HttpFoundation\Response;
use App\Questionnaire;
use Illuminate\Support\Facades\Auth;
use Redirect;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
//use Illuminate\Support\Facades\Response;
use PDF;
use Mpdf\Mpdf;
use Illuminate\Support\Facades\Hash;
use ZipArchive;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
class AccountController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth')->except('viewPoByLink');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    
    public function purchaseOrder(Request $request)
    {
        if(Auth::user()->perm_accounts==0){
            abort(403);
        }
        
        $suppliers = DB::table('customers')->where('type', 'supplier')->get();
        $projects = DB::table('projects as a')
        ->leftJoin('customers as b', 'a.customer_id', '=', 'b.id')
        ->leftJoin('project_statuses as c', 'a.project_status', '=', 'c.id')
        ->leftJoin('project_types as d', 'a.project_type', '=', 'd.id')
        ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type', 'b.address_1',)
        ->orderBy('a.id', 'desc')
        ->get();
        
        
        
        return view('account.purchase_order', ['suppliers' => $suppliers, 'projects'=>$projects]);
    }
    
    
    public function purchaseOrderList(Request $request)
    {
        if(Auth::user()->perm_accounts==0){
            abort(403);
        }
        
        $purchase_orders = DB::table('accounts_purchase_orders as a')
        ->leftJoin('customers as b', 'a.supplier_id', '=', 'b.id')
        ->leftJoin('supplier_invoices as c', 'a.supplier_invoice_id', '=', 'c.id')
        ->select('a.*', 'b.company_name', 'c.date as invoice_date')
        ->orderBy('a.id', 'desc')
        ->get();
        
        foreach($purchase_orders as $po){
            $sales_total = 0;
            $vat_total = 0;
            
            $po_items = DB::table('accounts_purchase_order_items')
            ->where('po_id', $po->id)
            ->get();
            
            foreach($po_items as $item){
                $plant = $item->plant;
                $labour = $item->labour;
                $material = $item->material;
                $sc_total = $item->sc_total;
                $sales_total += $plant+$labour+$material+$sc_total;
            }
            
            $po->total_net = $sales_total;
        }
        
        
        return view('account.purchase_order_list', ['purchase_orders' => $purchase_orders]);
    }
    
    
    public function supplierInvoices(Request $request)
    {
        if(Auth::user()->perm_accounts==0){
            abort(403);
        }
        
        $suppliers = DB::table('customers')
            ->where('type', 'supplier')
            ->get();
        
        $nominalCodes = DB::table('nominal_codes')->get();
        
        return view('account.supplier_invoices', ['suppliers' => $suppliers, 'nominal_codes' => $nominalCodes]);
    }
    
    public function showTransferPurchase(Request $request)
    {
        if(Auth::user()->perm_accounts==0){
            abort(403);
        }
        
        $invoices = DB::table('supplier_invoices as a')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->select('a.*', 'b.company_name')
            ->where('transferred', 0)
            ->orderBy('id', 'desc')
            ->get();
        
        $archived = DB::table('supplier_invoices as a')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->select('a.*', 'b.company_name')
            ->where('transferred', 1)
            ->orderBy('id', 'desc')
            ->get();
        
        return view('account.transfer_purchase', ['invoices' => $invoices, 'archived'=>$archived]);
    }
    
    
    public function showTransferSales(Request $request)
    {
        if(Auth::user()->perm_accounts==0){
            abort(403);
        }
        
        $invoices = DB::table('project_invoices as a')
            ->select('a.*', 'c.company_name')
            ->leftjoin('projects as b', 'a.project_id', '=', 'b.id')
            ->leftjoin('customers as c', 'b.customer_id', '=', 'c.id')
            ->where('a.transferred', 0)
            ->orderBy('a.id', 'desc')
            ->get();
        
        $archived = DB::table('project_invoices as a')
            ->select('a.*', 'c.company_name')
            ->leftjoin('projects as b', 'a.project_id', '=', 'b.id')
            ->leftjoin('customers as c', 'b.customer_id', '=', 'c.id')
            ->where('a.transferred', 1)
            ->orderBy('a.id', 'desc')
            ->get();
        
        
        return view('account.transfer_sales', ['invoices' => $invoices, 'archived' => $archived]);
    }
    
    
    public function transferPurchase(Request $request)
    {
        if(Auth::user()->perm_accounts==0){
            abort(403);
        }
        
        $request->validate([
            'invoices' => 'required|array',
        ]);
        
        //$list[] = array('Type', 'Account Reference', 'Nominal A/C Ref', 'Date', 'Reference', 'Details', 'Net Amount', 'Tax Code', 'Tax Amount');
        
        
        $tpid = DB::table('transfer_purchases')->insertGetId([
            'date'   =>   date('Y-m-d H:i'),
        ]);
        
        
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // Set headers
        $sheet->setCellValue('A1', 'Type');
        $sheet->setCellValue('B1', 'Account Reference');
        $sheet->setCellValue('C1', 'Nominal A/C Ref');
        $sheet->setCellValue('D1', 'Date');
        $sheet->setCellValue('E1', 'Reference');
        $sheet->setCellValue('F1', 'Details');
        $sheet->setCellValue('G1', 'Net Amount');
        $sheet->setCellValue('H1', 'Tax Code');
        $sheet->setCellValue('I1', 'Tax Amount');
        
        $row = 2;
        
        foreach($request->invoices as $invoiceid){
            
            DB::table('supplier_invoices')
                ->where('id', $invoiceid)
                ->update(
                 array(
                        'transferred'   =>   1,
                        'transfer_date'   =>   date('Y-m-d H:i'),
                        'tp_id' => $tpid,
                 )
            );
            
            $invoice = DB::table('supplier_invoices')->where('id', $invoiceid)->first();
            $invoice_items = DB::table('supplier_invoice_items')->where('supplier_invoice_id', $invoiceid)->get();
            //$supplier = DB::table('customers')->where('id', $invoice->supplier_id)->first();
            foreach($invoice_items as $item){
                
                $nominalCode = explode(' - ', $item->nominal_code);
                $taxCode = explode(' - ', $item->tax_code);
                $date = date('d/m/Y', strtotime($invoice->date));
                
                $list[] = array('PI', $invoice->account_ref, $nominalCode[0], $date, $invoice->invoice_no, $item->description, number_format($item->net_amount, 2), $taxCode[0], number_format($item->vat_amount, 2));
                
                $sheet->setCellValue('A' . $row, 'PI');
                $sheet->setCellValue('B' . $row, $invoice->account_ref);
                $sheet->setCellValue('C' . $row, $nominalCode[0]);
                $sheet->setCellValue('D' . $row, $date);
                $sheet->setCellValue('E' . $row, $invoice->invoice_no);
                $sheet->setCellValue('F' . $row, $item->description);
                $sheet->setCellValue('G' . $row, round($item->net_amount, 2));
                $sheet->setCellValue('H' . $row, $taxCode[0]);
                $sheet->setCellValue('I' . $row, round($item->vat_amount, 2));
                $row++;
            }
        }
        
        if(empty($list)){
            $request->session()->flash('danger', 'Error, No items found in selected invoices.');
            return redirect()->back();
        }
        
        $writer = new Csv($spreadsheet);
        $writer->setDelimiter(',');
        $writer->setEnclosure('');
        $writer->setLineEnding("\r\n");

        // Output to browser for download
        $filename = "PurchaseTransfer-".str_pad($tpid, 5, '0', STR_PAD_LEFT).".csv";
        $response = new Response();
        $response->headers->set('Content-Type', 'application/csv');
        $response->headers->set('Content-Disposition', 'attachment;filename="' . $filename . '"');
        $response->headers->set('Cache-Control', 'max-age=0');

        // Capture output
        ob_start();
        $writer->save('php://output');
        $content = ob_get_clean();
        $response->setContent($content);

        return $response;
        
        die();
    }
    
    
    
    public function transferSales(Request $request)
    {
        if(Auth::user()->perm_accounts==0){
            abort(403);
        }
        
        $request->validate([
            'invoices' => 'required|array',
        ]);
        
        
        $tsid = DB::table('transfer_sales')->insertGetId([
            'date'   =>   date('Y-m-d H:i'),
        ]);
        
        
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // Set headers
        $sheet->setCellValue('A1', 'Type');
        $sheet->setCellValue('B1', 'Account Reference');
        $sheet->setCellValue('C1', 'Nominal A/C Ref');
        $sheet->setCellValue('D1', 'Date');
        $sheet->setCellValue('E1', 'Reference');
        $sheet->setCellValue('F1', 'Details');
        $sheet->setCellValue('G1', 'Net Amount');
        $sheet->setCellValue('H1', 'Tax Code');
        $sheet->setCellValue('I1', 'Tax Amount');
        
        $row = 2;
        
        foreach($request->invoices as $invoiceid){
            
            DB::table('project_invoices')->where('id', $invoiceid)->update([
                'transferred'   =>   1,
                'transfer_date'   =>   date('Y-m-d H:i'),
                'ts_id' => $tsid,
            ]);
            
            $invoice_data =  DB::table('project_invoices')->where('id', $invoiceid)->first();
            $project = DB::table('projects')->where('id', $invoice_data->project_id)->first();
            $customer = DB::table('customers')->where('id', $project->customer_id)->first();
            
            $invoice_items = DB::table('project_invoice_items as a')
                ->select('b.*')
                ->leftjoin('project_financials as b', 'a.item_id', '=', 'b.id')
                ->orderBy('a.id', 'desc')
                ->where('a.invoice_id', $invoiceid)
                ->get();
            
            foreach($invoice_items as $item){
                
                $nominalCode = 4000;
                $taxCode = 'T1';
                $date = date('d/m/Y', strtotime($invoice_data->created_at));
                
                $plant = $item->plant*$item->quantity;
                $labour = $item->labour*$item->quantity;
                $material = $item->material*$item->quantity;
                $sales_net = $plant+$labour+$material;
                $vat = $sales_net * 0.20;
                
                $invoice_no = 'WGI-'.str_pad($invoiceid, 4, '0', STR_PAD_LEFT);
                
                $sheet->setCellValue('A' . $row, 'SI');
                $sheet->setCellValue('B' . $row, $customer->account_no);
                $sheet->setCellValue('C' . $row, $nominalCode);
                $sheet->setCellValue('D' . $row, $date);
                $sheet->setCellValue('E' . $row, $invoice_no);
                $sheet->setCellValue('F' . $row, str_replace(",", ".", $item->description));
                $sheet->setCellValue('G' . $row, round($sales_net, 2));
                $sheet->setCellValue('H' . $row, $taxCode);
                $sheet->setCellValue('I' . $row, round($vat, 2));
                $row++;
            }
        }
        
        /*if(empty($list)){
            $request->session()->flash('danger', 'Error, No items found in selected invoices.');
            return redirect()->back();
        }*/
        
        $writer = new Csv($spreadsheet);
        $writer->setDelimiter(',');
        $writer->setEnclosure('');
        $writer->setLineEnding("\r\n");

        // Output to browser for download
        $filename = "SalesTransfer-".str_pad($tsid, 5, '0', STR_PAD_LEFT).".csv";
        $response = new Response();
        $response->headers->set('Content-Type', 'application/csv');
        $response->headers->set('Content-Disposition', 'attachment;filename="' . $filename . '"');
        $response->headers->set('Cache-Control', 'max-age=0');

        // Capture output
        ob_start();
        $writer->save('php://output');
        $content = ob_get_clean();
        $response->setContent($content);

        return $response;
        
        die();
    }
    
    
    
    public function subContractsList(Request $request)
    {
        if(Auth::user()->perm_accounts==0){
            abort(403);
        }
        
        $sub_contracts = DB::table('sub_contract_quotes as a')
            ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
            ->leftjoin('customers as c', 'a.supplier_id', '=', 'c.id')
            ->select('b.title', 'a.*', 'b.notes', 'c.company_name', 'b.id as sc_id')
            ->where('a.accepted', 1)
            ->get();
        
        return view('account.sub_contracts_list', ['sub_contracts' => $sub_contracts]);
    }
    
    
    public function updatePurchaseOrder(Request $request, $id)
    {
        /*$request->validate([
            'receipt_photo' => 'required|mimes:jpeg,png,jpg,gif|max:3072',
        ]);*/

        
        $response = array();
        
        //$project = DB::table('projects')->where('id', $id)->first();
        //$idArray = explode(',', $request->po_items);
        
        DB::table('accounts_purchase_orders')
            ->where('id', $id)
            ->update(
             array(
                    'supplier_id'   =>   $request->supplier_id,
                    'delivery_date'   =>   $request->delivery_date,
                    'address'   =>   $request->address,
                    'city'   =>   $request->city,
                    'postcode'   =>   $request->postal_code,
             )
        );
        
        
        $request->session()->flash('success', 'Purchase order updated successfully.');
        return redirect()->back();
    }
    
    
    public function deletePoItem(Request $request, $po_id)
    {
        if(Auth::user()->perm_accounts==0){
            abort(403);
        }
        
        DB::table('accounts_purchase_order_items')
            ->where('id', $request->delete_id)
            ->where('po_id', $po_id)
            ->delete();
        $request->session()->flash('success', 'Item removed successfully.');
        return redirect()->back();
    }
    
    public function deletePO(Request $request)
    {
        if(Auth::user()->perm_accounts==0){
            abort(403);
        }
        
        DB::table('accounts_purchase_orders')
            ->where('id', $request->delete_id)
            ->delete();
        
        DB::table('accounts_purchase_order_items')
            ->where('po_id', $request->delete_id)
            ->delete();
        return redirect()->route('accounts.purchaseOrderList')->with('success', 'Purchase order removed successfully.');
    }
    
    
    public function supplierInvoiceDetails(Request $request, $id)
    {
        if(Auth::user()->perm_accounts==0){
            abort(403);
        }
        
        $invoice = DB::table('supplier_invoices as a')
        ->leftJoin('customers as b', 'a.supplier_id', '=', 'b.id')
        ->select('a.*', 'b.company_name')
        ->where('a.id', $id)
        ->first();
        
        $items = DB::table('supplier_invoice_items')
        ->where('supplier_invoice_id', $id)
        ->get();
        
        $purchase_orders = DB::table('accounts_purchase_orders')
            ->where('passed', 1)
            ->where('supplier_invoice_id', $id)
            ->get();
        
        foreach($purchase_orders as $po){
            $po->created_at = date('d M, Y', strtotime($po->created_at));
            $po->number = 'PO-'.str_pad($po->id, 4, '0', STR_PAD_LEFT);
            $sales_total = 0;
            $vat_total = 0;
            
            $po_items = DB::table('accounts_purchase_order_items')
            ->where('po_id', $po->id)
            ->get();
            
            foreach($po_items as $item){
                $plant = $item->plant;
                $labour = $item->labour;
                $material = $item->material;
                $sc_total = $item->sc_total;
                $sales_total += $plant+$labour+$material+$sc_total;
            }
            
            $po->total_net = $sales_total;
            
            if ($po->total_net == 0) {
                continue;
            }
            
            $po->total_vat = (20 / 100) * $sales_total;
            $po->total_gross = $po->total_net+$po->total_vat;
        }
        
        
        $unpassed_purchase_orders = DB::table('accounts_purchase_orders as a')
        ->leftJoin('customers as b', 'a.supplier_id', '=', 'b.id')
        ->select('a.*', 'b.company_name')
        ->where('a.supplier_id', $invoice->supplier_id)
        ->where('a.passed', 0)
        ->orderBy('a.id', 'desc')
        ->get();
        
        foreach($unpassed_purchase_orders as $po){
            $po->created_at = date('d M, Y', strtotime($po->created_at));
            $po->number = 'PO-'.str_pad($po->id, 4, '0', STR_PAD_LEFT);
            $sales_total = 0;
            $vat_total = 0;
            
            $po_items = DB::table('accounts_purchase_order_items')
            ->where('po_id', $po->id)
            ->get();
            
            foreach($po_items as $item){
                $plant = $item->plant;
                $labour = $item->labour;
                $material = $item->material;
                $sc_total = $item->sc_total;
                $sales_total += $plant+$labour+$material+$sc_total;
            }
            
            $po->total_net = $sales_total;
            $po->total_vat = (20 / 100) * $sales_total;
            $po->total_gross = $po->total_net+$po->total_vat;
            
        }
        
        
        return view('account.supplier_invoice_details', ['purchase_orders' => $purchase_orders, 'invoice'=>$invoice, 'items'=>$items, 'unpassed_purchase_orders'=>$unpassed_purchase_orders]);
    }
    
    
    public function purchaseOrderDetails(Request $request, $id)
    {
        if(Auth::user()->perm_accounts==0){
            abort(403);
        }
        
        $purchase_order = DB::table('accounts_purchase_orders')->where('id', $id)->first();
        $supplier = DB::table('customers')->where('id', $purchase_order->supplier_id)->first();
        $contacts = DB::table('customer_contacts')->where('company_id', $purchase_order->supplier_id)->get();
        $project = DB::table('projects as a')
        ->leftJoin('customers as b', 'a.customer_id', '=', 'b.id')
        ->leftJoin('project_statuses as c', 'a.project_status', '=', 'c.id')
        ->leftJoin('project_types as d', 'a.project_type', '=', 'd.id')
        ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type')
        ->where('a.id', $purchase_order->project_id)
        ->first();
        $items = DB::table('project_financials as a')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
            ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
            ->where('a.project_id', $purchase_order->project_id)
            ->orderBy('a.id', 'desc')
            ->get();
        
        $tenderItems = DB::table('tender_project_files')->where('project_id', $purchase_order->project_id)->get();
        
        $po_items = DB::table('accounts_purchase_order_items')
            ->where('po_id', $id)
            ->get();
        
        $financial_items = DB::table('project_financials as a')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
            ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
            ->where('a.project_id', $purchase_order->project_id)
            ->orderBy('a.id', 'desc')
            ->get();
        
        $sc = DB::table('sub_contract_quotes as a')
            ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
            ->select('b.title', 'a.*')
            ->where('a.project_id', $purchase_order->project_id)
            ->where('a.id', $purchase_order->sub_contract_id)
            ->where('a.accepted', 1)
            ->first();
        
        $suppliers = DB::table('customers')->where('type', 'supplier')->get();
        
        
        $otherPos = DB::table('accounts_purchase_orders')
            ->where('project_id', $purchase_order->project_id)
            ->get();
        
        foreach ($otherPos as $po) {
            $totals = DB::table('accounts_purchase_order_items')
                ->where('po_id', $po->id)
                ->select(
                    DB::raw('SUM(plant) as total_plant'),
                    DB::raw('SUM(labour) as total_labour'),
                    DB::raw('SUM(material) as total_materials'),
                    DB::raw('SUM(sc_total) as total_sc')
                )
                ->first();
            
            $po->sc = DB::table('sub_contract_quotes as a')
            ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
            ->select('b.title', 'a.*')
            ->where('a.project_id', $purchase_order->project_id)
            ->where('a.id', $po->sub_contract_id)
            ->where('a.accepted', 1)
            ->first();

            // Add totals to the purchase order object
            $po->total_plant = $totals->total_plant;
            $po->total_labour = $totals->total_labour;
            $po->total_materials = $totals->total_materials;
            $po->total_sc = $totals->total_sc;
            $po->total = $totals->total_plant + $totals->total_labour + $totals->total_materials + $totals->total_sc;
        }
        
        
        
        return view('account.po_details', ['purchase_order' => $purchase_order, 'project'=>$project, 'supplier'=>$supplier, 'items'=>$items, 'po_items'=>$po_items, 'financial_items'=>$financial_items, 'suppliers'=>$suppliers, 'sc'=>$sc, 'contacts'=>$contacts, 'tenderItems'=>$tenderItems, 'otherPos'=>$otherPos]);
    }
    
    
    
    public function addInvoicePO(Request $request, $id)
    {
        
        $response = array();
        $status = 'passed';
        if(!isset($request->purchase_order)){
            $request->session()->flash('danger', 'Please select at least one purchase order.');
            return redirect()->back();
        }else{
            foreach($request->purchase_order as $po_id){
                DB::table('accounts_purchase_orders')
                ->where('id', $po_id)
                ->update([
                    'passed'   =>   1,
                    'supplier_invoice_id'   =>   $id,
                ]);
            }
        }
        
        
        /*Add Notify Contracts Manager Code Here*/
        $request->session()->flash('success', 'Purchase orders added successfully.');
        return redirect()->back();
    }
    
    
    public function passSupplierInvoice(Request $request, $id)
    {
        $response = array();
        $count = DB::table('accounts_purchase_orders')->where('supplier_invoice_id', $id)->count();
        if($count==0){
            $request->session()->flash('danger', 'There are no purchase orders for this supplier invoice.');
            return redirect()->back();
        }else{
            DB::table('supplier_invoices')
            ->where('id', $id)
            ->update([
                'status'   =>   'passed',
            ]);
            
            $request->session()->flash('success', 'Supplier invoice passed successfully.');
            return redirect()->back();
        }
    }
    
    
    
    
    public function createSupplierInvoice(Request $request)
    {
        
        $response = array();
        $status = 'passed';
        if(!isset($request->purchase_order)){
            $status = 'not_passed';
            //$request->session()->flash('danger', 'Please select at least one purchase order.');
            //return redirect()->back();
        }
        
        
        $totalNet = 0;
        $totalVat = 0;
        $totalItems = count($request->net_amount);
        for($i=0; $i<$totalItems; $i++){
            $net = $request->net_amount;
            $vat = $request->vat;
            $totalNet += $net[$i];
            $totalVat += $vat[$i];
        }
        
        $invoiceid = DB::table('supplier_invoices')
            ->insertGetId(
             array(
                    'supplier_id'   =>   $request->supplier_id,
                    'account_ref'   =>   $request->account_ref,
                    'date'   =>   $request->invoice_date,
                    'invoice_no'   =>   $request->invoice_no,
                    'created_at'   =>   date('Y-m-d H:i'),
                    'amount'   =>   $totalNet,
                    'vat'   =>   $totalVat,
                    'status' => $status,
             )
        );
        
        for($i=0; $i<$totalItems; $i++){
            $nominalCode = $request->nominal_code;
            $taxCode = $request->tax_code;
            $net = $request->net_amount;
            $vat = $request->vat;
            $description = $request->description;
            $code = DB::table('nominal_codes')->where('id', $nominalCode[$i])->first();
            DB::table('supplier_invoice_items')
            ->insertGetId(
             array(
                    'supplier_invoice_id'   =>   $invoiceid,
                    'nominal_code'   =>   $code->code.' - '.$code->description,
                    'tax_code'   =>   $taxCode[$i],
                    'net_amount'   =>   $net[$i],
                    'vat_amount'   =>   $vat[$i],
                    'description'   =>   $description[$i],
             ));
        }
        
        if(isset($request->purchase_order)){
            foreach($request->purchase_order as $po_id){
                DB::table('accounts_purchase_orders')
                ->where('id', $po_id)
                ->update([
                    'passed'   =>   1,
                    'supplier_invoice_id'   =>   $invoiceid,
                ]);
            }
        }
        
        
        /*Add Notify Contracts Manager Code Here*/
        $request->session()->flash('success', 'Supplier invoice created successfully.');
        return redirect()->back();
    }
    
    
    public function supplierInvoicesList(Request $request)
    {
        if(Auth::user()->perm_accounts==0){
            abort(403);
        }
        
        $invoices = DB::table('supplier_invoices as a')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->select('a.*', 'b.company_name')
            ->orderBy('id', 'desc')
            ->get();
        return view('account.supplier_invoices_list', ['invoices' => $invoices]);
    }
    
    
    public function createPurchaseOrder(Request $request)
    {
        /*$request->validate([
            'receipt_photo' => 'required|mimes:jpeg,png,jpg,gif|max:3072',
        ]);*/
        
        
        $filename = "";
        if ($request->hasFile('receipt_photo')) {
            $file = $request->file('receipt_photo');
            $ext = $file->getClientOriginalExtension();
            $filename = uniqid(time()) . '.' . $ext;
            $name = $file->getClientOriginalName();
            $file->move(public_path('img/purchase_orders'), $filename);
        }

        
        $response = array();
        
        //$project = DB::table('projects')->where('id', $id)->first();
        //$idArray = explode(',', $request->po_items);
        $sub_contract = 0;
        $sub_contract_id = 0;
        if(isset($request->sub_contract)){
            $sub_contract = 1;
            $sub_contract_id = $request->sub_contract_id;
        }
        
        $project = DB::table('projects as a')
        ->leftJoin('customers as b', 'a.customer_id', '=', 'b.id')
        ->leftJoin('project_statuses as c', 'a.project_status', '=', 'c.id')
        ->leftJoin('project_types as d', 'a.project_type', '=', 'd.id')
        ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type', 'b.address_1 as client_address', 'b.city as client_city', 'b.postcode as client_postcode')
        ->where('a.id', $request->project_id)
        ->first();
        
        
        if($request->address_type=='client_address'){
            $address = $project->client_address;
            $postcode = $project->client_postcode;
            $city = $project->client_city;
        }elseif($request->address_type=='end_client'){
            $address = $project->end_customer_address;
            $postcode = $project->end_customer_postcode;
            $city = $project->end_customer_city;
        }else{
            $address = $request->address;
            $postcode = $request->postcode;
            $city = $request->city;
        }
        
        
        $po_id = DB::table('accounts_purchase_orders')
            ->insertGetId(
             array(
                    'project_id'   =>   $request->project_id,
                    'supplier_id'   =>   $request->supplier_id,
                    'created_at'   =>   date('Y-m-d H:i'),
                    'delivery_date'   =>   $request->delivery_date,
                    'address'   =>   $address,
                    'city'   =>   $city,
                    'postcode'   =>   $postcode,
                    'sub_contract'   =>   $sub_contract,
                    'sub_contract_id'   =>   $sub_contract_id,
                    'receipt_photo'   =>   $filename,
             )
        );
        
        
        //$request->session()->flash('success', 'Purchase order created successfully.');
        //return redirect()->back();
        return redirect()->route('accounts.purchaseOrderDetails', ['id'=>$po_id])->with('success', 'Purchase order created successfully.');
        
    }
    
    
    public function addItemsPO(Request $request, $id)
    {
        $po = DB::table('accounts_purchase_orders')->where('id', $id)->first();
        
        $plant = 0;
        $labour = 0;
        $material = 0;
        $sc_total = 0;
        
        if($po->sub_contract==1){
            $sc_total = $request->sc_total;
        }else{
            $plant = $request->plant;
            $labour = $request->labour;
            $material = $request->material;
        }
        
        DB::table('accounts_purchase_order_items')
            ->insertGetId(
             array(
                    'plant'   =>   $plant,
                    'labour'   =>   $labour,
                    'material'   =>   $material,
                    'sc_total'   =>   $sc_total,
                    'description'   =>   $request->description,
                    'project_id'   =>   $request->project_id,
                    'po_id'   =>   $id,
             )
        );
        
        $request->session()->flash('success', 'Item added successfully.');
        return redirect()->back();
    }
    
    public function getSubContracts(Request $request)
    {
        $sub_contracts = DB::table('sub_contract_quotes as a')
            ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
            ->select('b.title', 'a.*')
            ->where('a.project_id', $request->project_id)
            ->where('a.accepted', 1)
            ->get();
        
        return response()->json($sub_contracts);
    }
    
    public function getPurchaseOrders(Request $request)
    {
        $purchase_orders = DB::table('accounts_purchase_orders as a')
        ->leftJoin('customers as b', 'a.supplier_id', '=', 'b.id')
        ->select('a.*', 'b.company_name')
        ->where('a.supplier_id', $request->supplier_id)
        ->where('a.passed', 0)
        ->orderBy('a.id', 'desc')
        ->get();
        
        foreach($purchase_orders as $po){
            $po->created_at = date('d M, Y', strtotime($po->created_at));
            $po->number = 'PO-'.str_pad($po->id, 4, '0', STR_PAD_LEFT);
            $sales_total = 0;
            $vat_total = 0;
            
            $po_items = DB::table('accounts_purchase_order_items')
            ->where('po_id', $po->id)
            ->get();
            
            foreach($po_items as $item){
                $plant = $item->plant;
                $labour = $item->labour;
                $material = $item->material;
                $sc_total = $item->sc_total;
                $sales_total += $plant+$labour+$material+$sc_total;
            }
            
            $po->total_net = $sales_total;
            $po->total_vat = (20 / 100) * $sales_total;
            $po->total_gross = $po->total_net+$po->total_vat;
            
        }
        
        $supplier = DB::table('customers')->where('id', $request->supplier_id)->first();
        $response = array();
        $response['account_ref'] = $supplier->account_no;
        $response['purchase_orders'] = $purchase_orders;
        
        return response()->json($response);
    }
    
    
    public function getPoItems(Request $request)
    {
        $po = DB::table('accounts_purchase_orders')
            ->where('id', $request->po_id)
            ->first();
        $po_items = DB::table('accounts_purchase_order_items')
            ->where('po_id', $request->po_id)
            ->get();
        
        $type = $po->sub_contract == 1 ? 'sc' : 'normal';
        
        $response['data'] = $po_items;
        $response['type'] = $type;
        
        return response()->json($response);
    }
    
    
    
     public function printPO(Request $request, $id)
    {
        $purchase_order = DB::table('accounts_purchase_orders')->where('id', $id)->first();
         if($purchase_order->locked==0){
             DB::table('accounts_purchase_orders')
                ->where('id', $id)
                ->update(
                 array(
                        'locked'   =>   1,
                        'lock_date'   =>   date('Y-m-d H:i'),
                 )
            );
         }
         
         
        
        $supplier = DB::table('customers')->where('id', $purchase_order->supplier_id)->first();
        $project = DB::table('projects as a')
        ->leftJoin('customers as b', 'a.customer_id', '=', 'b.id')
        ->leftJoin('project_statuses as c', 'a.project_status', '=', 'c.id')
        ->leftJoin('project_types as d', 'a.project_type', '=', 'd.id')
        ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type')
        ->where('a.id', $purchase_order->project_id)
        ->first();
        $items = DB::table('project_financials as a')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
            ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
            ->where('a.project_id', $purchase_order->project_id)
            ->orderBy('a.id', 'desc')
            ->get();
        
        $po_items = DB::table('accounts_purchase_order_items')
            ->where('po_id', $id)
            ->get();
        
        $financial_items = DB::table('project_financials as a')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
            ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
            ->where('a.project_id', $purchase_order->project_id)
            ->orderBy('a.id', 'desc')
            ->get();
        
        $sc = DB::table('sub_contract_quotes as a')
            ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
            ->select('b.title', 'a.*')
            ->where('a.project_id', $purchase_order->project_id)
            ->where('a.id', $purchase_order->sub_contract_id)
            ->where('a.accepted', 1)
            ->first();
        
        
        $mpdf = new Mpdf([
            'tempDir' => storage_path('/tmp'),
            'mode' => 'utf-8',
            'format' => 'A4'
        ]);

        // Start buffer
        ob_start();
        $max_per_page = $request->images_per_screen;

// HTML content to be rendered into PDF
$html = '<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Purchase Order</title>
  <style>
  
   @page{
        padding:0;
   }
  
    body {
      font-family: Arial, sans-serif;
      margin: 0;
      padding: 0;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      
    }
    table td, table th {
      padding: 5px;
      text-align: center;
      border:1px solid #ddd;
    }
    table img {
      width: 100%;
      height: 250px;
    }
  </style>
</head>
<body>';
        
$html .= '<div style="position:absolute;right:20px"><img width="150px" src="'.asset('img/walker.png').'"></div><center><h1>Purchase Order</h1></center>';
        
$html .= '<table style="margin-top:50px">
<tr>
    <th>PO ID</th>
    <th>Project ID</th>
    <th>Supplier</th>
    <th>Delivery Date</th>
</tr>
<tr>
    <td>PO-'.str_pad($purchase_order->id, 4, '0', STR_PAD_LEFT).'</td>
    <td>WG-'.str_pad($project->id, 4, '0', STR_PAD_LEFT).'</td>
    <td>'.$supplier->company_name.'</td>
    <td>'.date('d M, Y', strtotime($purchase_order->delivery_date)).'</td>
</tr>
</table>

<table style="margin-top:50px">
<tr>
    <th >Delivery Address</th>
</tr>
<tr>
    <td >'.$purchase_order->address.', '.$purchase_order->city.' '.$purchase_order->postcode.'</td>
</tr>
</table>

';

$f_plant = 0;
$f_labour = 0;
$f_material = 0;

foreach($financial_items as $fi){
    $f_plant += $fi->plant*$fi->quantity;
    $f_labour += $fi->labour*$fi->quantity;
    $f_material += $fi->material*$fi->quantity;
} 
         
         
$plant = 0;
    $labour = 0;
    $material = 0;
    $sc_total = 0;
         
        
if($purchase_order->sub_contract==0){
    $html .= '<table style="margin-top:50px;table-layout:fixed">
<tr>
    <th>Description</th>
    <th>Plant</th>
    <th>Labour</th>
    <th>Material</th>
</tr>';
    
foreach($po_items as $item){
            $plant += $item->plant;
            $labour += $item->labour;
            $material += $item->material;
            $sc_total += $item->sc_total;
$html.='<tr>
    <td>'.$item->description.'</td>
    <td>£'.number_format($item->plant, 2).'</td>
    <td>£'.number_format($item->labour, 2).'</td>
    <td>£'.number_format($item->material, 2).'</td>
</tr>';
}
    
    
$html.='</table>';
}else{
        $html .= '<table style="margin-top:50px">
        <tr>
            <th colspan="2">Sub Contract</th>
        </tr>
        <tr>
            <th width="50%">Title</th>
            <th>Amount</th>
        </tr>
        <tr>
            <td>'.$sc->title.'</td>
            <td>£'.number_format($sc->amount, 2).'</td>
        </tr>
        </table>';
    
    
    
    $html .= '<table style="margin-top:50px">
        <tr>
            <th colspan="2">Items</th>
        </tr>
        <tr>
            <th width="50%">Description</th>
            <th>Amount</th>
        </tr>';
    
        foreach($po_items as $item){
            $plant += $item->plant;
            $labour += $item->labour;
            $material += $item->material;
            $sc_total += $item->sc_total;
            
            $html.='<tr>
                <td>'.$item->description.'</td>
                <td>£'.number_format($item->sc_total, 2).'</td>
            </tr>';
            
        }

        
        $html.='</table>';
}
         
         
$html .= '</body></html>';

        // Get buffer content and clean buffer
        //$html = ob_get_clean();

        // Write PDF content
        $mpdf->WriteHTML($html);

        // Output PDF to browser or download
        $mpdf->Output('purchase_order.pdf', 'D'); // D = download, I = inline
        /*return response($mpdf->Output('', 'S'))
            ->header('Content-Type', 'application/pdf')
            ->header('Content-Disposition', 'inline; filename="document.pdf"');
        exit;*/
        
    }
    
    
    
    
    public function sendPO(Request $request)
    {
        if($request->contact_id=='other'){
            $email = $request->other_email;
        }else{
            $contact = DB::table('customer_contacts')->where('id', $request->contact_id)->first();
            $email = $contact->email;
        }
        
        
        $po = DB::table('accounts_purchase_orders')->where('id', $request->po_id)->first();
        if($po->locked==0){
            $token = uniqid(time());
            DB::table('accounts_purchase_orders')->where('id', $request->po_id)->update(
                 array(
                        'locked'   =>   1,
                        'lock_date'   =>   date('Y-m-d H:i'),
                        'token' => $token,
                 )
            );
        }else{
            $token = $po->token;
        }
        
        $link = route('accounts.viewPoByLink', ['token'=>$token]);
        
        $mail = new PHPMailer(true);
        try {
            //Server settings
            $mail->isSMTP();
            $mail->Host = env('MAIL_HOST');
            $mail->SMTPAuth = true;
            $mail->Username = env('MAIL_USERNAME');
            $mail->Password = env('MAIL_PASSWORD');
            $mail->SMTPSecure = 'tls';
            $mail->Port = env('MAIL_PORT');

            //Recipients
            $mail->setFrom(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'));
            $mail->addAddress($email);

            // Content
            $mail->isHTML(true);
            $mail->Subject = 'Purchase Order';
            $mail->Body    = 'Dear Customer, <br>Please find the link below for the purchase order details. <br><a href="'.$link.'">'.$link.'</a>';
            $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';

            if($mail->send()){
                $request->session()->flash('success', 'Purchase order sent successfully.');
                return redirect()->back();
            }
            //echo 'Message has been sent';
        } catch (Exception $e) {
            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        }
    }
    
    
    public function viewPoByLink(Request $request, $token)
    {
        $purchase_order = DB::table('accounts_purchase_orders')->where('token', $token)->first();
        $supplier = DB::table('customers')->where('id', $purchase_order->supplier_id)->first();
        $contacts = DB::table('customer_contacts')->where('company_id', $purchase_order->supplier_id)->get();
        $project = DB::table('projects as a')
        ->leftJoin('customers as b', 'a.customer_id', '=', 'b.id')
        ->leftJoin('project_statuses as c', 'a.project_status', '=', 'c.id')
        ->leftJoin('project_types as d', 'a.project_type', '=', 'd.id')
        ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type')
        ->where('a.id', $purchase_order->project_id)
        ->first();
        $items = DB::table('project_financials as a')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
            ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
            ->where('a.project_id', $purchase_order->project_id)
            ->orderBy('a.id', 'desc')
            ->get();
        
        $po_items = DB::table('accounts_purchase_order_items')
            ->where('po_id', $purchase_order->id)
            ->get();
        
        $financial_items = DB::table('project_financials as a')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
            ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
            ->where('a.project_id', $purchase_order->project_id)
            ->orderBy('a.id', 'desc')
            ->get();
        
        $sc = DB::table('sub_contract_quotes as a')
            ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
            ->select('b.title', 'a.*')
            ->where('a.project_id', $purchase_order->project_id)
            ->where('a.id', $purchase_order->sub_contract_id)
            ->where('a.accepted', 1)
            ->first();
        
        $suppliers = DB::table('customers')->where('type', 'supplier')->get();
        
        return view('account.po_details_link', ['purchase_order' => $purchase_order, 'project'=>$project, 'supplier'=>$supplier, 'items'=>$items, 'po_items'=>$po_items, 'financial_items'=>$financial_items, 'suppliers'=>$suppliers, 'sc'=>$sc, 'contacts'=>$contacts]);
    }
    
    
    
    
    
    
    
}