<?php
namespace App\Http\Controllers\ApiControllers;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
    public function login(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);

        $user = User::where('email', $request->email)->first();

        if (!$user || !Hash::check($request->password, $user->password)) {
            return response()->json(['message' => 'Invalid credentials'], 401);
        }elseif($user->perm_app_access==0){
            return response()->json(['message' => 'Sorry you do not have access to the app.'], 401);
        }

        $token = $user->createToken('authToken')->plainTextToken;
        $user->image = asset('img/users/'.$user->image);

        return response()->json(['access_token' => $token, 'token_type' => 'Bearer', 'user'=>$user]);
    }
}