<?php
namespace App\Http\Controllers\ApiControllers;
use App\Http\Controllers\Controller;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Illuminate\Support\Facades\File;

class HrController extends Controller
{
    
    public function getAttendance(Request $request, $id)
    {
        $user = DB::table('users')->where('id', $id)->first();
        $holidays = DB::table('holidays')->where('user_id', $id)->get();
        $sick_leaves = DB::table('sick_leaves')->where('user_id', $id)->get();
        
        $totalHolidays = 0;
        $totalLeaves = 0;
        foreach($holidays as $holiday){
            if($holiday->status=='accepted'){
                $fromDate = Carbon::parse($holiday->from_date);
                $toDate = Carbon::parse($holiday->to_date);
                if($fromDate==$toDate){
                    $days = 1;
                }else{
                    $period = CarbonPeriod::create($fromDate, $toDate);
                    $days = $period->filter(function ($date) {
                        return !$date->isWeekend(); // Exclude Saturdays and Sundays
                    })->count();
                }

                
                $totalHolidays+=$days;
            }
        }

        
        
        $sickleaves = DB::table('sick_leaves')->where('user_id', $id)->get();
        foreach($sickleaves as $leave){
            if($fromDate==$toDate){
                $days = 1;
            }else{
                $fromDate = Carbon::parse($leave->from_date);
                $toDate = Carbon::parse($leave->to_date);
                $days = $fromDate->diffInDays($toDate);
            }

            
            $totalLeaves+=$days;
        }
        

        return response()->json(['success' => true, 'user' => $user, 'holidays'=>$holidays, 'sick_leaves'=>$sick_leaves, 'totalHolidays'=>$totalHolidays, 'totalLeaves'=>$totalLeaves]);
    }
    
    
    public function getGeneralDetails(Request $request, $id)
    {
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->leftjoin('project_types as d', 'a.project_type', '=', 'd.id')
            ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type')
            ->where('a.id', $id)
            ->first();
        $contracts_manager = DB::table('users')
            ->select('id', 'firstname', 'lastname', 'email', 'phone')
            ->where('id', $project->contracts_manager)->first();
        $site_manager = DB::table('users')
            ->select('id', 'firstname', 'lastname', 'email', 'phone')
            ->where('id', $project->site_manager)->first();
        return response()->json(['success' => true, 'project' => $project, 'contracts_manager'=>$contracts_manager, 'site_manager'=>$site_manager]);
        
    }
    
    public function getContract(Request $request, $id)
    {
        $user = DB::table('users')->where('id', $id)->first();
        if(!empty($user->contract)){
            $success = true;
            $contract = asset('documents/'.$user->contract);
        }else{
            $success = false;
            $contract = 'Not uploaded yet.';
        }
        
        return response()->json(['success' => $success, 'contract' => $contract]);
    }
    
    public function getUsers(Request $request)
    {
        $users = DB::table('users')->where('role', '!=', 'admin')->get();
        return response()->json(['success' => true, 'users' => $users]);
    }
    
    public function getHandbook(Request $request)
    {
        $handbook = DB::table('user_handbooks')->orderBy('id', 'desc')->limit(1)->first();
        if(!empty($handbook)){
            $success = true;
            $name = $handbook->name;
            $file = asset('documents/'.$handbook->file);
        }else{
            $success = false;
            $name = '';
            $file = '';
        }
        
        return response()->json(['success' => $success, 'name' => $name, 'file'=>$file]);
    }
    
    public function getDocuments(Request $request, $id)
    {
        
        
        $documents = DB::table('user_documents')
            ->where('user_id', $id)
            ->get();
        
        foreach($documents as $document){
            $document->document_link = asset('documents/'.$document->file);
        }
        
        return response()->json(['success' => true, 'documents'=>$documents]);
        
    }
    
    public function requestLeave(Request $request, $id)
    {
        if($request->type=='half'){
            $from = $request->date;
            $to = $request->date;
        }else{
            $from = $request->from;
            $to = $request->to;
        }
        
        $fileid = DB::table('holidays')->insertGetId(
             array(
                    'user_id'   =>   $id,
                    'from_date'   =>   $from,
                    'to_date'   =>   $to,
                    'type' => $request->type,
                    'description'   =>   $request->description,
                    'time'   =>   $request->time,
                    'leave_type'   =>   $request->leave_type,
             )
        );

        return response()->json(['success' => true, 'message' => 'Added Successfully.']);

    }
    
    public function addDocument(Request $request, $id)
    {
        $request->validate([
            'document' => 'required|mimes:jpeg,png,jpg,gif,pdf,doc,docx,xls,xlsx,ppt,pptx,txt|max:2048',
        ]);
        
        $file = $request->file('document');
        $ext = $file->getClientOriginalExtension();
        $filename = uniqid(time()) . '.' . $ext;
        $name = $file->getClientOriginalName();
        $file->move(public_path('documents'), $filename);
        $added = date('Y-m-d H:i');
        $fileid = DB::table('project_documents')->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'name'   =>   $name,
                    'file'   =>   $filename,
                    'created_at'   =>   $added,
                    'type'   =>   $ext,
                    'notes' => $request->notes,
                    'employee_access' => 1,
             )
        );


        $response = array();
        $response['filename'] = $filename;
        $response['link'] = asset('documents/'.$filename);
        
        $response['name'] = $name;
        $response['type'] = $ext;
        $response['created_at'] = $added;
        $response['file_id'] = $fileid;
        $response['notes'] = $request->notes;
        
        
        return response()->json(['success' => true, 'document' => $response]);
        
    }
    
    public function getPhotos(Request $request, $id)
    {
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->leftjoin('project_types as d', 'a.project_type', '=', 'd.id')
            ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type')
            ->where('a.id', $id)
            ->first();
        
        $before_images = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', 'before')
            ->orderBy('id', 'desc')
            ->get();
        
        $first_site_visit = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', '1st_site_visit')
            ->orderBy('id', 'desc')
            ->get();
        
        $during = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', 'during')
            ->orderBy('id', 'desc')
            ->get();
        
        $completed = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', 'project_completed')
            ->orderBy('id', 'desc')
            ->get();
        
        
        $link = asset('img/projects');
        return response()->json(['success' => true, 'project' => $project, 'images_folder'=>$link, 'before'=>$before_images, 'first_site_visit'=>$first_site_visit, 'during'=>$during, 'completed'=>$completed]);
        
    }
    
    public function addPhoto(Request $request, $id)
    {
        $request->validate([
            'image' => 'required|mimes:jpeg,png,jpg,gif|max:2048',
        ]);
        
        $file = $request->file('image');
        $ext = $file->getClientOriginalExtension();
        $filename = uniqid(time()) . '.' . $ext;
        $name = $file->getClientOriginalName();
        $file->move(public_path('img/projects'), $filename);
        $added = date('Y-m-d H:i');
        $fileid = DB::table('project_images')->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'name'   =>   $name,
                    'file'   =>   $filename,
                    'small_file'   =>   $filename,
                    'type'   =>   $request->type,
                    'created_at'   =>   $added,
                    
             )
        );

        $response = array();
        $response['name'] = $name;
        $response['filename'] = $filename;
        $response['link'] = asset('img/projects/'.$filename);
        $response['type'] = $ext;
        $response['image_id'] = $fileid;
        
        
        return response()->json(['success' => true, 'image' => $response]);
        
    }
    
    
}