<?php
namespace App\Http\Controllers\ApiControllers;
use App\Http\Controllers\Controller;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;

class ProjectController extends Controller
{
    
    public function getProjects()
    {
        $projects = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->leftjoin('project_types as d', 'a.project_type', '=', 'd.id')
            ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type')
            ->orderBy('id', 'desc')
            ->get();
        
        foreach($projects as $project){
            
            $project->wg_id = 'WG-'.str_pad($project->id, 4, '0', STR_PAD_LEFT);
            $current = DB::table('project_status_history')->where('project_id', $project->id)->where('status_id', $project->project_status)->orderBy('id', 'desc')->limit(1)->first();
            if($current){
                $project->end_date = $current->end_date;
            }else{
                $project->end_date = "";
            }
            
            $project->days_left = $this->getDaysLeft($project->end_date);
        }
        
        
        
        
        
        $projects = $projects->sortBy(function($project) {
            return $project->end_date ? strtotime($project->end_date) : PHP_INT_MAX;
        });

        return response()->json(['success' => true, 'projects' => $projects]);
    }
    
    private function getDaysLeft($endDate)
    {
        $daysLeft = "";
        $currentDate = new \DateTime(date('Y-m-d'));
        $upcomingDate = new \DateTime($endDate);
        $interval = date_diff($currentDate, $upcomingDate);
        $daysDifference = abs($interval->days);
        $isPast = $upcomingDate < $currentDate;

        if(!$isPast){
            $daysLeft = $daysDifference;
            $form = $daysDifference==1 ? 'day' : 'days';
            $daysLeft = $daysLeft.' '.$form.' '.'left';
        }else{
            $daysLeft = $daysDifference;
            $daysLeft = $daysDifference;
            $form = $daysDifference==1 ? 'day' : 'days';
            $daysLeft = $daysLeft.' '.$form.' '.'ago';
        }
        
        return $daysLeft;
    }
    
    
  /*  public function generatePo(Request $request, $id)
    {
        $request->validate([
            'address'   =>   'required|string',
            'postcode'   =>   'required|string',
            'city'   =>   'required|string',
            'supplier_id'   =>   'required|int',
            'delivery_date'   =>   'required|string',
            'city'   =>   'required|string',
        ]);
        
        
        $filename = "";
        if ($request->hasFile('receipt_photo')) {
            $file = $request->file('receipt_photo');
            $ext = $file->getClientOriginalExtension();
            $filename = uniqid(time()) . '.' . $ext;
            $name = $file->getClientOriginalName();
            $file->move(public_path('img/purchase_orders'), $filename);
        }

        
        $response = array();
        
        //$project = DB::table('projects')->where('id', $id)->first();
        //$idArray = explode(',', $request->po_items);
        $sub_contract = 0;
        $sub_contract_id = 0;
        if(isset($request->sub_contract)){
            $sub_contract = 1;
            $sub_contract_id = $request->sub_contract_id;
        }
        
        $address = $request->address;
        $postcode = $request->postcode;
        $city = $request->city;
        
        
        DB::table('accounts_purchase_orders')
            ->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'supplier_id'   =>   $request->supplier_id,
                    'created_at'   =>   date('Y-m-d H:i'),
                    'delivery_date'   =>   $request->delivery_date,
                    'address'   =>   $address,
                    'city'   =>   $city,
                    'postcode'   =>   $postcode,
                    'sub_contract'   =>   $sub_contract,
                    'sub_contract_id'   =>   $sub_contract_id,
                    'receipt_photo'   =>   $filename,
                    'description'   =>   $request->description,
                    'receipt_photo'   =>   $filename,
             )
        );
        
        
        return response()->json([
            'success' => true,
            'message' => 'Added Successfully.'
        ]);
    }
    */
    
    public function generatePo(Request $request, $id)
    {
        $request->validate([
            'supplier_id'   =>   'required|int',
        ]);

        
        $project = DB::table('projects')->where('id', $id)->first();
        
        $response = array();
        $po_id = DB::table('accounts_purchase_orders')
            ->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'supplier_id'   =>   $request->supplier_id,
                    'created_at'   =>   date('Y-m-d H:i'),
                    'delivery_date'   =>   date('Y-m-d H:i'),
             )
        );
        
        
        $plant = 0;
        $labour = 0;
        $material = 0;
        $sub_contract = 0;
        $other = 0;
        
        $sub_contracts_total = 0;
        $sub_contracts_other_total = 0;
        
        $sub_contracts = DB::table('sub_contract_quotes as a')
            ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
            ->select('b.title', 'a.*')
            ->where('a.project_id', $id)
            ->where('a.accepted', 1)
            ->get();
        
        
        foreach($sub_contracts as $sc){
            if($sc->type=='sub_contract'){
                $sub_contracts_total+=$sc->amount;
            }

            if($sc->type=='other'){
                $sub_contracts_other_total+=$sc->amount;
            }
        }
        
        if($project->tender==0){
            $items = DB::table('project_financials as a')
                ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
                ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
                ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
                ->where('a.project_id', $id)
                ->orderBy('a.id', 'desc')
                ->get();

            foreach($items as $item){
                $plant += $item->plant*$item->quantity;
                $labour += $item->labour*$item->quantity;
                $material += $item->material*$item->quantity;
            }

            $estimations = array(
                'plant' => round($plant*0.60, 2),
                'labour' => round($labour*0.60, 2),
                'materials' => round($material*0.60, 2),
            );
        }else{
            $tenderItems = DB::table('tender_project_files')->where('project_id', $id)->get();
            foreach($tenderItems as $ti){
                $plant += $ti->plant;
                $labour += $ti->labour;
                $material += $ti->material;
                $sub_contract += $ti->sub_contract;
                $other += $ti->other;
           }
            
            $estimations = array(
                'plant' => round($plant*0.60, 2),
                'labour' => round($labour*0.60, 2),
                'materials' => round($material*0.60, 2),
                'sub_contract' => round(($sub_contract*0.60-$sub_contracts_total), 2),
                'other' => round(($other*0.60-$sub_contracts_other_total), 2),
            );
        }
        
        
        return response()->json([
            'success' => true,
            'po_id' => $po_id,
            'po_number' => 'PO-'.str_pad($po_id, 4, '0', STR_PAD_LEFT),
            'estimations' => $estimations,
        ]);
    }
    
    public function getPoDetails(Request $request, $id, $po_id)
    {
        $purchase_order = DB::table('accounts_purchase_orders as a')
        ->leftJoin('customers as b', 'a.supplier_id', '=', 'b.id')
        ->select('a.*', 'b.company_name as supplier_name')
        ->where('a.project_id', $id)
        ->where('a.id', $po_id)
        ->orderBy('a.id', 'desc')
        ->first();
        
        $project = DB::table('projects as a')
        ->leftJoin('customers as b', 'a.customer_id', '=', 'b.id')
        ->leftJoin('project_statuses as c', 'a.project_status', '=', 'c.id')
        ->leftJoin('project_types as d', 'a.project_type', '=', 'd.id')
        ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type')
        ->where('a.id', $purchase_order->project_id)
        ->first();
        /*$items = DB::table('project_financials as a')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
            ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
            ->where('a.project_id', $purchase_order->project_id)
            ->orderBy('a.id', 'desc')
            ->get();*/
        
        $po_items = DB::table('accounts_purchase_order_items')
            ->where('po_id', $po_id)
            ->get();
        
        /*$financial_items = DB::table('project_financials as a')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
            ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
            ->where('a.project_id', $purchase_order->project_id)
            ->orderBy('a.id', 'desc')
            ->get();*/
        
        $sc = DB::table('sub_contract_quotes as a')
            ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
            ->select('b.title', 'a.*')
            ->where('a.project_id', $purchase_order->project_id)
            ->where('a.id', $purchase_order->sub_contract_id)
            ->where('a.accepted', 1)
            ->first();
        
        $suppliers = DB::table('customers')
            ->select('id', 'company_name', 'email', 'phone')
            ->where('type', 'supplier')->get();
        
        return response()->json(['success'=>true, 'purchase_order' => $purchase_order, 'project'=>$project, 'po_items'=>$po_items, 'suppliers'=>$suppliers, 'sc'=>$sc]);
        
        
    }
    
    public function getSuppliers(Request $request)
    {
        $suppliers = DB::table('customers')
            ->select('id', 'company_name', 'email', 'phone')
            ->where('type', 'supplier')->get();
        
        return response()->json(['success'=>true, 'suppliers' => $suppliers]);
    }
    
   /* public function addItemsPo(Request $request, $id, $po_id)
    {
        $po = DB::table('accounts_purchase_orders')->where('id', $po_id)->first();
        
        $plant = 0;
        $labour = 0;
        $material = 0;
        $sc_total = 0;
        
        if($po->sub_contract==1){
            $sc_total = $request->amount;
        }else{
            $plant = $request->plant;
            $labour = $request->labour;
            $material = $request->material;
        }
        
        DB::table('accounts_purchase_order_items')
            ->insertGetId(
             array(
                    'plant'   =>   $plant,
                    'labour'   =>   $labour,
                    'material'   =>   $material,
                    'sc_total'   =>   $sc_total,
                    'description'   =>   $request->description,
                    'project_id'   =>   $id,
                    'po_id'   =>   $po_id,
             )
        );
        
        return response()->json([
            'success' => true,
            'message' => 'Added Successfully.'
        ]);
    }*/
    
    
    public function addItemsPo(Request $request, $id, $po_id)
    {
        $po = DB::table('accounts_purchase_orders')->where('id', $po_id)->first();
        
        $plant = 0;
        $labour = 0;
        $material = 0;
        $sub_contract = 0;
        $other = 0;
        
        $sc_total = 0;
        
        if($po->sub_contract==1){
            $sc_total = $request->amount;
        }else{
            if($request->type=='plant'){
                $plant+=$request->amount;
            }
            
            if($request->type=='labour'){
                $labour+=$request->amount;
            }
            
            if($request->type=='materials'){
                $material+=$request->amount;
            }
            
            if($request->type=='sub_contract'){
                $sub_contract+=$request->amount;
            }
            
            if($request->type=='other'){
                $other+=$request->amount;
            }
        }
        
        $filename = "";
        if ($request->hasFile('receipt_photo')) {
            $file = $request->file('receipt_photo');
            $ext = $file->getClientOriginalExtension();
            $filename = uniqid(time()) . '.' . $ext;
            $name = $file->getClientOriginalName();
            $file->move(public_path('img/purchase_orders'), $filename);
        }
        
        DB::table('accounts_purchase_order_items')
            ->insertGetId(
             array(
                    'plant'   =>   $plant,
                    'labour'   =>   $labour,
                    'material'   =>   $material,
                    'sub_contract'   =>   $sub_contract,
                    'other'   =>   $other,
                    'sc_total'   =>   $sc_total,
                    'description'   =>   $request->description,
                    'project_id'   =>   $id,
                    'po_id'   =>   $po_id,
             )
        );
        
        if ($request->hasFile('receipt_photo')) {
            DB::table('accounts_purchase_orders')->where('id', $po_id)->update([
                'receipt_photo'   =>   $filename,
            ]);
        }
        
        return response()->json([
            'success' => true,
            'message' => 'Added Successfully.'
        ]);
    }
    
    public function getSubContracts(Request $request, $id)
    {
        $sub_contracts = DB::table('sub_contract_quotes as a')
            ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
            ->select('b.title', 'a.*')
            ->where('a.project_id', $id)
            ->where('a.accepted', 1)
            ->get();
        
        return response()->json($sub_contracts);
    }
    
    
    public function getExpenses(Request $request, $id)
    {
        
        $purchase_orders = DB::table('accounts_purchase_orders as a')
        ->leftJoin('customers as b', 'a.supplier_id', '=', 'b.id')
        ->select('a.*', 'b.company_name as supplier_name')
        ->where('a.project_id', $id)
        ->orderBy('a.id', 'desc')
        ->get();
        
        foreach ($purchase_orders as $po) {
            $po->po_number = 'PO-'.str_pad($po->id, 4, '0', STR_PAD_LEFT);
            $po->receipt_photo = asset('img/purchase_orders/'.$po->receipt_photo);
            $totals = DB::table('accounts_purchase_order_items')
                ->where('po_id', $po->id)
                ->select(
                    DB::raw('SUM(plant) as total_plant'),
                    DB::raw('SUM(labour) as total_labour'),
                    DB::raw('SUM(material) as total_materials'),
                    DB::raw('SUM(sc_total) as total_sc')
                )
                ->first();
            
            $po->sc = DB::table('sub_contract_quotes as a')
            ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
            ->select('b.title', 'a.*')
            ->where('a.project_id', $id)
            ->where('a.id', $po->sub_contract_id)
            ->where('a.accepted', 1)
            ->first();

            // Add totals to the purchase order object
            $po->total_plant = $totals->total_plant;
            $po->total_labour = $totals->total_labour;
            $po->total_materials = $totals->total_materials;
            $po->total_sc = $totals->total_sc;
            $po->total = $totals->total_plant + $totals->total_labour + $totals->total_materials + $totals->total_sc;
        }
        
        return response()->json([
            'success' => true,
            'purchase_orders' => $purchase_orders
        ]);
        
        
    }
    
    
    public function getMyProjects()
    {
        // Assuming you have the user_id stored in a variable
        $userId = Auth::id(); // Replace with your user_id

        // Get today's and tomorrow's dates
        $today = Carbon::today();
        $tomorrow = Carbon::tomorrow();

        // Query to get unique projects for the user
        /*$uniqueProjects = DB::table('project_planning')
            ->where('user_id', $userId)
            ->select('project_id')
            ->distinct()
            ->get();*/
        
        $uniqueProjects = DB::table('project_planning as z')
            ->leftjoin('projects as a', 'z.project_id', '=', 'a.id')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->leftjoin('project_types as d', 'a.project_type', '=', 'd.id')
            ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type')
            ->where('z.user_id', $userId)
            ->distinct('z.project_id')
            ->get();
        
        foreach($uniqueProjects as $project){
            $project->wg_id = 'WG-'.str_pad($project->id, 4, '0', STR_PAD_LEFT);
            $current = DB::table('project_status_history')->where('project_id', $project->id)->where('status_id', $project->project_status)->orderBy('id', 'desc')->limit(1)->first();
            if($current){
                $project->end_date = $current->end_date;
            }else{
                $project->end_date = "";
            }
            
            $project->days_left = $this->getDaysLeft($project->end_date);
        }

        // Query to get today's projects
        $todaysProjects = DB::table('project_planning as z')
            ->leftjoin('projects as a', 'z.project_id', '=', 'a.id')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->leftjoin('project_types as d', 'a.project_type', '=', 'd.id')
            ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type')
            ->where('z.user_id', $userId)
            ->whereDate('z.date', $today)
            ->get();
        
        foreach($todaysProjects as $project){
            $project->wg_id = 'WG-'.str_pad($project->id, 4, '0', STR_PAD_LEFT);
            $current = DB::table('project_status_history')->where('project_id', $project->id)->where('status_id', $project->project_status)->orderBy('id', 'desc')->limit(1)->first();
            if($current){
                $project->end_date = $current->end_date;
            }else{
                $project->end_date = "";
            }
            
            $project->days_left = $this->getDaysLeft($project->end_date);
        }

        // Query to get tomorrow's projects
        $tomorrowsProjects = DB::table('project_planning')
            ->where('user_id', $userId)
            ->whereDate('date', $tomorrow)
            ->get();
        
        foreach($tomorrowsProjects as $project){
            $project->wg_id = 'WG-'.str_pad($project->id, 4, '0', STR_PAD_LEFT);
            $current = DB::table('project_status_history')->where('project_id', $project->id)->where('status_id', $project->project_status)->orderBy('id', 'desc')->limit(1)->first();
            if($current){
                $project->end_date = $current->end_date;
            }else{
                $project->end_date = "";
            }
            
            $project->days_left = $this->getDaysLeft($project->end_date);
        }

        // Output results
        return response()->json([
            'success' => true,
            'userId' => $userId,
            'myProjects' => $uniqueProjects,
            'todaysProjects' => $todaysProjects,
            'tomorrowsProjects' => $tomorrowsProjects
        ]);

        //return response()->json(['success' => true, 'projects' => $projects]);
    }
    
    
    public function getGeneralDetails(Request $request, $id)
    {
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->leftjoin('project_types as d', 'a.project_type', '=', 'd.id')
            ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type')
            ->where('a.id', $id)
            ->first();
        $contracts_manager = DB::table('users')
            ->select('id', 'firstname', 'lastname', 'email', 'phone')
            ->where('id', $project->contracts_manager)->first();
        $site_manager = DB::table('users')
            ->select('id', 'firstname', 'lastname', 'email', 'phone')
            ->where('id', $project->site_manager)->first();
        return response()->json(['success' => true, 'project' => $project, 'contracts_manager'=>$contracts_manager, 'site_manager'=>$site_manager]);
        
    }
    
    public function getTimesheet(Request $request, $id)
    {
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->leftjoin('project_types as d', 'a.project_type', '=', 'd.id')
            ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type')
            ->where('a.id', $id)
            ->first();
        
        $timesheet = DB::table('project_planning')
            ->where('project_id', $id)
            ->where('user_id', Auth::id())
            ->get();
        
        return response()->json(['success' => true, 'project' => $project, 'timsheet'=>$timesheet]);
        
    }
    
    public function getDocuments(Request $request, $id)
    {
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->leftjoin('project_types as d', 'a.project_type', '=', 'd.id')
            ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type')
            ->where('a.id', $id)
            ->first();
        
        $documents = DB::table('project_documents')
            ->where('project_id', $request->id)
            ->where('employee_access', 1)
            ->orderBy('id', 'desc')
            ->get();
        
        foreach($documents as $document){
            $document->link = asset('documents/'.$document->file);
        }
        
        return response()->json(['success' => true, 'project' => $project, 'documents'=>$documents]);
        
    }
    
    public function addTimesheet(Request $request, $id)
    {
        $added = date('Y-m-d H:i');
        DB::table('project_planning')->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'date'   =>   $request->date,
                    'start_time'   =>   $request->start_time,
                    'end_time'   =>   $request->end_time,
                    'gps_start_time'   =>   $request->gps_end_time,
                    'gps_end_time'   =>   $request->gps_end_time,
                    'user_id' => Auth::id(),
                    'miles_travelled' => $request->miles_travelled,
                    'mins_travelled' => $request->mins_travelled,
                    'created_at' => $added,
             )
        );
        return response()->json(['success' => true, 'message' => 'Added Successfully']);
    }
    
    public function addDocument(Request $request, $id)
    {
        $request->validate([
            'document' => 'required|mimes:jpeg,png,jpg,gif,pdf,doc,docx,xls,xlsx,ppt,pptx,txt|max:2048',
        ]);
        
        $file = $request->file('document');
        $ext = $file->getClientOriginalExtension();
        $filename = uniqid(time()) . '.' . $ext;
        $name = $file->getClientOriginalName();
        $file->move(public_path('documents'), $filename);
        $added = date('Y-m-d H:i');
        $fileid = DB::table('project_documents')->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'name'   =>   $name,
                    'file'   =>   $filename,
                    'created_at'   =>   $added,
                    'type'   =>   $ext,
                    'notes' => $request->notes,
                    'employee_access' => 1,
             )
        );


        $response = array();
        $response['filename'] = $filename;
        $response['link'] = asset('documents/'.$filename);
        
        $response['name'] = $name;
        $response['type'] = $ext;
        $response['created_at'] = $added;
        $response['file_id'] = $fileid;
        $response['notes'] = $request->notes;
        
        
        return response()->json(['success' => true, 'document' => $response]);
        
    }
    
    public function getPhotos(Request $request, $id)
    {
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->leftjoin('project_types as d', 'a.project_type', '=', 'd.id')
            ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type')
            ->where('a.id', $id)
            ->first();
        
        $before_images = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', 'before')
            ->orderBy('id', 'desc')
            ->get();
        
        $first_site_visit = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', '1st_site_visit')
            ->orderBy('id', 'desc')
            ->get();
        
        $during = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', 'during')
            ->orderBy('id', 'desc')
            ->get();
        
        $completed = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', 'project_completed')
            ->orderBy('id', 'desc')
            ->get();
        
        
        $link = asset('img/projects');
        return response()->json(['success' => true, 'project' => $project, 'images_folder'=>$link, 'before'=>$before_images, 'first_site_visit'=>$first_site_visit, 'during'=>$during, 'completed'=>$completed]);
        
    }
    
    public function addPhoto(Request $request, $id)
    {
        $request->validate([
            'image' => 'required|mimes:jpeg,png,jpg,gif|max:2048',
        ]);
        
        $file = $request->file('image');
        $ext = $file->getClientOriginalExtension();
        $filename = uniqid(time()) . '.' . $ext;
        $name = $file->getClientOriginalName();
        $file->move(public_path('img/projects'), $filename);
        $added = date('Y-m-d H:i');
        $fileid = DB::table('project_images')->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'name'   =>   $name,
                    'file'   =>   $filename,
                    'small_file'   =>   $filename,
                    'type'   =>   $request->type,
                    'created_at'   =>   $added,
                    
             )
        );

        $response = array();
        $response['name'] = $name;
        $response['filename'] = $filename;
        $response['link'] = asset('img/projects/'.$filename);
        $response['type'] = $ext;
        $response['image_id'] = $fileid;
        
        
        return response()->json(['success' => true, 'image' => $response]);
        
    }
    
    
}