<?php

namespace App\Http\Controllers;
use DB;
use App\Quotation;
use Illuminate\Http\Request;
use Session;
use Redirect;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use Illuminate\Support\Str;
class CustomerController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    
    
    public function showProjects(Request $request, $id)
    {
        $projects = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->leftjoin('project_types as d', 'a.project_type', '=', 'd.id')
            ->leftjoin('project_status_history as e', 'e.status_id', '=', 'a.project_status')
            ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type', 'e.end_date')
            ->where('a.customer_id', $id)
            ->orderBy('id', 'desc')
            ->get();
        
        
        $project_types = DB::table('project_types')->orderBy('name', 'asc')->get();
        $statusses = DB::table('project_statuses')->orderBy('name', 'asc')->get();
        
        $customer = DB::table('customers')->where('id', $id)->first();
        return view('customer.projects', ['projects' => $projects, 'customer' => $customer, 'project_types' => $project_types, 'statusses' => $statusses]);
    }
    
    
    public function view(Request $request)
    {
        if(Auth::user()->perm_crm==0){
            abort(403);
        }
        $customers = DB::table('customers')->orderBy('id', 'desc')->get();
        return view('customer.view', ['customers' => $customers]);
    }
    
    public function details(Request $request)
    {
        if(Auth::user()->perm_crm==0){
            abort(403);
        }
        $customer = DB::table('customers')->where('id', $request->id)->first();
        $contacts = DB::table('customer_contacts')->where('company_id', $request->id)->get();
        return view('customer.details', ['customer' => $customer, 'contacts' => $contacts]);
    }
    
    
    public function addNew(Request $request)
    {
        if(Auth::user()->perm_crm==0){
            abort(403);
        }
        $address_types = DB::table('address_types')->get();
        return view('customer.add-new', $address_types);
    }
    
    
    public function updateImage(Request $request, $id)
    {
        $this->validate($request, [
            'image' => 'required|image|mimes:jpeg,jpg,png,gif',
        ]);
        
        if($request->hasFile('image')){
            $image = $request->file('image');
            $imageName = uniqid(time()).'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/img/customers');
            $image->move($destinationPath, $imageName);
            DB::table('customers')->where('id', $id)->update(
                 array(
                        'image' => $imageName,
                 )
            );
        }
        
        $request->session()->flash('success', 'Customer logo updated successfully.');
        return redirect()->back();
        
        
    }

    public function store(Request $request)
    {
        $response = array();
        $studioid = Auth::id();
        $errors = array();
        
        $this->validate($request, [
            'company_name'   =>   'required|string',
            'email'   =>   'required|string',
            'phone'   =>   'required|string',
            'address_1'   =>   'required|string',
            'postcode'   =>   'required|string',
            'city'   =>   'required|string',
        ]);
        
        
        if(isset($request->image)){
            $this->validate($request, [
                'image' => 'nullable|image|mimes:jpeg,jpg,png,gif',
            ]);
        }
        
        $dancerid = DB::table('customers')->insertGetId(
             array(
                    'company_name'   =>   $request->company_name,
                    'email'   =>   $request->email,
                    'phone'   =>   $request->phone,
                    'type'   =>   $request->type,
                    'address_type'   =>   $request->address_type,
                    'address_1'   =>   $request->address_1,
                    'address_2'   =>   $request->address_2,
                    'address_3'   =>   $request->address_3,
                    'postcode'   =>   $request->postcode,
                    'city'   =>   $request->city,
                    'account_no'   =>   $request->account_no,
                    'credit_limit'   =>   $request->credit_limit,
                    'created_at'   =>   date('Y-m-d H:i'),
                    'image' => 'default.webp'
             )
        );
        
        
        /*if($request->hasFile('image')){
            $image = $request->file('image');
            $imageName = uniqid(time()).'.'.$image->getClientOriginalExtension();
            $image->move(public_path('../../../images/dancers'), $imageName);
            DB::table('dancers')->where('id', $dancerid)->update(
                 array(
                        'photo' => $imageName,
                 )
            );
        }*/
        
        $request->session()->flash('success', 'Customer added successfully.');
        return redirect()->route('customer.addNew');
    }
    
    
    public function addNewProject(Request $request, $id)
    {
        $response = array();
        
        $this->validate($request, [
            'project_type'   =>   'required|int',
            'project_status'   =>   'required|int',
            'email'   =>   'required|string',
            'name'   =>   'required|string',
        ]);
        
        $uniqid = substr(Str::upper(Str::random(3)), 0, 3) . '-' . substr(Str::upper(Str::random(3)), 0, 3);
        $projectid = DB::table('projects')->insertGetId(
             array(
                    'customer_id'   =>   $id,
                    'customer_name'   =>   $request->name,
                    'customer_email'   =>   $request->email,
                    'customer_phone'   =>   $request->phone,
                    'customer_ref'   =>   $request->customer_ref,
                    'project_type'   =>   $request->project_type,
                    'project_status'   =>   $request->project_status,
                    'image' => 'placeholder.jpg',
                    'created_at' => date('Y-m-d H:i'),
                    'project_id' => $uniqid,
             )
        );
        
        $status = DB::table('project_statuses')->where('id', $request->project_status)->first();
        
        DB::table('project_status_history')->insertGetId(
             array(
                    'project_id'   =>   $projectid,
                    'status_id'   =>   $request->project_status,
                    'start_date'   =>   date('Y-m-d H:i'),
                    'end_date'   =>   Carbon::now()->addDays($status->completion_days)->toDateString(),
             )
        );
        
        $request->session()->flash('success', 'Project added successfully.');
        return redirect()->back();
    }
    

    public function update(Request $request, $id)
    {
        $response = array();
        $studioid = Auth::id();
        $errors = array();
        
        $this->validate($request, [
            'company_name'   =>   'required|string',
            'email'   =>   'required|string',
            'phone'   =>   'required|string',
            'address_1'   =>   'required|string',
            'postcode'   =>   'required|string',
            'city'   =>   'required|string',
        ]);
        
        
        if(isset($request->image)){
            $this->validate($request, [
                'image' => 'nullable|image|mimes:jpeg,jpg,png,gif',
            ]);
        }
        
        $dancerid = DB::table('customers')
            ->where('id', $id)
            ->update(
             array(
                    'company_name'   =>   $request->company_name,
                    'email'   =>   $request->email,
                    'phone'   =>   $request->phone,
                    'notes'   =>   $request->notes,
                    'address_type'   =>   $request->address_type,
                    'address_1'   =>   $request->address_1,
                    'address_2'   =>   $request->address_2,
                    'address_3'   =>   $request->address_3,
                    'postcode'   =>   $request->postcode,
                    'city'   =>   $request->city,
                    'account_no'   =>   $request->account_no,
                    'credit_limit'   =>   $request->credit_limit,
             )
        );
        
        
        /*if($request->hasFile('image')){
            $image = $request->file('image');
            $imageName = uniqid(time()).'.'.$image->getClientOriginalExtension();
            $image->move(public_path('../../../images/dancers'), $imageName);
            DB::table('dancers')->where('id', $dancerid)->update(
                 array(
                        'photo' => $imageName,
                 )
            );
        }*/
        
        $request->session()->flash('success', 'Customer updated successfully.');
        return redirect()->back();
    }
    
    
    public function addContact(Request $request, $id)
    {
        $response = array();
        $errors = array();
        
        $this->validate($request, [
            'name'   =>   'required|string',
            'email'   =>   'required|string',
            'phone'   =>   'required|string',
        ]);
        
        
        
        DB::table('customer_contacts')->insertGetId(
             array(
                    'name'   =>   $request->name,
                    'email'   =>   $request->email,
                    'phone'   =>   $request->phone,
                    'created_at'   =>   date('Y-m-d H:i'),
                    'company_id'   =>   $id,
             )
        );
        
        
        
        $request->session()->flash('success', 'Contact added successfully.');
        return redirect()->back();
    }
    
    
}
