<?php

namespace App\Http\Controllers;
use DB;
use App\Quotation;
use Illuminate\Http\Request;
use App\Patients;
use App\Doctors;
use Session;
use App\Questionnaire;
use Illuminate\Support\Facades\Auth;
use Redirect;
use Carbon\Carbon;
use PDF;
use ZipArchive;
class DashboardController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    
    public function index()
    {
        $userId = Auth::id();
        $projects = DB::table('projects as a')
        ->leftJoin('customers as b', 'a.customer_id', '=', 'b.id')
        ->leftJoin('project_statuses as c', 'a.project_status', '=', 'c.id')
        ->leftJoin('project_types as d', 'a.project_type', '=', 'd.id')
        ->leftJoin('user_project_likes as e', function ($join) use ($userId) {
            $join->on('a.id', '=', 'e.project_id')
                 ->where('e.user_id', '=', $userId);
        })
        ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type', DB::raw('IF(e.project_id IS NULL, 0, 1) as is_favorite'))
        ->having('is_favorite', 1)
        ->orderBy('a.id', 'desc')
        ->get();
        
        foreach($projects as $project){
            $current = DB::table('project_status_history')->where('project_id', $project->id)->where('status_id', $project->project_status)->orderBy('id', 'desc')->limit(1)->first();
            if($current){
                $project->end_date = $current->end_date;
            }else{
                $project->end_date = "";
            }
        }
        
        $projects = $projects->sortBy(function($project) {
            return $project->end_date ? strtotime($project->end_date) : PHP_INT_MAX;
        });
        
        return view('dashboard', compact('projects'));
    }
    
    public function unlike(Request $request)
    {
        DB::table('user_project_likes')->where('project_id', $request->project_id)->where('user_id', Auth::id())->delete();

        $request->session()->flash('success', 'Project removed from favourites successfully.');
        return redirect()->back();
    }
	



}