<?php

namespace App\Http\Controllers;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth')->except('forgotPassword', 'showPasswordReset', 'resetPassword');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('home');
    }
    
    public function forgotPassword(Request $request)
    {
        // Validate the request data
        $request->validate(['email' => 'required|email']);
        $token = uniqid(time());
        $link = route('password.reset', ['link'=>$token]);
        DB::table('password_resets')->insertGetId(
             array(
                    'email'   =>   $request->email,
                    'token' => $token
             )
        );
        
        $mail = new PHPMailer(true);

        try {
            //Server settings
            $mail->isSMTP();
            $mail->Host = env('MAIL_HOST');
            $mail->SMTPAuth = true;
            $mail->Username = env('MAIL_USERNAME');
            $mail->Password = env('MAIL_PASSWORD');
            $mail->SMTPSecure = 'tls';
            $mail->Port = env('MAIL_PORT');

            //Recipients
            $mail->setFrom(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'));
            $mail->addAddress($request->email);

            // Content
            $mail->isHTML(true);
            $mail->Subject = 'Password Reset Request';
            $mail->Body    = '<p>Dear User,</p>
            <p>We received a request to reset your password. Click the link below to reset your password:</p>
            <a href="'.$link.'" class="button">Reset Password</a>
            <p>Thanks</p>';
            $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';

            $mail->send();
        } catch (Exception $e) {
            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        }
        
        $request->session()->flash('success', 'Please check your email for password recovery link.');
        return redirect()->back();
    }
    
    public function showPasswordReset(Request $request)
    {
        $token = $request->link;
        $recovery = DB::table('password_resets')->where('token', $token)->first();
        if(!$recovery){
            return redirect()->route('login')->with('danger', 'The token for password recovery is not valid.');
        }
        
        $user = DB::table('users')->where('email', $recovery->email)->first();
        return view('auth.password_recovery', ['user' => $user, 'token'=>$token]);
    }
    
    public function resetPassword(Request $request, $token)
    {
        
        $request->validate([
            'new_password' => 'required|min:8|confirmed',
        ]);
        
        $recovery = DB::table('password_resets')->where('token', $token)->first();
        if(!$recovery){
            return redirect()->route('login')->with('danger', 'The token for password recovery is not valid.');
        }
        
        DB::table('users')->where('email', $recovery->email)->update([
            'password' => Hash::make($request->new_password)
        ]);
        
        DB::table('password_resets')->where('token', $token)->delete();
        
        return redirect()->route('login')->with('success', 'Password updated successfully.');
    }
    
}
