<?php

namespace App\Http\Controllers;
use DB;
use App\Quotation;
use Illuminate\Http\Request;
use App\Patients;
use App\Doctors;
use Session;
use App\Questionnaire;
use Illuminate\Support\Facades\Auth;
use Redirect;
use Carbon\Carbon;
use PDF;
use Illuminate\Support\Facades\Hash;
use ZipArchive;
class PlanningController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    
    
    
    public function showTimeSheet(Request $request)
    {
        if(Auth::user()->perm_timesheet==0){
            abort(403);
        }
        $now = Carbon::now();
        
        if(request()->has('filter')){
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
            $projectId = $request->input('project_id');
            $userId = $request->input('user_id');
            
            // Build query
            $query = DB::table('project_planning as a')
                ->select('a.*', 'b.firstname', 'b.lastname')
                 ->leftjoin('users as b', 'a.user_id', '=', 'b.id')
                 ->whereBetween('a.date', [$startDate, $endDate]);

            if ($projectId) {
                $query->where('a.project_id', $projectId);
            }

            if ($userId) {
                $query->where('a.user_id', $userId);
            }
            
            $records = $query->orderBy('a.date', 'asc');
            $records = $query->get();
            
        }else{
            $startDate = $now->startOfWeek()->toDateString();
            $endDate = $now->endOfWeek()->toDateString();
            $records = DB::table('project_planning as a')
                 ->select('a.*', 'b.firstname', 'b.lastname')
                 ->leftjoin('users as b', 'a.user_id', '=', 'b.id')
                 ->whereBetween('a.date', [$startDate, $endDate])
                 ->orderBy('a.date', 'asc')
                 ->get();
        }
        
        
        
        $users = DB::table('users')
             ->where('role', 'user')
             ->where('department', '!=', 'contracts_manager')
             ->get();
        
        $projects = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->select('a.id', 'b.company_name')
            ->orderBy('id', 'desc')
            ->get();
        
        return view('planning.timesheet', ['records' => $records, 'start'=>$startDate, 'end'=>$endDate, 'projects'=>$projects, 'users'=>$users]);
        //return view('planning.index');
    }
    
    public function showPlanning(Request $request)
    {
        if(Auth::user()->perm_planning==0){
            abort(403);
        }
        $projects = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->leftjoin('project_types as d', 'a.project_type', '=', 'd.id')
            ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type')
            ->orderBy('id', 'desc')
            ->get();
        $users = DB::table('users')->orderBy('firstname', 'asc')
            ->where('department', '!=', 'contracts_manager')
            ->where('role', '!=', 'admin')
            ->get();
        
        if(request()->has('week')){
            $dates = $this->getCurrentWeekDates(request()->week);
        }else{
            $dates = $this->getCurrentWeekDates();
        }
        
        $currentDate = new \DateTime();
        $currentDate->modify('first day of this month');
        $months = [];
        for ($i = 0; $i < 3; $i++) {
            $months[] = $currentDate->format('Y-m-d');
            $currentDate->modify('first day of next month');
        }
        return view('planning.index', ['projects' => $projects, 'users'=>$users, 'dates'=>$dates, 'months'=>$months]);
        //return view('planning.index');
    }
    
    
    public static function getProjectUsers($project_id, $date)
    {
        $users = DB::table('project_planning as a')
                ->leftjoin('users as b', 'a.user_id', '=', 'b.id')
                ->select('b.*')
                ->where('a.project_id', $project_id)
                ->where('a.date', $date)
                ->get();
        
        return $users;
    }
    
    public static function getUserSkills($userid)
    {
        $skills = DB::table('users as a')
                ->leftjoin('user_skills as b', 'a.id', '=', 'b.user_id')
                ->leftjoin('skills_set as c', 'b.skill_id', '=', 'c.id')
                ->select('c.name as skill_name')
                ->where('a.id', $userid)
                ->pluck('skill_name')
                ->toArray();
        
        return $skills;
    }
    
    public static function getLabourerSiteManager($userid)
    {
        $user = DB::table('site_manager_labourer as a')
                ->leftjoin('users as b', 'a.site_manager_id', '=', 'b.id')
                ->select('b.firstname', 'b.lastname')
                ->where('a.labourer_id', $userid)
                ->first();
        
        return $user;
    }
    
    public static function getUserPlannings($userid, $date)
    {
        $plannings = DB::table('project_planning as a')
                ->leftjoin('projects as b', 'a.project_id', '=', 'b.id')
                ->leftjoin('customers as c', 'b.customer_id', '=', 'c.id')
                ->select('a.*', 'c.company_name', 'b.border', 'b.background')
                ->where('user_id', $userid)
                ->where('date', $date)
                ->first();
        
        return $plannings;
    }
    
    public static function getOtherPlannings($userid, $date)
    {
        $plannings = DB::table('project_planning as a')
                ->leftjoin('projects as b', 'a.project_id', '=', 'b.id')
                ->leftjoin('customers as c', 'b.customer_id', '=', 'c.id')
                ->select('a.*', 'c.company_name', 'b.border', 'b.background')
                ->where('user_id', $userid)
                ->where('date', $date)
                ->orderBy('id', 'desc')
                ->first();
        
        return $plannings;
    }
    
    public static function checkBookings($userid, $date)
    {
        $check = DB::table('project_planning')
                ->where('user_id', $userid)
                ->where('date', $date)
                ->count();
        
        return $check;
    }
    
    public function updateColor(Request $request)
    {
        DB::table('projects')
            ->where('id', $request->project_id)
            ->update(
             array(
                    'background'   =>   $request->background,
                    'border'   =>   $request->border,
             )
        );
        return redirect()->back();
    }
    
    public function swapProjects(Request $request)
    {
        $project_1 = DB::table('project_planning')->where('project_id', $request->project_id_1)
            ->where('date', $request->date)
            ->where('user_id', $request->user_id)
            ->first();
        
        if($project_1->period == 1){
            $p1_period = 2;
        }elseif($project_1->period == 2){
            $p1_period = 1;
        }
        
        DB::table('project_planning')->where('id', $project_1->id)
            ->update(
             array(
                    'period'   =>   $p1_period,
             )
        );
        
        $project_2 = DB::table('project_planning')->where('project_id', $request->project_id_2)
            ->where('date', $request->date)
            ->where('user_id', $request->user_id)
            ->first();
        
        if($project_2->period == 1){
            $p2_period = 2;
        }elseif($project_2->period == 2){
            $p2_period = 1;
        }
        
        DB::table('project_planning')->where('id', $project_2->id)
            ->update(
             array(
                    'period'   =>   $p2_period,
             )
        );
        
        
        
        
        //return redirect()->back();
    }
    
    public function approvePlanning(Request $request)
    {
        DB::table('project_planning')
            ->where('id', $request->planning_id)
            ->update(
             array(
                    'approved'   =>   $request->approved,
             )
        );
        echo 'done';
    }
    
    public function confirmPlanning(Request $request)
    {
        $start = Carbon::parse($request->start);
        $end = Carbon::parse($request->end);

        $dates = [];

        // If the start date is greater than the end date, swap them
        if ($start->gt($end)) {
            list($start, $end) = [$end, $start];
        }

        // Generate dates between start and end, inclusive
        for ($date = $start; $date->lte($end); $date->addDay()) {
            $dates[] = $date->toDateString();
        }
        
        foreach($dates as $date){
            DB::table('project_planning')
                ->where('user_id', $request->user_id)
                ->where('date', $date)
                ->update(
                 array(
                        'confirmed'   =>   1,
                        'start_date'   =>   $request->start,
                        'end_date'   =>   $request->end,
                 )
            );
        }
    }
    
    public function revokeConfirmation(Request $request)
    {
        $start = Carbon::parse($request->start);
        $end = Carbon::parse($request->end);

        $dates = [];

        // If the start date is greater than the end date, swap them
        if ($start->gt($end)) {
            list($start, $end) = [$end, $start];
        }

        // Generate dates between start and end, inclusive
        for ($date = $start; $date->lte($end); $date->addDay()) {
            $dates[] = $date->toDateString();
        }
        
        foreach($dates as $date){
            DB::table('project_planning')
                ->where('user_id', $request->user_id)
                ->where('date', $date)
                ->update(
                 array(
                        'confirmed'   =>   0,
                        'start_date'   =>   "",
                        'end_date'   =>   "",
                 )
            );
        }
    }
    
    public function updateDateRange(Request $request)
    {
        $request->validate([
            'user_id' => 'required|integer',
            'project_id' => 'required|integer',
            'start' => 'required|date',
            'end' => 'required|date|after_or_equal:start',
        ]);

        $userId = $request->input('user_id');
        $projectId = $request->input('project_id');
        $newStartDate = Carbon::parse($request->input('start'));
        $newEndDate = Carbon::parse($request->input('end'));
        
        $currentRecords = DB::table('project_planning')
        ->where('user_id', $userId)
        ->where('project_id', $projectId)
        ->whereBetween('date', [$newStartDate->copy()->subDay(), $newEndDate->copy()->addDay()])
        ->get();

        // Determine the existing date range
        $currentStartDate = $currentRecords->min('date');
        $currentEndDate = $currentRecords->max('date');

        // Delete records that fall outside the new date range
        // Delete records within the current date range but outside the new date range
        DB::table('project_planning')
            ->where('user_id', $userId)
            ->where('project_id', $projectId)
            ->whereBetween('date', [$currentStartDate, $currentEndDate])
            ->where(function ($query) use ($newStartDate, $newEndDate) {
                $query->where('date', '<', $newStartDate)
                      ->orWhere('date', '>', $newEndDate);
            })
            ->delete();

        // Insert or update records within the new date range
        $dates = [];
        for ($date = $newStartDate; $date->lte($newEndDate); $date->addDay()) {
            $dates[] = [
                'user_id' => $userId,
                'project_id' => $projectId,
                'date' => $date->format('Y-m-d'),
                'created_at' => date('Y-m-d H:i'),
            ];
        }

        // Insert new records
        DB::table('project_planning')->insert($dates);

        return response()->json(['message' => 'Planning updated successfully']);
    }
    
    public function saveNote(Request $request)
    {
        $note = DB::table('project_planning_notes')
            ->where('project_id', $request->project_id)
            ->where('date', $request->date)
            ->first();
        if(!$note){
            DB::table('project_planning_notes')->insertGetId(
                 array(
                        'project_id'   =>   $request->project_id,
                        'date'   =>   $request->date,
                        'note'   =>   $request->note,
                 )
            );
        }else{
            DB::table('project_planning_notes')
                ->where('project_id', $request->project_id)
                ->where('date', $request->date)
                ->update(
                 array(
                        'note'   =>   $request->note,
                 )
            );
        }
    }
    
    
    public function addUserTimesheet(Request $request)
    {
        
        $check = DB::table('project_planning')->where('user_id', $request->user_id)->where('date', $request->date)->first();
        if(!$check){
            DB::table('project_planning')->insertGetId(
                 array(
                        'user_id'   =>   $request->user_id,
                        'project_id'   =>   $request->project_id,
                        'date'   =>   $request->date,
                        'created_at' => date('Y-m-d H:i'),
                        'start_time'   =>   $request->start_time,
                        'end_time'   =>   $request->end_time,
                        'miles_travelled'   =>   $request->miles_travelled,
                        'mins_travelled'   =>   $request->mins_travelled,
                 )
            );
            $request->session()->flash('success', 'User added successfully.');
        }else{
            $request->session()->flash('danger', 'User already booked on this date.');
        }
        
        
        /*$labourers = DB::table('site_manager_labourer')->where('site_manager_id', $request->user_id)->get();
        foreach($labourers as $labourer){
            $check = DB::table('project_planning')->where('user_id', $labourer->labourer_id)->where('project_id', $request->project_id)->where('date', $request->date)->first();
            if(!$check){
                DB::table('project_planning')->insertGetId(
                     array(
                            'user_id'   =>   $labourer->labourer_id,
                            'project_id'   =>   $request->project_id,
                            'date'   =>   $request->date,
                            'created_at' => date('Y-m-d H:i'),
                     )
                );
            }
        }*/
        
        
        
        
        return redirect()->back();
    }
    
    
    public function addTimeData(Request $request)
    {
        DB::table('project_planning')
            ->where('id', $request->planning_id)
            ->update(
             array(
                    'start_time'   =>   $request->start_time,
                    'end_time'   =>   $request->end_time,
                    'miles_travelled'   =>   $request->miles_travelled,
                    'mins_travelled'   =>   $request->mins_travelled,
             )
        );
        
        $request->session()->flash('success', 'Updated successfully.');
        return redirect()->back();
    }
    
    
    public static function calculateHours($start, $end)
{
    // Assuming the request has 'start_time' and 'end_time' in 'Y-m-d H:i:s' format
    $startTime = Carbon::parse($start);
    $endTime = Carbon::parse($end);

    // Calculate the difference in hours and minutes
    $diffInHours = $endTime->diffInHours($startTime);
    $diffInMinutes = $endTime->diffInMinutes($startTime) % 60;

    // Convert minutes to a fraction of an hour
    $totalHours = $diffInHours + ($diffInMinutes / 60);

    return $totalHours;
}
    
    
    public function removeFromProject(Request $request)
    {
        DB::table('project_planning')
            ->where('project_id', $request->project_id)
            ->where('date', $request->date)
            ->where('user_id', $request->user_id)
            ->delete();
        echo 1;
    }
    
    public function removeProject(Request $request)
    {
        if(isset($request->user_id)){
            DB::table('project_planning')
            ->where('project_id', $request->project_id)
            ->where('user_id', $request->user_id)
            ->where('date', $request->date)
            ->delete();
        }else{
            DB::table('project_planning')
            ->where('project_id', $request->project_id)
            ->where('date', $request->date)
            ->delete();
        }
        
        echo 1;
    }
    
    
    public function getPlanningDetails(Request $request)
    {
        $checkNote = DB::table('project_planning_notes')
            ->where('project_id', $request->project_id)
            ->where('date', $request->date)
            ->first();
        if($checkNote){
            $note = $checkNote->note;
        }else{
            $note = "";
        }
        
        $staffs = $this->getProjectUsers($request->project_id, $request->date);
        echo json_encode(array(
            'notes'=>$note,
            'staffs'=>$staffs
        ));
    }
    
    
    public function checkExistingUsers(Request $request)
    {
        $response = array();
        
        /*$this->validate($request, [
            'project_type'   =>   'required|int',
            'project_status'   =>   'required|int',
            'email'   =>   'required|string',
            'name'   =>   'required|string',
            'customer_id'   =>   'required|int',
        ]);*/
        
        $booked = array();
        $notbooked = array();
        
        $user = DB::table('project_planning')
            ->where('user_id', $request->user_id)
            ->where('date', $request->date)
            ->first();
        
        
        
        if($user){
            $booked[] = $request->user_id;
        }else{
            $notbooked[] = $request->user_id;
        }
        
        $labourers = DB::table('site_manager_labourer')->where('site_manager_id', $request->user_id)->get();
        foreach($labourers as $labourer){
            $all[] = $labourer->labourer_id;
            $user = DB::table('project_planning')
            ->where('user_id', $labourer->labourer_id)
            ->where('date', $request->date)
            ->first();
            if($user){
                $booked[] = $labourer->labourer_id;
            }else{
                $notbooked[] = $labourer->labourer_id;
            }
        }
        
        
        $users = DB::table('users')
            ->whereIn('id', $notbooked)
            ->pluck('id')
            ->toArray();
        
        $book = DB::table('users')
            ->whereIn('id', $booked)
            ->pluck('id')
            ->toArray();
        
        $booked_names = DB::table('users')
            ->select(DB::raw("CONCAT(firstname, ' ', lastname) AS fullname"))
            ->whereIn('id', $booked)
            ->get()
            ->pluck('fullname')
            ->toArray();
        
        $unbooked_names = DB::table('users')
            ->select(DB::raw("CONCAT(firstname, ' ', lastname) AS fullname"))
            ->whereIn('id', $notbooked)
            ->get()
            ->pluck('fullname')
            ->toArray();
        
        $response = array(
            'all_users' => $users,
            'booked' => $book,
            'booked_names' => implode(', ', $booked_names),
            'unbooked_names' => implode(', ', $unbooked_names),
            'project_id' => $request->project_id,
            'date' => $request->date,
        );
        return json_encode($response);
    }
    
    
    public function addPlanning(Request $request)
    {
        $response = array();
        
        if(isset($request->days)){
            $daysToAdd = $request->days;
            
            $dates = [];
            $start = Carbon::parse($request->date);
            
            if($request->direction == 'right'){
                for ($i = 0; $i <= $daysToAdd; $i++) {
                    $dates[] = $start->copy()->addDays($i)->format('Y-m-d');
                }
            }else{
                $daysToAdd--;
                // Adding backward dates
                for ($i = 1; $i <= $daysToAdd; $i++) {
                    $dates[] = $start->copy()->subDays($i)->format('Y-m-d');
                }

                // Optional: Sort dates to maintain a proper sequence if needed
                sort($dates);
            }
            
            
            
            
            foreach($dates as $date){
                $dayName = date('l', strtotime($date));
                $check = DB::table('project_planning')->where('user_id', $request->user_id)->where('project_id', $request->project_id)->where('date', $date)->first();
                if(!$check){
                    DB::table('project_planning')->insertGetId(
                         array(
                                'user_id'   =>   $request->user_id,
                                'project_id'   =>   $request->project_id,
                                'date'   =>   $date,
                                'created_at' => date('Y-m-d H:i'),
                         )
                    );
                }


                $labourers = DB::table('site_manager_labourer')->where('site_manager_id', $request->user_id)->get();
                foreach($labourers as $labourer){
                    $check = DB::table('project_planning')->where('user_id', $labourer->labourer_id)->where('project_id', $request->project_id)->where('date', $date)->first();
                    if(!$check){
                        DB::table('project_planning')->insertGetId(
                             array(
                                    'user_id'   =>   $labourer->labourer_id,
                                    'project_id'   =>   $request->project_id,
                                    'date'   =>   $date,
                                    'created_at' => date('Y-m-d H:i'),
                             )
                        );
                    }
                }
                
            }
            
            
            
            $response = 'success';
            return response()->json(['success' => $response]);
            die();
            
        }
        
        $check = DB::table('project_planning')
            ->where('user_id', $request->user_id)
            ->where('date', $request->date)
            ->count();
        if($check<2){
            if($check==0){
                $period = 1;
            }elseif($check==1){
                $period = 2;
            }
            if(isset($request->user_current_project) && !empty($request->user_current_project)){
                DB::table('project_planning')->where('user_id', $request->user_id)->where('date', $request->user_current_project)->delete();
            }
            
            DB::table('project_planning')->insertGetId(
                 array(
                        'user_id'   =>   $request->user_id,
                        'project_id'   =>   $request->project_id,
                        'date'   =>   $request->date,
                        'created_at' => date('Y-m-d H:i'),
                        'period' => $period,
                 )
            );
        }
        
        
        $labourers = DB::table('site_manager_labourer')->where('site_manager_id', $request->user_id)->get();
        foreach($labourers as $labourer){
            $check = DB::table('project_planning')
                ->where('user_id', $labourer->labourer_id)
                ->where('date', $request->date)
                ->first();
            if(!$check){
                DB::table('project_planning')->insertGetId(
                     array(
                            'user_id'   =>   $labourer->labourer_id,
                            'project_id'   =>   $request->project_id,
                            'date'   =>   $request->date,
                            'created_at' => date('Y-m-d H:i'),
                     )
                );
            }
        }
        
        $response = 'success';
        return response()->json(['success' => $response]);
    }
    
    
    public static function getDatesOfMonth($m) {
        // Create a DateTime object for the first day of the given month and year
        $date = new \DateTime($m);

        // Get the total number of days in the month
        $daysInMonth = $date->format('t');

        // Array to store the dates
        $dates = [];

        // Loop through each day of the month
        for ($day = 1; $day <= $daysInMonth; $day++) {
            // Add the date to the array
            $dates[] = $date->format('Y-m-d');

            // Move to the next day
            $date->modify('+1 day');
        }

        return $dates;
    }
    
    private function getCurrentWeekDates($weekOffset=0)
    {
        $now = new \DateTime();
        $now->modify("{$weekOffset} week");

        // Find the current week's Monday
        if ($now->format('N') != 1) {
            $now->modify('last monday');
        }

        // Initialize an array to hold the dates
        $weekDates = [];

        // Loop from Monday to Sunday
        for ($i = 0; $i < 7; $i++) {
            $weekDates[] = $now->format('Y-m-d');
            $now->modify('+1 day');
        }

        return $weekDates;
    }
    
}