<?php

namespace App\Http\Controllers;
use DB;
use App\Quotation;
use Illuminate\Http\Request;
use App\Patients;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use App\Doctors;
use Session;
use App\Questionnaire;
use Illuminate\Support\Facades\Auth;
use Redirect;
use Carbon\Carbon;
use PDF;
use ZipArchive;
use Illuminate\Support\Str;
use Mpdf\Mpdf;
use Image;
use Illuminate\Support\Facades\File;
use Webklex\IMAP\Facades\Client;
use Illuminate\Support\Facades\Http;
class ProjectController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth')->except('viewVariationByLink', 'changeVariationStatus', 'viewSubContractByLink');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    
    
    
    public function viewProjects(Request $request)
    {
        if(Auth::user()->perm_projects==0){
            abort(403);
        }
        $userId = Auth::id();
        $projects = DB::table('projects as a')
        ->leftJoin('customers as b', 'a.customer_id', '=', 'b.id')
        ->leftJoin('project_statuses as c', 'a.project_status', '=', 'c.id')
        ->leftJoin('project_types as d', 'a.project_type', '=', 'd.id')
        ->leftJoin('user_project_likes as e', function ($join) use ($userId) {
            $join->on('a.id', '=', 'e.project_id')
                 ->where('e.user_id', '=', $userId);
        })
        ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type', DB::raw('IF(e.project_id IS NULL, 0, 1) as is_favorite'))
        ->orderBy('a.id', 'desc')
        ->where('project_status', '!=', 1)
        ->get();
        
        $new_projects = DB::table('projects as a')
        ->leftJoin('customers as b', 'a.customer_id', '=', 'b.id')
        ->leftJoin('project_statuses as c', 'a.project_status', '=', 'c.id')
        ->leftJoin('project_types as d', 'a.project_type', '=', 'd.id')
        ->leftJoin('user_project_likes as e', function ($join) use ($userId) {
            $join->on('a.id', '=', 'e.project_id')
                 ->where('e.user_id', '=', $userId);
        })
        ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type', DB::raw('IF(e.project_id IS NULL, 0, 1) as is_favorite'))
        ->orderBy('a.id', 'desc')
        ->where('project_status', 1)
        ->get();
        
        foreach($projects as $project){
            $current = DB::table('project_status_history')->where('project_id', $project->id)->where('status_id', $project->project_status)->orderBy('id', 'desc')->limit(1)->first();
            if($current){
                $project->end_date = $current->end_date;
            }else{
                $project->end_date = "";
            }
        }
        
        foreach($new_projects as $project){
            $current = DB::table('project_status_history')->where('project_id', $project->id)->where('status_id', $project->project_status)->orderBy('id', 'desc')->limit(1)->first();
            if($current){
                $project->end_date = $current->end_date;
            }else{
                $project->end_date = "";
            }
        }
        
        $projects = $projects->sortBy(function($project) {
            return $project->end_date ? strtotime($project->end_date) : PHP_INT_MAX;
        });
        

        
        $project_types = DB::table('project_types')->orderBy('name', 'asc')->get();
        $statusses = DB::table('project_statuses')->orderBy('name', 'asc')->get();
        $customers = DB::table('customers')->orderBy('id', 'asc')->get();
        
        //$customer = DB::table('customers')->where('id', $id)->first();
        return view('project.projects', ['projects' => $projects, 'project_types' => $project_types, 'statusses' => $statusses, 'customers'=>$customers, 'new_projects'=>$new_projects]);
    }
    
    
    public function deleteProject(Request $request)
    {
        DB::table('projects')->where('id', $request->project_id)->delete();
        DB::table('project_financials')->where('project_id', $request->project_id)->delete();
        DB::table('project_documents')->where('project_id', $request->project_id)->delete();
        DB::table('project_emails')->where('project_id', $request->project_id)->delete();
        DB::table('project_images')->where('project_id', $request->project_id)->delete();
        DB::table('project_invoices')->where('project_id', $request->project_id)->delete();
        DB::table('project_invoice_items')->where('project_id', $request->project_id)->delete();
        DB::table('project_invoice_items')->where('project_id', $request->project_id)->delete();
        DB::table('project_planning')->where('project_id', $request->project_id)->delete();
        DB::table('project_planning')->where('project_id', $request->project_id)->delete();
        DB::table('project_status_history')->where('project_id', $request->project_id)->delete();
        DB::table('project_uplift_history')->where('project_id', $request->project_id)->delete();
        DB::table('project_variations')->where('project_id', $request->project_id)->delete();
        DB::table('user_project_likes')->where('project_id', $request->project_id)->delete();
        DB::table('project_sub_contracts')->where('project_id', $request->project_id)->delete();
        return redirect()->route('projects.view')->with('success', 'Project removed successfully.');
    }
    
    
    public function exportImages(Request $request, $id)
    {
        
        $before_images = explode(',', $request->before_images);
        $first_site = explode(',', $request->first_site);
        
        
        
        $beforeArray = array();
        $firstSiteArray = array();
        
        if(!empty($request->before_images)){
            foreach($before_images as $bi){
                $image = DB::table('project_images')->where('id', $bi)->first();
                if(isset($image->file)){
                    $beforeArray[] = asset('img/projects/'.$image->file);
                }
            }
        }
        
        if(!empty($request->first_site)){
            foreach($first_site as $fs){
                $image = DB::table('project_images')->where('id', $fs)->first();
                if(isset($image->file)){
                    $firstSiteArray[] = asset('img/projects/'.$image->file);
                }
            }
        }
        
        
        $project = DB::table('projects')->where('id', $id)->first();
        
        /*$options = new Options();
        $options->set('isPhpEnabled', true);
        $options->set('isHtml5ParserEnabled', true);
        $options->set('isRemoteEnabled', true);*/
        
        $mpdf = new Mpdf([
            'tempDir' => storage_path('/tmp'),
            'mode' => 'utf-8',
            'format' => 'A4'
        ]);

        // Start buffer
        ob_start();
        $max_per_page = $request->images_per_screen;

// HTML content to be rendered into PDF
$html = '<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>mPDF Example</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 0;
      padding: 0;
    }
    table {
      width: 100%;
      border-collapse: collapse;
    }
    table td {
      padding: 5px;
      text-align: center;
    }
    table img {
      width: 100%;
      height: 250px;
    }
  </style>
</head>
<body>';
        
$html .= '<div style="position:absolute;right:20px"><img width="150px" src="'.asset('img/walker.png').'"></div><center><h1>Image Report<br><span style="font-size:14px">'.date('d F Y').'</span></h1></center>';
        
$html .= '<p><b>Project ID: WG-'.str_pad($project->id, 4, '0', STR_PAD_LEFT).'</b> <br>
<b>Customer Location: Grosvenor Waterside, London</b>
<br>
</p>';

// Loop through $beforeArray and create pages dynamically
$total_images = count($beforeArray);
$start_index = 0;

while ($start_index < $total_images) {
    $end_index = $start_index + $max_per_page;
    $chunk = array_slice($beforeArray, $start_index, $max_per_page);
    $html .= '<h2 style="text-align:center">Before</h2>';
    $html .= '<table>';
    foreach (array_chunk($chunk, 3) as $row) {
        $html .= '<tr>';
        foreach ($row as $image) {
            $html .= '<td width="33%"><img style="margin-bottom:25px;margin-top:25px;width:250px;height:250px" src="' . $image . '" alt="Image"><p style="font-size:15px;margin-top:20px;margin-bottom:20px;">Location: 67 Grosvenor St, London<br>Date and Time: '.date('F d, Y h:ia').'</p></td>';
        }
        // Fill remaining cells if less than 3 images in the last row
        $num_cells = count($row);
        if ($num_cells < 3) {
            $remaining_cells = 3 - $num_cells;
            for ($i = 0; $i < $remaining_cells; $i++) {
                $html .= '<td></td>'; // Add empty TDs for missing images
            }
        }
        $html .= '</tr>';
    }
    $html .= '</table>';
    
    // Add page break after each set of 9 images
    if ($end_index < $total_images) {
        $html .= '<div style="page-break-after: always;"></div>';
    }
    
    $start_index = $end_index;
}
        
        
$total_images = count($firstSiteArray);
$start_index = 0;

while ($start_index < $total_images) {
    $end_index = $start_index + $max_per_page;
    $chunk = array_slice($firstSiteArray, $start_index, $max_per_page);
    if(!empty($beforeArray)){
        $html .= '<div style="page-break-after: always;"></div>';
    }
    $html .= '<h2 style="text-align:center">1st Site Visit</h2>';
    $html .= '<table>';
    foreach (array_chunk($chunk, 3) as $row) {
        $html .= '<tr>';
        foreach ($row as $image) {
            $html .= '<td width="33%"><img style="margin-bottom:25px;margin-top:25px;width:250px;height:250px" src="' . $image . '" alt="Image"><p style="font-size:15px;margin-top:20px;margin-bottom:20px;">Location: 67 Grosvenor St, London<br>Date and Time: '.date('F d, Y h:ia').'</p></td>';
        }
        // Fill remaining cells if less than 3 images in the last row
        $num_cells = count($row);
        if ($num_cells < 3) {
            $remaining_cells = 3 - $num_cells;
            for ($i = 0; $i < $remaining_cells; $i++) {
                $html .= '<td></td>'; // Add empty TDs for missing images
            }
        }
        $html .= '</tr>';
    }
    $html .= '</table>';
    
    // Add page break after each set of 9 images
    if ($end_index < $total_images) {
        $html .= '<div style="page-break-after: always;"></div>';
    }
    
    $start_index = $end_index;
}

$html .= '</body></html>';

        // Get buffer content and clean buffer
        //$html = ob_get_clean();

        // Write PDF content
        $mpdf->WriteHTML($html);

        // Output PDF to browser or download
        $mpdf->Output('project-report.pdf', 'D'); // D = download, I = inline

        exit;
        
    }
    
    
    
    
    
    public function addNewProject(Request $request)
    {
        $response = array();
        
        $this->validate($request, [
            'title'   =>   'required|string',
            'project_type'   =>   'required|int',
            'project_status'   =>   'required|int',
            'email'   =>   'required|string',
            'name'   =>   'required|string',
            'customer_id'   =>   'required|int',
        ]);
        
        $red = mt_rand(0, 127);
        $green = mt_rand(0, 127);
        $blue = mt_rand(0, 127);
        $tender = isset($request->tenderProject) ? 1 : 0;

        $randomDarkColor = sprintf('#%02X%02X%02X', $red, $green, $blue);
        
        $projectid = DB::table('projects')->insertGetId(
             array(
                    'title'   =>   $request->title,
                    'customer_id'   =>   $request->customer_id,
                    'customer_name'   =>   $request->name,
                    'customer_email'   =>   $request->email,
                    'customer_phone'   =>   $request->phone,
                    'customer_ref'   =>   $request->customer_ref,
                    'project_type'   =>   $request->project_type,
                    'project_status'   =>   $request->project_status,
                    'image' => 'placeholder.jpg',
                    'created_at' => date('Y-m-d H:i'),
                    'border'=>$randomDarkColor,
                    'tender'=>$tender,
             )
        );
        
        DB::table('customer_contacts')->insertGetId(
             array(
                    'company_id'   =>   $request->customer_id,
                    'name'   =>   $request->name,
                    'email'   =>   $request->email,
                    'phone'   =>   $request->phone,
                    'created_at'   =>   date('Y-m-d H:i'),
             )
        );
        
        $status = DB::table('project_statuses')->where('id', $request->project_status)->first();
        
        DB::table('project_status_history')->insertGetId(
             array(
                    'project_id'   =>   $projectid,
                    'status_id'   =>   $request->project_status,
                    'start_date'   =>   date('Y-m-d H:i'),
                    'end_date'   =>   Carbon::now()->addDays($status->completion_days)->toDateString(),
             )
        );
        
        $milestones = DB::table('project_milestones')
            ->where('project_type_id', $request->project_type)
            ->orderBy('sort', 'asc')
            ->get();
        if($milestones){
            foreach($milestones as $milestone){
                DB::table('milestones')->insertGetId(
                     array(
                            'milestone_id'   =>   $milestone->id,
                            'project_id'   =>   $projectid,
                            'milestone_name'   =>   $milestone->name,
                     )
                );
            }
        }
        
        $request->session()->flash('success', 'Project added successfully.');
        return redirect()->back();
    }
    
    
    public function showMilestones(Request $request)
    {
        if(Auth::user()->perm_projects==0){
            abort(403);
        }
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        
        $milestones = DB::table('milestones as a')
            ->leftjoin('users as b', 'a.completed_by', '=', 'b.id')
            ->select('a.*', 'b.firstname', 'b.lastname')
            ->where('a.project_id', $request->id)
            ->get();
        
        $project_milestones = DB::table('project_milestones')->where('project_type_id', $project->project_type)->get();
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        return view('project.milestones', ['customer' => $customer, 'project' => $project, 'milestones' => $milestones, 'project_milestones'=>$project_milestones]);
    }
    
    
    public function showVariations(Request $request)
    {
        if(Auth::user()->perm_projects==0){
            abort(403);
        }
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        $contacts = DB::table('customer_contacts')->where('company_id', $customer->id)->get();
        $suppliers = DB::table('customers')->where('type', 'supplier')->get();
        $uoms = DB::table('financial_uoms')->orderBy('id', 'asc')->get();
        $variations = DB::table('project_variations')->where('project_id', $request->id)->get();
        foreach($variations as $variation){
            $variation->items = DB::table('variation_items')->where('variation_id', $variation->id)->get();
        }
        $f_items = DB::table('financial_items')->get();
        return view('project.variations', ['customer' => $customer, 'project' => $project, 'suppliers'=>$suppliers,  'uoms'=>$uoms, 'variations'=>$variations, 'f_items'=>$f_items, 'contacts'=>$contacts]);
    }
    
    
    public function showSubContractsQuote(Request $request, $id)
    {
        if(Auth::user()->perm_projects==0){
            abort(403);
        }
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        $suppliers = DB::table('customers')->where('type', 'supplier')->get();
        $titles = DB::table('sub_contract_titles')->orderBy('name', 'asc')->get();
        
        $subcontracts = DB::table('project_sub_contracts')->where('project_id', $request->id)->get();
        
        if(request()->has('sc_id')){
            $subcontract = $subcontracts->firstWhere('id', $request->sc_id);
        }else{
            $subcontract = $subcontracts->first();
        }
        
        if ($subcontract) {
            $subcontract->suppliers = DB::table('sub_contract_quotes as a')
            ->select('a.*', 'b.company_name')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->leftjoin('customer_contacts as c', 'a.contact_id', '=', 'c.id')
            ->where('a.sub_contract_id', $subcontract->id)
            ->get();
            $subcontract->documents = DB::table('sub_contract_documents as a')->where('sub_contract_id', $subcontract->id)->orderBy('id', 'desc')->get();
            
            foreach($subcontract->suppliers as $supplier){
                $supplier->items = DB::table('sub_contract_accepted_items as a')
                    ->leftjoin('financial_items as b', 'a.item_id', '=', 'b.id')
                    ->where('a.quote_id', $supplier->id)
                    ->orderBy('a.id', 'desc')
                    ->get();
            }
            
        }
        
        $uoms = DB::table('financial_uoms')->orderBy('id', 'asc')->get();
        
        $items = DB::table('project_financials as a')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
            ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
            ->where('a.project_id', $id)
            ->orderBy('a.id', 'desc')
            ->get();
        
        
        return view('project.sub_contracts_quote', ['customer' => $customer, 'project' => $project, 'suppliers'=>$suppliers, 'subcontracts'=>$subcontracts, 'subcontract'=>$subcontract, 'uoms'=>$uoms, 'items'=>$items, 'titles'=>$titles]);
    }
    
    
    public function showCorrespondence(Request $request)
    {
        if(Auth::user()->perm_projects==0){
            abort(403);
        }
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        $correspondence = DB::table('correspondence')->where('project_id', $project->id)->get();
        $users = DB::table('users')->where('role', 'user')->get();
        return view('project.correspondence', ['customer' => $customer, 'project' => $project, 'users'=>$users, 'correspondence'=>$correspondence]);
    }
    
    public function showEmails(Request $request)
    {
        if(Auth::user()->perm_projects==0){
            abort(403);
        }
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        $emails = DB::table('project_emails')->where('project_id', $project->id)->orderBy('id', 'desc')->get();
        $users = DB::table('users')->where('role', 'user')->get();
        
        
        
        
        
        return view('project.emails', ['customer' => $customer, 'project' => $project, 'users'=>$users, 'emails'=>$emails]);
    }
    
    
    public function showDocuments(Request $request)
    {
        if(Auth::user()->perm_projects==0){
            abort(403);
        }
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        
        $documents = DB::table('project_documents')
            ->where('project_id', $request->id)
            ->where('rams', 0)
            ->orderBy('favourite', 'desc')
            ->orderBy('id', 'desc')
            ->get();
        
        $rams_pdf = DB::table('project_documents')
            ->where('project_id', $request->id)
            ->where('rams', 1)
            ->first();
        
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        return view('project.documents', ['customer' => $customer, 'project' => $project,  'documents'=>$documents, 'rams_pdf'=>$rams_pdf]);
    }
    
    
    public function showImages(Request $request)
    {
        if(Auth::user()->perm_projects==0){
            abort(403);
        }
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        
        $before_images = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', 'before')
            ->orderBy('id', 'desc')
            ->get();
        
        $first_site_visit = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', '1st_site_visit')
            ->orderBy('id', 'desc')
            ->get();
        
        $during = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', 'during')
            ->orderBy('id', 'desc')
            ->get();
        
        $completed = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', 'project_completed')
            ->orderBy('id', 'desc')
            ->get();
        
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        return view('project.images', ['customer' => $customer, 'project' => $project,  'before_images'=>$before_images, 'first_site_visit'=>$first_site_visit, 'during'=>$during, 'completed'=>$completed]);
    }
    
    
    public function showBeforeImages(Request $request)
    {
        if(Auth::user()->perm_projects==0){
            abort(403);
        }
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        
        $before_images = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', 'before')
            ->orderBy('id', 'desc')
            ->get();
        
        
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        return view('project.all_images', ['customer' => $customer, 'project' => $project,  'before_images'=>$before_images, 'type'=>'Before']);
    }
    
    public function showFirstSiteImages(Request $request)
    {
        if(Auth::user()->perm_projects==0){
            abort(403);
        }
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        
        $before_images = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', '1st_site_visit')
            ->orderBy('id', 'desc')
            ->get();
        
        
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        return view('project.all_images', ['customer' => $customer, 'project' => $project,  'before_images'=>$before_images, 'type'=>'First Site']);
    }
    
    public function showDuringImages(Request $request)
    {
        if(Auth::user()->perm_projects==0){
            abort(403);
        }
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        
        $before_images = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', 'during')
            ->orderBy('id', 'desc')
            ->get();
        
        
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        return view('project.all_images', ['customer' => $customer, 'project' => $project,  'before_images'=>$before_images, 'type'=>'During']);
    }
    
    public function showCompletedImages(Request $request)
    {
        if(Auth::user()->perm_projects==0){
            abort(403);
        }
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        
        $before_images = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', 'project_completed')
            ->orderBy('id', 'desc')
            ->get();
        
        
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        return view('project.all_images', ['customer' => $customer, 'project' => $project,  'before_images'=>$before_images, 'type'=>'Project Completed']);
    }
    
    
    public function uploadDocument(Request $request, $id)
    {
        $request->validate([
            'file' => 'required|mimes:jpeg,png,jpg,gif,pdf,doc,docx,xls,xlsx,ppt,pptx,txt,zip|max:2048',
        ]);

        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $ext = $file->getClientOriginalExtension();
            $filename = uniqid(time()) . '.' . $ext;
            $name = $file->getClientOriginalName();
            $file->move(public_path('documents'), $filename);
            $added = date('Y-m-d H:i');
            $fileid = DB::table('project_documents')->insertGetId(
                 array(
                        'project_id'   =>   $id,
                        'name'   =>   $name,
                        'file'   =>   $filename,
                        'created_at'   =>   $added,
                        'type'   =>   $ext,
                 )
            );

            
            $response = array();
            $response['filename'] = $filename;
            $response['name'] = $name;
            $response['type'] = $ext;
            $response['created_at'] = $added;
            $response['file_id'] = $fileid;
            return response()->json(['success' => $response]);
        }

        return response()->json(['error' => 'No file uploaded'], 400);
    }
    
    
    public function updateImage(Request $request)
    {
        $request->validate([
            'image' => 'required|mimes:jpeg,png,jpg,gif|max:3072',
        ]);

        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $ext = $file->getClientOriginalExtension();
            $filename = uniqid(time()) . '.' . $ext;
            $name = $file->getClientOriginalName();
            $file->move(public_path('img/projects'), $filename);
            $added = date('Y-m-d H:i');
            $fileid = DB::table('project_images')->where('id', $request->image_id)->update(
                 array(
                        'name'   =>   $name,
                        'file'   =>   $filename,
                        'small_file'   =>   $filename,
                        'type'   =>   $request->type,
                 )
            );
            
            $request->session()->flash('success', 'Image updated successfully.');
            return redirect()->back();
        }

    }
    
    
    public function sendVariation(Request $request)
    {
        $contact = DB::table('customer_contacts')->where('id', $request->contact_id)->first();
        $variation = DB::table('project_variations')->where('id', $request->variation_id)->first();
        DB::table('project_variations')->where('id', $request->variation_id)->update(
             array(
                    'sent'   =>   1,
                    'attention'   =>   $request->contact_id,
             )
        );
        $link = route('project.viewVariationByLink', ['token'=>$variation->token]);
        $mail = new PHPMailer(true);
        try {
            //Server settings
            $mail->isSMTP();
            $mail->Host = env('MAIL_HOST');
            $mail->SMTPAuth = true;
            $mail->Username = env('MAIL_USERNAME');
            $mail->Password = env('MAIL_PASSWORD');
            $mail->SMTPSecure = 'tls';
            $mail->Port = env('MAIL_PORT');

            //Recipients
            $mail->setFrom(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'));
            $mail->addAddress($contact->email);

            // Content
            $mail->isHTML(true);
            $mail->Subject = 'Variation Request for Project: WG-'.str_pad($variation->project_id, 4, '0', STR_PAD_LEFT);
            $mail->Body    = 'Dear Customer, <br>Please find the link below for variation request. <br> If you can accept or decline the variation as soon as possible, as we have workers on site ready to commence the work. <br> <a href="'.$link.'">'.$link.'</a>';
            $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';

            if($mail->send()){
                $request->session()->flash('success', 'Variation link sent successfully.');
                return redirect()->back();
            }
            //echo 'Message has been sent';
        } catch (Exception $e) {
            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        }
    }
    
    
    public function uploadSubContractDocuments(Request $request, $id)
    {
        /*$request->validate([
            'file' => 'required|mimes:jpeg,png,jpg,gif|max:3072',
        ]);*/

        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $ext = $file->getClientOriginalExtension();
            $filename = uniqid(time()) . '.' . $ext;
            $name = $file->getClientOriginalName();
            $file->move(public_path('documents/sub_contracts_quotes/'), $filename);
            $added = date('Y-m-d H:i');
            
            $fileid = DB::table('sub_contract_documents')->insertGetId(
                 array(
                        'project_id'   =>   $id,
                        'sub_contract_id'   =>   $request->sub_contract_id,
                        'name'   =>   $name,
                        'file'   =>   $filename,
                        'created_at'   =>   $added,
                 )
            );
            
            $response = array();
            return response()->json(['success' => 1]);
        }

        return response()->json(['error' => 'No file uploaded'], 400);
    }
    
    
    public function uploadProjectImages(Request $request, $id)
    {
        $request->validate([
            'file' => 'required|mimes:jpeg,png,jpg,gif|max:3072',
        ]);

        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $ext = $file->getClientOriginalExtension();
            $filename = uniqid(time()) . '.' . $ext;
            $name = $file->getClientOriginalName();
            $file->move(public_path('img/projects'), $filename);
            $added = date('Y-m-d H:i');
            
            // Create an Intervention Image instance
            $image = public_path('img/projects/'.$filename);
            $img = Image::make($image);
            $quality = 25; // Example quality setting

            // Define the path to save the image
            $destinationPath = public_path('/img/projects/small');
            $imageName = uniqid(time()).'.'.$ext;

            // Save the image
            $img->save($destinationPath.'/'.$imageName, $quality);
            
            $fileid = DB::table('project_images')->insertGetId(
                 array(
                        'project_id'   =>   $id,
                        'name'   =>   $name,
                        'file'   =>   $filename,
                        'small_file' => $imageName,
                        'created_at'   =>   $added,
                        'type'   =>   $request->images_type,
                 )
            );
            
            $response = array();
            return response()->json(['success' => 1]);
        }

        return response()->json(['error' => 'No file uploaded'], 400);
    }
    
    
    public function uploadImage(Request $request, $id)
    {
        $request->validate([
            'image' => 'required|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $ext = $file->getClientOriginalExtension();
            $filename = uniqid(time()) . '.' . $ext;
            $file->move(public_path('img/projects'), $filename);
            $added = date('Y-m-d H:i');
            DB::table('projects')->where('id', $id)->update(
                 array(
                        'image'   =>   $filename,
                 )
            );
            
            $request->session()->flash('success', 'Image updated successfully.');
            return redirect()->back();
            
        }
    }
    
    
    public function addToFavourites(Request $request)
    {
        $status = 0;
        $like = DB::table('user_project_likes')
            ->where('project_id', $request->project_id)
            ->where('user_id', Auth::id())
            ->first();
        
        if($like){
            DB::table('user_project_likes')
            ->where('project_id', $request->project_id)
            ->where('user_id', Auth::id())
            ->delete();
            $message = 'Project removed to favorites';
        }else{
            $status = 1;
            DB::table('user_project_likes')->insert([
                'user_id'   =>   Auth::id(),
                'project_id'   =>   $request->project_id,
            ]);
            $message = 'Project added to favorites';
        }
        return response()->json(['success' => true, 'message' => $message, 'status' =>$status]);
    }
    
    
    public function showPoDetails(Request $request)
    {
        $po = DB::table('project_purchase_orders as a')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->select('a.*', 'b.company_name as supplier')
            ->where('a.id', $request->po_id)->first();
        
        $po->number = 'PO-'.str_pad($po->id, 4, '0', STR_PAD_LEFT);
        $po->amount = number_format($po->amount, 2);
        if(!empty($po->receipt_photo)){
            $po->receipt_photo = asset('img/purchase_orders/'.$po->receipt_photo);
        }else{
            $po->receipt_photo = "";
        }
        
        return response()->json(['po' => $po]);
    }
    
    public function getQuoteItemDetails(Request $request)
    {
        $item = DB::table('contractor_quotes_items')->where('id', $request->item_id)->first();
        return response()->json(['item' => $item]);
    }
    
    
    public function bookmarkDocument(Request $request)
    {
        $status = 0;
        $document = DB::table('project_documents')->where('id', $request->document_id)->first();
        
        if($document->favourite==1){
            $status = 0;
            $message = 'Document removed to favorites';
        }else{
            $status = 1;
            $message = 'Document added to favorites';
        }
        
        DB::table('project_documents')->where('id', $request->document_id)->update(
             array(
                    'favourite'   =>   $status,
             )
        );

        return response()->json(['success' => true, 'message' => $message, 'status' =>$status]);
    }
    
    
    public function addMilestone(Request $request, $id)
    {
        DB::table('milestones')->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'milestone_id'   =>   $request->milestone_id,
             )
        );
        
        $request->session()->flash('success', 'Milestone added successfully.');
        return redirect()->back();
    }
    
    public function addMoreSuppliers(Request $request, $id)
    {
        $project = DB::table('projects')->where('id', $id)->first();
        $subcontract = DB::table('project_sub_contracts')->where('id', $request->sub_contract_id)->first();
        
        DB::table('sub_contract_quotes')->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'sub_contract_id'   =>   $request->sub_contract_id,
                    'supplier_id' => $request->supplier_id,
                    'contact_id' => $request->contact_id,
             )
        );
        
        $contact = DB::table('customer_contacts')->where('id', $request->contact_id)->first();
        if($contact){
            $link = route('project.viewSubContractByLink', ['token'=>$subcontract->token]);
            $this->sendSubContractQuoteMail($contact, $project, $link);
        }
        
        $request->session()->flash('success', 'Supplier added successfully.');
        return redirect()->back();
    }
    
    
    public function sendSubContractAsLink(Request $request, $id)
    {
        $project = DB::table('projects')->where('id', $id)->first();
        $subcontract = DB::table('project_sub_contracts')->where('id', $request->sub_contract_id)->first();
        $supplier = DB::table('sub_contract_quotes')->where('sub_contract_id', $request->sub_contract_id)->where('supplier_id', $request->supplier_id)->first();
        
        $contact = DB::table('customer_contacts')->where('id', $supplier->contact_id)->first();
        if($contact){
            $link = route('project.viewSubContractByLink', ['token'=>$subcontract->token]);
            $this->sendSubContractQuoteMail($contact, $project, $link);
        }
        
        $request->session()->flash('success', 'Link sent successfully.');
        return redirect()->back();
    }
    
    
    public function addSubContractQuotes(Request $request, $id)
    {
        $token = uniqid(time());
        $project = DB::table('projects')->where('id', $id)->first();
        
        $sub_contract_id = DB::table('project_sub_contracts')->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'title'   =>   $request->title,
                    'notes'   =>   $request->notes,
                    'token' => $token,
             )
        );
        
        foreach($request->suppliers as $supplier){
            DB::table('sub_contract_quotes')->insertGetId(
                 array(
                        'project_id'   =>   $id,
                        'sub_contract_id'   =>   $sub_contract_id,
                        'supplier_id'   =>   $supplier,
                        'contact_id'   =>   $request->contact[$supplier],
                 )
            );
            
            $contact = DB::table('customer_contacts')->where('id', $request->contact[$supplier])->first();
            if($contact){
                $link = route('project.viewSubContractByLink', ['token'=>$token]);
                $this->sendSubContractQuoteMail($contact, $project, $link);
            }
        }
        
        echo $sub_contract_id;
        die();
        //$request->session()->flash('success', 'Milestone added successfully.');
        //return redirect()->back();
    }
    
    
    private function sendSubContractQuoteMail($contact, $project, $link)
    {
        $mail = new PHPMailer(true);
        try {
            //Server settings
            $mail->isSMTP();
            $mail->Host = env('MAIL_HOST');
            $mail->SMTPAuth = true;
            $mail->Username = env('MAIL_USERNAME');
            $mail->Password = env('MAIL_PASSWORD');
            $mail->SMTPSecure = 'tls';
            $mail->Port = env('MAIL_PORT');

            //Recipients
            $mail->setFrom(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'));
            $mail->addAddress($contact->email);

            // Content
            $mail->isHTML(true);
            $mail->Subject = 'Sub Contract for Project: WG-'.str_pad($project->id, 4, '0', STR_PAD_LEFT);
            $mail->Body    = 'Dear Supplier, <br>Please find the link below for sub contract quote. <br><a href="'.$link.'">'.$link.'</a>';
            $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';
            $mail->send();
        } catch (Exception $e) {
            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        }
    }
    
    public function deleteFinancialItem(Request $request)
    {
        DB::table('project_financials')->where('id', $request->delete_id)->delete();
        $request->session()->flash('success', 'Item removed successfully.');
        return redirect()->back();
    }
    
    public function addCorrespondence(Request $request, $id)
    {
        
        $correspondence_id = DB::table('correspondence')->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'title'   =>   $request->title,
                    'notes'   =>   $request->notes,
                    'created_at'   =>   date('Y-m-d H:i'),
             )
        );
        
        foreach($request->users as $user){
            DB::table('correspondence_users')->insertGetId(
                 array(
                        'correspondence_id'   =>   $correspondence_id,
                        'user_id'   =>   $user,
                 )
            );
        }
        
        $request->session()->flash('success', 'Correspondence added successfully.');
        return redirect()->back();
    }
    
    
    public function addVariation(Request $request, $id)
    {
        $token = uniqid(time());
        DB::table('project_variations')->insertGetId(
             array(
                    'name'   =>   $request->name,
                    'description'   =>   $request->notes,
                    'token'   =>   $token,
                    'project_id'   =>   $id,
                    'created_at'   =>   date('Y-m-d H:i'),
             )
        );
        
        $request->session()->flash('success', 'Variation added successfully.');
        return redirect()->back();
    }
    
    
    public function addFinancials(Request $request, $id)
    {
        $added_ids = array();
        foreach($request->items as $item){
            
            $financial = DB::table('financial_items')->where('id', $item)->first();
            if($financial){
                $financialid = DB::table('project_financials')->insertGetId(
                     array(
                            'code'   =>   $financial->code,
                            'description'   =>   $financial->description,
                            'item_id'   =>   $item,
                            'sales_price'   =>   $financial->sales_price,
                            'plant'   =>   $financial->plant,
                            'labour'   =>   $financial->labour,
                            'material'   =>   $financial->material,
                            'uom'   =>   $financial->uom,
                            'project_id'   =>   $id,
                            'quantity'   =>   $financial->quantity,
                            'credit_note'   =>   $financial->credit_note,
                     )
                );   
                
                $added_ids[] = $financialid;
            }
        }
        
        $request->session()->flash('success', 'Financials added successfully.');
        return redirect()->back()->with('added_ids', $added_ids);
    }
    
    
    public function deleteTenderItem (Request $request)
    {
        DB::table('project_financials')->where('id', $request->item_id)->delete();
        echo 1;
    }
    
    
    public function editTenderFinancials (Request $request, $id)
    {
        $tenderData =  DB::table('tender_project_files')->where('project_id', $id)->first();
        $tenderItems = DB::table('project_financials')->where('project_id', $id)->get();
        return view('project.edit_tender_financials', ['tenderItems' => $tenderItems, 'project_id' => $id, 'tenderData'=>$tenderData]);
    }
    
    public function updateTenderItems (Request $request)
    {
        $request->validate([
            'code' => 'required|array',
        ]);
        
        $total = $request->plant+$request->labour+$request->material;
        
        $project = DB::table('tender_project_files')->where('project_id', $request->project_id)->count();
        if($project>0){
            DB::table('tender_project_files')
            ->where('project_id', $request->project_id)
            ->update([
                'plant'   =>   $request->plant,
                'labour'   =>   $request->labour,
                'material'   =>   $request->material,
                'total'   =>   $total,
            ]);
        }else{
            DB::table('tender_project_files')->insertGetId([
                'project_id'   =>   $request->project_id,
                'plant'   =>   $request->plant,
                'labour'   =>   $request->labour,
                'material'   =>   $request->material,
                'total'   =>   $total,
                'created_at'   =>   date('Y-m-d H:i'),
            ]);
        }
        
        
        $deleteids = explode(',', $request->delete_ids);
        foreach($deleteids as $deleteid){
            DB::table('project_financials')->where('id', $deleteid)->delete();
        }
        
        $total = count($request->code);
        $added_ids = array();
        for($i=0; $i<$total; $i++){
            $code = $request->code[$i];
            $description = $request->description[$i];
            $uom = $request->uom[$i];
            $qty = $request->qty[$i];
            $sales_price = $request->rate[$i];
            $itemid = $request->item_id[$i];
            
            if($itemid==0){
                $financialid = DB::table('project_financials')->insertGetId(
                     array(
                            'code'   =>   $code,
                            'description'   =>   $description,
                            'item_id'   =>   0,
                            'sales_price'   =>   $sales_price,
                            'plant'   =>   0,
                            'labour'   =>   0,
                            'material'   =>   0,
                            'uom'   =>   $uom,
                            'project_id'   =>   $request->project_id,
                            'quantity'   =>   $qty,
                            'credit_note'   =>   0,
                     )
                );   
                //$added_ids[] = $financialid;
            }else{
                DB::table('project_financials')->where('id', $itemid)->update([
                    'code'   =>   $code,
                    'description'   =>   $description,
                    'item_id'   =>   0,
                    'sales_price'   =>   $sales_price,
                    'plant'   =>   0,
                    'labour'   =>   0,
                    'material'   =>   0,
                    'uom'   =>   $uom,
                    'quantity'   =>   $qty,
                    'credit_note'   =>   0,
                ]);
            }
        }
        $request->session()->flash('success', 'Financials added successfully.');
        return redirect()->route('projects.financials', ['id' => $request->project_id])->with('added_ids', $added_ids);
    }
    
    
    public function importExcel(Request $request)
    {
        
        $request->validate([
            'code' => 'required|array',
        ]);
        
        $total = $request->plant+$request->labour+$request->material+$request->sub_contract+$request->other;
        
        $project = DB::table('tender_project_files')->where('project_id', $request->project_id)->count();
        if($project>0){
            DB::table('tender_project_files')
            ->where('project_id', $request->project_id)
            ->update([
                'plant' => DB::raw("plant + {$request->plant}"),
                'labour' => DB::raw("labour + {$request->labour}"),
                'material' => DB::raw("material + {$request->material}"),
                'sub_contract' => DB::raw("material + {$request->sub_contract}"),
                'other' => DB::raw("material + {$request->other}"),
                'total' => DB::raw("total + {$total}"),
            ]);
        }else{
            DB::table('tender_project_files')->insertGetId([
                'project_id'   =>   $request->project_id,
                'plant'   =>   $request->plant,
                'labour'   =>   $request->labour,
                'material'   =>   $request->material,
                'sub_contract'   =>   $request->sub_contract,
                'other'   =>   $request->other,
                'total'   =>   $total,
                'created_at'   =>   date('Y-m-d H:i'),
            ]);
        }
        
        
        $total = count($request->code);
        $added_ids = array();
        for($i=0; $i<$total; $i++){
            $code = $request->code[$i];
            $description = $request->description[$i];
            $uom = $request->uom[$i];
            $qty = $request->qty[$i];
            $sales_price = $request->rate[$i];
            
            $financialid = DB::table('project_financials')->insertGetId(
                 array(
                        'code'   =>   $code,
                        'description'   =>   $description,
                        'item_id'   =>   0,
                        'sales_price'   =>   $sales_price,
                        'plant'   =>   0,
                        'labour'   =>   0,
                        'material'   =>   0,
                        'uom'   =>   $uom,
                        'project_id'   =>   $request->project_id,
                        'quantity'   =>   $qty,
                        'credit_note'   =>   0,
                 )
            );   
            $added_ids[] = $financialid;
        }
        $request->session()->flash('success', 'Financials added successfully.');
        return redirect()->route('projects.financials', ['id' => $request->project_id])->with('added_ids', $added_ids);
    }
    
    
    public function importFinancials(Request $request, $id)
    {
        $added_ids = array();
        // Validate the request
        $request->validate([
            'excel' => 'required|mimes:xls,xlsx,csv'
        ]);

        // Load the uploaded file
        $file = $request->file('excel')->getRealPath();
        $spreadsheet = IOFactory::load($file);

        // Get the first sheet in the file
        $sheet = $spreadsheet->getActiveSheet();
        
        
        $project =  DB::table('projects')->where('id', $id)->first();
        if($project->tender==1){
            $data = $spreadsheet->getActiveSheet()->toArray();
            return view('project.edit_spreadsheet', ['data' => $data, 'project_id' => $id]);
        }
        
        $rows = array();
        $notfound = array();
        $items = array();
        // Loop through the rows
        foreach ($sheet->getRowIterator() as $row) {
            $cellIterator = $row->getCellIterator();
            $cellIterator->setIterateOnlyExistingCells(false);

            $data = [];
            foreach ($cellIterator as $cell) {
                $data[] = $cell->getValue();
            }
            
            if($data[0]!='Code'){
                $financial = DB::table('financial_items')->where('code', $data[0])->first();
                if(!$financial){
                    $notfound[] = $data[0];
                }else{
                    $financial->qty = $data[2];
                    $items[] = $financial;
                }
            }
        }
        
        if(count($notfound)>0){
            $request->session()->flash('danger', 'Error. These codes are not found. '.implode(', ', $notfound).'. Please correct these codes to import.');
            return redirect()->back();
        }else{
            foreach($items as $item){
                $financialid = DB::table('project_financials')->insertGetId(
                     array(
                            'code'   =>   $item->code,
                            'description'   =>   $item->description,
                            'item_id'   =>   $item->id,
                            'sales_price'   =>   $item->sales_price,
                            'plant'   =>   $item->plant,
                            'labour'   =>   $item->labour,
                            'material'   =>   $item->material,
                            'uom'   =>   $item->uom,
                            'project_id'   =>   $id,
                            'quantity'   =>   $item->qty,
                            'credit_note'   =>   $item->credit_note,
                     )
                );   

                $added_ids[] = $financialid;
            }
            $request->session()->flash('success', 'Financials added successfully.');
            return redirect()->back()->with('added_ids', $added_ids);
        }
    }
    
    
    public function saveDocumentNotes(Request $request)
    {
        DB::table('project_documents')->where('id', $request->file_id)->update(
             array(
                   'notes'   =>   $request->notes,
             )
        );
        
        $document = DB::table('project_documents')->where('id', $request->file_id)->first();
        
        $response = array();
        $response['filename'] = $document->file;
        $response['name'] = $document->name;
        $response['type'] = $document->type;
        $response['created_at'] = date('jS M Y h:ia', strtotime($document->created_at));
        $response['file_id'] = $document->id;
        $response['notes'] = $document->notes;
        return response()->json(['success' => $response]);
    }
    
    public function getSupplierContacts(Request $request)
    {
        $contacts = DB::table('customer_contacts')->where('company_id', $request->supplier_id)->get();
        echo json_encode($contacts);
    }
    
    
    public function completeMilestone(Request $request)
    {
        DB::table('milestones')
            ->where('milestone_id', $request->milestone_id)
            ->where('project_id', $request->project_id)
            ->update(
             array(
                    'completed'   =>   1,
                    'completed_by'   =>   Auth::id(),
                    'completion_date'   =>   date('Y-m-d H:i'),
                    
             )
        );
        
        $request->session()->flash('success', 'Milestone completed successfully.');
        return redirect()->back();
    }
    
    
    public function upliftFinancials(Request $request, $id)
    {
        /*$percentage = $request->uplift_percentage;
        $financials = DB::table('project_financials')->where('project_id', $id)->where('invoiced', 0)->get();
        foreach($financials as $financial){
            $sales_price = $financial->sales_price;
            $updated = ($sales_price) * ($percentage / 100);
            $total = $sales_price+$updated;
            DB::table('project_financials')
                ->where('id', $financial->id)
                ->where('project_id', $id)
                ->where('credit_note', 0)
                ->update(
                 array(
                        'sales_price'   =>   $total,
                 )
            );
        }
        
        DB::table('project_uplift_history')->insert([
            'admin_id'   =>   Auth::id(),
            'percentage'   =>   $percentage,
            'project_id'   =>   $id,
            'created_at'   =>   date('Y-m-d H:i'),
        ]);*/
        
        $request->session()->flash('success', 'Financials uplifted successfully.');
        return redirect()->back();
    }
    
    
    public function updateDocumentNotes(Request $request)
    {
        DB::table('project_documents')
            ->where('id', $request->document_id)
            ->update(
             array(
                    'notes'   =>   $request->notes,
             )
        );
        
        $request->session()->flash('success', 'Notes updated successfully.');
        return redirect()->back();
    }
    
    
    public function updateDocumentAccess(Request $request)
    {
        if(isset($request->employee_access)){
            DB::table('project_documents')
                ->where('id', $request->document_id)
                ->update(
                 array(
                        'employee_access'   =>   1,
                 )
            );
        }else{
            DB::table('project_documents')
                ->where('id', $request->document_id)
                ->update(
                 array(
                        'employee_access'   =>   0,
                 )
            );
        }
        
        
        $request->session()->flash('success', 'Access updated successfully.');
        return redirect()->back();
    }
    
    
    public function updateMilestoneNotes(Request $request)
    {
        DB::table('milestones')
            ->where('id', $request->milestone_id)
            ->where('project_id', $request->project_id)
            ->update(
             array(
                    'notes'   =>   $request->notes,
             )
        );
        
        $request->session()->flash('success', 'Notes updated successfully.');
        return redirect()->back();
    }
    
    public function deleteDocument(Request $request)
    {
        $document = DB::table('project_documents')->where('id', $request->document_id)->first();
        if($document){
            $filePath = public_path('documents/'.$document->file);

            if (File::exists(public_path($filePath))) {
                File::delete(public_path($filePath));
            } 
        }
        
        DB::table('project_documents')->where('id', $request->document_id)->delete();
        $request->session()->flash('success', 'Document removed successfully.');
        return redirect()->back();
    }
    
    
    public function deleteImage(Request $request)
    {
        $image = DB::table('project_images')->where('id', $request->image_id)->first();
        if($image){
            $filePath = public_path('img/projects/'.$image->file);

            if (File::exists(public_path($filePath))) {
                File::delete(public_path($filePath));
            } 
        }
        
        DB::table('project_images')->where('id', $request->image_id)->delete();
        $request->session()->flash('success', 'Image removed successfully.');
        return redirect()->back();
    }
    
    
    public function assignManager(Request $request, $id)
    {
        if($request->manager_type=='Contracts'){
            $type = 'Contracts';
            DB::table('projects')->where('id', $id)->update(
                 array(
                        'contracts_manager'   =>   $request->manager_id,
                 )
            );
        }else{
            $type = 'Site';
            DB::table('projects')->where('id', $id)->update(
                 array(
                        'site_manager'   =>   $request->manager_id,
                 )
            );
        }
        
        
        if($request->manager_id!=Auth::id()){
            $title = 'Project Assigned';
            $description = 'You are assigned as '.$type.' manager for the Project ID: WG-'.str_pad($id, 4, '0', STR_PAD_LEFT);

            DB::table('notifications')->insert(
                 array(
                        'user_id'   =>   $request->manager_id,
                        'title'   =>   $title,
                        'description'   =>   $description,
                        'created_at'   =>   date('Y-m-d H:i'),
                        'link'   =>   'project/'.$id,
                 )
            );
        }
        
        
        
        /*DB::table('project_managers')->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'staff_id'   =>   $request->manager_id,
                    'type'   =>   $request->manager_type,
                    'assign_date' => date('Y-m-d H:i'),
             )
        );*/
        $request->session()->flash('success', 'Assigned successfully.');
        return redirect()->back();
    }
    
    
    public function showDetails(Request $request, $id)
    {
        if(Auth::user()->perm_projects==0){
            abort(403);
        }
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $id)
            ->first();
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        $customers = DB::table('customers')->orderBy('id', 'asc')->get();
        $statuses = DB::table('project_statuses')->orderBy('id', 'asc')->get();
        $users = DB::table('users')->where('role', 'user')->get();
        
        $project_types = DB::table('project_types')->orderBy('name', 'asc')->get();
        $contracts_manager = DB::table('users')->where('id', $project->contracts_manager)->first();
        $site_manager = DB::table('users')->where('id', $project->site_manager)->first();
        return view('project.details', ['customer' => $customer, 'project' => $project, 'customers'=>$customers, 'users'=>$users, 'site_manager'=>$site_manager, 'contracts_manager'=>$contracts_manager, 'statuses'=>$statuses, 'project_types'=>$project_types]);
    }
    
    public function viewInvoice(Request $request, $id)
    {
        if(Auth::user()->perm_projects==0){
            abort(403);
        }
        $invoice = DB::table('project_invoices')->where('id', $id)->first();
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $invoice->project_id)
            ->first();
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        
        $items = DB::table('project_invoice_items as a')
            ->leftjoin('project_financials as b', 'a.item_id', '=', 'b.id')
            ->select('a.*', 'b.*')
            ->where('a.invoice_id', $invoice->id)
            ->get();
        
        return view('project.invoice', ['invoice' => $invoice, 'project' => $project, 'customer'=>$customer, 'items'=>$items]);
    }
    
    
    public function viewVariation(Request $request, $projectid, $id)
    {
        if(Auth::user()->perm_projects==0){
            abort(403);
        }
        $variation = DB::table('project_variations')->where('id', $id)->first();
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $variation->project_id)
            ->first();
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        $contracts_manager = DB::table('users')->where('id', $project->contracts_manager)->first();
        $contact = DB::table('customer_contacts')->where('id', $variation->attention)->first();
        
        $items = DB::table('variation_items')
            ->where('variation_id', $variation->id)
            ->get();
        
        return view('project.variation', ['variation' => $variation, 'project' => $project, 'customer'=>$customer, 'items'=>$items, 'contracts_manager'=>$contracts_manager, 'contact'=>$contact]);
    }
    
    public function viewVariationByLink(Request $request, $token)
    {
        $variation = DB::table('project_variations')->where('token', $token)->first();
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $variation->project_id)
            ->first();
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        $contracts_manager = DB::table('users')->where('id', $project->contracts_manager)->first();
        $contact = DB::table('customer_contacts')->where('id', $variation->attention)->first();
        
        $items = DB::table('variation_items')
            ->where('variation_id', $variation->id)
            ->get();
        
        return view('project.variation', ['variation' => $variation, 'project' => $project, 'customer'=>$customer, 'items'=>$items, 'contracts_manager'=>$contracts_manager, 'contact'=>$contact]);
    }
    
    
    
    public function viewSubContractByLink(Request $request, $token)
    {
        
        $subcontract = DB::table('project_sub_contracts')->where('token', $token)->first();
        
        
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $subcontract->project_id)
            ->first();
        
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        $suppliers = DB::table('customers')->where('type', 'supplier')->get();
        $titles = DB::table('sub_contract_titles')->orderBy('name', 'asc')->get();
        
        
        
        if ($subcontract) {
            $subcontract->suppliers = DB::table('sub_contract_quotes as a')
            ->select('a.*', 'b.company_name')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->leftjoin('customer_contacts as c', 'a.contact_id', '=', 'c.id')
            ->where('a.sub_contract_id', $subcontract->id)
            ->get();
            $subcontract->documents = DB::table('sub_contract_documents as a')->where('sub_contract_id', $subcontract->id)->orderBy('id', 'desc')->get();
            
            foreach($subcontract->suppliers as $supplier){
                $supplier->items = DB::table('sub_contract_accepted_items as a')
                    ->leftjoin('financial_items as b', 'a.item_id', '=', 'b.id')
                    ->where('a.quote_id', $supplier->id)
                    ->orderBy('a.id', 'desc')
                    ->get();
            }
            
        }
        
        $uoms = DB::table('financial_uoms')->orderBy('id', 'asc')->get();
        
        $items = DB::table('project_financials as a')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
            ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
            ->where('a.project_id', $subcontract->project_id)
            ->orderBy('a.id', 'desc')
            ->get();
        
        
        return view('project.sub_contract_by_link', ['customer' => $customer, 'project' => $project, 'suppliers'=>$suppliers,  'subcontract'=>$subcontract, 'uoms'=>$uoms, 'items'=>$items, 'titles'=>$titles]);
    }
    
    
    public function getEmailBody(Request $request)
    {
        $email = DB::table('project_emails')->where('id', $request->email_id)->first();
        if($email){
            return $email->message;
        }else{
            return 'Email not found';
        }
    }
    
    
    public function getItemsDetails(Request $request)
    {
        $ids = $request->financial_ids;
        $idArray = explode(',', $ids);
        $items = DB::table('project_financials')
            ->whereIn('id', $idArray)
            ->orderBy('id', 'desc')
            ->get();
        return response()->json($items);
    }
    
    
    public function showFinancials(Request $request, $id)
    {
        if(Auth::user()->perm_projects==0){
            abort(403);
        }
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $id)
            ->first();
        
        $plannings = DB::table('project_planning')
            ->select('start_time', 'end_time')
            ->where('project_id', $project->id)
            ->where('start_time', '!=', '')
            ->where('approved', '1')
            ->get();
        
        $totalHours = 0;
        foreach($plannings as $planning){
            $totalHours+=$this->calculateHours($planning->start_time, $planning->end_time);
        }
        
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        $invoices = DB::table('project_invoices')->where('project_id', $id)->orderBy('id', 'desc')->get();
        
        $items = DB::table('project_financials as a')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
            ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
            ->where('a.project_id', $id)
            ->orderBy('a.id', 'desc')
            ->get();
        
        $tenderItems = DB::table('tender_project_files')->where('project_id', $id)->get();
        
        $uplifts = DB::table('project_uplift_history as a')
            ->leftjoin('users as b', 'a.admin_id', '=', 'b.id')
            ->select('a.*', 'b.firstname', 'b.lastname')
            ->where('a.project_id', $id)
            ->orderBy('a.id', 'desc')
            ->get();
        
        $purchase_orders = DB::table('accounts_purchase_orders')
            ->where('project_id', $id)
            ->get();
        
        foreach ($purchase_orders as $po) {
            $totals = DB::table('accounts_purchase_order_items')
                ->where('po_id', $po->id)
                ->select(
                    DB::raw('SUM(plant) as total_plant'),
                    DB::raw('SUM(labour) as total_labour'),
                    DB::raw('SUM(material) as total_materials'),
                    DB::raw('SUM(sc_total) as total_sc')
                )
                ->first();
            
            $po->sc = DB::table('sub_contract_quotes as a')
            ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
            ->select('b.title', 'a.*')
            ->where('a.project_id', $id)
            ->where('a.id', $po->sub_contract_id)
            ->where('a.accepted', 1)
            ->first();

            // Add totals to the purchase order object
            $po->total_plant = $totals->total_plant;
            $po->total_labour = $totals->total_labour;
            $po->total_materials = $totals->total_materials;
            $po->total_sc = $totals->total_sc;
            $po->total = $totals->total_plant + $totals->total_labour + $totals->total_materials + $totals->total_sc;
        }
        
        $sub_contracts = DB::table('sub_contract_quotes as a')
            ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
            ->select('b.title', 'a.*')
            ->where('a.project_id', $id)
            ->where('a.accepted', 1)
            ->get();
        
        $po_plant_total = 0;
        $po_labour_total = 0;
        $po_material_total = 0;
        /*foreach($purchase_orders as $po){
            if($po->category=='plant'){
                $po_plant_total += $po->amount*$po->quantity;
            }
            
            if($po->category=='labour'){
                $po_labour_total += $po->amount*$po->quantity;
            }
            
            if($po->category=='material'){
                $po_material_total += $po->amount*$po->quantity;
            }
        }*/
        
        $f_items = DB::table('financial_items')->get();
        $suppliers = DB::table('customers')->where('type', 'supplier')->get();
        $uoms = DB::table('financial_uoms')->orderBy('id', 'asc')->get();
        
        
        
        
        if($project->tender==1){
            
            $invoicesWithNoCreditNote = DB::table('project_invoice_items')
                ->join('project_financials', 'project_invoice_items.item_id', '=', 'project_financials.id')
                ->join('project_invoices', 'project_invoice_items.invoice_id', '=', 'project_invoices.id')
                ->select(
                    DB::raw('SUM((sales_price*quantity)) as total_sales_price'),
                    DB::raw('SUM((sales_price*quantity))*0.20 as total_vat'),
                    DB::raw('SUM((sales_price*quantity)) + (SUM((sales_price*quantity))*0.20) as gross_total')
                )
                ->where('project_invoices.credit_note', 0)
                ->where('project_invoices.project_id', $id)
                ->first();

            $invoicesWithCreditNote = DB::table('project_invoice_items')
                ->join('project_financials', 'project_invoice_items.item_id', '=', 'project_financials.id')
                ->join('project_invoices', 'project_invoice_items.invoice_id', '=', 'project_invoices.id')
                ->select(
                    DB::raw('SUM(project_financials.sales_price) as total_sales_price'),
                    DB::raw('SUM(project_financials.sales_price * 0.20) as total_vat'),
                    DB::raw('SUM(project_financials.sales_price) + SUM(project_financials.sales_price * 0.20) as gross_total')
                )
                ->where('project_invoices.credit_note', 1)
                ->where('project_invoices.project_id', $id)
                ->first();

                $difference = [
                    'sales_price_difference' => $invoicesWithNoCreditNote->total_sales_price + $invoicesWithCreditNote->total_sales_price,
                    'vat_difference' => $invoicesWithNoCreditNote->total_vat + $invoicesWithCreditNote->total_vat,
                    'gross_total_difference' => $invoicesWithNoCreditNote->gross_total + $invoicesWithCreditNote->gross_total
                ];
            
            return view('project.financials_tender', ['customer' => $customer, 'project' => $project, 'items'=>$items, 'uoms'=>$uoms, 'f_items'=>$f_items, 'suppliers'=>$suppliers, 'invoices'=>$invoices, 'uplifts'=>$uplifts, 'difference'=>$difference, 'normalInvoice'=>$invoicesWithNoCreditNote, 'creditInvoice'=>$invoicesWithCreditNote, 'purchase_orders'=>$purchase_orders, 'po_material_total'=>$po_material_total, 'po_labour_total'=>$po_labour_total, 'po_plant_total'=>$po_plant_total, 'totalHours'=>$totalHours, 'sub_contracts'=>$sub_contracts, 'tenderItems'=>$tenderItems]);
        }else{
            
            
            $invoicesWithNoCreditNote = DB::table('project_invoice_items')
                ->join('project_financials', 'project_invoice_items.item_id', '=', 'project_financials.id')
                ->join('project_invoices', 'project_invoice_items.invoice_id', '=', 'project_invoices.id')
                ->select(
                    DB::raw('SUM((plant*quantity)+(labour*quantity)+(material*quantity)) as total_sales_price'),
                    DB::raw('SUM((plant*quantity)+(labour*quantity)+(material*quantity))*0.20 as total_vat'),
                    DB::raw('SUM((plant*quantity)+(labour*quantity)+(material*quantity)) + (SUM((plant*quantity)+(labour*quantity)+(material*quantity))*0.20) as gross_total')
                )
                ->where('project_invoices.credit_note', 0)
                ->where('project_invoices.project_id', $id)
                ->first();

            $invoicesWithCreditNote = DB::table('project_invoice_items')
                ->join('project_financials', 'project_invoice_items.item_id', '=', 'project_financials.id')
                ->join('project_invoices', 'project_invoice_items.invoice_id', '=', 'project_invoices.id')
                ->select(
                    DB::raw('SUM(project_financials.sales_price) as total_sales_price'),
                    DB::raw('SUM(project_financials.sales_price * 0.20) as total_vat'),
                    DB::raw('SUM(project_financials.sales_price) + SUM(project_financials.sales_price * 0.20) as gross_total')
                )
                ->where('project_invoices.credit_note', 1)
                ->where('project_invoices.project_id', $id)
                ->first();

                $difference = [
                    'sales_price_difference' => $invoicesWithNoCreditNote->total_sales_price + $invoicesWithCreditNote->total_sales_price,
                    'vat_difference' => $invoicesWithNoCreditNote->total_vat + $invoicesWithCreditNote->total_vat,
                    'gross_total_difference' => $invoicesWithNoCreditNote->gross_total + $invoicesWithCreditNote->gross_total
                ];
            
            return view('project.financials', ['customer' => $customer, 'project' => $project, 'items'=>$items, 'uoms'=>$uoms, 'f_items'=>$f_items, 'suppliers'=>$suppliers, 'invoices'=>$invoices, 'uplifts'=>$uplifts, 'difference'=>$difference, 'normalInvoice'=>$invoicesWithNoCreditNote, 'creditInvoice'=>$invoicesWithCreditNote, 'purchase_orders'=>$purchase_orders, 'po_material_total'=>$po_material_total, 'po_labour_total'=>$po_labour_total, 'po_plant_total'=>$po_plant_total, 'totalHours'=>$totalHours, 'sub_contracts'=>$sub_contracts]);
        }
        
        
    }
    
    
    
    public static function calculateHours($start, $end)
    {
        // Assuming the request has 'start_time' and 'end_time' in 'Y-m-d H:i:s' format
        $startTime = Carbon::parse($start);
        $endTime = Carbon::parse($end);

        // Calculate the difference in hours and minutes
        $diffInHours = $endTime->diffInHours($startTime);
        $diffInMinutes = $endTime->diffInMinutes($startTime) % 60;

        // Convert minutes to a fraction of an hour
        $totalHours = $diffInHours + ($diffInMinutes / 60);

        return $totalHours;
    }
    
    
    public function updateEndCustomer(Request $request, $id)
    {
        $response = array();
        
        DB::table('projects')
            ->where('id', $id)
            ->update(
             array(
                    'end_customer_name'   =>   $request->name,
                    'end_customer_phone'   =>   $request->phone,
                    'end_customer_email'   =>   $request->email,
                    'end_customer_address'   =>   $request->address,
                    'end_customer_city'   =>   $request->city,
                    'end_customer_postcode'   =>   $request->postcode,
             )
        );
        
        $request->session()->flash('success', 'End customer updated successfully.');
        return redirect()->back();
    }
    
    public function addQuoteItem(Request $request, $id)
    {
        $response = array();
        
        DB::table('contractor_quotes_items')
            ->insert(
             array(
                    'category'   =>   $request->category,
                    'uom'   =>   $request->uom,
                    'quantity'   =>   $request->quantity,
                    'amount'   =>   $request->amount,
                    'description'   =>   $request->description,
                    'supplier_id'   =>   $request->supplier_id,
                    'project_id'   =>   $id,
                    'sc_id'   =>   $request->sc_id,
             )
        );
        
        $request->session()->flash('success', 'Item added successfully.');
        return redirect()->back();
    }
    
    public function addVariationItem(Request $request, $id)
    {
        $response = array();
        $item = DB::table('financial_items')->where('id', $request->code)->first();
        DB::table('variation_items')
            ->insert(
             array(
                    'code'   =>   $item->code,
                    'description'   =>   $item->description,
                    'quantity'   =>   $request->quantity,
                    'uom'   =>   $item->uom,
                    'sales_price'   =>   $item->sales_price,
                    'variation_id'   =>   $request->variation_id,
                    'project_id'   =>   $id,
             )
        );
        
        $request->session()->flash('success', 'Item added successfully.');
        return redirect()->back();
    }
    
    
    public function changeVariationStatus(Request $request)
    {
        $response = array();
        $variationid = $request->variation_id;
        $status = $request->status;
        $variation = DB::table('project_variations')->where('id', $variationid)->first();
        DB::table('project_variations')->where('id', $variationid)
            ->update(
             array(
                    'status'   =>   $status,
             )
        );
        
        
        if($status=='accepted'){
            $items = DB::table('variation_items')
            ->where('variation_id', $variationid)
            ->get();
        
            foreach($items as $item){
                $data = DB::table('financial_items')->where('code', $item->code)->first();
                if($data){
                    DB::table('project_financials')->insertGetId(
                         array(
                                'code'   =>   $item->code,
                                'description'   =>   $data->description,
                                'item_id'   =>   $data->id,
                                'sales_price'   =>   $data->sales_price,
                                'plant'   =>   $data->plant,
                                'labour'   =>   $data->labour,
                                'material'   =>   $data->material,
                                'uom'   =>   $data->uom,
                                'project_id'   =>   $variation->project_id,
                                'quantity'   =>   $item->quantity,
                                'credit_note'   =>   $data->credit_note,
                                'variation'   =>   1,
                         )
                    );   
                }
            }
        }
        
        $variation_id = 'WG-'.str_pad($variation->project_id, 4, '0', STR_PAD_LEFT).'#V-'.str_pad($variation->id, 4, '0', STR_PAD_LEFT);
        if($status=='accepted'){
            $title = 'Variation '.$variation_id.' accepted.';
            $description = 'Variation '.$variation_id.' has been accepted.';
        }else{
            $title = 'Variation '.$variation_id.' declined.';
            $description = 'Variation '.$variation_id.' has been declined.';
        }
        
        
        $project = DB::table('projects')->where('id', $variation->project_id)->first();
        DB::table('notifications')->insert(
             array(
                    'user_id'   =>   $project->contracts_manager,
                    'title'   =>   $title,
                    'description'   =>   $description,
                    'created_at'   =>   date('Y-m-d H:i'),
                    'link'   =>   'project/'.$variation->project_id.'/variations',
             )
        );
        
        
        $request->session()->flash('success', 'Thank you for your response. The contracts manager will be notified.');
        return redirect()->back();
    }
    
    
    public function acceptQuote(Request $request, $id)
    {
        $response = array();
        $quote_id = $request->quote_id;
        $sub_contract_id = $request->subcontract_id;
        $project = DB::table('projects')->where('id', $id)->first();
        
        if($project->tender==0){
            if(!isset($request->po_items) || empty($request->po_items)){
                $request->session()->flash('danger', 'Please select at least one item.');
                return redirect()->back();
            }

            foreach($request->po_items as $itemid){
                DB::table('sub_contract_accepted_items')
                    ->insertGetId(
                     array(
                            'quote_id'   =>   $quote_id,
                            'sub_contract_id'   =>   $sub_contract_id,
                            'item_id'   =>   $itemid,
                            'project_id'   =>   $id,
                     )
                );

                DB::table('project_financials')->where('id', $itemid)
                    ->where('project_id', $id)
                    ->update(
                     array(
                            'sub_contract_accepted'   =>   1,
                     )
                );
            }


            DB::table('sub_contract_quotes')->where('id', $quote_id)
                ->update(
                 array(
                        'accepted'   =>   1,
                        'accept_time'   =>   date('Y-m-d H:i'),
                        'amount'   =>   $request->final_amount,
                 )
            );
        }else{
            DB::table('sub_contract_quotes')->where('id', $quote_id)
                ->update(
                 array(
                        'accepted'   =>   1,
                        'accept_time'   =>   date('Y-m-d H:i'),
                        'amount'   =>   $request->final_amount,
                        'type'   =>   $request->type,
                 )
            );
        }
       
        
        
        
        
        
        $request->session()->flash('success', 'Quote accepted successfully.');
        return redirect()->back();
    }
    
    public function updateQuoteItem(Request $request, $id)
    {
        $response = array();
        
        DB::table('contractor_quotes_items')->where('id', $request->item_id)
            ->update(
             array(
                    'category'   =>   $request->category,
                    'uom'   =>   $request->uom,
                    'quantity'   =>   $request->quantity,
                    'amount'   =>   $request->amount,
                    'description'   =>   $request->description,
                    'project_id'   =>   $id,
             )
        );
        
        $request->session()->flash('success', 'Item updated successfully.');
        return redirect()->back();
    }
    
    
    public function updateFinancial(Request $request, $id)
    {
        $response = array();
        $project = DB::table('projects')->where('id', $id)->first();
        $items = $request->item_id;
        $i = 0;
        
        if($project->tender==1){
            foreach($items as $item){
                DB::table('project_financials')
                    ->where('id', $item)
                    ->update([
                        'description'   =>   $request->description[$i],
                        'sales_price'   =>   $request->rate[$i],
                        'quantity'   =>   $request->quantity[$i],
                        'estimated_price'   =>   $request->estimated_price[$i],
                        'supplier_id'   =>   empty($request->supplier[$i])?0:$request->supplier[$i],
                        'uom'   =>   empty($request->uom[$i])?0:$request->uom[$i],
                    ]);
                $i++;
            }
        }else{
            foreach($items as $item){
                DB::table('project_financials')
                    ->where('id', $item)
                    ->update([
                        'description'   =>   $request->description[$i],
                        'plant'   =>   $request->plant[$i],
                        'labour'   =>   $request->labour[$i],
                        'material'   =>   $request->material[$i],
                        'quantity'   =>   $request->quantity[$i],
                        'estimated_price'   =>   $request->estimated_price[$i],
                        'supplier_id'   =>   empty($request->supplier[$i])?0:$request->supplier[$i],
                        'uom'   =>   empty($request->uom[$i])?0:$request->uom[$i],
                    ]);
                $i++;
            }
        }
        
        
        
        $request->session()->flash('success', 'Updated successfully.');
        return redirect()->back();
    }
    
    public function updateStatus(Request $request, $id)
    {
        $response = array();
        
        $project = DB::table('projects')->where('id', $id)->first();
        $status = DB::table('project_statuses')->where('id', $request->status_id)->first();
        
        
        DB::table('project_status_history')
            ->where('project_id', $id)
            ->where('status_id', $project->project_status)
            ->update(
             array(
                    'completed_on'   =>   date('Y-m-d H:i'),
                    'completed_by'   =>   Auth::id(),
             )
        );
        
        DB::table('projects')
            ->where('id', $id)
            ->update(
             array(
                    'project_status'   =>   $request->status_id,
             )
        );
        
        DB::table('project_status_history')
            ->insert(
             array(
                    'project_id'   =>   $id,
                    'status_id'   =>   $request->status_id,
                    'start_date'   =>   date('Y-m-d H:i'),
                    'end_date'   =>   Carbon::now()->addDays($status->completion_days)->toDateString(),
             )
        );
        
        
        
        $request->session()->flash('success', 'Status updated successfully.');
        return redirect()->back();
    }
    
    
    
    public function sendInvoice(Request $request)
    {
        DB::table('project_invoices')->where('id', $request->invoice_id)->update(
             array(
                    'sent_to_client'   =>   1,
                    'status'   =>   'printed',
             )
        );
        $request->session()->flash('success', 'Invoice send to client successfully.');
        return redirect()->back();
    }
    
    public function deleteInvoice(Request $request)
    {
       
        DB::table('project_financials')->where('invoice_id', $request->invoice_id)->update(
             array(
                    'invoiced'   =>   0,
                    'invoice_id'   =>   0,
             )
        );
        
        DB::table('project_invoices')->where('id', $request->invoice_id)->delete();
        $request->session()->flash('success', 'Invoice removed successfully.');
        return redirect()->back();
    }
    
    
    public function createPurchaseOrder(Request $request, $id)
    {
        /*$request->validate([
            'receipt_photo' => 'required|mimes:jpeg,png,jpg,gif|max:3072',
        ]);*/

        $filename = "";
        if ($request->hasFile('receipt_photo')) {
            $file = $request->file('receipt_photo');
            $ext = $file->getClientOriginalExtension();
            $filename = uniqid(time()) . '.' . $ext;
            $name = $file->getClientOriginalName();
            $file->move(public_path('img/purchase_orders'), $filename);
        }
        $response = array();
        
        $project = DB::table('projects')->where('id', $id)->first();
        //$idArray = explode(',', $request->po_items);
        
        $po_id = DB::table('project_purchase_orders')
            ->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'customer_id'   =>   $project->customer_id,
                    'created_at'   =>   date('Y-m-d H:i'),
                    'amount'   =>   $request->amount,
                    'uom'   =>   $request->uom,
                    'quantity'   =>   $request->quantity,
                    'supplier_id'   =>   $request->supplier_id,
                    'category'   =>   $request->category,
                    'description'   =>   $request->description,
                    'receipt_photo'   =>   $filename,
             )
        );
        
        /*foreach($request->po_items as $itemid){
            DB::table('purchase_order_items')
                ->insertGetId(
                 array(
                        'po_id'   =>   $po_id,
                        'item_id'   =>   $itemid,
                 )
            );
            
            DB::table('project_financials')->where('id', $itemid)->update(
                 array(
                        'purchased'   =>   1,
                        'purchase_order_id'   =>   $po_id,
                 )
            );
        }*/
        
        
        
        $request->session()->flash('success', 'Purchase order generated successfully.');
        return redirect()->back();
    }
    
    
    public function createInvoice(Request $request, $id)
    {
        $response = array();
        $project = DB::table('projects')->where('id', $id)->first();
        
        if($project->tender==0){
            $idArray = explode(',', $request->item_ids);
            $notes = $request->notes;
            $hide_items = isset($request->show_items) ? 0 : 1;

            // Use the query builder to perform the query
            $sumEstimatedPrice = DB::table('project_financials')
                ->whereIn('id', $idArray)
                ->sum(DB::raw('(plant*quantity) + (labour*quantity) + (material*quantity)'));

            $credit_note = 0;

            $check_credit_note = DB::table('project_financials')
                ->whereIn('id', $idArray)
                ->where('credit_note', 1)
                ->count();

            if($check_credit_note>0){
                $credit_note = 1;
            }
        }else{
            $idArray = explode(',', $request->item_ids);
            $notes = $request->notes;
            $hide_items = isset($request->show_items) ? 0 : 1;

            // Use the query builder to perform the query
            $sumEstimatedPrice = DB::table('project_financials')
                ->whereIn('id', $idArray)
                ->sum(DB::raw('(sales_price*quantity)'));

            $credit_note = 0;

            $check_credit_note = DB::table('project_financials')
                ->whereIn('id', $idArray)
                ->where('credit_note', 1)
                ->count();

            if($check_credit_note>0){
                $credit_note = 1;
            }
        }
        
        
        
        $invoiceid = DB::table('project_invoices')
            ->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'customer_id'   =>   $project->customer_id,
                    'created_at'   =>   date('Y-m-d H:i'),
                    'final_amount'   =>   $sumEstimatedPrice,
                    'notes'   =>   $notes,
                    'hide_items'   =>   $hide_items,
                    'credit_note'   =>   $credit_note,
             )
        );
        
        foreach($idArray as $itemid){
            DB::table('project_invoice_items')
                ->insertGetId(
                 array(
                        'project_id'   =>   $id,
                        'invoice_id'   =>   $invoiceid,
                        'item_id'   =>   $itemid,
                 )
            );
            
            DB::table('project_financials')->where('id', $itemid)->update(
                 array(
                        'invoiced'   =>   1,
                        'invoice_id'   =>   $invoiceid,
                 )
            );
        }
        
        
        
        $request->session()->flash('success', 'Invoice created successfully.');
        return redirect()->back();
    }
    
    
    public function updateCustomer(Request $request, $id)
    {
        $response = array();
        
        DB::table('projects')
            ->where('id', $id)
            ->update(
             array(
                    'customer_name'   =>   $request->name,
                    'customer_phone'   =>   $request->phone,
                    'customer_email'   =>   $request->email,
                    'customer_ref'   =>   $request->customer_ref,
                    'customer_id'   =>   $request->customer_id,
             )
        );
        
        $request->session()->flash('success', 'Customer updated successfully.');
        return redirect()->back();
    }
    
    
    public function updateProject(Request $request, $id)
    {
        $response = array();
        
        DB::table('projects')
            ->where('id', $id)
            ->update([
                'title'   =>   $request->title,
                'project_type'   =>   $request->project_type,
            ]);
        
        $request->session()->flash('success', 'Project details updated successfully.');
        return redirect()->back();
    }
    
    
    public function updateLocation(Request $request, $id)
    {
        $response = array();
        
        $this->validate($request, [
            'location'   =>   'required|string',
        ]);
        
        DB::table('projects')
            ->where('id', $id)
            ->update(
             array(
                    'location'   =>   $request->location,
             )
        );
        
        $request->session()->flash('success', 'Project location updated successfully.');
        return redirect()->back();
    }
	
    
    public function getEmails()
    {
        try {
            $client = Client::account('gmail'); // Use the 'gmail' account configured in imap.php
            $client->connect(); // Connect to the account

            $emails = [];

            // Get all mailboxes
            $folders = $client->getFolders();

            foreach ($folders as $folder) {
                // Get all messages of the current mailbox
                $messages = $folder->messages()->all()->get();

                foreach ($messages as $message) {
                    $emails[] = [
                        'subject' => $message->getSubject(),
                        'date' => $message->getDate()->format('Y-m-d H:i:s'),
                        'attachments' => $message->getAttachments()->count(),
                        'body' => $message->getHTMLBody(),
                    ];
                }
            }

            return view('emails.index', compact('emails'));
        } catch (\Exception $e) {
            dd('Connection setup failed: ' . $e->getMessage());
        }
    }
    
    
    public function addSupplierContact(Request $request)
    {
        $response = array();
        $errors = array();
        
        $this->validate($request, [
            'name'   =>   'required|string',
            'email'   =>   'required|string',
            'phone'   =>   'required|string',
        ]);
        
        
        $check = DB::table('customer_contacts')
            ->where('email', $request->email)
            ->where('company_id', $request->supplier_id)
            ->count();
        if($check>0){
            $exists = 1;
            $contactid = 0;
        }else{
            $exists = 0;
            $contactid = DB::table('customer_contacts')->insertGetId(
                 array(
                        'name'   =>   $request->name,
                        'email'   =>   $request->email,
                        'phone'   =>   $request->phone,
                        'created_at'   =>   date('Y-m-d H:i'),
                        'company_id'   =>   $request->supplier_id,
                 )
            );
        }
        
        
        
        echo json_encode([
           'exists' => $exists, 
           'contact_id' => $contactid, 
           'supplier_id' => $request->supplier_id,
           'name' => $request->name, 
           'email' => $request->email, 
        ]);
    }
    
    
    
    public function updateRams(Request $request, $id)
    {
        $project = DB::table('projects')->where('id', $id)->first();
        
        $jsonData = json_decode($project->rams_data, true);
        $rams_id =  $jsonData['data']['id'];
        
        if(empty($project->title)){
            $request->session()->flash('danger', 'This project does not have any title. Please enter the project title and try again.');
            return redirect()->back();
        }
        
        // Define the API endpoint and your API token
        $url = 'https://api.handshq.com/v1/projects/'.$rams_id;
        $apiToken = '6d2596c4199043a2aaff1dc98e552501';

        // Define the payload
        $payload = [
            "project" => [
                "name" => $project->title,
            ]
        ];

        // Send the POST request using Laravel's HTTP client
        $response = Http::withHeaders([
            'Accept' => 'application/json',
            'Authorization' => 'Bearer ' . $apiToken,
            'Content-Type' => 'application/json',
        ])->patch($url, $payload);
        

        // Check the response status and return the result
        if ($response->status() === 200) {
            DB::table('projects')->where('id', $id)->update([
                'rams_data' => json_encode($response->json()),
                'rams_last_updated' => date('Y-m-d H:i'),
            ]);
            
            $request->session()->flash('success', 'Rams document updated successfully.');
            return redirect()->back();
            
        } else {
            $request->session()->flash('danger', 'Something went wrong.');
            return redirect()->back();
        }
    }
    
    
    
    public function ramsPDF(Request $request, $id)
    {
        $project = DB::table('projects')->where('id', $id)->first();
        
        $jsonData = json_decode($project->rams_data, true);
        $rams_id =  $jsonData['data']['id'];

        $url = 'https://api.handshq.com/v1/projects/'.$rams_id.'/latest_version_pdf';
        $apiToken = '6d2596c4199043a2aaff1dc98e552501';
        
        // Send the POST request using Laravel's HTTP client
        $response = Http::withHeaders([
            'Accept' => 'application/json',
            'Authorization' => 'Bearer ' . $apiToken,
            'Content-Type' => 'application/json',
        ])->get($url);
        
        
        $pdf_link = "";
        
        if ($response->status() === 200) {
            $responseData = $response->json();
            if(isset($responseData['data']['links']['content'])){
                if($responseData['data']['id']!=$project->rams_latest_pdf_id){
                    $pdf_link = $responseData['data']['links']['content'];
                    $pdfContent = Http::get($pdf_link);
                    if ($pdfContent->successful()) {
                        // Step 4: Save the document locally (e.g., in Laravel's storage)
                        $fileName = 'rams_document_'.$responseData['data']['id'].'.pdf';
                        $filePath = public_path("documents/".$fileName);
                        file_put_contents($filePath, $pdfContent->body());
                        $fileid = DB::table('project_documents')->insertGetId(
                             array(
                                    'project_id'   =>   $id,
                                    'name'   =>   $fileName,
                                    'file'   =>   $fileName,
                                    'created_at'   =>   date('Y-m-d H:i'),
                                    'type'   =>   'pdf',
                                    'rams' => 1,
                                    'employee_access' => 1,
                             )
                        );

                        DB::table('projects')->where('id', $id)->update([
                            'rams_latest_pdf_id' => $responseData['data']['id'],
                        ]);

                        $request->session()->flash('success', 'Latest RAMS pdf document added to the projects successfully.');
                        return redirect()->route('projects.documents', ['id' => $id])->with('success', 'Latest RAMS pdf document added to the projects successfully.');
                        //return response()->download($filePath);

                    }
                }else{
                    $request->session()->flash('danger', 'There is no updated version of the PDF available.');
                    return redirect()->back();
                }
                
            }else{
                $request->session()->flash('danger', 'Pdf not available yet.');
                return redirect()->back();
            }
        }else{
            $request->session()->flash('danger', 'Api error occurred.');
            return redirect()->back();
        }
    }
    
    
    public function createRamsDocument(Request $request, $id)
    {
        $project = DB::table('projects')->where('id', $id)->first();
        if(empty($project->title)){
            $request->session()->flash('danger', 'This project does not have any title. Please enter the project title and try again.');
            return redirect()->back();
        }
        // Define the API endpoint and your API token
        $url = 'https://api.handshq.com/v1/projects';
        $apiToken = '6d2596c4199043a2aaff1dc98e552501';

        // Define the payload
        $payload = [
            "user_email" => 'r.whitlock@boomsoftware.co.uk',
            "project" => [
                "name" => $project->title,
                "start_date" => date('Y-m-d', strtotime($project->created_at)),
                "reference" => 'WG-'.str_pad($project->id, 4, '0', STR_PAD_LEFT),
            ]
        ];

        // Send the POST request using Laravel's HTTP client
        $response = Http::withHeaders([
            'Accept' => 'application/json',
            'Authorization' => 'Bearer ' . $apiToken,
            'Content-Type' => 'application/json',
        ])->post($url, $payload);
        

        // Check the response status and return the result
        if ($response->status() === 201) {
            $responseData = $response->json();
            $rams_project_id = $responseData['data']['id'] ?? null;
            DB::table('projects')->where('id', $id)->update([
                'rams_data' => json_encode($response->json()),
                'rams_project_id' => $rams_project_id,
                'rams_date' => date('Y-m-d H:i'),
                'rams' => 1,
            ]);
            
            $request->session()->flash('success', 'Rams document created successfully.');
            return redirect()->back();
            
        } else {
            $request->session()->flash('danger', 'Something went wrong.');
            return redirect()->back();
        }
    }



}