<?php

namespace App\Http\Controllers;
use DB;
use App\Quotation;
use Illuminate\Http\Request;
use App\Patients;
use App\Doctors;
use Session;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Csv;
use Symfony\Component\HttpFoundation\Response;
use App\Questionnaire;
use Illuminate\Support\Facades\Auth;
use Redirect;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
//use Illuminate\Support\Facades\Response;
use PDF;
use Mpdf\Mpdf;
use Illuminate\Support\Facades\Hash;
use ZipArchive;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
class ReportController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth')->except('viewPoByLink');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    
    
    
    public function showCostVariance(Request $request)
    {
        if(Auth::user()->perm_reports==0){
            abort(403);
        }
        
        
        if(request()->has('from')){
            $startDate = request()->from;
            $endDate = request()->to;
        }else{
            $startDate = Carbon::now()->subDays(90);
            $endDate = Carbon::now();
        }
        
        $projects = DB::table('projects as a')
                ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
                ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
                ->select('a.*', 'b.company_name', 'c.name as status')
                ->whereBetween('a.created_at', [$startDate, $endDate])
                ->get();
        
        if($projects){
              foreach($projects as $project){
                $project->items = DB::table('project_financials as a')
                    ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
                    ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
                    ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
                    ->where('a.project_id', $project->id)
                    ->orderBy('a.id', 'desc')
                    ->get();

                $project->tenderItems = DB::table('tender_project_files')->where('project_id', $project->id)->get();


                $project->purchase_orders = DB::table('accounts_purchase_orders')
                    ->where('project_id', $project->id)
                    ->get();


                foreach ($project->purchase_orders as $po) {
                    $totals = DB::table('accounts_purchase_order_items')
                        ->where('po_id', $po->id)
                        ->select(
                            DB::raw('SUM(plant) as total_plant'),
                            DB::raw('SUM(labour) as total_labour'),
                            DB::raw('SUM(material) as total_materials'),
                            DB::raw('SUM(sc_total) as total_sc')
                        )
                        ->first();

                    $po->sc = DB::table('sub_contract_quotes as a')
                    ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
                    ->select('b.title', 'a.*')
                    ->where('a.project_id', $project->id)
                    ->where('a.id', $po->sub_contract_id)
                    ->where('a.accepted', 1)
                    ->first();

                    // Add totals to the purchase order object
                    $po->total_plant = $totals->total_plant;
                    $po->total_labour = $totals->total_labour;
                    $po->total_materials = $totals->total_materials;
                    $po->total_sc = $totals->total_sc;
                    $po->total = $totals->total_plant + $totals->total_labour + $totals->total_materials + $totals->total_sc;
                }


                $project->sub_contracts = DB::table('sub_contract_quotes as a')
                    ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
                    ->select('b.title', 'a.*')
                    ->where('a.project_id', $project->id)
                    ->where('a.accepted', 1)
                    ->get();
            }
        }
        
        $projectCounts = DB::table('projects as a')
        ->selectRaw('DATE_FORMAT(a.created_at, "%Y-%m") as month, COUNT(*) as total_projects')
        ->groupBy('month')
        ->orderBy('month', 'asc')
        ->get();
        
        $chartData = $projectCounts->map(function ($item) {
            return [
                'month' => $item->month,
                'total_projects' => $item->total_projects,
            ];
        })->toArray();
      
        return view('reports.cost_variance', compact('projects', 'chartData'));
    }
    
    
    public function showContractManagersReport (Request $request)
    {
        if(Auth::user()->perm_reports==0){
            abort(403);
        }
        
        $users = DB::table('users')->get();
        if(request()->has('from')){
            $startDate = request()->from;
            $endDate = request()->to;
        }else{
            $startDate = Carbon::now()->subDays(90);
            $endDate = Carbon::now();
        }
        foreach($users as $user){
            $user->projects = DB::table('projects as a')
                ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
                ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
                ->select('a.*', 'b.company_name', 'c.name as status')
                ->where('a.contracts_manager', $user->id)
                ->whereBetween('a.created_at', [$startDate, $endDate])
                ->get();
        
            foreach($user->projects as $project){
                $project->items = DB::table('project_financials as a')
                    ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
                    ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
                    ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
                    ->where('a.project_id', $project->id)
                    
                    ->orderBy('a.id', 'desc')
                    ->get();

                $project->tenderItems = DB::table('tender_project_files')->where('project_id', $project->id)->get();


                $project->purchase_orders = DB::table('accounts_purchase_orders')
                    ->where('project_id', $project->id)
                    ->get();


                foreach ($project->purchase_orders as $po) {
                    $totals = DB::table('accounts_purchase_order_items')
                        ->where('po_id', $po->id)
                        ->select(
                            DB::raw('SUM(plant) as total_plant'),
                            DB::raw('SUM(labour) as total_labour'),
                            DB::raw('SUM(material) as total_materials'),
                            DB::raw('SUM(sc_total) as total_sc')
                        )
                        ->first();

                    $po->sc = DB::table('sub_contract_quotes as a')
                    ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
                    ->select('b.title', 'a.*')
                    ->where('a.project_id', $project->id)
                    ->where('a.id', $po->sub_contract_id)
                    ->where('a.accepted', 1)
                    ->first();

                    // Add totals to the purchase order object
                    $po->total_plant = $totals->total_plant;
                    $po->total_labour = $totals->total_labour;
                    $po->total_materials = $totals->total_materials;
                    $po->total_sc = $totals->total_sc;
                    $po->total = $totals->total_plant + $totals->total_labour + $totals->total_materials + $totals->total_sc;
                }


                $project->sub_contracts = DB::table('sub_contract_quotes as a')
                    ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
                    ->select('b.title', 'a.*')
                    ->where('a.project_id', $project->id)
                    ->where('a.accepted', 1)
                    ->get();
            }
        }
        
        return view('reports.contracts_manager', compact('users'));
        
    }
    
    
    public function showSiteManagersReport (Request $request)
    {
        if(Auth::user()->perm_reports==0){
            abort(403);
        }
        
        $users = DB::table('users')->get();
        if(request()->has('from')){
            $startDate = request()->from;
            $endDate = request()->to;
        }else{
            $startDate = Carbon::now()->subDays(90);
            $endDate = Carbon::now();
        }
        foreach($users as $user){
            $user->projects = DB::table('projects as a')
                ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
                ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
                ->select('a.*', 'b.company_name', 'c.name as status')
                ->where('a.site_manager', $user->id)
                ->whereBetween('a.created_at', [$startDate, $endDate])
                ->get();
        
            foreach($user->projects as $project){
                $project->items = DB::table('project_financials as a')
                    ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
                    ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
                    ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
                    ->where('a.project_id', $project->id)
                    
                    ->orderBy('a.id', 'desc')
                    ->get();

                $project->tenderItems = DB::table('tender_project_files')->where('project_id', $project->id)->get();


                $project->purchase_orders = DB::table('accounts_purchase_orders')
                    ->where('project_id', $project->id)
                    ->get();


                foreach ($project->purchase_orders as $po) {
                    $totals = DB::table('accounts_purchase_order_items')
                        ->where('po_id', $po->id)
                        ->select(
                            DB::raw('SUM(plant) as total_plant'),
                            DB::raw('SUM(labour) as total_labour'),
                            DB::raw('SUM(material) as total_materials'),
                            DB::raw('SUM(sc_total) as total_sc')
                        )
                        ->first();

                    $po->sc = DB::table('sub_contract_quotes as a')
                    ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
                    ->select('b.title', 'a.*')
                    ->where('a.project_id', $project->id)
                    ->where('a.id', $po->sub_contract_id)
                    ->where('a.accepted', 1)
                    ->first();

                    // Add totals to the purchase order object
                    $po->total_plant = $totals->total_plant;
                    $po->total_labour = $totals->total_labour;
                    $po->total_materials = $totals->total_materials;
                    $po->total_sc = $totals->total_sc;
                    $po->total = $totals->total_plant + $totals->total_labour + $totals->total_materials + $totals->total_sc;
                }


                $project->sub_contracts = DB::table('sub_contract_quotes as a')
                    ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
                    ->select('b.title', 'a.*')
                    ->where('a.project_id', $project->id)
                    ->where('a.accepted', 1)
                    ->get();
            }
        }
        
        return view('reports.site_managers', compact('users'));
        
    }
    
    
    public function showOrderBookReport(Request $request)
    {
        if(Auth::user()->perm_reports==0){
            abort(403);
        }
        
        
        
        if(request()->has('from')){
            $startDate = request()->from;
            $endDate = request()->to;
        }else{
            $startDate = Carbon::now()->subDays(90);
            $endDate = Carbon::now();
        }
        
        $projects = DB::table('projects as a')
                ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
                ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
                ->select('a.*', 'b.company_name', 'c.name as status')
                ->whereBetween('a.created_at', [$startDate, $endDate])
                ->get();
        
        if($projects){
              foreach($projects as $project){
                $project->items = DB::table('project_financials as a')
                    ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
                    ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
                    ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
                    ->where('a.project_id', $project->id)
                    ->orderBy('a.id', 'desc')
                    ->get();

                $project->tenderItems = DB::table('tender_project_files')->where('project_id', $project->id)->get();


                $project->purchase_orders = DB::table('accounts_purchase_orders')
                    ->where('project_id', $project->id)
                    ->get();


                foreach ($project->purchase_orders as $po) {
                    $totals = DB::table('accounts_purchase_order_items')
                        ->where('po_id', $po->id)
                        ->select(
                            DB::raw('SUM(plant) as total_plant'),
                            DB::raw('SUM(labour) as total_labour'),
                            DB::raw('SUM(material) as total_materials'),
                            DB::raw('SUM(sc_total) as total_sc')
                        )
                        ->first();

                    $po->sc = DB::table('sub_contract_quotes as a')
                    ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
                    ->select('b.title', 'a.*')
                    ->where('a.project_id', $project->id)
                    ->where('a.id', $po->sub_contract_id)
                    ->where('a.accepted', 1)
                    ->first();

                    // Add totals to the purchase order object
                    $po->total_plant = $totals->total_plant;
                    $po->total_labour = $totals->total_labour;
                    $po->total_materials = $totals->total_materials;
                    $po->total_sc = $totals->total_sc;
                    $po->total = $totals->total_plant + $totals->total_labour + $totals->total_materials + $totals->total_sc;
                }


                $project->sub_contracts = DB::table('sub_contract_quotes as a')
                    ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
                    ->select('b.title', 'a.*')
                    ->where('a.project_id', $project->id)
                    ->where('a.accepted', 1)
                    ->get();
            }
        }
        
        $projectCounts = DB::table('projects as a')
        ->selectRaw('DATE_FORMAT(a.created_at, "%Y-%m") as month, COUNT(*) as total_projects')
        ->groupBy('month')
        ->orderBy('month', 'asc')
        ->get();
        
        $chartData = $projectCounts->map(function ($item) {
            return [
                'month' => $item->month,
                'total_projects' => $item->total_projects,
            ];
        })->toArray();
      
        return view('reports.order_book_value', compact('projects', 'chartData'));
    }
    
    
    public function showSalesReport(Request $request)
    {
        if(Auth::user()->perm_reports==0){
            abort(403);
        }
        
        
        if(request()->has('from')){
            $startDate = request()->from;
            $endDate = request()->to;
        }else{
            $startDate = Carbon::now()->subDays(90);
            $endDate = Carbon::now();
        }
        
        $projects = DB::table('projects as a')
                ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
                ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
                ->select('a.*', 'b.company_name', 'c.name as status')
                ->whereBetween('a.created_at', [$startDate, $endDate])
                ->get();
        
        if($projects){
              foreach($projects as $project){
                $project->items = DB::table('project_financials as a')
                    ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
                    ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
                    ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
                    ->where('a.project_id', $project->id)
                    ->orderBy('a.id', 'desc')
                    ->get();

                $project->tenderItems = DB::table('tender_project_files')->where('project_id', $project->id)->get();


                $project->purchase_orders = DB::table('accounts_purchase_orders')
                    ->where('project_id', $project->id)
                    ->get();


                foreach ($project->purchase_orders as $po) {
                    $totals = DB::table('accounts_purchase_order_items')
                        ->where('po_id', $po->id)
                        ->select(
                            DB::raw('SUM(plant) as total_plant'),
                            DB::raw('SUM(labour) as total_labour'),
                            DB::raw('SUM(material) as total_materials'),
                            DB::raw('SUM(sc_total) as total_sc')
                        )
                        ->first();

                    $po->sc = DB::table('sub_contract_quotes as a')
                    ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
                    ->select('b.title', 'a.*')
                    ->where('a.project_id', $project->id)
                    ->where('a.id', $po->sub_contract_id)
                    ->where('a.accepted', 1)
                    ->first();

                    // Add totals to the purchase order object
                    $po->total_plant = $totals->total_plant;
                    $po->total_labour = $totals->total_labour;
                    $po->total_materials = $totals->total_materials;
                    $po->total_sc = $totals->total_sc;
                    $po->total = $totals->total_plant + $totals->total_labour + $totals->total_materials + $totals->total_sc;
                }


                $project->sub_contracts = DB::table('sub_contract_quotes as a')
                    ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
                    ->select('b.title', 'a.*')
                    ->where('a.project_id', $project->id)
                    ->where('a.accepted', 1)
                    ->get();
            }
        }
        
        $projectCounts = DB::table('projects as a')
        ->selectRaw('DATE_FORMAT(a.created_at, "%Y-%m") as month, COUNT(*) as total_projects')
        ->groupBy('month')
        ->orderBy('month', 'asc')
        ->get();
        
        $chartData = $projectCounts->map(function ($item) {
            return [
                'month' => $item->month,
                'total_projects' => $item->total_projects,
            ];
        })->toArray();
      
        return view('reports.sales_report', compact('projects', 'chartData'));
    }
    
    
    public function showBestClients(Request $request)
    {
        if(Auth::user()->perm_reports==0){
            abort(403);
        }
        
        if(request()->has('from')){
            $startDate = request()->from;
            $endDate = request()->to;
        }else{
            $startDate = Carbon::now()->subDays(90);
            $endDate = Carbon::now();
        }
        
        $clients = DB::table('customers')->where('type', 'customer')->get();
        foreach($clients as $client){
            $client->projects = DB::table('projects as a')
                ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
                ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
                ->select('a.*', 'b.company_name', 'c.name as status')
                ->where('a.customer_id', $client->id)
                ->whereBetween('a.created_at', [$startDate, $endDate])
                ->get();
        
            foreach($client->projects as $project){
                $project->items = DB::table('project_financials as a')
                    ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
                    ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
                    ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
                    ->where('a.project_id', $project->id)
                    
                    ->orderBy('a.id', 'desc')
                    ->get();

                $project->tenderItems = DB::table('tender_project_files')->where('project_id', $project->id)->get();


                $project->purchase_orders = DB::table('accounts_purchase_orders')
                    ->where('project_id', $project->id)
                    ->get();


                foreach ($project->purchase_orders as $po) {
                    $totals = DB::table('accounts_purchase_order_items')
                        ->where('po_id', $po->id)
                        ->select(
                            DB::raw('SUM(plant) as total_plant'),
                            DB::raw('SUM(labour) as total_labour'),
                            DB::raw('SUM(material) as total_materials'),
                            DB::raw('SUM(sc_total) as total_sc')
                        )
                        ->first();

                    $po->sc = DB::table('sub_contract_quotes as a')
                    ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
                    ->select('b.title', 'a.*')
                    ->where('a.project_id', $project->id)
                    ->where('a.id', $po->sub_contract_id)
                    ->where('a.accepted', 1)
                    ->first();

                    // Add totals to the purchase order object
                    $po->total_plant = $totals->total_plant;
                    $po->total_labour = $totals->total_labour;
                    $po->total_materials = $totals->total_materials;
                    $po->total_sc = $totals->total_sc;
                    $po->total = $totals->total_plant + $totals->total_labour + $totals->total_materials + $totals->total_sc;
                }


                $project->sub_contracts = DB::table('sub_contract_quotes as a')
                    ->leftjoin('project_sub_contracts as b', 'a.sub_contract_id', '=', 'b.id')
                    ->select('b.title', 'a.*')
                    ->where('a.project_id', $project->id)
                    ->where('a.accepted', 1)
                    ->get();
            }
        }
        
        
      
        return view('reports.best_clients', compact('clients'));
    }
    
    
    
    public function showBidToWin(Request $request)
    {
        if(Auth::user()->perm_reports==0){
            abort(403);
        }
        
        if(request()->has('from')){
            $startDate = request()->from;
            $endDate = request()->to;
        }else{
            $startDate = Carbon::now()->subDays(90);
            $endDate = Carbon::now();
        }
        
        $totalQuotes = DB::table('project_type_history')->where('type', 'Quote')
            ->whereBetween('created_at', [$startDate, $endDate])
            ->distinct('project_id')
            ->count('project_id');
        
        
        $convertedToOther = DB::table('project_type_history')->select('pth1.project_id')
            ->from('project_type_history as pth1')
            ->join('project_type_history as pth2', function ($join) {
                $join->on('pth1.project_id', '=', 'pth2.project_id')
                    ->where('pth2.type', '!=', 'Quote');
            })
            ->where('pth1.type', 'Quote')
            ->whereBetween('pth1.created_at', [$startDate, $endDate])
            ->distinct('pth1.project_id')
            ->count();
        
        $convertedProjectIds = DB::table('project_type_history')->select('pth1.project_id')
        ->from('project_type_history as pth1')
        ->join('project_type_history as pth2', function ($join) {
            $join->on('pth1.project_id', '=', 'pth2.project_id')
                ->where('pth2.type', '!=', 'Quote');
        })
        ->where('pth1.type', 'Quote')
        ->whereBetween('pth1.created_at', [$startDate, $endDate])
        ->distinct('pth1.project_id')
        ->pluck('pth1.project_id')
        ->toArray();
        
        
        $bidToWinPercentage = $totalQuotes > 0
        ? ($convertedToOther / $totalQuotes) * 100
        : 0;
        
        
        $projects = DB::table('projects')->whereIn('id', $convertedProjectIds)->get();
        
        return view('reports.bid_to_win', ['projects' => $projects, 'win_percentage'=>$bidToWinPercentage, 'total_quotes'=>$totalQuotes], );
    }
    
    
    
    public function showPoReport(Request $request)
    {
        if(Auth::user()->perm_reports==0){
            abort(403);
        }
        
        if(request()->has('from')){
            $startDate = request()->from;
            $endDate = request()->to;
        }else{
            $startDate = Carbon::now()->subDays(90);
            $endDate = Carbon::now();
        }
        
        $invoices = DB::table('supplier_invoices as a')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->select('a.*', 'b.company_name')
            ->where('transferred', 0)
            ->whereBetween('a.date', [$startDate, $endDate])
            ->orderBy('id', 'desc')
            ->get();
        
        return view('reports.po_report', ['invoices' => $invoices]);
    }
    
    
    public function showSalesInvoiceReport(Request $request)
    {
        if(Auth::user()->perm_accounts==0){
            abort(403);
        }
        
        
        if(request()->has('from')){
            $startDate = request()->from;
            $endDate = request()->to;
        }else{
            $startDate = Carbon::now()->subDays(90);
            $endDate = Carbon::now();
        }
        
        $invoices = DB::table('project_invoices as a')
            ->select('a.*', 'c.company_name')
            ->leftjoin('projects as b', 'a.project_id', '=', 'b.id')
            ->leftjoin('customers as c', 'b.customer_id', '=', 'c.id')
            ->where('a.transferred', 0)
            ->whereBetween('a.created_at', [$startDate, $endDate])
            ->orderBy('a.id', 'desc')
            ->get();
        
        return view('reports.sales_invoice_report', ['invoices' => $invoices]);
    }
    
    
    
    public function showCompletionRate(Request $request)
    {
        if(Auth::user()->perm_reports==0){
            abort(403);
        }
        
        if(request()->has('from')){
            $startDate = request()->from;
            $endDate = request()->to;
        }else{
            $startDate = Carbon::now()->subDays(90);
            $endDate = Carbon::now();
        }
        
        $projects = DB::table('projects as a')
            ->select('a.*', 'b.company_name')
            ->leftJoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->where('a.completed', 1)
            ->whereBetween('a.created_at', [$startDate, $endDate])
            ->get();
        
        // Step 2: Initialize counters and a list for completed projects on time
        $totalProjects = count($projects);
        $completedOnTimeCount = 0;
        $completedOnTimeProjects = [];

        foreach ($projects as $project) {
            // Check if the project is completed and within 60 days
            if ($project->completed == 1) {
                $createdAt = Carbon::parse($project->created_at);
                $updatedAt = Carbon::parse($project->completion_date);

                if ($createdAt->diffInDays($updatedAt) <= 60) {
                    $project->complete_status = 'on_time';
                    $completedOnTimeCount++;
                    $completedOnTimeProjects[] = $project;
                }else{
                    $project->complete_status = 'late';
                }
            }
        }

        // Step 3: Calculate the percentage
        $percentage = $totalProjects > 0 
            ? ($completedOnTimeCount / $totalProjects) * 100 
            : 0;
        
        return view('reports.project_completion_rate', ['projects' => $projects, 'percentage'=>$percentage, 'completed_on_time'=>$completedOnTimeCount]);
    }
    
    
    public function showJobDuration(Request $request)
    {
        if(Auth::user()->perm_reports==0){
            abort(403);
        }
        
        if(request()->has('from')){
            $startDate = request()->from;
            $endDate = request()->to;
        }else{
            $startDate = Carbon::now()->subDays(90);
            $endDate = Carbon::now();
        }
        
        $projects = DB::table('projects as a')
            ->select('a.*', 'b.company_name')
            ->leftJoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->whereBetween('a.created_at', [$startDate, $endDate])
            ->get();
        
        // Step 2: Initialize counters and a list for completed projects on time
        $totalProjects = count($projects);
        $completedOnTimeCount = 0;
        $completedOnTimeProjects = [];

        $completed = 0;
        $in_progress = 0;
        
        foreach ($projects as $project) {
            if($project->completed==1){
                $completed++;
            }else{
                $in_progress++;
            }
            
            $createdAt = Carbon::parse($project->created_at);
            $updatedAt = Carbon::parse($project->completion_date);
            $project->days = $createdAt->diffInDays($updatedAt);
        }
        
        return view('reports.project_job_duration', ['projects' => $projects, 'completed'=>$completed, 'in_progress'=>$in_progress]);
    }
    
    
    
    public function purchaseOrderList(Request $request)
    {
        if(Auth::user()->perm_accounts==0){
            abort(403);
        }
        
        $purchase_orders = DB::table('accounts_purchase_orders as a')
        ->leftJoin('customers as b', 'a.supplier_id', '=', 'b.id')
        ->leftJoin('supplier_invoices as c', 'a.supplier_invoice_id', '=', 'c.id')
        ->select('a.*', 'b.company_name', 'c.date as invoice_date')
        ->orderBy('a.id', 'desc')
        ->get();
        
        foreach($purchase_orders as $po){
            $sales_total = 0;
            $vat_total = 0;
            
            $po_items = DB::table('accounts_purchase_order_items')
            ->where('po_id', $po->id)
            ->get();
            
            foreach($po_items as $item){
                $plant = $item->plant;
                $labour = $item->labour;
                $material = $item->material;
                $sc_total = $item->sc_total;
                $sales_total += $plant+$labour+$material+$sc_total;
            }
            
            $po->total_net = $sales_total;
        }
        
        
        return view('account.purchase_order_list', ['purchase_orders' => $purchase_orders]);
    }
    
    
    public function supplierInvoices(Request $request)
    {
        if(Auth::user()->perm_accounts==0){
            abort(403);
        }
        
        $suppliers = DB::table('customers')
            ->where('type', 'supplier')
            ->get();
        
        $nominalCodes = DB::table('nominal_codes')->get();
        
        return view('account.supplier_invoices', ['suppliers' => $suppliers, 'nominal_codes' => $nominalCodes]);
    }
    
}