<?php

namespace App\Http\Controllers;
use DB;
use App\Quotation;
use Illuminate\Http\Request;
use App\Patients;
use App\Doctors;
use Session;
use App\Questionnaire;
use Illuminate\Support\Facades\Auth;
use Redirect;
use Carbon\Carbon;
use PDF;
use Illuminate\Support\Facades\Hash;
use ZipArchive;
use Illuminate\Support\Facades\File;
class SettingController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    
    
    public function updateProfile(Request $request)
    {
        // Validate the request data
        $request->validate([
            'firstname' => 'required|string|max:255',
            'lastname'  => 'required|string|max:255',
            'email'     => 'required|email|max:255|unique:users,email,' . Auth::id(),
            'phone'     => 'nullable|string|max:20',
        ]);

        // Update user details
        DB::table('users')->where('id', Auth::id())->update([
            'firstname' => $request->firstname,
            'lastname'  => $request->lastname,
            'email'     => $request->email,
            'phone'     => $request->phone,
        ]);

        // Return a success response
        return back()->with('success', 'Profile updated successfully.');
    }
    
    public function updatePassword(Request $request)
    {
        // Validate the form data
        $request->validate([
            'current_password' => 'required',
            'new_password' => 'required|min:8|confirmed',
        ]);

        // Check if the current password is correct
        if (!Hash::check($request->current_password, Auth::user()->password)) {
            return back()->withErrors(['current_password' => 'Current password is incorrect']);
        }

        // Update the user's password
        DB::table('users')->where('id', Auth::id())->update([
            'password' => Hash::make($request->new_password)
        ]);

        return back()->with('success', 'Password updated successfully.');
    }
    
    public function viewProjectTypes(Request $request)
    {
        $types = DB::table('project_types')->get();
        return view('setting.project_types', ['project_types' => $types]);
    }
    
    public function viewFinancialItems(Request $request)
    {
        $items = DB::table('financial_items')->get();
        $uoms = DB::table('financial_uoms')->orderBy('id', 'asc')->get();
        return view('setting.financial_items', ['items' => $items, 'uoms'=>$uoms]);
    }
    
    public function viewUsers(Request $request)
    {
        $users = DB::table('users as a')
            ->leftjoin('office_locations as b', 'a.office_location', '=', 'b.id')
            ->select('a.*', 'b.name as office_location')
            ->where('a.role', 'user')->orderBy('a.id', 'desc')->get();
        $offices = DB::table('office_locations')->get();
        return view('setting.users', ['users' => $users, 'offices'=>$offices]);
    }
    
    public function viewProfile(Request $request)
    {
        $user = DB::table('users')->where('id', Auth::id())->first();
        $offices = DB::table('office_locations')->get();
        return view('setting.profile', ['user' => $user, 'offices'=>$offices]);
    }
    
    
    public function viewProjectStatuses(Request $request)
    {
        $types = DB::table('project_statuses')->get();
        return view('setting.project_statuses', ['statuses' => $types]);
    }
    
    
    public function viewAddressTypes(Request $request)
    {
        $addresses = DB::table('address_types')->get();
        return view('setting.address_types', ['addresses' => $addresses]);
    }
    
    public function viewFinancialUoms(Request $request)
    {
        $uoms = DB::table('financial_uoms')->get();
        return view('setting.uoms', ['uoms' => $uoms]);
    }
    
    public function officeLocations(Request $request)
    {
        $locations = DB::table('office_locations')->get();
        return view('setting.office_locations', ['locations' => $locations]);
    }
    
    
    public function viewMilestones(Request $request)
    {
        $milestones = DB::table('project_milestones as a')
            ->leftjoin('project_types as b', 'a.project_type_id', '=', 'b.id')
            ->select('a.*', 'b.name as project_type')
            ->get();
        $types = DB::table('project_types')->get();
        return view('setting.milestones', ['milestones' => $milestones, 'project_types'=>$types]);
    }
    
    public function showProjectTypeMilestones(Request $request, $id)
    {
        $milestones = DB::table('project_milestones')->where('project_type_id', $id)->orderBy('sort', 'asc')->get();
        $type = DB::table('project_types')->where('id', $id)->first();
        return view('setting.pt_milestones', ['milestones' => $milestones, 'project_type'=>$type]);
    }
    
    
    public function editUser(Request $request, $id)
    {
        
        $user = DB::table('users')->where('id', $id)->first();
        $project_types = DB::table('project_types')->get();
        $offices = DB::table('office_locations')->get();
        $skills = DB::table('skills_set')->get();
        $labourers = DB::table('users')->where('department', 'labourer')->get();
        $user_skills = DB::table('user_skills')->where('user_id', $id)->pluck('skill_id')->toArray();
        $user_labourers = DB::table('site_manager_labourer')->where('site_manager_id', $id)->pluck('labourer_id')->toArray();
        $managers = DB::table('users')->where('manager_access', '1')->get();
        
        return view('setting.edit_user', ['user' => $user, 'project_types'=>$project_types, 'skills'=>$skills, 'user_skills'=>$user_skills, 'labourers'=>$labourers, 'user_labourers'=>$user_labourers, 'managers'=>$managers, 'offices'=>$offices]);
    }
    
    
    public function addOfficeLocation(Request $request)
    {
        DB::table('office_locations')->insertGetId(
             array(
                    'name'   =>   $request->name,
             )
        );
        
        $request->session()->flash('success', 'Office location added successfully.');
        return redirect()->back();
    }
    
    
    
    public function addProjectType(Request $request)
    {
        DB::table('project_types')->insertGetId(
             array(
                    'name'   =>   $request->name,
             )
        );
        
        $request->session()->flash('success', 'Project type added successfully.');
        return redirect()->back();
    }
    
    public function addFinancialUom(Request $request)
    {
        DB::table('financial_uoms')->insertGetId(
             array(
                    'name'   =>   $request->name,
             )
        );
        
        $request->session()->flash('success', 'Financial uom added successfully.');
        return redirect()->back();
    }
    
    public function updateOfficeLocation(Request $request)
    {
        DB::table('office_locations')->where('id', $request->type_id)->update(
             array(
                    'name'   =>   $request->name,
             )
        );
        
        $request->session()->flash('success', 'Office location updated successfully.');
        return redirect()->back();
    }
    
    public function updateProjectType(Request $request)
    {
        DB::table('project_types')->where('id', $request->type_id)->update(
             array(
                    'name'   =>   $request->name,
             )
        );
        
        $request->session()->flash('success', 'Project type updated successfully.');
        return redirect()->back();
    }
    
    public function updateAddressType(Request $request)
    {
        DB::table('address_types')->where('id', $request->type_id)->update(
             array(
                    'name'   =>   $request->name,
             )
        );
        
        $request->session()->flash('success', 'Address type updated successfully.');
        return redirect()->back();
    }
    
    
    public function updateFinancialUom(Request $request)
    {
        DB::table('financial_uoms')->where('id', $request->type_id)->update(
             array(
                    'name'   =>   $request->name,
             )
        );
        
        $request->session()->flash('success', 'Financial uom updated successfully.');
        return redirect()->back();
    }
    
    
    public function readNotifications(Request $request)
    {
        DB::table('notifications')->where('user_id', Auth::id())->update(
             array(
                    'user_read'   =>   1,
             )
        );
        
        echo 1;
    }
    
    
    public function updateFinancials(Request $request)
    {
        $sales_price = $request->plant + $request->labour + $request->material;
        DB::table('financial_items')->where('id', $request->item_id)->update(
             array(
                    'code'   =>   $request->code,
                    'description'   =>   $request->description,
                    'plant'   =>   $request->plant,
                    'labour'   =>   $request->labour,
                    'material'   =>   $request->material,
                    'sales_price'   =>   $sales_price,
             )
        );
        
        $request->session()->flash('success', 'Milestone updated successfully.');
        return redirect()->back();
    }
    
    
    public function updateMilestone(Request $request)
    {
        DB::table('project_milestones')->where('id', $request->type_id)->update(
             array(
                    'name'   =>   $request->name,
             )
        );
        
        $request->session()->flash('success', 'Milestone updated successfully.');
        return redirect()->back();
    }
    
    public function updateProjectStatus(Request $request)
    {
        DB::table('project_statuses')->where('id', $request->type_id)->update(
             array(
                    'name'   =>   $request->name,
                    'completion_days'   =>   $request->completion_days,
             )
        );
        
        $request->session()->flash('success', 'Project status updated successfully.');
        return redirect()->back();
    }
    
    
    public function updateMilestoneSort(Request $request)
    {
        $ids = explode(',', $_POST['sortids']);
        $i = 1;
        foreach($ids as $id){
            DB::table('project_milestones')->where('id', $id)->update(
                 array(
                        'sort'   =>   $i,
                 )
            );
            
            $i++;
        }
        
        $request->session()->flash('success', 'Sort order updated successfully.');
        return redirect()->back();
    }
    
    
    public function updateUser(Request $request, $id)
    {
        
        $dashboard = isset($request->dashboard) ? 1: 0;
        $crm = isset($request->crm) ? 1: 0;
        $projects = isset($request->projects) ? 1: 0;
        $planning = isset($request->planning) ? 1: 0;
        $accounts = isset($request->accounts) ? 1: 0;
        
       
        
        $reports = isset($request->reports) ? 1: 0;
        $system = isset($request->system) ? 1: 0;
        $appaccess = isset($request->app_access) ? 1: 0;
        $timesheet = isset($request->timesheet) ? 1: 0;
        $manageraccess = isset($request->manager_access) ? 1: 0;
        $thirdparty = isset($request->third_party) ? 1: 0;
        
        
        if(isset($request->project_types)){
            $project_types = implode(',', $request->project_types);
        }else{
            $project_types = 0;
        }
        
        DB::table('users')->where('id', $id)->update(
             array(
                    'firstname'   =>   $request->firstname,
                    'lastname'   =>   $request->lastname,
                    'email'   =>   $request->email,
                    'phone'   =>   $request->phone,
                    'department'   =>   $request->department,
                    'office_location'   =>   $request->office_location,
                    'manager_id'   =>   $request->manager_id,
                    'perm_dashboard' => $dashboard,
                    'perm_crm' => $crm,
                    'perm_projects' => $projects,
                    'perm_planning' => $planning,
                    'perm_accounts' => $accounts,
                    'perm_reports' => $reports,
                    'perm_system' => $system,
                    'perm_app_access' => $appaccess,
                    'perm_timesheet' => $timesheet,
                    'third_party' => $thirdparty,
                    'manager_access' => $manageraccess,
                    'project_types_access' => $project_types,
             )
        );
        
        DB::table('user_skills')->where('user_id', $id)->delete();
        DB::table('site_manager_labourer')->where('site_manager_id', $id)->delete();
        
        if(isset($request->skills_set)){
            foreach($request->skills_set as $skill){
                DB::table('user_skills')->insert(
                     array(
                            'user_id'   =>   $id,
                            'skill_id'   => $skill,
                     )
                );
            }
        }
        
        if(isset($request->labourers)){
            foreach($request->labourers as $labourer){
                DB::table('site_manager_labourer')->insert(
                     array(
                            'site_manager_id'   =>   $id,
                            'labourer_id'   => $labourer,
                     )
                );
            }
        }
        
        $request->session()->flash('success', 'User updated successfully.');
        return redirect()->back();
    }
    
    public function addStaff(Request $request)
    {
        
        $request->validate([
            'email' => 'required|string|email|max:255|unique:users',
        ]);
        
        $dashboard = isset($request->dashboard) ? 1: 0;
        $crm = isset($request->crm) ? 1: 0;
        $projects = isset($request->projects) ? 1: 0;
        $planning = isset($request->planning) ? 1: 0;
        $accounts = isset($request->accounts) ? 1: 0;
        $reports = isset($request->reports) ? 1: 0;
        $system = isset($request->system) ? 1: 0;
        $appaccess = isset($request->app_access) ? 1: 0;
        $timesheet = isset($request->timesheet) ? 1: 0;
        $manageraccess = isset($request->manager_access) ? 1: 0;
        $thirdparty = isset($request->third_party) ? 1: 0;
        
        DB::table('users')->insertGetId(
             array(
                    'firstname'   =>   $request->firstname,
                    'lastname'   =>   $request->lastname,
                    'email'   =>   $request->email,
                     'password' => Hash::make($request->password),
                    'phone'   =>   $request->phone,
                    'department'   =>   $request->department,
                    'office_location'   =>   $request->office_location,
                    'perm_dashboard' => $dashboard,
                    'perm_crm' => $crm,
                    'perm_projects' => $projects,
                    'perm_planning' => $planning,
                    'perm_accounts' => $accounts,
                    'perm_reports' => $reports,
                    'perm_system' => $system,
                    'perm_app_access' => $appaccess,
                    'perm_timesheet' => $timesheet,
                    'manager_access' => $manageraccess,
                    'third_party' => $thirdparty,
                    'created_at'   =>   date('Y-m-d H:i'),
                    'role' => 'user'
             )
        );
        
        $request->session()->flash('success', 'User added successfully.');
        return redirect()->back();
    }
    
    
    public function addAddressType(Request $request)
    {
        DB::table('address_types')->insertGetId(
             array(
                    'name'   =>   $request->name,
             )
        );
        
        $request->session()->flash('success', 'Address type added successfully.');
        return redirect()->back();
    }
    
    
    public function addProjectStatus(Request $request)
    {
        DB::table('project_statuses')->insertGetId(
             array(
                    'name'   =>   $request->name,
                    'completion_days'   =>   $request->completion_days,
             )
        );
        
        $request->session()->flash('success', 'Project status added successfully.');
        return redirect()->back();
    }
    
    public function deleteProjectType(Request $request)
    {
        DB::table('project_types')->where('id', $request->delete_id)->delete();
        
        $request->session()->flash('success', 'Project type removed successfully.');
        return redirect()->back();
    }
    
    
    public function uploadUserImage(Request $request, $id)
    {
        $request->validate([
            'image' => 'required|string'
        ]);

        // Get the base64 string
        $base64Image = $request->input('image');

        // Decode the base64 string
        $image = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $base64Image));

        // Define the path where you want to save the image
        $imageName = uniqid(time()) . '.png'; // You can change the extension based on the image type
        $path = public_path('img/users/' . $imageName);

        // Save the image to the specified path
        File::put($path, $image);
        
        $user = DB::table('users')->where('id', $id)->first();
        if ($user->image!='default.png' && File::exists(public_path('img/users/' . $user->image))) {
            File::delete(public_path('img/users/' . $user->image));
        }
        
        
        DB::table('users')->where('id', $id)->update([
            'image' => $imageName,
        ]);

        // Optionally, return a response with the saved image path or URL
        return response()->json(['image_url' => $imageName], 200);
    }
    
    public function deleteOfficeLocation(Request $request)
    {
        DB::table('office_locations')->where('id', $request->delete_id)->delete();
        
        $request->session()->flash('success', 'Office location removed successfully.');
        return redirect()->back();
    }
    
    public function deleteProjectStatus(Request $request)
    {
        DB::table('project_statuses')->where('id', $request->delete_id)->delete();
        
        $request->session()->flash('success', 'Project status removed successfully.');
        return redirect()->back();
    }
    
    public function deleteProjectMilestones(Request $request)
    {
        DB::table('project_milestones')->where('id', $request->delete_id)->delete();
        
        $request->session()->flash('success', 'Milestone removed successfully.');
        return redirect()->back();
    }
    
    public function deleteFinancialItems(Request $request)
    {
        DB::table('financial_items')->where('id', $request->delete_id)->delete();
        
        $request->session()->flash('success', 'Financial item removed successfully.');
        return redirect()->back();
    }
    
    public function deleteFinancialUoms(Request $request)
    {
        DB::table('financial_uoms')->where('id', $request->delete_id)->delete();
        
        $request->session()->flash('success', 'Uom removed successfully.');
        return redirect()->back();
    }
    
    public function deleteAddressType(Request $request)
    {
        DB::table('address_types')->where('id', $request->delete_id)->delete();
        
        $request->session()->flash('success', 'Address type removed successfully.');
        return redirect()->back();
    }
    
    
    public function addMilestone(Request $request)
    {
        DB::table('project_milestones')->insertGetId(
             array(
                    'name'   =>   $request->name,
                    'project_type_id'   =>   $request->project_type,
             )
        );
        
        $request->session()->flash('success', 'Milestone added successfully.');
        return redirect()->back();
    }
    
    
    public function addFinancialItem(Request $request)
    {
        DB::table('financial_items')->insertGetId(
             array(
                    'code'   =>   $request->code,
                    'description'   =>   $request->description,
                    'sales_price'   =>   $request->sales_price,
                    'quantity'   =>   $request->quantity,
                    'uom'   =>   $request->uom,
             )
        );
        
        $request->session()->flash('success', 'Financial item added successfully.');
        return redirect()->back();
    }
    
    
    
	



}