<?php

namespace App\Http\Controllers;
use DB;
use App\Quotation;
use Illuminate\Http\Request;
use App\Patients;
use App\Doctors;
use Session;
use App\Questionnaire;
use Illuminate\Support\Facades\Auth;
use Redirect;
use Carbon\Carbon;
use PDF;
use Hash;
use ZipArchive;
class ViewController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    
    public function signUpView()
    {
        return view('auth.signup');
    }
    
    
    public function signup(Request $request)
    {
        // Validate input
        $request->validate([
            'email' => 'required|email|unique:users,email',
            'password' => 'required|min:8|confirmed',
        ]);

        // Create the user
        $user = DB::table('users')->insert([
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'created_at' => date('Y-m-d H:i'),
        ]);

        // Optionally log the user in
        // auth()->login($user);

        return redirect()->route('login')->with('success', 'Account created successfully. Please check your email for verification link.');
    }
    
    
    public function setupProfileView()
    {
        return view('auth.set-profile');
    }
    
    public function createPostView()
    {
        $social_accounts = DB::table('user_social_accounts')
            ->where('user_id', Auth::user()->id)->get();
        return view('content.create-post', compact('social_accounts'));
    }
    
    
    public function allPosts()
    {
        $posts = DB::table('posts')
            ->where('user_id', Auth::user()->id)->get();
        return view('content.all-posts', compact('posts'));
    }
    
    
    public function createPost(Request $request)
    {
        $request->validate([
            'content' => 'required|string',            
        ]);
        
        $schedule_time = '';
        if($request->action=='draft'){
            $action = 'draft';
            $status = 'draft';
        }elseif($request->action=='schedule'){
            $action = 'schedule';
            $status = 'pending_schedule';
            $schedule_time = $request->schedule_time;
        }elseif($request->action=='publish'){
            $action = 'publish';
            $status = 'pending_approval';
        }
        
        
        $filename = "";
        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $ext = $file->getClientOriginalExtension();
            $filename = uniqid(time()) . '.' . $ext;
            $name = $file->getClientOriginalName();
            $file->move(public_path('post_images'), $filename);
        }
        
        DB::table('posts')->insert([
            'content' => $request->content,
            'tags' => $request->tags_comma_separated,
            'image' => $filename,
            'status' => $status,
            'schedule_time' => $schedule_time,
            'action' => $action,
            'user_id' => Auth::user()->id,
            'created_at' => date('Y-m-d H:i'),
        ]);
        
        $request->session()->flash('success', 'Post created successfully.');
        return redirect()->back();
    }
    
    
    public function addNewSocial(Request $request)
    {
        $request->validate([
            'social_media' => 'required|string|max:255',
        ]);

        DB::table('user_social_accounts')->insert([
            'social_media' => $request->social_media,
            'user_id' => Auth::user()->id,
            'created_at' => date('Y-m-d H:i'),
        ]);

        $request->session()->flash('success', 'Social account has been added successfully.');
        return redirect()->back();
    }
    
    
    public function setupProfile(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'phone' => 'required|string|max:15',
        ]);

        $user = auth()->user();
        DB::table('users')->where('id', Auth::user()->id)->update([
            'name' => $request->name,
            'phone' => $request->phone,
            'company_name' => $request->company_name,
            'job_title' => $request->job_title,
            'profile_setup' => 1,
        ]);

        return redirect()->route('dashboard');
    }
    
    public function selectPackage()
    {
        return view('auth.packages');
    }
    
    public function userDashboard()
    {
        return view('dashboard');
    }
    
    
    public function unlike(Request $request)
    {
        DB::table('user_project_likes')->where('project_id', $request->project_id)->where('user_id', Auth::id())->delete();

        $request->session()->flash('success', 'Project removed from favourites successfully.');
        return redirect()->back();
    }
	



}