<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Auth;

use DB;
class ViewServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    
    
    public function boot()
    {
        
        View::share('humanReadableTime', function ($datetime) {
            return humanReadableTime($datetime);
        });
        
        View::composer('*', function ($view) {
            if (Auth::check()) {
                $notifications = DB::table('notifications')->where('user_id', Auth::id())->orderBy('id', 'desc')->get();
                $unreadCount = DB::table('notifications')->where('user_id', Auth::id())->where('user_read', 0)
                    ->count();
                $view->with([
                    'notifications' => $notifications,
                    'unreadNotifs' => $unreadCount,
                ]);
            }
        });
    }
}
