@extends('layouts.app')
@section('title', 'Project Details')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <style>
        .project-image {
            width: 100%;
            height: 428px;
            object-fit: cover;
        }

        iframe {
            width: 100% !important;
            height: 300px !important;
            margin: 0 !important;
            border-radius: 10px;
        }

        .nav-link {
            font-size: 18px;
            color: #5E5E5E;
        }

        .nav-pills .nav-link.active,
        .nav-pills .show>.nav-link {
            border: 1px solid #93D50066;
            background: white;
            color: black;
            font-weight: 500;
        }

        .page-heading {
            font-size: 24px !important;
        }

        .project-id {
            font-size: 18px;
            color: #556171 !important;
        }

        .image-container {
            position: relative;
            /*display: inline-block;*/
        }



        .overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transition: opacity 0.5s ease;
        }

        .image-container:hover .overlay {
            opacity: 1;
        }

        .upload-btn {
            background-color: #93D500;
            border: none;
            color: white;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 16px;
            margin: 4px 2px;
            cursor: pointer;
            border-radius: 12px;
        }

        .project-image {
            width: 100%;
            height: 428px;
            object-fit: cover;
        }


        .select2-container--bootstrap5 .select2-selection--multiple .select2-selection__rendered .select2-selection__choice {
            background-color: #93D500;
            color: black;
        }

        .correspondence {
            border: 1px solid #E1E1E1;
            background: #FAFAFA;
            padding: 15px;
            border-radius: 10px;
        }

        .cr-title {
            font-size: 16px;
            font-weight: 500;
        }

        .cr-description {
            color: #5E5E5E;
            font-size: 14px;
            font-weight: 400;
        }

        .cr-time {
            color: #556171;
            font-size: 16px;
            font-weight: 400;
        }

        table p {
            margin-bottom: 0;
        }

        .table td,
        .table th {
            vertical-align: middle;
        }

        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            text-align: center;
            color: #727879;
        }

        .table .tr-credit td {
            background: #ffcccc;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            text-align: center;
            color: #727879;
        }

        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }



        .showPoDetails{
            cursor: pointer;
        }

        table.table-bordered.dataTable {
            border: 0 !important;
            border-bottom: 0 !important;
        }

        input[readonly] {
            background-color: #E3E3E3;
            /* Change this to your desired color */
        }

        table.dataTable.no-footer {
            border-bottom: 0 !important;
        }

        .table-field {
            display: none;
        }

        .form-check-input:checked {
            border-color: #93d500;
        }

        .form-check-input {
            border-color: grey;
        }

        .table-checkbox {
            /*display: none;*/
        }

        .financial-table {
            width: 180%;
        }

        .form-check {
            display: flex;
            justify-content: center;
        }
        
        .estimated_stats .min-w-125px{
            width: 100%;
        }
        
        .invoices-stats .min-w-125px{
            width: 20%;
        }
        
        .invoice-credit .border-dashed{
            border-color: #f8285a !important;
        }
        
        .invoice-difference .border-dashed{
            border-color: #93D500 !important;
        }
        
        .alert-primary{
            color: #93D500 !important;
            border: 1px solid #93D50033 !important;
            background: #f5ffe0 !important;
            font-size: 15px;
        }
        
        .delete_column{
            cursor: pointer;
        }
        
        .red{
            border-color: #f8285a !important;
        }
        
        .green{
            border-color: #93D500 !important;
        }
        
        
    

    </style>
    @include('project.head')
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <div class="row align-items-center mb-7">
                <div class="col-md-12">
                    @include('project.nav')
                </div>

            </div>


            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif
            
            @if(session('danger'))
            <div class="alert alert-danger">
                {{ session('danger') }}
            </div>
            @endif

            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif

            <div class="card mb-7">




                <div class="card-header " id="kt_chat_contacts_header">
                    <!--begin::Card title-->
                    <div class="card-title justify-content-between">
                        <div class="d-flex align-items-center">
                            <h3 class="fw-bold"><i class="fa-solid fa-sterling-sign me-2 text-dark" style="font-size:18px"></i> Financials <span class="ms-7" id="profit_span">Gross Profit: <span id="gross_profit">£0.00</span></span></h3>

                        </div>




                    </div>
                    <div class="align-self-center">
                        @if ($items->count() > 0)

                        <button style="display:none" id="cancel_btn" class="btn  btn-sm btn-primary ">Cancel</button>
                        <button id="edit_btn" class="btn  btn-sm btn-primary ">Edit</button>
                        <button id="savebtn" style="display:none" onclick="$('#items_form').submit();" class="btn  btn-sm btn-primary ms-2">Save</button>
                        @endif
                        <button id="uplift_btn" class="btn ms-2 btn-sm btn-success ">Uplift</button>
                        <button id="invoice_btn" class="btn ms-2 btn-sm btn-success invoice_btn" data-type="invoice">Invoice</button>
                        <button id="credit_btn" class="btn ms-2 btn-sm btn-success invoice_btn" data-type="credit">Credit Note</button>
                        <button id="add_financials_btn" data-bs-toggle="modal" data-bs-target="#kt_modal_new_target" class="btn ms-2 btn-sm btn-primary ">Add Financials</button>
                        <button id="add_po_btn" data-bs-toggle="modal" data-bs-target="#purchaseOrderModal" class="btn ms-2 btn-sm btn-primary ">Add PO</button>
                    </div>
                    <!--end::Card title-->
                </div>
                <div class="card-body py-2 px-2">
                    <div class="" style="border-radius:10px">
                        <!--begin::Table-->

                        @php
                        $plant = 0;
                        $labour = 0;
                        $material = 0;
                        $estimated_price = 0;
                        $sales_price = 0;
                        $total_vat = 0;
                        $total_sales_net = 0;
                        @endphp

                        <p style="font-style:italic;display:none" id="edit_message" class="mt-3 ms-1"><span class="text-danger"><i class="text-danger fas fa-exclamation-circle"></i> Invoiced items are non editable.</span></p>
                        @if($uplifts->count()>0)
                        @foreach($uplifts as $uplift)
                        <p style="font-style:italic;" id="" class="mt-3 ms-1"><span class="text-danger"><i class="text-danger fas fa-exclamation-circle"></i> Uplifted {{ $uplift->percentage }}% by {{$uplift->firstname}} {{$uplift->lastname}} at {{ date('jS M Y', strtotime($uplift->created_at)) }}.</span></p>
                        @endforeach
                        @endif
                        
                        
                        
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="ps-3 mb-0 py-3">Sales</h4>
                                <div class="d-flex flex-wrap ps-3 sales_stats  mb-5">
                                    <!--begin::Stat-->
                                    <div class="border border-gray-300 border-dashed rounded min-w-125px py-3 px-4 me-3 mb-3">
                                        <!--begin::Number-->
                                        <div class="d-flex align-items-center">

                                            <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="4500" data-kt-countup-prefix="$" data-kt-initialized="1" id="total_plant">£{{ number_format($plant, 2) }}</div>
                                        </div>
                                        <!--end::Number-->
                                        <!--begin::Label-->
                                        <div class="fw-semibold fs-6 text-gray-500">Plant (<span id="total_plant_percent">0%</span>)</div>
                                        <!--end::Label-->
                                    </div>
                                    <!--end::Stat-->
                                    <!--begin::Stat-->
                                    <div class="border border-gray-300 border-dashed rounded min-w-125px py-3 px-4 me-3 mb-3">
                                        <!--begin::Number-->
                                        <div class="d-flex align-items-center">

                                            <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="80" data-kt-initialized="1" id="total_labour">£{{ number_format($labour, 2) }}</div>
                                        </div>
                                        <!--end::Number-->
                                        <!--begin::Label-->
                                        <div class="fw-semibold fs-6 text-gray-500">Labour (<span id="total_labour_percent">0%</span>)</div>
                                        <!--end::Label-->
                                    </div>
                                    <!--end::Stat-->
                                    <!--begin::Stat-->
                                    <div class="border border-gray-300 border-dashed rounded min-w-125px py-3 px-4 me-3 mb-3">
                                        <!--begin::Number-->
                                        <div class="d-flex align-items-center">

                                            <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="60" data-kt-countup-prefix="%" data-kt-initialized="1" id="total_material">£{{ number_format($material, 2) }}</div>
                                        </div>
                                        <!--end::Number-->
                                        <!--begin::Label-->
                                        <div class="fw-semibold fs-6 text-gray-500">Material (<span id="total_material_percent">0%</span>)</div>
                                        <!--end::Label-->
                                    </div>
                                    <!--end::Stat-->
                                    <div class="border border-gray-300 border-dashed rounded min-w-125px py-3 px-4 me-3 mb-3">
                                        <!--begin::Number-->
                                        <div class="d-flex align-items-center">

                                            <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="60" data-kt-countup-prefix="%" data-kt-initialized="1" id="total_sales">£{{ number_format($total_sales_net, 2) }}</div>
                                        </div>
                                        <!--end::Number-->
                                        <!--begin::Label-->
                                        <div class="fw-semibold fs-6 text-gray-500">Sales Net</div>
                                        <!--end::Label-->
                                    </div>
                                    <div class="border border-gray-300 border-dashed rounded min-w-125px py-3 px-4 me-3 mb-3">
                                        <!--begin::Number-->
                                        <div class="d-flex align-items-center">

                                            <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="60" data-kt-countup-prefix="%" data-kt-initialized="1" id="total_vat">£{{ number_format($total_vat, 2) }}</div>
                                        </div>
                                        <!--end::Number-->
                                        <!--begin::Label-->
                                        <div class="fw-semibold fs-6 text-gray-500">VAT</div>
                                        <!--end::Label-->
                                    </div>
                                    <div class="border border-gray-300 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                        <!--begin::Number-->
                                        <div class="d-flex align-items-center">

                                            <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="60" data-kt-countup-prefix="%" data-kt-initialized="1" id="total_gross">£{{ number_format($sales_price, 2) }}</div>
                                        </div>
                                        <!--end::Number-->
                                        <!--begin::Label-->
                                        <div class="fw-semibold fs-6 text-gray-500">Sales Gross</div>
                                        <!--end::Label-->
                                    </div>
                                </div>
                                
                                <h4 class="ps-3 mb-0 py-3">Labour Days Estimated</h4>
                                <div class="d-flex flex-wrap ps-3 sales_stats  mb-5">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="border border-gray-300 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                            <!--begin::Number-->
                                            <div class="d-flex align-items-center">

                                                <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="60" data-kt-countup-prefix="%" data-kt-initialized="1" id="labour_days">0</div>
                                            </div>
                                            <!--end::Number-->
                                            <!--begin::Label-->
                                            <div class="fw-semibold fs-6 text-gray-500">Days</div>
                                            <!--end::Label-->
                                        </div>
                                    </div>
                                </div>
                                </div>
                                
                            </div>
                            <div class="col-md-6">
                                <h4 class="pe-3 mb-0 py-3">Estimated Cost</h4>
                                <div class="pe-3 estimated_stats  mb-3">
                                    <!--begin::Stat-->
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="border border-gray-300 border-dashed green rounded min-w-125px py-3 px-4 me-3 mb-3" id="plant_estimated_box">
                                                <!--begin::Number-->
                                                <div class="d-flex align-items-center">

                                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="4500" data-kt-countup-prefix="$" data-kt-initialized="1" id="total_plant_estimated">£0</div>
                                                </div>
                                                <!--end::Number-->
                                                <!--begin::Label-->
                                                <div class="fw-semibold fs-6 text-gray-500">Plant</div>
                                                <!--end::Label-->
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="border border-gray-300 border-dashed green rounded min-w-125px py-3 px-4 me-3 mb-3" id="labour_estimated_box">
                                                <!--begin::Number-->
                                                <div class="d-flex align-items-center">

                                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="80" data-kt-initialized="1" id="total_labour_estimated">£0</div>
                                                </div>
                                                <!--end::Number-->
                                                <!--begin::Label-->
                                                <div class="fw-semibold fs-6 text-gray-500">Labour</div>
                                                <!--end::Label-->
                                            </div>
                                            
                                        </div>
                                        <div class="col-md-4">
                                            <div class="border border-gray-300 border-dashed green rounded min-w-125px py-3 px-4 me-3 mb-3" id="material_estimated_box">
                                                <!--begin::Number-->
                                                <div class="d-flex align-items-center">

                                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="60" data-kt-countup-prefix="%" data-kt-initialized="1" id="total_material_estimated">£0</div>
                                                </div>
                                                <!--end::Number-->
                                                <!--begin::Label-->
                                                <div class="fw-semibold fs-6 text-gray-500">Material</div>
                                                <!--end::Label-->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <h4 class="pe-3 mb-0 py-3">Total Labour</h4>
                                <div class="pe-3 estimated_stats mb-5">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="border border-gray-300 border-dashed green rounded min-w-125px py-3 px-4 me-3 mb-3" id="">
                                                <!--begin::Number-->
                                                <div class="d-flex align-items-center">

                                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="80" data-kt-initialized="1" id="">{{ number_format($totalHours, 2) }} Hrs</div>
                                                </div>
                                                <!--end::Number-->
                                                <!--begin::Label-->
                                                <div class="fw-semibold fs-6 text-gray-500">Labour</div>
                                                <!--end::Label-->
                                            </div>
                                        </div>
                                        @foreach($sub_contracts as $sc)
                                        <div class="col-md-4">
                                            <div class="border border-gray-300 border-dashed  rounded min-w-125px py-3 px-4 me-3 mb-3" id="">
                                                <!--begin::Number-->
                                                <div class="d-flex align-items-center">

                                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="80" data-kt-initialized="1" id="">£{{ number_format($sc->amount, 2) }}</div>
                                                </div>
                                                <!--end::Number-->
                                                <!--begin::Label-->
                                                <div class="fw-semibold fs-6 text-gray-500">{{ $sc->title }}</div>
                                                <!--end::Label-->
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                                
                                <h4 class="pe-3 mb-0 py-3">Purchase Orders</h4>
                                <div class="pe-3 estimated_stats  mb-5">
                                    <!--begin::Stat-->
                                    <div class="row">
                                       @foreach($purchase_orders as $po)
                                        <div class="col-md-6">
                                            
                                            
                                            
                                            <div style="cursor:pointer" onclick="window.location='{{ route('accounts.purchaseOrderDetails', ['id'=>$po->id]) }}'" class="border border-gray-300 border-dashed  rounded min-w-125px py-3 px-4  mb-3" data-id="{{ $po->id }}">
                                                <div class="d-flex align-items-center">

                                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="4500" data-kt-countup-prefix="$" data-kt-initialized="1">£{{ number_format($po->total, 2) }} <small style="font-size:13px" class="text-gray-500">PO-{{str_pad($po->id, 4, '0', STR_PAD_LEFT);}} </small></div>
                                                </div>
                                                <div class="fw-semibold fs-6 text-gray-500"><small>@if($po->sub_contract==1) {{ $po->sc->title }} @else P: £{{number_format($po->total_plant, 2)}} | L: £{{number_format($po->total_labour, 2)}} | M: £{{number_format($po->total_materials, 2)}} @endif</small></div>
                                            </div>
                                            
                                            
                                            
                                        </div>
                                        @endforeach
                                        
                                        
                                    </div>
                                </div>
                                
                            </div>
                        </div>
                        
                        
                        <p style="font-style:italic;display:none" id="edit_message" class="mt-3 ms-1"><span class="text-danger"><i class="text-danger fas fa-exclamation-circle"></i> Invoiced items are non editable.</span></p>
                        <form action="{{route('projects.updateFinancial', ['id'=>$project->id])}}" method="post" id="items_form">
                            @csrf
                            <div class="table-responsive">
                                <table class="table table-bordered financial-table" id="kt_table_users">
                                    <thead>
                                        <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                            <th class="table-checkbox"></th>
                                            <th>Code</th>
                                            <th>Description</th>
                                            <th>UoM</th>
                                            <th>Qty</th>
                                            <th>Plant</th>
                                            <th>Labour</th>
                                            <th>Material</th>
                                            <th class="non-editable">Sales Net</th>
                                            <th class="non-editable">VAT</th>
                                            <th class="non-editable">Sales Gross</th>
                                            <th>Estimated Cost</th>
                                            <th>Supplier</th>
                                            <th class="non-editable">Actual Cost</th>
                                            <th class="non-editable">PO Number</th>
                                            <th class="non-editable">Sales Invoice No.</th>
                                            <th class="delete_column"></th>

                                        </tr>
                                    </thead>
                                    <tbody class="text-gray-600 fw-semibold">
                                        @foreach($items as $item)
                                        <tr id="item_row_{{$item->id}}" class="@if($item->invoiced==1) tr-invoiced @endif @if($item->credit_note==1) tr-credit @else tr-invoice @endif">
                                            <td align="center" class="table-checkbox">
                                                @if($item->invoiced==0)
                                                <div class="form-check text-center m-0">
                                                    <input data-price="{{ $item->estimated_price }}" name="invoice_item[]" class="form-check-input invoice-checkbox" type="checkbox" value="{{$item->id}}" id="flexCheckDefault">
                                                </div>
                                                @endif
                                            </td>
                                            <td> @if($item->variation==1) <i class="fa fa-check-circle text-primary"></i> @endif {{ $item->code }}</td>
                                            <td>
                                                <span class="table-data">{{ substr($item->description, 0, 30).'...' }}</span>
                                                <input @if($item->invoiced==1) readonly @endif class="form-control table-field form-control-sm" type="text" value="{{ $item->description }}" name="description[]">
                                            </td>

                                            <td class="td-uom">
                                                <span class="table-data">{{ $item->uom }} </span>
                                                @if($item->invoiced==1)
                                                <input readonly class="form-control table-field form-control-sm" type="text" value="{{ $item->uom }}" name="uom[]">
                                                @else
                                                <select class="form-control form-control-sm table-field" name="uom[]" id="">
                                                    <option value="">Select</option>
                                                    @foreach($uoms as $uom)
                                                    <option @if($uom->name==$item->uom) selected @endif value="{{$uom->name}}">{{$uom->name}}</option>
                                                    @endforeach
                                                </select>
                                                @endif

                                            </td>
                                            <td>
                                                <span class="table-data">{{ $item->quantity }}</span>
                                                <input @if($item->invoiced==1) readonly @endif class="form-control quantity table-field form-control-sm" type="number" value="{{ $item->quantity }}" name="quantity[]">
                                            </td>
                                            <td>
                                                <span class="table-data">£{{ number_format(round($item->plant, 2)*$item->quantity, 2) }}</span>
                                                <input  data-price="{{round($item->plant, 2)}}" class="form-control plant table-field form-control-sm" type="number" value="{{ round($item->plant, 2) }}" name="plant[]">
                                            </td>
                                            <td>
                                                <span class="table-data">£{{ number_format(round($item->labour, 2)*$item->quantity, 2) }}</span>
                                                <input  data-price="{{ round($item->labour, 2) }}" class="form-control labour table-field form-control-sm" type="number" value="{{ round($item->labour, 2) }}" name="labour[]">
                                            </td>
                                            <td>
                                                <span class="table-data">£{{ number_format(round($item->material, 2)*$item->quantity, 2) }}</span>
                                                <input  data-price="{{ round($item->material, 2) }}" class="form-control material table-field form-control-sm" type="number" value="{{ round($item->material, 2) }}" name="material[]">
                                            </td>

                                            <td class="non-editable">
                                                @php
                                                $sales_net = $item->quantity*(round($item->plant, 2)+round($item->labour, 2)+round($item->material, 2));
                                                $total_sales_net += $sales_net;
                                                @endphp
                                                <span class="total">£{{ number_format($sales_net, 2) }}</span>

                                            </td>
                                            <td class="non-editable">
                                                @php
                                                $vat = $sales_net * (20 / 100);
                                                $total_vat += $vat;
                                                @endphp
                                                <span class="vat">£{{ number_format($vat, 2) }}</span>

                                            </td>
                                            <td class="non-editable">
                                                @php $gross = $vat+$sales_net; @endphp
                                                <span class="total_vat">£{{ number_format($gross, 2) }}</span>

                                            </td>
                                            <td>
                                                <span class="table-data">£{{ number_format($item->estimated_price, 2) }}</span>
                                                <input class="form-control table-field form-control-sm" type="number" value="{{ $item->estimated_price }}" name="estimated_price[]">
                                            </td>
                                            <td>
                                                <span class="table-data">{{ $item->supplier }}</span>
                                                <select class="form-control form-control-sm table-field" name="supplier[]" id="">
                                                    <option value="">Select</option>
                                                    @foreach($suppliers as $supplier)
                                                    <option @if($supplier->id==$item->supplier_id) selected @endif value="{{$supplier->id}}">{{$supplier->company_name}}</option>
                                                    @endforeach
                                                </select>
                                                <input type="hidden" value="{{$item->id}}" name="item_id[]">
                                            </td>
                                            <td class="non-editable" style="background:#E8E8E8" width="10%"> </td>
                                            <td class="non-editable" style="background:#E8E8E8" width="10%">
                                                @if($item->purchased==1)
                                                <a target="_blank" class="text-primary" href="{{asset('img/purchase_orders/'.$item->receipt_photo)}}"><i class="fas fa-eye text-primary  me-3"></i> PO-{{str_pad($item->purchase_order_id, 4, '0', STR_PAD_LEFT);}} </a>
                                                @endif
                                            </td>
                                            <td class="non-editable" style="background:#E8E8E8" width="10%">
                                                @if($item->invoiced==1)
                                                @if($item->credit_note==0)
                                                WGI-{{str_pad($item->invoice_id, 4, '0', STR_PAD_LEFT);}}
                                                @else
                                                <span class="text-danger">
                                                    WGC-{{str_pad($item->invoice_id, 4, '0', STR_PAD_LEFT);}}
                                                </span>
                                                @endif

                                                @endif
                                            </td>
                                            <td class="delete_column">
                                                 @if($item->invoiced != 1 && $item->purchased != 1 && $item->sub_contract_accepted != 1)
                                                <i class="fa fa-trash text-danger deleteItemBtn" data-id="{{ $item->id }}"></i>
                                                @endif
                                            </td>
                                        </tr>

                                        @php
                                        $estimated_price += $item->estimated_price;
                                        $sales_price += $gross;
                                        $plant += $item->plant*$item->quantity;
                                        $labour += $item->labour*$item->quantity;
                                        $material += $item->material*$item->quantity;
                                        @endphp

                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </form>
                        <div class="mb-3" id="create_invoice" style="display:none">
                            <div class="float-end">

                                <button class="btn btn-primary" id="create_invoice_btn">Create Invoice</button>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div class="clearfix"></div>
                        

                        @php
                            $plant_percentage = 0;
                            $labour_percentage = 0;
                            $material_percentage = 0;
                            if ($total_sales_net > 0) {
                                $plant_percentage = ($plant / $total_sales_net) * 100;
                                $labour_percentage = ($labour / $total_sales_net) * 100;
                                $material_percentage = ($material / $total_sales_net) * 100;
                            }
                        @endphp
                    </div>
                    <!--end::Table-->
                </div>







            </div>

            <div class="card mb-7">




                <div class="card-header " id="kt_chat_contacts_header">
                    <!--begin::Card title-->
                    <div class="card-title justify-content-between">
                        <div class="d-flex align-items-center">
                            <h3 class="fw-bold"><i class="ki-solid ki-cheque me-2 text-dark fs-2" style="font-size:18px"></i> Invoices History</h3>

                        </div>





                    </div>

                    <!--end::Card title-->
                </div>

                
                
                
                <div class="card-body py-2 px-2">
                    <div class="" style="border-radius:10px">
                        <!--begin::Table-->




                        @csrf
                        <table class="table table-bordered" id="kt_table_users_2">
                            <thead>
                                <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                    <th>Date</th>
                                    <th>Invoice</th>
                                    <th>Name</th>
                                    <th>Status</th>
                                    <th>Final Amount</th>
                                    <th>Actions</th>

                                </tr>
                            </thead>
                            <tbody class="text-gray-600 fw-semibold">
                                @foreach($invoices as $invoice)
                                <tr>

                                    <td>{{ date('jS M Y', strtotime($invoice->created_at)) }}</td>
                                    <td>
                                        @if($invoice->credit_note==0)
                                        WGI-{{str_pad($invoice->id, 4, '0', STR_PAD_LEFT);}}
                                        @else
                                        <span class="text-danger">WGC-{{str_pad($invoice->id, 4, '0', STR_PAD_LEFT);}}</span>
                                        @endif
                                    </td>
                                    <td>{{ $customer->company_name }}</td>
                                    <td>
                                        @if($invoice->sent_to_client==0)
                                        <span class="text-danger fw-bold">{{ ucfirst($invoice->status) }}</span>
                                        @else
                                        <span class="text-primary fw-bold">{{ ucfirst($invoice->status) }}</span>
                                        @endif
                                    </td>
                                    @php
                                        $invoice_vat = $invoice->final_amount*0.20;
                                        $invoice_total = $invoice_vat+$invoice->final_amount;
                                    @endphp
                                    <td><span class="fw-bold">£{{ number_format($invoice_total, 2) }}</span></td>
                                    <td>
                                        <a target="_blank" href="{{ route('project.viewInvoice', ['id'=>$invoice->id]) }}"><i class="fas fa-eye text-dark"></i></a>
                                        @if($invoice->sent_to_client==0)
                                        <a class="ms-3 deletebtn" data-id="{{$invoice->id}}" href="#!"><i class="fas fa-trash text-danger"></i></a>
                                        @else
                                        <a class="ms-3" data-id="{{$invoice->id}}" href="#!"><i class="fas fa-trash text-gray-600"></i></a>
                                        @endif
                                        <a class="ms-3 sendbtn" data-id="{{$invoice->id}}" href="#!"><i class="fas fa-paper-plane text-primary"></i></a>
                                    </td>





                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                        
                <div class="row">
                    <div class="col-md-12">
                        <div class="d-flex invoice-sales invoices-stats flex-wrap justify-content-center mt-8 mb-3">
                            <!--begin::Stat-->
                            <div class="border border-gray-300 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                <!--begin::Number-->
                                <div class="d-flex align-items-center">

                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="4500" data-kt-countup-prefix="$" data-kt-initialized="1">£{{ number_format($normalInvoice->total_sales_price, 2) }}</div>
                                </div>
                                <!--end::Number-->
                                <!--begin::Label-->
                                <div class="fw-semibold fs-6 text-gray-500">Invoice Sales Net</div>
                                <!--end::Label-->
                            </div>
                            <!--end::Stat-->
                            <!--begin::Stat-->
                            <div class="border border-gray-300 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                <!--begin::Number-->
                                <div class="d-flex align-items-center">

                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="80" data-kt-initialized="1">£{{ number_format($normalInvoice->total_vat, 2) }}</div>
                                </div>
                                <!--end::Number-->
                                <!--begin::Label-->
                                <div class="fw-semibold fs-6 text-gray-500">Invoice VAT</div>
                                <!--end::Label-->
                            </div>
                            <!--end::Stat-->
                            <!--begin::Stat-->
                            <div class="border border-gray-300 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                <!--begin::Number-->
                                <div class="d-flex align-items-center">

                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="60" data-kt-countup-prefix="%" data-kt-initialized="1">£{{ number_format($normalInvoice->gross_total, 2) }}</div>
                                </div>
                                <!--end::Number-->
                                <!--begin::Label-->
                                <div class="fw-semibold fs-6 text-gray-500">Invoice Sales Gross</div>
                                <!--end::Label-->
                            </div>
                            <!--end::Stat-->

                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="d-flex invoice-credit invoices-stats flex-wrap justify-content-center mb-3">
                            <!--begin::Stat-->
                            <div class="border border-gray-300 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                <!--begin::Number-->
                                <div class="d-flex align-items-center">

                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="4500" data-kt-countup-prefix="$" data-kt-initialized="1">£{{ number_format($creditInvoice->total_sales_price, 2) }}</div>
                                </div>
                                <!--end::Number-->
                                <!--begin::Label-->
                                <div class="fw-semibold fs-6 text-gray-500">Credit Note Sales Net</div>
                                <!--end::Label-->
                            </div>
                            <!--end::Stat-->
                            <!--begin::Stat-->
                            <div class="border border-gray-300 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                <!--begin::Number-->
                                <div class="d-flex align-items-center">

                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="80" data-kt-initialized="1">£{{ number_format($creditInvoice->total_vat, 2) }}</div>
                                </div>
                                <!--end::Number-->
                                <!--begin::Label-->
                                <div class="fw-semibold fs-6 text-gray-500">Credit Note VAT</div>
                                <!--end::Label-->
                            </div>
                            <!--end::Stat-->
                            <!--begin::Stat-->
                            <div class="border border-gray-300 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                <!--begin::Number-->
                                <div class="d-flex align-items-center">

                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="60" data-kt-countup-prefix="%" data-kt-initialized="1">£{{ number_format($creditInvoice->gross_total, 2) }}</div>
                                </div>
                                <!--end::Number-->
                                <!--begin::Label-->
                                <div class="fw-semibold fs-6 text-gray-500">Credit Note Sales Gross</div>
                                <!--end::Label-->
                            </div>
                            <!--end::Stat-->

                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="d-flex invoice-difference invoices-stats flex-wrap justify-content-center mb-5">
                            <!--begin::Stat-->
                            <div class="border border-gray-300 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                <!--begin::Number-->
                                <div class="d-flex align-items-center">

                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="4500" data-kt-countup-prefix="$" data-kt-initialized="1">£{{ number_format($difference['sales_price_difference'], 2) }}</div>
                                </div>
                                <!--end::Number-->
                                <!--begin::Label-->
                                <div class="fw-semibold fs-6 text-gray-500">Total Sales Net</div>
                                <!--end::Label-->
                            </div>
                            <!--end::Stat-->
                            <!--begin::Stat-->
                            <div class="border border-gray-300 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                <!--begin::Number-->
                                <div class="d-flex align-items-center">

                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="80" data-kt-initialized="1">£{{ number_format($difference['vat_difference'], 2) }}</div>
                                </div>
                                <!--end::Number-->
                                <!--begin::Label-->
                                <div class="fw-semibold fs-6 text-gray-500">Total VAT</div>
                                <!--end::Label-->
                            </div>
                            <!--end::Stat-->
                            <!--begin::Stat-->
                            <div class="border border-gray-300 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                <!--begin::Number-->
                                <div class="d-flex align-items-center">

                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="60" data-kt-countup-prefix="%" data-kt-initialized="1">£{{ number_format($difference['gross_total_difference'], 2) }}</div>
                                </div>
                                <!--end::Number-->
                                <!--begin::Label-->
                                <div class="fw-semibold fs-6 text-gray-500">Total Sales Gross</div>
                                <!--end::Label-->
                            </div>
                            <!--end::Stat-->

                        </div>
                    </div>
                </div>



                    </div>
                    <!--end::Table-->
                </div>







            </div>

        </div>
    </div>
    <!--end::Content-->
</div>

<div class="modal fade" id="kt_modal_new_target" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add Financials</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    
                    <div class="d-flex flex-column mb-8 fv-row">
                       
                        <ul class="nav nav-tabs nav-line-tabs mb-5 fs-6">
                            <li class="nav-item">
                                <a class="nav-link active" style="font-size: 1.075rem !important;" data-bs-toggle="tab" href="#kt_tab_pane_1">Search</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" style="font-size: 1.075rem !important;" data-bs-toggle="tab" href="#kt_tab_pane_2">Upload Spreadsheet</a>
                            </li>
                            
                        </ul>
                    </div>

                    <div class="d-flex flex-column mb-8 fv-row">
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade show active" id="kt_tab_pane_1" role="tabpanel">
                                <form method="POST" class="form" action="{{route('project.addFinancials', ['id'=>$project->id])}}">
                                    <!--begin::Heading-->
                                    @csrf
                                    <div class="mb-8">
                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                            <span class="required">Select Items</span>
                                        </label>
                                        <!--end::Label-->
                                        <select required name="items[]" class="form-select" multiple id="add_financials" data-placeholder="Select">
                                            <option></option>
                                            @foreach($f_items as $f_item)
                                            <option value="{{$f_item->id}}">{{$f_item->code}} - {{$f_item->description}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="text-center">
                                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                </form>
                            </div>
                            <div class="tab-pane fade" id="kt_tab_pane_2" role="tabpanel">
                                <form method="POST" class="form" action="{{route('project.importFinancials', ['id'=>$project->id])}}" enctype="multipart/form-data">
                                    <!--begin::Heading-->
                                    @csrf
                                    <div class="mb-8">
                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                            <span class="required">Select Spreadsheet</span>
                                        </label>
                                        <!--end::Label-->
                                        <input type="file" class="form-control" required name="excel">
                                    </div>
                                    <div class="text-center">
                                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!--begin::Label-->
                    </div>
                    
                    <!--end::Actions-->
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


<div class="modal fade" id="upliftModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('project.upliftFinancials', ['id'=>$project->id])}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Uplift</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->


                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Enter Percentage</span>
                        </label>
                        <!--end::Label-->
                        <input type="text" id="twoDigitInput" class="form-control" required name="uplift_percentage">
                    </div>
                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


<div class="modal fade" id="poDetailsModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-lg  ">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->


                <div class="mb-13 text-center">
                    <!--begin::Title-->
                    <h1 class="mb-3">Purchase Order Details</h1>
                    <!--end::Title-->
                    <!--begin::Description-->

                    <!--end::Description-->
                </div>
                <!--end::Heading-->
                <!--begin::Input group-->

                
                    <div class="d-flex flex-column mb-8 fv-row">

                        
                        <div class=" mb-8 fv-row" id="po_image_div">
                            <div>
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="">Photo of the receipt</span>
                                </label>
                                <img id="po_image" style="width:80px;height:80px;object-fit:contain;border:1px solid #ddd;border-radius:10px" src="" alt="" >
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="">PO Number</span>
                                    </label>
                                    <div class="alert alert-primary">
                                        <p id="po_number" class="text-dark mb-0"></p>
                                    </div>
                                    <!--end::Label-->
                                    
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="">Supplier</span>
                                    </label>
                                    <!--end::Label-->
                                    <div class="alert alert-primary">
                                        <p id="po_supplier" class="text-dark mb-0"></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="">Category</span>
                                    </label>
                                    <div class="alert alert-primary">
                                        <p id="po_category" style="text-transform:capitalize" class="text-dark mb-0"></p>
                                    </div>
                                    <!--end::Label-->
                                    
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="">UoM</span>
                                    </label>
                                    <div class="alert alert-primary">
                                        <p id="po_uom" class="text-dark mb-0"></p>
                                    </div>
                                    <!--end::Label-->
                                    
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="">Quantity</span>
                                    </label>
                                    <!--end::Label-->
                                    <div class="alert alert-primary">
                                        <p id="po_quantity" class="text-dark mb-0"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="">Amount</span>
                                    </label>
                                    <!--end::Label-->
                                    <div class="alert alert-primary">
                                        <p id="po_amount" class="text-dark mb-0"></p>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="d-flex flex-column mb-8 fv-row">
                            <!--begin::Label-->
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="">Description</span>
                            </label>
                            <!--end::Label-->
                            <div class="alert alert-primary">
                                <p id="po_description" class="text-dark mb-0"></p>
                            </div>
                        </div>

                    </div>
                   
                    
               
                <!--end::Actions-->

                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>



<div class="modal fade" id="purchaseOrderModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-lg  ">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->


                <div class="mb-13 text-center">
                    <!--begin::Title-->
                    <h1 class="mb-3">Add Purchase Order</h1>
                    <!--end::Title-->
                    <!--begin::Description-->

                    <!--end::Description-->
                </div>
                <!--end::Heading-->
                <!--begin::Input group-->

                <form action="{{route('project.createPurchaseOrder', ['id'=>$project->id])}}" method="post" enctype="multipart/form-data">
                    <div class="d-flex flex-column mb-8 fv-row">

                        
                        <div class="d-flex flex-column mb-8 fv-row">
                            <div>
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="">Add a photo of the receipt</span>
                                </label>
                                <img style="width:80px;height:80px;object-fit:contain;border:1px solid #ddd;border-radius:10px" id="receipt_photo" src="{{ asset('img/add-image.png') }}" alt="" onclick="$('#receipt_photo_input').trigger('click')">
                                <input name="receipt_photo" type="file" style="display:none" id="receipt_photo_input" accept="image/*">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Select Supplier</span>
                                    </label>
                                    <!--end::Label-->
                                    <select class="form-control" name="supplier_id" id="" required>
                                        <option value="">Select</option>
                                        @foreach($suppliers as $supplier)
                                        <option value="{{$supplier->id}}">{{$supplier->company_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Select Category</span>
                                    </label>
                                    <!--end::Label-->
                                    <select class="form-control" name="category" id="" required>
                                        <option value="">Select</option>
                                        <option value="plant">Plant</option>
                                        <option value="labour">Labour</option>
                                        <option value="material">Material</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">UoM</span>
                                    </label>
                                    <!--end::Label-->
                                    <select class="form-control" required name="uom" id="">
                                        <option value="">Select</option>
                                        @foreach($uoms as $uom)
                                        <option value="{{$uom->name}}">{{$uom->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Quantity</span>
                                    </label>
                                    <!--end::Label-->
                                    <input type="number" class="form-control" name="quantity" step="any" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Enter Amount</span>
                                    </label>
                                    <!--end::Label-->
                                    <input type="number" class="form-control" name="amount" step="any" required>
                                </div>
                            </div>
                        </div>


                        <div class="d-flex flex-column mb-8 fv-row">
                            <!--begin::Label-->
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Enter Description</span>
                            </label>
                            <!--end::Label-->
                            <textarea required name="description" class="form-control" id="" cols="30" rows="5"></textarea>
                        </div>

                    </div>
                    @csrf
                    <div class="text-center">

                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Generate Purchase Order
                        </button>
                    </div>
                </form>
                <!--end::Actions-->

                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


<div class="modal fade" id="invoiceModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-lg  ">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->


                <div class="mb-13 text-center">
                    <!--begin::Title-->
                    <h1 class="mb-3" id="create_invoice_title">Create Invoice</h1>
                    <!--end::Title-->
                    <!--begin::Description-->

                    <!--end::Description-->
                </div>
                <!--end::Heading-->
                <!--begin::Input group-->

                <form action="{{route('project.createInvoice', ['id'=>$project->id])}}" method="post">
                    <div class="d-flex flex-column mb-8 fv-row">
                        <div class="d-flex">
                            <label class="form-check form-switch form-check-custom form-check-solid mb-3">
                                <!--begin::Input-->
                                <input class="form-check-input w-30px h-20px" type="checkbox" value="1" id="show_items" name="show_items" checked>
                                <!--end::Input-->
                                <!--end::Label-->
                                <span class="form-check-label text-muted fs-6">Show Items</span>
                                <!--end::Label-->
                            </label>
                            
                        </div>
                        <table class="table table-bordered" id="invoice_table">
                            <thead>
                                <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                    <th>Description</th>
                                    <th>Quantity</th>
                                    <th>Sales Net</th>
                                    <th>VAT %</th>
                                    <th>VAT</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-600 fw-semibold">
                                <!-- Data will be appended here by AJAX -->
                            </tbody>
                        </table>
                        <div class="row">
                            <div class="col-md-6">
                                <textarea name="notes" placeholder="Enter Notes" class="form-control" id="invoice_notes" cols="30" rows="3" style="display:none"></textarea>
                            </div>
                            <div class="col-md-6">
                                <div class="fw-bold" style="text-align:right">
                                    <p>Total Net Amount: <span id="totalSalesPrice"></span></p>
                                    <p>Total VAT Amount: <span id="totalVAT"></span></p>
                                    <p>Total Gross Amount: <span id="totalGross"></span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    @csrf
                    <div class="text-center">
                        <input type="hidden" name="item_ids" id="item_ids">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="create_invoice_btn_2" class="btn btn-primary">
                            Create Invoice
                        </button>
                    </div>
                </form>
                <!--end::Actions-->

                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


<form action="{{route('project.createInvoice', ['id'=>$project->id])}}" method="post" style="display:none" id="invoice_form">
    @csrf
</form>

<form action="{{route('project.deleteInvoice')}}" method="post" style="display:none" id="deleteForm">
    @csrf
    <input type="hidden" id="delete_invoice_id" name="invoice_id">
</form>

<form action="{{route('project.sendInvoice')}}" method="post" style="display:none" id="sendForm">
    @csrf
    <input type="hidden" id="send_invoice_id" name="invoice_id">
</form>

<form action="{{ route('project.deleteFinancialItem') }}" method="post" id="deleteItemForm">
    @csrf
    <input type="hidden" name="delete_id" id="delete_id">
</form>

@endsection


@section('js')
<script>
    
    $(".deleteItemBtn").click(function(){
        var id = $(this).data('id');
        $("#delete_id").val(id);
        if(confirm('Are you sure want to delete?')){
            $("#deleteItemForm").submit();
        }
    });
    
    $("#total_plant").html('£{{ number_format($plant, 2) }}');
    $("#total_labour").html('£{{ number_format($labour, 2) }}');
    $("#total_material").html('£{{ number_format($material, 2) }}');
    $("#total_sales").html('£{{ number_format($total_sales_net, 2) }}');
    $("#total_vat").html('£{{ number_format($total_vat, 2) }}');
    $("#total_gross").html('£{{ number_format($sales_price, 2) }}');
    $("#total_plant_percent").html('{{ number_format($plant_percentage, 2) }}%');
    
    $("#total_labour_percent").html('{{ number_format($labour_percentage, 2) }}%');
    $("#total_material_percent").html('{{ number_format($material_percentage, 2) }}%');
    
    
    <?php  
        foreach($items as $item){
            if($item->sub_contract_accepted==1){
                $plant -= $item->plant*$item->quantity;
                $labour -= $item->labour*$item->quantity;
                $material -= $item->material*$item->quantity;
            }
        }
    ?>
    
    
    $("#total_plant_estimated").html('£{{ number_format($plant*0.60, 2) }}');
    $("#total_labour_estimated").html('£{{ number_format($labour*0.60, 2) }}');
    $("#total_material_estimated").html('£{{ number_format($material*0.60, 2) }}');
    
    var po_plant_difference = parseFloat('{{ ($plant*0.60)-$po_plant_total }}');
    var po_labour_difference = parseFloat('{{ ($labour*0.60)-$po_labour_total }}');
    var po_material_difference = parseFloat('{{ ($material*0.60)-$po_material_total }}');
    
    if(parseFloat('{{ $po_plant_total }}') > parseFloat('{{ $plant*0.60 }}')){
        $("#plant_estimated_box").addClass('red').removeClass('green');
    }
    
    if(parseFloat('{{ $po_labour_total }}') > parseFloat('{{ $labour*0.60 }}')){
        $("#labour_estimated_box").addClass('red').removeClass('green');
    }
    
    if(parseFloat('{{ $po_material_total }}') > parseFloat('{{ $plant*0.60 }}')){
        $("#plant_estimated_box").addClass('red').removeClass('green');
    }
    
    
    
    @if(session('added_ids'))
    @php
    $added_ids = session('added_ids');
    @endphp
    @foreach($added_ids as $id)
    $("#item_row_{{$id}} .table-data").hide();
    $("#item_row_{{$id}} .table-field").show();
    @endforeach
    $(".td-uom").attr('width', '10%');
    $("#savebtn").show();
    @endif


    $(".deletebtn").click(function() {
        var id = $(this).data('id');
        if (confirm('Are you sure want to delete this invoice?')) {
            $("#delete_invoice_id").val(id);
            $("#deleteForm").submit();
        }
    });
    
    
    var totalLabourCost = parseFloat('{{ number_format($labour, 2) }}');
    var totalLabourHours = (totalLabourCost / 40);
    var dayHours = totalLabourHours / 8;
    var totalDayTeams = dayHours / 2;
    
    $("#labour_days").html(totalDayTeams.toFixed(2));

    $('#twoDigitInput').on('input', function() {
        var value = $(this).val();

        // Remove any non-digit characters
        value = value.replace(/[^0-9]/g, '');

        // Ensure the value is between 1 and 99
        if (value > 99) {
            value = 99;
        } else if (value < 1 && value !== "") {
            value = 1;
        }

        $(this).val(value);
    });

    $(".sendbtn").click(function() {
        var id = $(this).data('id');
        if (confirm('Are you sure want to send this invoice to the client?')) {
            $("#send_invoice_id").val(id);
            $("#sendForm").submit();
        }
    });
    
    
    $(".showPoDetails").click(function(){
        var id = $(this).data('id');
        $.ajax({
            url: '{{route("projects.showPoDetails", ["id"=>$project->id])}}', // Replace with your server endpoint
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
            },
            dataType: 'JSON',
            data: { po_id: id },
            success: function(response) {
                //var data = JSON.parse(response);
                $("#po_number").html(response.po.number);
                $("#po_supplier").html(response.po.supplier);
                if(response.po.receipt_photo!=''){
                    $("#po_image").attr('src', response.po.receipt_photo);
                    $("#po_image_div").show();
                }else{
                    $("#po_image").attr('src', "");
                    $("#po_image_div").hide();
                }
                $("#po_image").attr('src', response.po.receipt_photo);
                $("#po_image").attr('onclick', 'window.location="'+response.po.receipt_photo+'"');
                $("#po_amount").html('£'+response.po.amount);
                $("#po_category").html(response.po.category);
                $("#po_uom").html(response.po.uom);
                $("#po_quantity").html(response.po.quantity);
                $("#po_description").html(response.po.description);
                $("#poDetailsModal").modal("show");
            }
        });
    });


    $('#receipt_photo_input').on('change', function(event) {
        const file = event.target.files[0];
        const imageDisplay = $('#receipt_photo');
        //imageDisplay.empty();

        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                $('#receipt_photo').attr('src', e.target.result);
                //imageDisplay.append(img);
            };
            reader.readAsDataURL(file);
        } else {
            $('#receipt_photo').attr('src', '{{asset("img/add-image.png")}}');
        }
    });
    
    $("#show_breakdown").change(function() {
        if ($(this).is(":checked")) {
            $(".breakdown-item").show();
        } else {
            $(".breakdown-item").hide();
        }
    });


    $("#show_items").change(function() {
        if ($(this).is(":checked")) {
            $("#invoice_table").show();
            $("#invoice_notes").hide();
            $("#invoice_notes").prop('required', false);
        } else {
            $("#invoice_table").hide();
            $("#invoice_notes").show();
            $("#invoice_notes").prop('required', true);
        }
    });

    $(document).ready(function() {
        $(".table-checkbox").hide();

        /*function calculate() {
            $('tbody tr').each(function() {
                var quantity = parseFloat($(this).find('.quantity').val()) || 0;
                var salesPrice = parseFloat($(this).find('.sales_price').val()) || 0;
                var total = quantity * salesPrice;
                var vat = total * 0.20;
                var totalVat = total + vat;

                $(this).find('.total').text('£' + total.toFixed(2));
                $(this).find('.vat').text('£' + vat.toFixed(2));
                $(this).find('.total_vat').text('£' + totalVat.toFixed(2));
            });
        }

        $('.quantity, .sales_price').on('input', function() {
            calculate();
        });*/

        /*$('.quantity').on('input', function() {
            var $row = $(this).closest('tr');
            var quantity = $(this).val();
            var plant = parseFloat($row.find('.plant').data('price')) || 0;
            var labour = parseFloat($row.find('.labour').data('price')) || 0;
            var material = parseFloat($row.find('.material').data('price')) || 0;
            var plantTotal = quantity * plant;
            var labourTotal = quantity * labour;
            var materialTotal = quantity * material;
            $row.find('.plant').val(plantTotal.toFixed(2));
            $row.find('.labour').val(labourTotal.toFixed(2));
            $row.find('.material').val(materialTotal.toFixed(2));
            var total = plantTotal+labourTotal+materialTotal;
            var vat = total * 0.20;
            var totalVat = total + vat;

            $row.find('.total').text('£' + total.toFixed(2));
            $row.find('.vat').text('£' + vat.toFixed(2));
            $row.find('.total_vat').text('£' + totalVat.toFixed(2));
        });*/

        // Initial calculation
        //calculate();
    });


    $(".delete_column").hide();

    $(document).ready(function() {
        function updateTotalPrice() {
            let totalPrice = 0;
            $('.po-checkbox:checked').each(function() {
                totalPrice += parseFloat($(this).data('price'));
            });
            $('#est_price').text('£' + totalPrice.toFixed(2));
        }

        $('.po-checkbox').change(updateTotalPrice);
    });


    function getCheckedValues() {
        let checkedValues = [];
        $('.invoice-checkbox:checked').each(function() {
            checkedValues.push($(this).val());
        });
        return checkedValues.join(',');
    }


    $("#create_invoice_btn").click(function() {
        var ids = getCheckedValues();
        if (!ids) {
            alert('Please select atleast one item!');
            return false;
        } else {
            $("#item_ids").val(ids);
            $.ajax({
                url: "{{route('project.getItemsDetails')}}",
                type: 'POST',
                data: {
                    financial_ids: ids,
                },
                headers: {
                    'X-CSRF-TOKEN': '{{csrf_token()}}'
                },
                success: function(response) {
                    var tbody = '';
                    var totalSalesPrice = 0;
                    var totalVAT = 0;
                    var grossTotal = 0;

                    $.each(response, function(index, item) {
                        var vat = (item.sales_price * item.quantity) * 0.20;
                        var totalPrice = item.sales_price + vat;
                        var netPrice = item.sales_price * item.quantity;

                        var plant = (item.plant * item.quantity).toFixed(2)
                        var labour = (item.labour * item.quantity).toFixed(2)
                        var material = (item.material * item.quantity).toFixed(2)

                        totalSalesPrice += item.sales_price * item.quantity;
                        totalVAT += vat;
                        //grossTotal += totalPrice;

                        tbody += '<tr>';
                        tbody += '<td>' + item.description.substring(0, 25) + '...</td>';
                        tbody += '<td>' + item.quantity + '</td>';
                        //tbody += '<td class="breakdown-item">' + plant + '</td>';
                        //tbody += '<td class="breakdown-item">' + labour + '</td>';
                        //tbody += '<td class="breakdown-item">' + material + '</td>';

                        tbody += '<td>£' + netPrice.toFixed(2) + '</td>';
                        tbody += '<td>20%</td>';
                        tbody += '<td>£' + vat.toFixed(2) + '</td>';
                        tbody += '</tr>';
                    });

                    grossTotal = totalSalesPrice + totalVAT;
                    $('#dataTable tbody').html(tbody);
                    $('#totalSalesPrice').text('£' + totalSalesPrice.toFixed(2));
                    $('#totalVAT').text('£' + totalVAT.toFixed(2));
                    $('#totalGross').text('£' + grossTotal.toFixed(2));
                    $("#invoice_table tbody").html(tbody);
                    $("#invoiceModal").modal("show");
                },
                error: function(xhr, status, error) {
                    alert('Error sending notification');
                    console.log(xhr.responseText);
                }
            });
            //$("#item_ids").val(ids);
            //$("#invoice_form").submit();
        }
    });


    /*$("#create_invoice_btn").click(function() {
        var ids = getCheckedValues();
        if (!ids) {
            alert('Please select atleast one item!');
            return false;
        } else {
            $("#item_ids").val(ids);
            $("#invoice_form").submit();
        }
    })*/

    $("#credit_btn").click(function() {
        $("#cancel_btn").show();
        $("#add_financials_btn").hide();
        $("#invoice_btn").hide();
        $("#edit_btn").hide();
        $("#uplift_btn").hide();
        $(".table-checkbox").show();
        $("#create_invoice").show();
        $(".tr-invoiced").hide();
        $(".tr-invoice").hide();
        $("#add_po_btn").hide();
        $('#create_invoice_btn').html('Create Credit Note');
        $('#create_invoice_btn_2').html('Create Credit Note');
        $('#create_invoice_title').html('Create Credit Note');
    });

    $("#invoice_btn").click(function() {
        $("#add_po_btn").hide();
        $("#cancel_btn").show();
        $("#add_financials_btn").hide();
        $("#credit_btn").hide();
        $("#edit_btn").hide();
        $("#uplift_btn").hide();
        $(".table-checkbox").show();
        $("#create_invoice").show();
        $(".tr-credit").hide();
        $(".tr-invoice").show();
        $(".tr-invoiced").hide();
        $('#create_invoice_btn').html('Create Invoice');
        $('#create_invoice_btn_2').html('Create Invoice');
        $('#create_invoice_title').html('Create Invoice');
    });

    $("#uplift_btn").click(function() {
        $("#upliftModal").modal('show');
    });

    $("#edit_btn").click(function() {
        $(".delete_column").show();
        $("#edit_message").show();
        $(".table-data").hide();
        $(".table-field").show();
        $(".non-editable").hide();
        $("#create_invoice").hide();
        $("#uplift_btn").hide();
        $("#add_financials_btn").hide();
        $("#invoice_btn").hide();
        $("#savebtn").show();
        $("#cancel_btn").show();

        $("#edit_btn").hide();
        $("#kt_table_users").css('table-layout', 'fixed');
    });

    $("#cancel_btn").click(function() {
        $(".delete_column").hide();
        $("#add_po_btn").show();
        $(".table-checkbox").hide();
        $("#create_invoice").hide();
        $("#edit_message").hide();
        $(".table-data").show();
        $(".table-field").hide();
        $(".non-editable").show();
        $(".tr-invoiced").show();
        $(".tr-credit").show();
        $("#add_financials_btn").show();
        $("#invoice_btn").show();
        $("#credit_btn").show();
        $("#uplift_btn").show();
        $("#savebtn").hide();
        $("#cancel_btn").hide();
        $("#edit_btn").show();
        $("#kt_table_users").css('table-layout', 'unset');
    });


    $("#gross_profit").html('£{{ number_format($sales_price-$estimated_price, 2) }}');

    var gross_profit = parseFloat("{{$sales_price-$estimated_price}}");
    if (gross_profit >= 0) {
        $("#profit_span").addClass('text-primary');
    } else {
        $("#profit_span").addClass('text-danger');
    }

    $('#add_financials, #add_uom').select2({
        dropdownParent: $('#kt_modal_new_target')
    });




    $(".assign-manager").click(function() {
        $("#manager_type_heading").html($(this).data('type'));
        $("#manager_type").val($(this).data('type'));
    })

    /*
var table = $("#kt_table_users").DataTable({
    "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
    "paging": false,//Dont want paging                
    "bPaginate": false,//Dont want paging
});

$('#mySearch').on('input', function() {
  table.search($(this).val()).draw();
})*/

</script>
@endsection
