@extends('layouts.app')
@section('title', 'Purchase Order Details')
@php $existing = array(); @endphp
@section('content')

<style>
    .send-link-btn {
        color: #5790FF !important;
        border: 1px solid #0048D533 !important;
        background: #eef4ff !important;
        font-size: 15px;
    }

    .send-link-btn i {
        color: #5790FF !important;
        font-size: 20px;
        font-weight: bold;
    }

    .form-check-label {
        font-size: 15px;
        color: black;
    }

    .form-check-cover {
        margin-bottom: 10px;
        padding: 8px;
        border-radius: 8px;
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.94), rgba(255, 255, 255, 0.94)), #5E5E5E;
    }

    .form-check-cover.active {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.8), rgba(255, 255, 255, 0.8)), #93D500;
    }

    .form-check-input:checked {
        border-color: #93d500;
    }

    .user-data.form-control {
        background: white;
        border-color: #ddd;
    }

    .badge {
        font-size: 16px;
        font-weight: 400;
        padding: 8px;
        color: black;
    }

    .card-footer {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.9), rgba(255, 255, 255, 0.9)), #93D500 !important;
    }

    .box {
        background: #f2f2f2;
        border-radius: 8px;
        position: relative;
    }

    .box p {
        color: #5E5E5E;
    }

    .table td {
        background: #93D5001A;
        border: 3px solid white !important;
        padding: 8px !important;
        color: black !important;
        color: #727879;
    }



    .table th {
        border: 3px solid white !important;
        background: #E3E3E3;
        color: #5E5E5E !important;
        font-weight: 500;
        font-size: 12px;
        margin: 10px !important;
        text-align: center;
        vertical-align: middle;
    }

    .fa-trash {
        cursor: pointer;
    }

    .send-link-btn {
        color: #5790FF !important;
        border: 1px solid #0048D533 !important;
        background: #eef4ff !important;
        font-size: 15px;
    }

    .send-link-btn i {
        color: #5790FF !important;
        font-size: 20px;
        font-weight: bold;
    }

    .tfoot th {
        color: black !important;
        font-size: 13px;
    }

    .edit-btn {
        position: absolute;
        right: 10px;
        cursor: pointer;
    }
    
     .delete-btn {
        position: absolute;
        right: 10px;
        bottom:10px;
        cursor: pointer;
    }
    
</style>


<?php
    $po_total_plant = 0;
    $po_total_material = 0;
    $po_total_labour = 0;
    
    foreach($otherPos as $po){
        if($po->sub_contract==0){
            $po_total_plant += $po->total_plant;
            $po_total_material += $po->total_materials;
            $po_total_labour += $po->total_labour;
        }
    }
    
?>


<div class="d-flex flex-column flex-column-fluid">

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif

            @if(session('danger'))
            <div class="alert alert-danger">
                {{ session('danger') }}
            </div>
            @endif

            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="box p-3 mb-5">
                                @if($purchase_order->locked==0)
                                <span class="edit-btn"><i style="font-size:18px;" class="fa fa-edit"></i></span>
                                <span class="delete-btn"><i style="font-size:18px;" class="fa fa-trash text-danger"></i></span>
                                @endif
                                <div class="row">
                                    <div class="col-md-3">
                                        <p class="mb-0">PO Number:</p>
                                        <h4>PO-{{str_pad($purchase_order->id, 4, '0', STR_PAD_LEFT) }}</h4>
                                    </div>
                                    <div class="col-md-3">
                                        <p class="mb-0">Project ID:</p>
                                        <h4>WG-{{str_pad($project->id, 4, '0', STR_PAD_LEFT)}}</h4>
                                    </div>
                                    <div class="col-md-3">
                                        <p class="mb-0">Supplier Name:</p>
                                        <h4>{{ $supplier->company_name }}</h4>
                                    </div>
                                    <div class="col-md-3">
                                        <p class="mb-0">Delivery Date:</p>
                                        <h4>{{ date('d M, Y', strtotime($purchase_order->delivery_date)) }}</h4>
                                    </div>
                                    
                                    @if(!empty($purchase_order->receipt_photo))
                                    <div class="col-md-2 mt-3">
                                        <p class="mb-0">Receipt Photo:</p>
                                        <h4><a target="_blank" class="text-primary" href="{{asset('img/purchase_orders/'.$purchase_order->receipt_photo)}}">View</a></h4>
                                    </div>
                                    @endif
                                    <div class="col-md-10 mt-3">
                                        <p class="mb-0">Delivery Address:</p>
                                        <h4> @if(!empty($purchase_order->address)) {{ $purchase_order->address }}, {{ $purchase_order->city }} {{ $purchase_order->postcode }} @endif</h4>
                                    </div>
                                </div>
                            </div>

                            <?php
                                $f_plant = 0;
                                $f_labour = 0;
                                $f_material = 0;

                                if($project->tender==0){
                                    foreach($financial_items as $fi){
                                        $f_plant += $fi->plant*$fi->quantity;
                                        $f_labour += $fi->labour*$fi->quantity;
                                        $f_material += $fi->material*$fi->quantity;
                                    }
                                }else{
                                    foreach($tenderItems as $ti){
                                        $f_plant += $ti->plant;
                                        $f_labour += $ti->labour;
                                        $f_material += $ti->material;
                                        //$subcontract += $ti->sub_contract;
                                        //$other += $ti->other;
                                   }
                                }
                                

                            ?>

                            
                            <div class="col-md-12">
                                
                                <div class="pe-3 estimated_stats  mb-3">
                                    <!--begin::Stat-->
                                    @if($purchase_order->sub_contract==0)
                                    <div class="row">
                                        <div class="col-md-12">
                                            <h4 class="pe-3 mb-0 py-3">Estimated Cost</h4>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="border border-gray-300 border-dashed green rounded min-w-125px py-3 px-4 me-3 mb-3" id="plant_estimated_box">
                                                <!--begin::Number-->
                                                <div class="d-flex align-items-center">

                                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="4500" data-kt-countup-prefix="$" data-kt-initialized="1" id="total_plant_estimated">£0</div>
                                                </div>
                                                <!--end::Number-->
                                                <!--begin::Label-->
                                                <div class="fw-semibold fs-6 text-gray-500">Plant (Rem: <span id="rem_plant"></span>)</div>
                                                <!--end::Label-->
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="border border-gray-300 border-dashed green rounded min-w-125px py-3 px-4 me-3 mb-3" id="labour_estimated_box">
                                                <!--begin::Number-->
                                                <div class="d-flex align-items-center">

                                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="80" data-kt-initialized="1" id="total_labour_estimated">£0</div>
                                                </div>
                                                <!--end::Number-->
                                                <!--begin::Label-->
                                                <div class="fw-semibold fs-6 text-gray-500">Labour (Rem: <span id="rem_labour"></span>)</div>
                                                <!--end::Label-->
                                            </div>

                                        </div>
                                        <div class="col-md-4">
                                            <div class="border border-gray-300 border-dashed green rounded min-w-125px py-3 px-4 me-3 mb-3" id="material_estimated_box">
                                                <!--begin::Number-->
                                                <div class="d-flex align-items-center">

                                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="60" data-kt-countup-prefix="%" data-kt-initialized="1" id="total_material_estimated">£0</div>
                                                </div>
                                                <!--end::Number-->
                                                <!--begin::Label-->
                                                <div class="fw-semibold fs-6 text-gray-500">Material (Rem: <span id="rem_material"></span>)</div>
                                                <!--end::Label-->
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                    
                                    @if($purchase_order->sub_contract==1)
                                    <div class="row">
                                        <div class="col-md-12">
                                            <h4 class="pe-3 mb-0 py-3">Sub Contract</h4>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="border border-gray-300 border-dashed  rounded min-w-125px py-3 px-4 me-3 mb-3" id="">
                                                <!--begin::Number-->
                                                <div class="d-flex align-items-center">

                                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="80" data-kt-initialized="1" id="">£{{ number_format($sc->amount, 2) }}</div>
                                                </div>
                                                <!--end::Number-->
                                                <!--begin::Label-->
                                                <div class="fw-semibold fs-6 text-gray-500">{{ $sc->title }} (Rem: £<span id="rem_total"></span>)</div>
                                                <!--end::Label-->
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                </div>
                            </div>

                            @php
                            $plant = 0;
                            $labour = 0;
                            $material = 0;
                            
                            $sc_total = 0;
                            
                            @endphp


                            @if($po_items->count()==0)
                            <div class="text-center mb-3">
                                <img style="width:40%" src="{{asset('img/notes.png')}}" alt="">
                            </div>
                            <div class="text-center">
                               @if($purchase_order->locked==0)
                                <button style="color:black !important" data-bs-toggle="modal" data-bs-target="#purchaseOrderModal" class="btn btn-primary  ">
                                    <i class="ki-duotone ki-plus-circle fs-1"><span class="path1"></span><span class="path2"></span></i>
                                    Add Items
                                </button>
                                @endif
                            </div>
                            @else
                            <table class="table table-bordered mb-8">
                                <thead>
                                    <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">

                                        <th class="text-start">Description</th>
                                         @if($purchase_order->sub_contract==0)
                                        <th>Plant</th>
                                        <th>Labour</th>
                                        <th>Material</th>
                                        @else
                                        <th>Amount</th>
                                        @endif
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody class="text-gray-600 fw-semibold">



                                    @foreach($po_items as $item)
                                    @php
                                    $plant += $item->plant;
                                    $labour += $item->labour;
                                    $material += $item->material;
                                    $sc_total += $item->sc_total;
                                    @endphp

                                    <tr>
                                        <td class="">{{ $item->description }}</td>
                                        @if($purchase_order->sub_contract==0)
                                        <td class="text-center">£{{ number_format($item->plant, 2) }}</td>
                                        <td class="text-center">£{{ number_format($item->labour, 2) }}</td>
                                        <td class="text-center">£{{ number_format($item->material, 2) }}</td>
                                        @else
                                        <td class="text-center">£{{ number_format($item->sc_total, 2) }}</td>
                                        @endif

                                        <td style="background:#fbe1e1">
                                            <p class="mb-0 text-center"><i data-id="{{ $item->id }}" class="fa fa-trash deleteBtn text-danger"></i></p>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr class="tfoot">
                                        <th>TOTAL</th>
                                        @if($purchase_order->sub_contract==0)
                                        <th>£{{ number_format($plant, 2) }}</th>
                                        <th>£{{ number_format($labour, 2) }}</th>
                                        <th>£{{ number_format($material, 2) }}</th>
                                        @else
                                        <th>£{{ number_format($sc_total, 2) }}</th>
                                        @endif
                                        <th></th>
                                    </tr>
                                </tfoot>
                            </table>



                            <div class="row align-items-center">
                                <div class="col-md-6">
                                   @if($purchase_order->locked==0)
                                    <button style="color:black !important" data-bs-toggle="modal" data-bs-target="#purchaseOrderModal" class="btn btn-primary  ">
                                        <i class="ki-duotone ki-plus-circle fs-1"><span class="path1"></span><span class="path2"></span></i>
                                        Add Items
                                    </button>
                                    @else
                                    <h4 class="text-primary"><i>First printed on {{ date('d M, Y', strtotime($purchase_order->lock_date)) }}</i></h4>
                                    @endif
                                </div>
                                <div class="col-md-6">
                                    <div class="float-end">
                                       <form action="{{ route('accounts.printPO', ['id'=>$purchase_order->id]) }}" method="post" id="printForm" target="_blank">
                                           @csrf
                                           <button class="btn btn-icon-success btn-sm me-2 send-link-btn btn-text-success">
                                            <i class="ki-duotone ki-printer fs-1"><span class="path1"></span><span class="path2"></span></i>
                                            Print
                                        </button>
                                        <button id="sendPO" type="button" class="btn btn-icon-success btn-sm me-2 send-link-btn btn-text-success">
                                            <i class="ki-duotone ki-send fs-1"><span class="path1"></span><span class="path2"></span></i>
                                            Send
                                        </button>
                                       </form>
                                        
                                    </div>
                                </div>
                            </div>


                            @endif
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>


<div class="modal fade" id="sendVarationModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog   modal-lg">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->


                <div class="mb-13 text-center">
                    <!--begin::Title-->
                    <h1 class="mb-3">Send Variation</h1>
                    <p id="supplier_name"></p>
                    <!--end::Title-->
                    <!--begin::Description-->

                    <!--end::Description-->
                </div>
                <!--end::Heading-->
                <!--begin::Input group-->

                <form action="{{ route('accounts.sendPO') }}" method="post" enctype="multipart/form-data">
                    <div class="d-flex flex-column mb-8 fv-row">



                        <div class="row">
                            
                            <div class="col-md-12">
                                <div class="mb-8">
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Select Contact</span>
                                    </label>
                                    <!--end::Label-->
                                    <select required name="contact_id" class="form-select" id="contact_select" >
                                        <option value="">Select</option>
                                        @foreach($contacts as $contact)
                                        <option value="{{$contact->id}}">{{ucwords($contact->name)}}</option>
                                        @endforeach
                                        <option value="other">Other</option>
                                    </select>
                                </div>
                                <div class="mb-8" style="display:none" id="other_email_div">
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Enter Email</span>
                                    </label>
                                    <!--end::Label-->
                                    <input type="email" name="other_email" class="form-control" id="other_email">
                                </div>
                            </div>

                            <input type="hidden" name="po_id" value="{{ $purchase_order->id }}">
                        </div>
                    </div>
                    @csrf
                    <div class="text-center">

                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Send
                        </button>
                    </div>
                </form>
                <!--end::Actions-->

                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>



<div class="modal fade" id="purchaseOrderModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-lg  ">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header p-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body  ">
                <!--begin:Form-->


                <div class="mb-8 text-center">
                    <!--begin::Title-->
                    <h1>Add Items</h1>
                    <!--end::Title-->
                    <!--begin::Description-->

                    <!--end::Description-->
                </div>
                <!--end::Heading-->
                <!--begin::Input group-->

                <form action="{{route('accounts.addItemsPO', ['id'=>$purchase_order->id])}}" method="post" enctype="multipart/form-data">
                    <div class="mb-8 row">
                        @if($purchase_order->sub_contract==0)
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">Plant</span>
                                </label>
                                <!--end::Label-->
                                <input type="number" id="plant_input" class="form-control mb-3" name="plant" step="any" required>
                                <span class="text-danger" id="plant_error"></span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">Labour</span>
                                </label>
                                <!--end::Label-->
                                <input type="number" class="form-control mb-3" name="labour" step="any" required id="labour_input">
                                <span id="labour_error" class="text-danger"></span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">Material</span>
                                </label>
                                <!--end::Label-->
                                <input type="number" class="form-control mb-3" name="material" id="material_input" step="any" required>
                                <span class="text-danger" id="material_error"></span>
                            </div>
                        </div>
                        @else
                        <div class="col-md-12">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">Amount</span>
                                </label>
                                <!--end::Label-->
                                <input type="number" class="form-control mb-3" name="sc_total" id="total_amount" step="any" required>
                                <span class="text-danger" id="amount_error"></span>
                            </div>
                        </div>
                        @endif
                        <div class="col-md-12">
                            <div class="d-flex flex-column fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">Description</span>
                                </label>
                                <!--end::Label-->
                                <textarea name="description" class="form-control" id="" cols="30" rows="5"></textarea>
                            </div>
                        </div>
                    </div>
                    @csrf
                    <div class="text-center mb-5">

                        <input type="hidden" name="project_id" value="{{$project->id}}">
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Add to Purchase Order
                        </button>
                    </div>
                </form>
                <!--end::Actions-->

                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-lg  ">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header p-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body  ">
                <!--begin:Form-->


                <div class="mb-8 text-center">
                    <!--begin::Title-->
                    <h1>Edit Purchase Order</h1>
                    <!--end::Title-->
                    <!--begin::Description-->

                    <!--end::Description-->
                </div>
                <!--end::Heading-->
                <!--begin::Input group-->

                <form action="{{ route('accounts.updatePurchaseOrder', ['id'=>$purchase_order->id]) }}" method="post" enctype="multipart/form-data">
                    <div class="d-flex flex-column mb-8 fv-row">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Select Supplier</span>
                                    </label>
                                    <!--end::Label-->
                                    <select class="form-control" name="supplier_id" id="" required>
                                        <option value="">Select</option>
                                        @foreach($suppliers as $supplier)
                                        <option @if($purchase_order->supplier_id==$supplier->id) selected @endif value="{{$supplier->id}}">{{$supplier->company_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Delivery Date</span>
                                    </label>
                                    <!--end::Label-->
                                    <input required type="date" class="form-control" name="delivery_date" value="{{ $purchase_order->delivery_date }}">

                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Delivery Address</span>
                                    </label>
                                    <!--end::Label-->
                                    <input type="text" class="form-control" name="address" required value="{{ $purchase_order->address }}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">City</span>
                                    </label>
                                    <!--end::Label-->
                                    <input type="text" class="form-control" name="city" required value="{{ $purchase_order->city }}">
                                </div>
                            </div>
                            
                            
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Postcode</span>
                                    </label>
                                    <!--end::Label-->
                                    <input type="text" class="form-control" name="postal_code" required value="{{ $purchase_order->postcode }}">
                                </div>
                            </div>
                        </div>



                    </div>
                    @csrf
                    <div class="text-center mb-5">


                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Update
                        </button>
                    </div>
                </form>
                <!--end::Actions-->

                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

<form action="{{ route('accounts.deletePoItem', ['po_id'=>$purchase_order->id]) }}" method="post" id="deleteForm">
    @csrf
    <input type="hidden" name="delete_id" id="delete_id">
</form>

<form action="{{ route('accounts.deletePO') }}" method="post" id="deletePoForm">
    @csrf
    <input type="hidden" name="delete_id" value="{{$purchase_order->id}}">
</form>

@endsection


@section('js')
<script>
    
    $("#contact_select").change(function(){
        if($(this).val()=='other'){
            $("#other_email_div").show();
            $("#other_email").prop('required', true);
        }else{
            $("#other_email_div").hide();
            $("#other_email").prop('required', false);
        }
    });
    
    $("#sendPO").click(function(){
        $("#sendVarationModal").modal('show');
    })
    
    $("#printForm").on('submit', function(){
        if(!confirm('Are you sure want to print this purchase order?')){
            return false;
        }else{
            setTimeout(function(){
                location.reload();
            }, 1000);
        }
    })
    
    $(document).on('click', '.delete-btn', function(){
        var id = $(this).data('id');
       
        if(confirm('Are you sure want to delete this purchase order?')){
            $("#deletePoForm").submit();
        }
    });
    
    $(".edit-btn").click(function() {
        $("#editModal").modal('show');
    });
    
    <?php  
        foreach($financial_items as $fi){
            if($fi->sub_contract_accepted==1){
                $f_plant -= $fi->plant*$fi->quantity;
                $f_labour -= $fi->labour*$fi->quantity;
                $f_material -= $fi->material*$fi->quantity;
            }
        }
    ?>

    $("#total_plant_estimated").html('£{{ number_format($f_plant*0.60, 2) }}');
    $("#total_labour_estimated").html('£{{ number_format($f_labour*0.60, 2) }}');
    $("#total_material_estimated").html('£{{ number_format($f_material*0.60, 2) }}');


    <?php 
        $remaining_plant = ($f_plant*0.60)-$plant;
        $remaining_labour = ($f_labour*0.60)-$labour;
        $remaining_material = ($f_material*0.60)-$material;
    ?>
    
    var remaining_plant = parseFloat('{{ ($f_plant*0.60) - $po_total_plant }}'); 
    var remaining_labour = parseFloat('{{ ($f_labour*0.60) - $po_total_labour }}');
    var remaining_material = parseFloat('{{ ($f_material*0.60) - $po_total_material }}');
    
    @if($purchase_order->sub_contract==1)
        @php $remaining_total = $sc->amount - $sc_total  @endphp
        var remaining_total = parseFloat('{{ number_format($remaining_total, 2) }}');
        $("#rem_total").html('{{ number_format($remaining_total, 2) }}');
    @endif

    $("#rem_plant").html('£'+remaining_plant.toFixed(2));
    $("#rem_labour").html('£'+remaining_labour.toFixed(2));
    $("#rem_material").html('£'+remaining_material.toFixed(2));
    
    
    
    $("#total_amount").on('input change keyup', function(){
        if($(this).val()>remaining_total){
            $("#amount_error").text('This value exceeds total remaining total cost.');
        }else{
            $("#amount_error").text('');
        }
    });
    
    
    $("#labour_input").on('input change keyup', function(){
        if($(this).val()>remaining_labour && $(this).val()!=0){
            $("#labour_error").text('This value exceeds total remaining labour cost.');
        }else{
            $("#labour_error").text('');
        }
    })
    
    $("#material_input").on('input change keyup', function(){
        if($(this).val()>remaining_material && $(this).val()!=0){
            $("#material_error").text('This value exceeds total remaining material cost.');
        }else{
            $("#material_error").text('');
        }
    })
    
    $("#plant_input").on('input change keyup', function(){
        if($(this).val()>remaining_plant && $(this).val()!=0){
            $("#plant_error").text('This value exceeds total remaining plant cost.');
        }else{
            $("#plant_error").text('');
        }
    })
    

    $(document).on('click', '.deleteBtn', function() {
        var id = $(this).data('id');
        $("#delete_id").val(id);
        if (confirm('Are you sure?')) {
            $("#deleteForm").submit();
        }
    });
</script>
@endsection