@extends('layouts.app')
@section('title', 'Purchase Order')

@section('content')

<style>
    .form-check-label {
        font-size: 15px;
        color: black;
    }

    .form-check-cover {
        margin-bottom: 10px;
        padding: 8px;
        border-radius: 8px;
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.94), rgba(255, 255, 255, 0.94)), #5E5E5E;
    }

    .form-check-cover.active {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.8), rgba(255, 255, 255, 0.8)), #93D500;
    }

    .form-check-input:checked {
        border-color: #93d500;
    }

    .user-data.form-control {
        background: white;
        border-color: #ddd;
    }

    .badge {
        font-size: 16px;
        font-weight: 400;
        padding: 8px;
        color: black;
    }

    .card-footer {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.9), rgba(255, 255, 255, 0.9)), #93D500 !important;
    }

</style>

<div class="d-flex flex-column flex-column-fluid">

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif

            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row justify-content-center">
                                <div class="col-md-8">
                                    <form action="{{ route('accounts.createPurchaseOrder') }}" method="post" enctype="multipart/form-data">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <!--begin::Label-->
                                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                            <span class="required">Select Supplier</span>
                                                        </label>
                                                        <!--end::Label-->
                                                        <select class="form-control" name="supplier_id" id="" required>
                                                            <option value="">Select</option>
                                                            @foreach($suppliers as $supplier)
                                                            <option value="{{$supplier->id}}">{{$supplier->company_name}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-md-6">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <!--begin::Label-->
                                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                            <span class="required">Delivery Date</span>
                                                        </label>
                                                        <!--end::Label-->
                                                        <input required type="date" class="form-control" name="delivery_date">

                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <!--begin::Label-->
                                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                            <span class="">Receipt Photo (Optional)</span>
                                                        </label>
                                                        <!--end::Label-->
                                                        <input type="file" name="receipt_photo" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <!--begin::Label-->
                                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                            <span class="required">Select Project</span>
                                                        </label>
                                                        <!--end::Label-->
                                                        <select class="form-control" name="project_id" id="project_select" required>
                                                            <option value="">Select</option>
                                                            @foreach($projects as $project)
                                                            <option value="{{$project->id}}">{{$project->company_name}} WG-{{str_pad($project->id, 4, '0', STR_PAD_LEFT)}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <label class="form-check form-switch form-check-custom form-check-solid" id="showProjects">
                                                            <input class="form-check-input w-30px h-20px" type="checkbox" value="1" name="sub_contract" id="projectsSwitch" >
                                                            <span class="form-check-label  fs-7">Sub Contract Quote</span>
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="col-md-12" id="sub_contract_div" style="display:none">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <!--begin::Label-->
                                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                            <span class="required">Select Sub Contract</span>
                                                        </label>
                                                        <!--end::Label-->
                                                        <select class="form-control" name="sub_contract_id" id="sub_contract_select"></select>
                                                    </div>
                                                </div>
                                                <div class="row mb-6">
                                                    <div class="col-lg-6 fv-row fv-plugins-icon-container">
                                                        <label class="col-form-label required fw-semibold fs-6">Delivery Address</label><br>
                                                        <div class="form-check form-check-inline mb-3 form-check-custom form-check-solid me-10">
                                                            <input name="address_type" class="form-check-input " type="radio" checked value="client_address" id="flexCheckbox30" />
                                                            <label class="form-check-label" for="flexCheckbox30">
                                                                Client Address
                                                            </label>
                                                        </div>
                                                        <div class="form-check form-check-inline mb-3 form-check-custom form-check-solid me-10">
                                                            <input name="address_type" class="form-check-input " type="radio" value="end_client_address" id="flexCheckbox302" />
                                                            <label class="form-check-label" for="flexCheckbox302">
                                                                End Client Address
                                                            </label>
                                                        </div>
                                                        <div class="form-check form-check-inline mb-3 form-check-custom form-check-solid me-10">
                                                            <input name="address_type" class="form-check-input " type="radio" value="other_address" id="flexCheckbox303" />
                                                            <label class="form-check-label" for="flexCheckbox303">
                                                                Other
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row" id="other_address" style="display:none">
                                                <div class="col-md-12">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <!--begin::Label-->
                                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                            <span class="required">Address</span>
                                                        </label>
                                                        <!--end::Label-->
                                                        <input type="text" class="form-control other_address_field" name="address">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <!--begin::Label-->
                                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                            <span class="required">City</span>
                                                        </label>
                                                        <!--end::Label-->
                                                        <input type="text" class="form-control other_address_field" name="city">
                                                    </div>
                                                </div>
                                                
                                                
                                                <div class="col-md-6">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <!--begin::Label-->
                                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                            <span class="required">Postcode</span>
                                                        </label>
                                                        <!--end::Label-->
                                                        <input type="text" class="form-control other_address_field" name="postcode">
                                                    </div>
                                                </div>
                                                </div>
                                            </div>



                                        </div>
                                        @csrf
                                        <div class="text-center">


                                            <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                                                Create Purchase Order
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>



@endsection


@section('js')
<script>
    
@if(request()->has('project'))
    $(document).ready(function() {
        $("#project_select").val("{{ request()->project }}");
        setTimeout(function(){
            $('#project_select').trigger('change');
        }, 1000);
    });
@endif
    
    
$('input[name="address_type"]').on('change', function() {
    var selectedValue = $('input[name="address_type"]:checked').val();
    if(selectedValue=='other_address'){
        $("#other_address").show();
        $(".other_address_field").prop('required', true);
    }else{
        $("#other_address").hide();
        $(".other_address_field").prop('required', false);
    }
});    

    
$("#project_select").change(function(){
    var val = $(this).val();
    $.ajax({
        url: "{{ route('accounts.getSubContracts') }}",
        type: 'POST',
        data: {
            project_id: val,
           _token: '{{ csrf_token() }}'
        },
        success: function(response) {
            $('#sub_contract_select').empty();
            $('#sub_contract_select').append('<option value="">Select</option>');

            // Loop through the returned data and append it to the select dropdown
            $.each(response, function (key, value) {
                $('#sub_contract_select').append('<option value="' + value.id + '">' + value.title + '</option>');
            });
        },
        error: function(response) {
            alert('Error: ' + response.responseJSON.message);
        }
    });
})    

$("#projectsSwitch").change(function() {
    if ($('#projectsSwitch').is(":checked")) {
        $("#sub_contract_div").show();
        $("#sub_contract_select").prop('required', true);
    } else {
        $("#sub_contract_div").hide();
        $("#sub_contract_select").prop('required', false);
    }
})



</script>
@endsection
