@extends('layouts.app')
@section('title', 'Sub Contracts List')

@section('content')

<style>
    
    .send-link-btn{
        color: #5790FF !important;
        border: 1px solid #0048D533 !important;
        background: #eef4ff !important;
        font-size: 15px;
    }

    .send-link-btn i{
        color: #5790FF !important;
        font-size: 20px;
        font-weight: bold;
    }
    
    .form-check-label {
        font-size: 15px;
        color: black;
    }

    .form-check-cover {
        margin-bottom: 10px;
        padding: 8px;
        border-radius: 8px;
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.94), rgba(255, 255, 255, 0.94)), #5E5E5E;
    }

    .form-check-cover.active {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.8), rgba(255, 255, 255, 0.8)), #93D500;
    }

    .form-check-input:checked {
        border-color: #93d500;
    }

    .user-data.form-control {
        background: white;
        border-color: #ddd;
    }

    .badge {
        font-size: 16px;
        font-weight: 400;
        padding: 8px;
        color: black;
    }

    .card-footer {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.9), rgba(255, 255, 255, 0.9)), #93D500 !important;
    }

    .box {
        background: #f2f2f2;
        border-radius: 8px;
    }

    .box p {
        color: #5E5E5E;
    }

    .table td {
        background: #93D5001A;
        border: 3px solid white !important;
        padding: 8px !important;
        color: black !important;
        color: #727879;
        text-align: center;
    }



    .table th {
        border: 3px solid white !important;
        background: #E3E3E3;
        color: #5E5E5E !important;
        font-weight: 500;
        font-size: 12px;
        margin: 10px !important;
        text-align: center;
        vertical-align: middle;
    }

    .fa-trash {
        cursor: pointer;
    }

    .send-link-btn {
        color: #5790FF !important;
        border: 1px solid #0048D533 !important;
        background: #eef4ff !important;
        font-size: 15px;
    }

    .send-link-btn i {
        color: #5790FF !important;
        font-size: 20px;
        font-weight: bold;
    }
</style>

<div class="d-flex flex-column flex-column-fluid">

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif

            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body p-4">
                            
                            <div class="float-end">
                                <div class="d-flex align-items-center justify-between position-relative mb-3 ">
                                <i class="ki-outline ki-magnifier fs-3 position-absolute ms-5"></i>
                                <input type="text" data-kt-user-table-filter="search" class="form-control  w-250px ps-13" placeholder="Search Sub Contracts" id="mySearch" />

                            </div>
                            </div>
                            
                            <table class="table table-bordered" id="myTable">
                                <thead>
                                    <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                        <th>Project ID</th>
                                        <th>Title</th>
                                        <th>Description</th>
                                        <th>Accepeted Supplier</th>
                                        <th>Accepeted Quote</th>
                                        <th>View</th>
                                    </tr>
                                </thead>
                                <tbody class="text-gray-600 fw-semibold">
                                    @foreach($sub_contracts as $sc)
                                        <tr>
                                            <td>WG-{{str_pad($sc->project_id, 4, '0', STR_PAD_LEFT) }}</td>
                                            <td>{{ $sc->title }}</td>
                                            <td>{{ $sc->notes }}</td>
                                            <td class="text-center">{{ $sc->company_name }}</td>
                                            <td class="text-center">£{{ number_format($sc->amount, 2) }}</td>
                                            <td class="text-center"><a href="{{ route('projects.subContractsQuote', ['id' => $sc->project_id]) }}?sc_id={{$sc->sc_id}}" class="text-dark"><i class="fa fa-eye"></i></a></td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                
                            </table>




                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>


<div class="modal fade" id="purchaseOrderModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-lg  ">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header p-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body  ">
                <!--begin:Form-->


                <div class="mb-8 text-center">
                    <!--begin::Title-->
                    <h1>Select Items</h1>
                    <!--end::Title-->
                    <!--begin::Description-->

                    <!--end::Description-->
                </div>
                <!--end::Heading-->
                <!--begin::Input group-->

                <form action="" method="post" enctype="multipart/form-data">
                    <div class="d-flex flex-column mb-8 fv-row">
                        <table class="table table-bordered mb-8">
                            <thead>
                                <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                    <th></th>
                                    <th>Description</th>
                                    <th>Qty</th>
                                    <th>UoM</th>
                                    <th>Price</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-600 fw-semibold">
                                
                                
                                
                            </tbody>

                        </table>

                    </div>
                    
                </form>
                <!--end::Actions-->

                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>



@endsection


@section('js')
<script>
    
    $(document).ready(function() {
      // Function to filter the table
      $('#mySearch').on('keyup', function() {
        var value = $(this).val().toLowerCase(); // Get the search value and convert to lowercase
        $('#myTable tbody tr').filter(function() {
          $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1); // Toggle rows based on search
        });
      });
    });
    
    $(document).on('click', '.deleteBtn', function() {
        var id = $(this).data('id');
        $("#delete_id").val(id);
        if (confirm('Are you sure?')) {
            $("#deleteForm").submit();
        }
    });
</script>
@endsection