@extends('layouts.app')
@section('title', 'Supplier Invoices')

@section('content')

<style>
    .form-check-label {
        font-size: 15px;
        color: black;
    }

    .form-check-cover {
        margin-bottom: 10px;
        padding: 8px;
        border-radius: 8px;
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.94), rgba(255, 255, 255, 0.94)), #5E5E5E;
    }

    .form-check-cover.active {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.8), rgba(255, 255, 255, 0.8)), #93D500;
    }

    .form-check-input:checked {
        border-color: #93d500;
    }

    .user-data.form-control {
        background: white;
        border-color: #ddd;
    }

    .badge {
        font-size: 16px;
        font-weight: 400;
        padding: 8px;
        color: black;
    }

    .card-footer {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.9), rgba(255, 255, 255, 0.9)), #93D500 !important;
    }

    .table td {
        background: #93D5001A;
        border: 3px solid white !important;
        padding: 8px !important;
        color: black !important;
        color: #727879;
        text-align: center;
    }



    .table th {
        border: 3px solid white !important;
        background: #E3E3E3;
        color: #5E5E5E !important;
        font-weight: 500;
        font-size: 12px;
        margin: 10px !important;
        text-align: center;
        vertical-align: middle;
    }

    .form-check {
        display: flex;
        justify-content: center;
    }
</style>

<div class="d-flex flex-column flex-column-fluid">

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif

            @if(session('danger'))
            <div class="alert alert-danger">
                {{ session('danger') }}
            </div>
            @endif

            <div class="row">
                <div class="col-md-12">
                    
                        <div class="card mb-8">
                            <div class="card-body">
                                <div class="row justify-content-center">
                                    <div class="col-md-12">

                                        <div class="d-flex flex-column fv-row">
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <!--begin::Label-->
                                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                            <span class="">Supplier</span>
                                                        </label>
                                                        <!--end::Label-->
                                                        <h3>{{ $invoice->company_name }}</h3>
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <!--begin::Label-->
                                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                            <span class="">Invoice No.</span>
                                                        </label>
                                                        <!--end::Label-->
                                                        <h3>{{ $invoice->invoice_no }}</h3>

                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <!--begin::Label-->
                                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                            <span class="">Invoice Date</span>
                                                        </label>
                                                        <!--end::Label-->
                                                        <h3>{{ date('d M, Y', strtotime($invoice->date)) }}</h3>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row align-items-center" id="">
                                                <div class="col-md-4">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <!--begin::Label-->
                                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                            <span class="">Net Amount</span>
                                                        </label>
                                                        <!--end::Label-->
                                                        <h3>£{{ number_format($invoice->amount, 2) }}</h3>
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <!--begin::Label-->
                                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                            <span class="">VAT</span>
                                                        </label>
                                                        <!--end::Label-->
                                                        <h3>£{{ number_format($invoice->vat, 2) }}</h3>
                                                    </div>
                                                </div>


                                                <div class="col-md-4">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <!--begin::Label-->
                                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                            <span class="">Gross</span>
                                                        </label>
                                                        <!--end::Label-->
                                                        <h3>£{{ number_format($invoice->vat+$invoice->amount, 2) }}</h3>
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                        <span class="">Status</span>
                                                    </label>
                                                    @if($invoice->status=='passed')
                                                    <h3 class="text-primary">Passed</h3>
                                                    @else
                                                    <h3 class="text-danger">Not Passed</h3>
                                                    @endif
                                                </div>
                                                @if($invoice->status=='not_passed')
                                                <div class="col-md-4">
                                                    <form action="{{ route('accounts.passSupplierInvoice', ['id'=>$invoice->id]) }}" method="post" id="passInvoiceForm">
                                                        @csrf
                                                        
                                                        <button class="btn btn-primary btn-sm">Pass now</button>
                                                        
                                                    </form>
                                                </div>
                                                @endif
                                            </div>


                                        </div>
                                        @csrf

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card mb-8">
                            <div class="card-header " id="kt_chat_contacts_header">
                                <!--begin::Card title-->
                                <div class="card-title justify-content-between">
                                    <h3 class="fw-bold">Items</h3>

                                </div>

                            </div>
                            <div class="card-body p-0">




                                <table class="table table-bordered mb-0" id="myTable">
                                    <thead>
                                        <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                            <th>Description</th>
                                            <th>Nominal Code</th>
                                            <th>Tax Code</th>
                                            <th>Net Amount</th>
                                            <th>VAT</th>
                                            <th>Gross</th>
                                        </tr>
                                    </thead>
                                    <tbody class="text-gray-600 fw-semibold" id="purchase_orders_select">
                                        @foreach($items as $item)
                                        <tr>
                                            <td>{{ $item->description }}</td>
                                            <td>{{ $item->nominal_code }}</td>
                                            <td>{{ $item->tax_code }}</td>
                                            <td>£{{ number_format($item->net_amount, 2) }}</td>
                                            <td>£{{ number_format($item->vat_amount, 2) }}</td>
                                            <td>£{{ number_format($item->net_amount+$item->vat_amount, 2) }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header " id="kt_chat_contacts_header">
                                <!--begin::Card title-->
                                <div class="card-title justify-content-between">
                                    <h3 class="fw-bold">Purchase Orders</h3>
                                </div>
                                @if($invoice->status=='not_passed')
                                <div class="align-self-center">
                                    <button id="passPoModalBtn" class="btn btn-primary btn-sm">Add Purchase Orders</button>
                                </div>
                                @endif

                            </div>
                            <div class="card-body p-0">




                                <table class="table table-bordered mb-0" id="myTable">
                                    <thead>
                                        <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                            <th>PO Number</th>
                                            <th>PO Date</th>
                                            <th>Net Amount</th>
                                            <th>VAT</th>
                                            <th>Gross</th>
                                        </tr>
                                    </thead>
                                    <tbody class="text-gray-600 fw-semibold" id="purchase_orders_select">
                                        @foreach($purchase_orders as $po)
                                        <tr>
                                            <td><a href="#!" data-id="{{ $po->id }}" class="text-primary showDetails">{{ $po->number }}</a></td>
                                            <td>{{ $po->created_at }}</td>
                                            <td>£{{ number_format($po->total_net, 2) }}</td>
                                            <td>£{{ number_format($po->total_vat, 2) }}</td>
                                            <td>£{{ number_format($po->total_gross, 2) }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="purchaseOrderModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog  modal-lg">
        <div class="modal-content rounded">
            <div class="modal-header pb-0 border-0 justify-content-end">
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
            </div>
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <div class="mb-13 text-center">
                    <h1 class="mb-3">Purchase Order Items</h1>
                </div>
                <table class="table table-bordered mb-0" id="normal_table" style="display:none">
                    <thead>
                        <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                            <th>Description</th>
                            <th>Plant</th>
                            <th>Labour</th>
                            <th>Material</th>
                        </tr>
                    </thead>
                    <tbody class="text-gray-600 fw-semibold"></tbody>
                </table>
                <table class="table table-bordered mb-0" id="sc_table" style="display:none">
                    <thead>
                        <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                            <th width="50%">Description</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody class="text-gray-600 fw-semibold"></tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="passPoModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog  modal-lg">
        <div class="modal-content rounded">
            <div class="modal-header pb-0 border-0 justify-content-end">
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
            </div>
            <div class="modal-body scroll-y px-10  pt-0 ">
                <div class="mb-13 text-center">
                    <h1 class="mb-3">Select Purchase Orders</h1>
                </div>
                <form action="{{ route('accounts.addInvoicePO', ['id' => $invoice->id]) }}" method="post" id="invoiceForm">
                   @csrf
                    <table class="table table-bordered mb-5" id="myTable">
                        <thead>
                            <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                <th>Supplier</th>
                                <th>PO Number</th>
                                <th>PO Date</th>
                                <th>Net Amount</th>
                                <th>VAT</th>
                                <th>Gross</th>
                                <th>Pass PO</th>
                            </tr>
                        </thead>
                        <tbody class="text-gray-600 fw-semibold" id="unpassed_purchase_orders">

                        </tbody>
                    </table>
                    
                    <div class="float-end">
                        <button class="btn btn-primary" id="submitBtn">Submit</button>
                    </div>
                    
                </form>
            </div>
        </div>
    </div>
</div>


<input type="hidden" id="outstanding_input">
@endsection
@section('js')
<script>
    
    $("#passInvoiceForm").submit(function(e){
       if(!confirm('Are you sure want to pass this supplier invoice?')){
           e.preventDefault();
           return false;
       } 
    });
    
    $("#invoiceForm").submit(function(e) {
        if ($('.invoice-checkbox:checked').length == 0) {
            alert('Please select at least one purchase order.');
            return false;
        }
    });
    
    
    $("#passPoModalBtn").click(function() {
        var val = $(this).val();
        $.ajax({
            url: "{{ route('accounts.getPurchaseOrders') }}",
            type: 'POST',
            data: {
                supplier_id: '{{$invoice->supplier_id}}',
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                var count = response.purchase_orders.length;
                $('#unpassed_purchase_orders').empty();
                //$('#purchase_orders_select').append('<option value="">Select Purchase Order</option>');

                // Loop through the returned data and append it to the select dropdown
                var po = response.purchase_orders;
                //$("#account_ref").val(response.account_ref);
                $.each(po, function(key, value) {
                    if (value.total_net > 0) {
                        $('#unpassed_purchase_orders').append('<tr><td>' + value.company_name + '</td><td>' + value.number + '</td><td>' + value.created_at + '</td><td>£' + value.total_net.toFixed(2) + '</td><td>£' + value.total_vat.toFixed(2) + '</td><td>£' + value.total_gross.toFixed(2) + '</td><td align="center" class="text-center"><div class="form-check text-center m-0"><input data-price="' + value.total_net + '" name="purchase_order[]" class="form-check-input invoice-checkbox" type="checkbox" value="' + value.id + '" id="flexCheckDefault"></div></td></tr>');
                    }
                });
            },
            error: function(response) {
                alert('Error: ' + response.responseJSON.message);
            }
        });
    })


    $("#passPoModalBtn").click(function() {
        $("#passPoModal").modal("show");
    })

    $(".showDetails").click(function() {
        var val = $(this).data('id');
        $.ajax({
            url: "{{ route('accounts.getPoItems') }}",
            type: 'POST',
            data: {
                po_id: val,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                $("#sc_table").hide();
                $("#normal_table").hide();

                if (response.type == 'sc') {
                    $("#sc_table").show();
                    $('#sc_table tbody').html("");
                } else {
                    $("#normal_table").show();
                    $('#normal_table tbody').html("");
                }

                $.each(response.data, function(key, value) {
                    if (response.type == 'sc') {
                        $('#sc_table tbody').append('<tr><td>' + value.description + '</td><td>£' + value.sc_total + '</td></tr>');
                    } else {
                        $('#normal_table tbody').append('<tr><td>' + value.description + '</td><td>£' + value.plant + '</td><td>£' + value.labour + '</td><td>£' + value.material + '</td></tr>');
                    }

                });
                $("#purchaseOrderModal").modal("show");
            },
            error: function(response) {
                alert('Error: ' + response.responseJSON.message);
            }
        });

    });
</script>
@endsection