@extends('layouts.app')
@section('title', 'Supplier Invoices')

@section('content')

<style>
    .form-check-label {
        font-size: 15px;
        color: black;
    }

    .form-check-cover {
        margin-bottom: 10px;
        padding: 8px;
        border-radius: 8px;
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.94), rgba(255, 255, 255, 0.94)), #5E5E5E;
    }

    .form-check-cover.active {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.8), rgba(255, 255, 255, 0.8)), #93D500;
    }

    .form-check-input:checked {
        border-color: #93d500;
    }

    .user-data.form-control {
        background: white;
        border-color: #ddd;
    }

    .badge {
        font-size: 16px;
        font-weight: 400;
        padding: 8px;
        color: black;
    }

    .card-footer {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.9), rgba(255, 255, 255, 0.9)), #93D500 !important;
    }

    .table td {
        background: #93D5001A;
        border: 3px solid white !important;
        padding: 8px !important;
        color: black !important;
        color: #727879;
        text-align: center;
    }



    .table th {
        border: 3px solid white !important;
        background: #E3E3E3;
        color: #5E5E5E !important;
        font-weight: 500;
        font-size: 12px;
        margin: 10px !important;
        text-align: center;
        vertical-align: middle;
    }

    .form-check {
        display: flex;
        justify-content: center;
    }

</style>

<div class="d-flex flex-column flex-column-fluid">

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif

            @if(session('danger'))
            <div class="alert alert-danger">
                {{ session('danger') }}
            </div>
            @endif

            <div class="row">
                <div class="col-md-12">
                    <form action="{{ route('accounts.createSupplierInvoice') }}" method="post" enctype="multipart/form-data" id="invoiceForm">
                        <div class="card mb-8">
                            <div class="card-body">
                                <div class="row justify-content-center">
                                    <div class="col-md-12">

                                        <div class="d-flex flex-column fv-row">
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <!--begin::Label-->
                                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                            <span class="required">Select Supplier</span>
                                                        </label>
                                                        <!--end::Label-->
                                                        <select class="form-control" name="supplier_id" id="supplier_id" required>
                                                            <option value="">Select</option>
                                                            @foreach($suppliers as $supplier)
                                                            <option value="{{$supplier->id}}">{{$supplier->company_name}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <!--begin::Label-->
                                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                            <span class="required">Account Reference</span>
                                                        </label>
                                                        <!--end::Label-->
                                                        <input type="text" name="account_ref" required class="form-control" id="account_ref">
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <!--begin::Label-->
                                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                            <span class="required">Invoice No.</span>
                                                        </label>
                                                        <!--end::Label-->
                                                        <input required type="text" class="form-control" name="invoice_no">

                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <!--begin::Label-->
                                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                            <span class="required">Invoice Date</span>
                                                        </label>
                                                        <!--end::Label-->
                                                        <input required type="date" class="form-control" name="invoice_date">

                                                    </div>
                                                </div>
                                            </div>
                                            <div id="items_row">
                                                <div class="row template_row" id="template_row">
                                                    <div class="col-md-3">
                                                        <div class="d-flex flex-column mb-8 fv-row">
                                                            <!--begin::Label-->
                                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                                <span class="required">Nominal Code</span>
                                                            </label>
                                                            <!--end::Label-->
                                                            <select required name="nominal_code[]" class="form-control" id="">
                                                                <option value="">Select</option>
                                                                @foreach($nominal_codes as $code)
                                                                <option value="{{ $code->id }}">{{ $code->code }} - {{ $code->description }}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="d-flex flex-column mb-8 fv-row">
                                                            <!--begin::Label-->
                                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                                <span class="required">Tax Code</span>
                                                            </label>
                                                            <!--end::Label-->
                                                            <select required name="tax_code[]" class="form-control" id="">
                                                                <option value="">Select</option>
                                                                <option value="T0 - Zero Rated">T0 - Zero Rated</option>
                                                                <option value="T1 - Standard 20%">T1 - Standard 20%</option>
                                                                <option value="T5 - 5%">T5 - 5%</option>
                                                                <option value="T9 - Exempt">T9 - Exempt</option>
                                                                <option value="T26 - Reverse VAT">T26 - Reverse VAT</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="d-flex flex-column mb-8 fv-row">
                                                            <!--begin::Label-->
                                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                                <span class="required">Net Amount</span>
                                                            </label>
                                                            <!--end::Label-->
                                                            <input required type="number" class="form-control net_amount" name="net_amount[]">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="d-flex flex-column mb-8 fv-row">
                                                            <!--begin::Label-->
                                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                                <span class="required">VAT</span>
                                                            </label>
                                                            <!--end::Label-->
                                                            <input required type="number" class="form-control vat_amount" name="vat[]">
                                                        </div>
                                                    </div>


                                                    <div class="col-md-2">
                                                        <div class="d-flex flex-column mb-8 fv-row">
                                                            <!--begin::Label-->
                                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2" style="position:relative">
                                                                <span class="">Gross </span>
                                                                <i class="fa fa-times-circle text-danger" style="position:absolute;right:0;font-size:18px;display:none"></i>
                                                            </label>
                                                            <!--end::Label-->
                                                            <input readonly type="text" class="form-control gross_amount" value="£0.00">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="d-flex flex-column mb-8 fv-row">
                                                            <!--begin::Label-->
                                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                                <span class="required">Description</span>
                                                            </label>
                                                            <!--end::Label-->
                                                            <input type="text" class="form-control" name="description[]">
                                                        </div>
                                                        <hr>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <p style="font-size:15px"><a id="add_more_item" href="#!"><i class="fa fa-plus-circle text-primary" style="font-size:18px"></i></a></p>
                                                </div>
                                            </div>
                                            <div class="row justify-content-end">
                                                <div class="col-md-4"></div>
                                                <div class="col-md-3 text-center">

                                                    <button type="submit" id="submit_btn" class="btn w-100 btn-primary" style="padding-left:50px;padding-right:50px">
                                                        Save
                                                    </button>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="alert bg-secondary">
                                                        <p class="mb-0 text-muted fw-semibold">Outstanding: £<span id="outstanding">0.00</span></p>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        @csrf

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-body p-4">


                                <div class="text-center" id="no_data_image">
                                    <img src="{{ asset('img/no-data.svg') }}" alt="">
                                </div>

                                <table class="table table-bordered" id="myTable" style="display:none">
                                    <thead>
                                        <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                            <th>Supplier</th>
                                            <th>PO Number</th>
                                            <th>PO Date</th>
                                            <th>Net Amount</th>
                                            <th>VAT</th>
                                            <th>Gross</th>
                                            <th>Pass PO</th>
                                        </tr>
                                    </thead>
                                    <tbody class="text-gray-600 fw-semibold" id="purchase_orders_select">

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<input type="hidden" id="outstanding_input">
@endsection
@section('js')
<script>
    
    $(document).ready(function() {
        // Listen for changes in the net amount input
        $(document).on('input', '.net_amount', function() {
            const netAmount = parseFloat($(this).val()) || 0;
            const vatAmount = netAmount * 0.20;
            const grossAmount = netAmount + vatAmount;

            // Find the VAT and Gross fields within the same row
            const row = $(this).closest('.template_row');
            row.find('.vat_amount').val(vatAmount.toFixed(2));
            row.find('.gross_amount').val(`£${grossAmount.toFixed(2)}`);
            calculateAndUpdateTotalNet();
        });
        
        $(document).on('input', '.vat_amount', function() {
            const row = $(this).closest('.template_row');
            const netAmount = parseFloat(row.find('.net_amount').val()) || 0;
            const vatAmount = parseFloat($(this).val()) || 0;
            const grossAmount = netAmount + vatAmount;

            row.find('.gross_amount').val(`£${grossAmount.toFixed(2)}`);
            calculateAndUpdateTotalNet();
        });
    });
    
    
    
    $(document).ready(function() {
        $('#add_more_item').click(function() {
            // Clone the row and append to container
            let newRow = $('#template_row').clone().removeAttr('id');
            newRow.find('input').val('');
            newRow.find('select').prop('selectedIndex', 0); // Reset select to default
            newRow.find('.fa-times-circle').show(); // Reset select to default
            $('#items_row').append(newRow);
        });
        
        $(document).on('click', '.fa-times-circle', function() {
            $(this).parent().parent().parent().parent().remove();
        });
    });
    
    
    function calculateAndUpdateTotalNet() {
        let totalNet = 0;
        $('.net_amount').each(function() {
            const netAmount = parseFloat($(this).val()) || 0;
            totalNet += netAmount;
        });
        $('#outstanding_input').val(`${totalNet.toFixed(2)}`);
    }

    $("#invoiceForm").submit(function(e) {
        let sum = 0;

        /*if ($('.invoice-checkbox:checked').length == 0) {
            alert('Please select at least one purchase order.');
            return false;
        }*/

        $('.invoice-checkbox:checked').each(function() {
            sum += parseFloat($(this).data('price'));
        });
        var outstanding = parseFloat($('#outstanding_input').val()) - sum;
        if (outstanding > 0) {
            if (!confirm('There is a difference of £' + outstanding + '. Are you sure want to pass?')) {
                e.preventDefault();
            }
        }
    });

    $(document).ready(function() {
        // Calculate sum when any checkbox is clicked
        $(document).on('change', '.invoice-checkbox', function() {
            calculateSum();
        });
    });

    $(document).ready(function() {
        $('#net_amount').on('input', function() {
            var netAmount = parseFloat($(this).val()) || 0;

            // Automatically calculate VAT as 20% of net amount
            var vat = netAmount * 0.20;
            $('#vat').val(vat.toFixed(2));

            // Update gross amount (net + VAT)
            var grossAmount = netAmount + vat;
            $("#outstanding").text(netAmount.toFixed(2));
            $("#outstanding_input").val(netAmount.toFixed(2));
            $('#gross_amount').val('£' + grossAmount.toFixed(2));
            calculateSum();
        });

        // When VAT changes, update the gross amount
        $('#vat').on('input', function() {
            var netAmount = parseFloat($('#net_amount').val()) || 0;
            var vat = parseFloat($(this).val()) || 0;

            // Update gross amount (net + VAT)
            var grossAmount = netAmount + vat;
            $('#gross_amount').val('£' + grossAmount.toFixed(2));
        });
    });


    $("#supplier_id").change(function() {
        var val = $(this).val();
        $.ajax({
            url: "{{ route('accounts.getPurchaseOrders') }}",
            type: 'POST',
            data: {
                supplier_id: val,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                var count = response.purchase_orders.length;
                if (count == 0) {
                    $("#no_data_image").show();
                    $("#myTable").hide();
                } else {
                    $("#no_data_image").hide();
                    $("#myTable").show();
                }

                $('#purchase_orders_select').empty();
                //$('#purchase_orders_select').append('<option value="">Select Purchase Order</option>');

                // Loop through the returned data and append it to the select dropdown
                var po = response.purchase_orders;
                $("#account_ref").val(response.account_ref);
                $.each(po, function(key, value) {
                    if (value.total_net > 0) {
                        $('#purchase_orders_select').append('<tr><td>' + value.company_name + '</td><td>' + value.number + '</td><td>' + value.created_at + '</td><td>£' + value.total_net.toFixed(2) + '</td><td>£' + value.total_vat.toFixed(2) + '</td><td>£' + value.total_gross.toFixed(2) + '</td><td align="center" class="text-center"><div class="form-check text-center m-0"><input data-price="' + value.total_net + '" name="purchase_order[]" class="form-check-input invoice-checkbox" type="checkbox" value="' + value.id + '" id="flexCheckDefault"></div></td></tr>');
                    }
                });
            },
            error: function(response) {
                alert('Error: ' + response.responseJSON.message);
            }
        });
    })

    function calculateSum() {
        let sum = 0;
        $('.invoice-checkbox:checked').each(function() {
            sum += parseFloat($(this).data('price'));
        });
        var outstanding = parseFloat($('#outstanding_input').val()) - sum;
        $("#outstanding").text(outstanding.toFixed(2));
    }

</script>
@endsection
