@extends('layouts.app')
@section('title', 'Transfer Sales')

@section('content')

<style>
    .send-link-btn {
        color: #5790FF !important;
        border: 1px solid #0048D533 !important;
        background: #eef4ff !important;
        font-size: 15px;
    }

    .send-link-btn i {
        color: #5790FF !important;
        font-size: 20px;
        font-weight: bold;
    }

    .form-check-label {
        font-size: 15px;
        color: black;
    }

    .form-check-cover {
        margin-bottom: 10px;
        padding: 8px;
        border-radius: 8px;
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.94), rgba(255, 255, 255, 0.94)), #5E5E5E;
    }

    .form-check-cover.active {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.8), rgba(255, 255, 255, 0.8)), #93D500;
    }

    .form-check-input:checked {
        border-color: #93d500;
    }

    .user-data.form-control {
        background: white;
        border-color: #ddd;
    }

    .badge {
        font-size: 16px;
        font-weight: 400;
        padding: 8px;
        color: black;
    }

    .card-footer {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.9), rgba(255, 255, 255, 0.9)), #93D500 !important;
    }

    .box {
        background: #f2f2f2;
        border-radius: 8px;
    }

    .box p {
        color: #5E5E5E;
    }

    .table td {
        background: #93D5001A;
        border: 3px solid white !important;
        padding: 8px !important;
        color: black !important;
        color: #727879;
        text-align: center;
    }



    .table th {
        border: 3px solid white !important;
        background: #E3E3E3;
        color: #5E5E5E !important;
        font-weight: 500;
        font-size: 12px;
        margin: 10px !important;
        text-align: center;
        vertical-align: middle;
    }

    .fa-trash {
        cursor: pointer;
    }

    .send-link-btn {
        color: #5790FF !important;
        border: 1px solid #0048D533 !important;
        background: #eef4ff !important;
        font-size: 15px;
    }

    .send-link-btn i {
        color: #5790FF !important;
        font-size: 20px;
        font-weight: bold;
    }

</style>

<div class="d-flex flex-column flex-column-fluid">

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif
            
            @if(session('danger'))
            <div class="alert alert-danger">
                {{ session('danger') }}
            </div>
            @endif
            
            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif

            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                       @if(!request()->has('archived'))
                        <div class="card-header " id="kt_chat_contacts_header">
                            <!--begin::Card title-->
                            <div class="card-title justify-content-between">
                                <h3 class="fw-bold">Transfer Sales</h3>
                            </div>
                            <div class="align-self-center">
                                <a href="{{ route('accounts.transferSales') }}?archived=1" class="btn btn-primary">Show Archived</a>
                            </div>
                        </div>
                        @else
                        <div class="card-header " id="kt_chat_contacts_header">
                            <!--begin::Card title-->
                            <div class="card-title justify-content-between">
                                <h3 class="fw-bold">Archived Invoices</h3>
                            </div>
                            <div class="align-self-center">
                                <a href="{{ route('accounts.transferSales') }}" class="btn btn-primary">Show Non Transferred</a>
                            </div>
                        </div>
                        @endif        
                        
                        
                        @if(!request()->has('archived'))
                        <div class="card-body p-4">
                            <form action="{{ route('accounts.transferSales') }}" method="post">
                               @csrf
                                <table class="table table-bordered mb-8" id="myTable">
                                    <thead>
                                        <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                            <th></th>
                                            <th>Date</th>
                                            <th>Invoice</th>
                                            <th>Project</th>
                                            <th>Customer</th>
                                            <th>Status</th>
                                            <th>Final Amount</th>
                                            <th>View</th>
                                        </tr>
                                    </thead>
                                    <tbody class="text-gray-600 fw-semibold">
                                        @foreach($invoices as $invoice)
                                        <tr>
                                            <td class="text-center" align="center">
                                                <div class="form-check text-center m-0" style="display:flex;justify-content:center"><input name="invoices[]" class="form-check-input invoice-checkbox" type="checkbox" value="{{ $invoice->id }}" id="flexCheckDefault"></div>
                                            </td>
                                            <td>{{ date('jS M Y', strtotime($invoice->created_at)) }}</td>
                                            <td>
                                                @if($invoice->credit_note==0)
                                                WGI-{{str_pad($invoice->id, 4, '0', STR_PAD_LEFT);}}
                                                @else
                                                <span class="text-danger">WGC-{{str_pad($invoice->id, 4, '0', STR_PAD_LEFT);}}</span>
                                                @endif
                                            </td>
                                            <td>
                                                WG-{{str_pad($invoice->project_id, 4, '0', STR_PAD_LEFT);}}
                                            </td>
                                            <td>{{ $invoice->company_name }}</td>
                                            <td class="text-center">
                                                @if($invoice->sent_to_client==0)
                                                <span class="text-danger fw-bold">{{ ucfirst($invoice->status) }}</span>
                                                @else
                                                <span class="text-primary fw-bold">{{ ucfirst($invoice->status) }}</span>
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                @php
                                                    $invoice_vat = $invoice->final_amount*0.20;
                                                    $invoice_total = $invoice_vat+$invoice->final_amount;
                                                @endphp
                                                £{{ number_format($invoice_total, 2) }}
                                            </td>
                                            <td class="text-center">
                                                <a target="_blank" href="{{ route('project.viewInvoice', ['id'=>$invoice->id]) }}"><i class="fas fa-eye text-dark"></i></a>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>

                                <div class="float-end">
                                    <button class="btn btn-primary" id="transfer_btn">Transfer</button>
                                </div>
                            </form>
                        </div>
                        @else
                        <div class="card-body p-4">
                            <form action="{{ route('accounts.transferPurchase') }}" method="post">
                               @csrf
                                <table class="table table-bordered mb-8" id="myTable">
                                    <thead>
                                        <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                            
                                            <th>Date</th>
                                            <th>Invoice</th>
                                            <th>Project</th>
                                            <th>Customer</th>
                                            
                                            <th>Final Amount</th>
                                            <th>Transfer File</th>
                                            <th>Transferred Date</th>
                                            <th>View</th>
                                        </tr>
                                    </thead>
                                    <tbody class="text-gray-600 fw-semibold">
                                        @foreach($archived as $invoice)
                                        <tr>
                                            
                                            <td>{{ date('jS M Y', strtotime($invoice->created_at)) }}</td>
                                            <td>
                                                @if($invoice->credit_note==0)
                                                WGI-{{str_pad($invoice->id, 4, '0', STR_PAD_LEFT);}}
                                                @else
                                                <span class="text-danger">WGC-{{str_pad($invoice->id, 4, '0', STR_PAD_LEFT);}}</span>
                                                @endif
                                            </td>
                                            <td>
                                                WG-{{str_pad($invoice->project_id, 4, '0', STR_PAD_LEFT);}}
                                            </td>
                                            <td>{{ $invoice->company_name }}</td>
                                            
                                            <td class="text-center">
                                                @php
                                                    $invoice_vat = $invoice->final_amount*0.20;
                                                    $invoice_total = $invoice_vat+$invoice->final_amount;
                                                @endphp
                                                £{{ number_format($invoice_total, 2) }}
                                            </td>
                                            <td class="text-center">
                                               @if($invoice->ts_id!=0)
                                                SalesTransfer-{{ str_pad($invoice->ts_id, 5, '0', STR_PAD_LEFT) }}
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                {{ date('d M, Y', strtotime($invoice->transfer_date)) }}
                                            </td>
                                            <td class="text-center"><a href="{{ route('accounts.supplierInvoiceDetails', ['id'=>$invoice->id]) }}" class="text-dark"><i class="fa fa-eye"></i></a></td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </form>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="purchaseOrderModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-lg  ">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header p-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body  ">
                <!--begin:Form-->


                <div class="mb-8 text-center">
                    <!--begin::Title-->
                    <h1>Select Items</h1>
                    <!--end::Title-->
                    <!--begin::Description-->

                    <!--end::Description-->
                </div>
                <!--end::Heading-->
                <!--begin::Input group-->

                <form action="" method="post" enctype="multipart/form-data">
                    <div class="d-flex flex-column mb-8 fv-row">
                        <table class="table table-bordered mb-8">
                            <thead>
                                <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                    <th></th>
                                    <th>Description</th>
                                    <th>Qty</th>
                                    <th>UoM</th>
                                    <th>Price</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-600 fw-semibold">



                            </tbody>

                        </table>

                    </div>

                </form>
                <!--end::Actions-->

                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>



@endsection


@section('js')
<script>
    
    $('#transfer_btn').click(function() {
        $('#myTable .invoice-checkbox:checked').each(function() {
            $(this).closest('tr').hide();
        });
    });
    
    $(document).ready(function() {
        // Function to filter the table
        $('#mySearch').on('keyup', function() {
            var value = $(this).val().toLowerCase(); // Get the search value and convert to lowercase
            $('#myTable tbody tr').filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1); // Toggle rows based on search
            });
        });
    });

    $(document).on('click', '.deleteBtn', function() {
        var id = $(this).data('id');
        $("#delete_id").val(id);
        if (confirm('Are you sure?')) {
            $("#deleteForm").submit();
        }
    });

</script>
@endsection
