<!DOCTYPE html>
<html lang="en">

<head>
    <title>Set up your profile</title>
    <meta charset="utf-8" />

    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta property="og:locale" content="en_US" />
    <link rel="shortcut icon" href="{{asset('media/logos/favicon.ico')}}" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700" />
    <link href="{{asset('plugins/global/plugins.bundle.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{asset('css/style.bundle.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{asset('css/custom.css')}}?{{time()}}" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.15/css/intlTelInput.css">

    <style>
        .form-label {
            color: #666666;
        }

        .bg-body {
            border: 1px solid #ddd;
        }

        .btn-primary {
            color: white !important;
        }

        .iti {
            width: 100% !important;
        }
    </style>


</head>
<!--end::Head-->
<!--begin::Body-->

<body id="kt_body" class="app-blank bgi-size-cover bgi-attachment-fixed bgi-position-center bgi-no-repeat">
    <!--begin::Theme mode setup on page load-->
    <script>
        var defaultThemeMode = "light";
        var themeMode;
        if (document.documentElement) {
            if (document.documentElement.hasAttribute("data-bs-theme-mode")) {
                themeMode = document.documentElement.getAttribute("data-bs-theme-mode");
            } else {
                if (localStorage.getItem("data-bs-theme") !== null) {
                    themeMode = localStorage.getItem("data-bs-theme");
                } else {
                    themeMode = defaultThemeMode;
                }
            }
            if (themeMode === "system") {
                themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light";
            }
            document.documentElement.setAttribute("data-bs-theme", themeMode);
        }
    </script>
    <!--end::Theme mode setup on page load-->
    <!--begin::Root-->
    <div class="d-flex flex-column flex-root" id="kt_app_root">
        <!--begin::Page bg image-->

        <!--end::Page bg image-->
        <!--begin::Authentication - Sign-in -->
        <div class="d-flex flex-column flex-column-fluid justify-content-center">
            <!--begin::Aside-->

            <!--begin::Aside-->
            <!--begin::Body-->
            <div class="d-flex flex-column-fluid flex-lg-row-auto justify-content-center  p-12 p-lg-20">
                <!--begin::Card-->
                <div class="bg-body  d-flex flex-column align-items-stretch flex-center rounded-4 w-md-600px p-10">
                    <!--begin::Wrapper-->
                    <div class="px-lg-10">

                        @if(session('danger'))
                        <div class="alert alert-danger">
                            {{ session('danger') }}
                        </div>
                        @endif

                        @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                        @endif
                        <form class="form w-100" method="POST" action="{{ route('user.setupProfile') }}" id="profileForm">
                            <!--begin::Heading-->
                            <div class="text-center mb-11">
                                <!--begin::Title-->
                                <h1 style="color:#333333" class="mb-8">Set up your profile</h1>

                            </div>
                            <div class="fv-row mb-8">
                                <!--begin::Email-->
                                <label for="" class="form-label required">Full Name</label>
                                <input type="text" placeholder="" name="name" autocomplete="off" class="form-control bg-transparent" required value="{{ old('full_name') }}" />
                                <!--end::Email-->
                            </div>
                            <div class="fv-row mb-8">
                                <!--begin::Password-->
                                <label for="" class="form-label required">Phone number</label>
                                <div class="w-100">
                                    <input type="text" id="phone" class="form-control w-100 bg-transparent" required />
                                    <input type="hidden" name="phone" id="real_phone">
                                </div>
                                <!--end::Password-->
                            </div>
                            <!--end::Input group=-->
                            <div class="fv-row mb-8">
                                <!--begin::Password-->
                                <label for="" class="form-label">Company Name</label>
                                <input type="text" placeholder="" name="company_name" autocomplete="off" class="form-control bg-transparent" value="{{ old('company_name') }}" />
                                <!--end::Password-->
                            </div>
                            <div class="fv-row mb-8">
                                <!--begin::Password-->
                                <label for="" class="form-label">Job Title</label>
                                <input type="text" placeholder="" name="job_title" autocomplete="off" class="form-control bg-transparent" value="{{ old('job_title') }}" />
                                <!--end::Password-->
                            </div>


                            <!--end::Wrapper-->
                            <!--begin::Submit button-->



                            <div class="d-grid mb-8">
                                @csrf
                                <button type="submit" name="submit" id="kt_sign_in_submit" class="btn btn-gradient">
                                    <!--begin::Indicator label-->
                                    <span class="indicator-label">Continue</span>
                                    <!--end::Indicator label-->
                                    <!--begin::Indicator progress-->
                                    <span class="indicator-progress">Please wait...
                                        <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                                    <!--end::Indicator progress-->
                                </button>

                            </div>


                        </form>
                    </div>
                </div>
                <!--end::Card-->
            </div>
            <!--end::Body-->
        </div>
        <!--end::Authentication - Sign-in-->
    </div>
    <!--end::Root-->
    <!--begin::Javascript-->
    <script>
        var hostUrl = "assets/";
    </script>
    <!--begin::Global Javascript Bundle(mandatory for all pages)-->
    <script src="assets/plugins/global/plugins.bundle.js"></script>
    <script src="assets/js/scripts.bundle.js"></script>
    <!--end::Global Javascript Bundle-->
    <!--begin::Custom Javascript(used for this page only)-->
    <script src="assets/js/custom/authentication/sign-in/general.js"></script>
    <script src="{{ asset('plugins/global/plugins.bundle.js') }}"></script>
    <script src="{{ asset('js/scripts.bundle.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.15/js/intlTelInput.min.js"></script>
    <!--end::Custom Javascript-->
    <!--end::Javascript-->
    <script>
        $("#showReset").click(function() {
            $("#loginForm").hide();
            $("#passwordResetForm").show();
        });

        $("#showLogin").click(function() {
            $("#passwordResetForm").hide();
            $("#loginForm").show();
        });
    </script>
    <script>
        var input = document.querySelector("#phone");
        var iti = window.intlTelInput(input, {
            utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@18/build/js/utils.js",
            initialCountry: "gb", // Automatically detect the user's country
            separateDialCode: true, // Show the country code separately
            preferredCountries: ['us', 'gb', 'ca'], // Optional: specify preferred countries
        });

        // Optional: You can get the full phone number with the country code
        function getPhoneNumber() {
            var phoneNumber = iti.getNumber();
            console.log(phoneNumber);
        }

        $("#profileForm").on('submit', function(e) {
            $("#real_phone").val(iti.getNumber());
        });
    </script>
</body>
<!--end::Body-->

</html>