@extends('layouts.app')
@section('title', 'Add New Client / Supplier')

@section('content')

<style>
    #imagePreview{
        width: 100px;
        height: 100px;
        object-fit: cover;
        border-radius: 10px;
    }
</style>

<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-7 pt-lg-10">
        <!--begin::Toolbar container-->
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <!--begin::Toolbar wrapper-->
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <!--begin::Page title-->
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <!--begin::Title-->
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">Add Client / Supplier</h1>
                    <!--end::Title-->
                    <!--begin::Breadcrumb-->
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                        <!--begin::Item-->
                        <li class="breadcrumb-item text-muted">
                            <a href="{{route('customer.view')}}" class="text-muted text-hover-primary">CRM</a>
                        </li>
                        <!--end::Item-->
                        <!--begin::Item-->
                        <li class="breadcrumb-item">
                            <span class="bullet bg-gray-500 w-5px h-2px"></span>
                        </li>
                        <!--end::Item-->
                        <!--begin::Item-->
                        <li class="breadcrumb-item text-muted">Add Client or Supplier</li>
                        <!--end::Item-->
                    </ul>
                    <!--end::Breadcrumb-->
                </div>
                <!--end::Page title-->
                <!--begin::Actions-->

                <!--end::Actions-->
            </div>
            <!--end::Toolbar wrapper-->
        </div>
        <!--end::Toolbar container-->
    </div>
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            <div class="row justify-content-center g-5 g-xl-10 mb-xl-10">
                <div class="col-lg-12">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if ($errors->any())
                    <div class="alert alert-danger">
                        {!! implode('<br>', $errors->all(':message')) !!}
                    </div>
                    @endif
                    <div class="card mb-5 mb-xl-10">

                        <div id="kt_account_settings_profile_details" class="collapse border-top show">
                            <!--begin::Form-->
                            <form method="post" action="{{route('customer.store')}}" id="kt_account_profile_details_form" class="form fv-plugins-bootstrap5 fv-plugins-framework" novalidate="novalidate">
                                <!--begin::Card body-->
                                <div class="card-body p-9">


                                    <div class="row mb-6">

                                        <div class="col-lg-12">
                                            <!--begin::Row-->
                                            <div class="row">
                                                <!--begin::Col-->
                                                <div class="col-lg-12 mb-3">
                                                    <div class="text-center">
                                                        <img id="imagePreview" onclick="$('#image').click();" src="{{asset('img/add-image.png')}}" style="cursor:pointer" alt="">
                                                        <input type="file" style="display:none;" name="image" id="image">
                                                    </div>
                                                </div>
                                                <div class="col-lg-12 mb-3">
                                                    <label class="col-form-label required fw-semibold fs-6">Company Name</label>
                                                    <input type="text" name="company_name" class="form-control form-control-lg" placeholder="Enter Company Name" value="">
                                                </div>
                                                <!--end::Col-->

                                                <!--begin::Col-->

                                                <!--end::Col-->
                                            </div>
                                            <!--end::Row-->
                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Input group-->

                                    <!--begin::Input group-->
                                    <div class="row mb-6">
                                        <div class="col-lg-6 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label required fw-semibold fs-6">Email</label>
                                            <input type="text" class="form-control form-control-lg " value="" placeholder="Email Address" name="email">

                                        </div>
                                        <div class="col-lg-6 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label required fw-semibold fs-6">Phone Number</label>
                                            <input type="text" name="phone" class="form-control form-control-lg " placeholder="Phone" value="">
                                        </div>

                                    </div>

                                    <div class="row mb-6">
                                        <div class="col-lg-6 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label required fw-semibold fs-6">Type</label><br>
                                            <div class="form-check form-check-inline mb-3 form-check-custom form-check-solid me-10">
                                                <input name="type" class="form-check-input " type="radio" checked value="customer" id="flexCheckbox30" />
                                                <label class="form-check-label" for="flexCheckbox30">
                                                    Client
                                                </label>
                                            </div>
                                            <div class="form-check form-check-inline form-check-custom form-check-solid me-10">
                                                <input name="type" class="form-check-input " type="radio" value="supplier" id="flexCheckbox302" />
                                                <label class="form-check-label" for="flexCheckbox302">
                                                    Supplier
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <div class="col-lg-6 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label fw-semibold fs-6">Account No.</label>
                                            <input type="text" name="account_no" class="form-control form-control-lg " value="">
                                        </div>
                                        <div class="col-lg-6 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label fw-semibold fs-6">Credit Limit</label>
                                            <input type="text" name="credit_limit" class="form-control form-control-lg " value="">
                                        </div>
                                    </div>

                                    <div class="row mb-6">
                                        
                                        <div class="col-lg-6 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label required fw-semibold fs-6">Address Type</label>
                                            <select id="address_type" name="address_type" aria-label="Select" data-control="select2" data-placeholder="Select address type" class="form-select  form-select-lg fw-semibold">
                                                <option value="">Select Address Type</option>
                                                <option value="1">Head Office</option>
                                            </select>

                                            <div class="fv-plugins-message-container fv-plugins-message-container--enabled invalid-feedback"></div>
                                        </div>
                                    </div>


                                    <div class="row mb-6">
                                        <div class="col-lg-12 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label required fw-semibold fs-6">Address 1</label>
                                            <input type="text" name="address_1" class="form-control form-control-lg " value="">

                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <div class="col-lg-12 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label fw-semibold fs-6">Address 2</label>
                                            <input type="text" name="address_2" class="form-control form-control-lg " value="">

                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <div class="col-lg-12 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label fw-semibold fs-6">Address 3</label>
                                            <input type="text" name="address_3" class="form-control form-control-lg " value="">

                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <div class="col-lg-12 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label fw-semibold fs-6">Address 4</label>
                                            <input type="text" name="address_4" class="form-control form-control-lg " value="">

                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <div class="col-lg-6 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label required fw-semibold fs-6">City</label>
                                            <input type="text" name="city" class="form-control form-control-lg "  required>
                                        </div>
                                        <div class="col-lg-6 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label required fw-semibold fs-6">Postcode</label>
                                            <input type="text" name="postcode" class="form-control form-control-lg " required>
                                        </div>
                                    </div>






                                </div>
                                <!--end::Card body-->
                                @csrf
                                <!--begin::Actions-->
                                <div class="card-footer d-flex justify-content-end py-6 px-9">
                                    <button type="submit" class="btn btn-primary" name="submit" id="kt_account_profile_details_submit">Submit</button>
                                </div>
                                <!--end::Actions-->
                                <input type="hidden">
                            </form>
                            <!--end::Form-->
                        </div>
                        <!--end::Content-->
                    </div>
                </div>
                <!--end::Col-->
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>
@endsection

@section('js')
<script>
$(document).ready(function(){
    $('#image').on('change', function(){
        var file = this.files[0];
        if (file) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#imagePreview').attr('src', e.target.result).show();
            }
            reader.readAsDataURL(file);
        }
    });
});
</script>
@endsection
