@extends('layouts.app')
@section('title', 'Details')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-7 pt-lg-10">
        <!--begin::Toolbar container-->
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <!--begin::Toolbar wrapper-->
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <!--begin::Page title-->
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <!--begin::Title-->
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">{{$customer->company_name}} - Details</h1>
                    <!--end::Title-->
                    <!--begin::Breadcrumb-->
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                        <!--begin::Item-->
                        <li class="breadcrumb-item text-muted">
                            <a href="{{route('customer.view')}}" class="text-muted text-hover-primary">CRM</a>
                        </li>
                        <!--end::Item-->
                        <!--begin::Item-->
                        <li class="breadcrumb-item">
                            <span class="bullet bg-gray-500 w-5px h-2px"></span>
                        </li>
                        <!--end::Item-->
                        <!--begin::Item-->
                        <li class="breadcrumb-item text-muted">Details / Edit</li>
                        <!--end::Item-->
                    </ul>
                    <!--end::Breadcrumb-->
                </div>
                <!--end::Page title-->
                <!--begin::Actions-->

                <!--end::Actions-->
            </div>
            <!--end::Toolbar wrapper-->
        </div>
        <!--end::Toolbar container-->
    </div>
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            <div class="row justify-content-center g-5 g-xl-10 mb-xl-10">
                <div class="col-lg-12">
                    @if(session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                    @endif

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        {!! implode('<br>', $errors->all(':message')) !!}
                    </div>
                    @endif
                    <div class="card mb-5 mb-xl-10">
                        <div class="card-header py-4 border-0 cursor-pointer">


                            <div class="d-flex align-items-start align-items-sm-center gap-4">
                                <img src="{{asset('img/customers/'.$customer->image)}}" alt="user-avatar" class="d-block rounded-circle" height="80" width="80" id="uploadedAvatar">

                                <button onclick="$('#image').trigger('click');" for="upload" class="btn btn-outline btn-outline-dashed btn-sm btn-outline-primary" tabindex="0">
                                    Upload new photo

                                </button>
                                <form enctype="multipart/form-data" action="{{route('customer.updateImage', ['id'=>$customer->id])}}" method="POST" style="display:none" id="myform">
                                    @csrf
                                    <input type="file" id="image" name="image" accept="image/png, image/gif, image/jpeg">
                                    <input type="hidden" name="uploadImage" value="1">
                                </form>
                            </div>
                        </div>
                        <div id="kt_account_settings_profile_details" class="collapse border-top show">
                            <!--begin::Form-->
                            <form method="post" action="{{route('customer.update', ['id'=>$customer->id])}}" id="kt_account_profile_details_form" class="form fv-plugins-bootstrap5 fv-plugins-framework" novalidate="novalidate">
                                <!--begin::Card body-->
                                <div class="card-body p-9">


                                    <div class="row mb-6">

                                        <div class="col-lg-8 mb-3">
                                            <label class="col-form-label required fw-semibold fs-6">Company Name</label>
                                            <input type="text" name="company_name" class="form-control form-control-lg " placeholder="Enter Company Name" value="{{$customer->company_name}}" required>
                                        </div>
                                        <div class="col-lg-4 mb-3">
                                            <label class="col-form-label required fw-semibold fs-6">Profile</label>
                                            <input type="text" readonly class="form-control form-control-lg " value="{{ $customer->type=='customer'?'Client':'Supplier' }}">
                                        </div>
                                        <!--end::Col-->
                                    </div>
                                    <!--end::Input group-->

                                    <!--begin::Input group-->
                                    <div class="row mb-6">
                                        <div class="col-lg-6 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label required fw-semibold fs-6">Email</label>
                                            <input type="text" class="form-control form-control-lg " value="{{$customer->email}}" placeholder="Email Address" name="email" required>

                                        </div>
                                        <div class="col-lg-6 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label required fw-semibold fs-6">Phone Number</label>
                                            <input type="text" name="phone" class="form-control form-control-lg " placeholder="Phone" value="{{$customer->phone}}" required>
                                        </div>

                                    </div>


                                    <div class="row mb-6">
                                        <div class="col-lg-6 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label fw-semibold fs-6">Account No.</label>
                                            <input type="text" name="account_no" class="form-control form-control-lg " value="{{$customer->account_no}}">
                                        </div>
                                        <div class="col-lg-6 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label fw-semibold fs-6">Credit Limit</label>
                                            <input type="text" name="credit_limit" class="form-control form-control-lg " value="{{$customer->credit_limit}}">
                                        </div>
                                    </div>

                                    <div class="row mb-6">
                                        <div class="col-lg-12 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label required fw-semibold fs-6">Address Type</label>
                                            <select id="address_type" name="address_type" aria-label="Select" data-control="select2" data-placeholder="Select address type" class="form-select form-select form-select-lg fw-semibold">
                                                <option value="">Select Address Type</option>
                                                <option value="1">Head Office</option>


                                            </select>

                                            <div class="fv-plugins-message-container fv-plugins-message-container--enabled invalid-feedback"></div>
                                        </div>
                                    </div>


                                    <div class="row mb-6">
                                        <div class="col-lg-12 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label required fw-semibold fs-6">Address 1</label>
                                            <input type="text" name="address_1" class="form-control form-control-lg " value="{{$customer->address_1}}" required>

                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <div class="col-lg-12 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label fw-semibold fs-6">Address 2</label>
                                            <input type="text" name="address_2" class="form-control form-control-lg " value="{{$customer->address_2}}">

                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <div class="col-lg-12 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label fw-semibold fs-6">Address 3</label>
                                            <input type="text" name="address_3" class="form-control form-control-lg " value="{{$customer->address_3}}">

                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <div class="col-lg-6 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label required fw-semibold fs-6">City</label>
                                            <input type="text" name="city" class="form-control form-control-lg " value="{{$customer->city}}" required>

                                        </div>
                                        <div class="col-lg-6 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label required fw-semibold fs-6">Postcode</label>
                                            <input type="text" name="postcode" class="form-control form-control-lg " value="{{$customer->postcode}}" required>

                                        </div>
                                    </div>

                                    


                                    <div class="row mb-6">
                                        <div class="col-lg-12 fv-row fv-plugins-icon-container">
                                            <label class="col-form-label fw-semibold fs-6">Notes</label>
                                            <textarea name="notes" class="form-control form-control-lg " id="" cols="30" rows="5">{{$customer->notes}}</textarea>

                                        </div>

                                    </div>

                                </div>
                                <!--end::Card body-->
                                @csrf
                                <!--begin::Actions-->
                                <div class="card-footer d-flex justify-content-end py-6 px-9">
                                    <button type="submit" class="btn btn-primary" name="submit" id="kt_account_profile_details_submit">Save Changes</button>
                                </div>
                                <!--end::Actions-->
                                <input type="hidden">
                            </form>
                            <!--end::Form-->
                        </div>
                        <!--end::Content-->
                    </div>
                    <div class="page-title mt-5 mb-5">
                        <!--begin::Title-->
                        <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">Contact List</h1>

                    </div>
                    <div class="card">
                        <!--begin::Card header-->
                        <div class="card-header border-0 pt-6">
                            <!--begin::Card title-->
                            <div class="card-title">
                                <!--begin::Search-->
                                <div class="d-flex align-items-center justify-between position-relative my-1">
                                    <i class="ki-outline ki-magnifier fs-3 position-absolute ms-5"></i>
                                    <input type="text" data-kt-user-table-filter="search" class="form-control  w-250px ps-13" placeholder="Search contacts" id="mySearch" />
                                    <div class="ms-3 float-end">
                                        <a href="#" class="btn btn-primary er fs-6 " data-bs-toggle="modal" data-bs-target="#kt_modal_new_target">Add New Contact</a>
                                    </div>
                                </div>

                                <!--end::Search-->
                            </div>
                            <!--begin::Card title-->
                            <!--begin::Card toolbar-->

                            <!--end::Card toolbar-->
                        </div>
                        <!--end::Card header-->
                        <!--begin::Card body-->
                        <div class="card-body py-4">
                            <!--begin::Table-->
                            <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_table_users">
                                <thead>
                                    <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">

                                        <th class="min-w-125px">Name</th>
                                        <th class="min-w-100px">Email</th>
                                        <th class="min-w-100px">Phone</th>
                                        <th class="min-w-100px">Actions</th>
                                    </tr>
                                </thead>
                                <tbody class="text-gray-600 fw-semibold">
                                    @foreach($contacts as $contact)
                                    <tr>
                                        <td>
                                            {{ $contact->name }}
                                        </td>
                                        <td>
                                            {{ $contact->email }}
                                        </td>
                                        <td>
                                            {{ $contact->phone }}
                                        </td>

                                        <td class="">


                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                            <!--end::Table-->
                        </div>
                        <!--end::Card body-->
                    </div>
                </div>
                <!--end::Col-->
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>

<div class="modal fade" id="kt_modal_new_target" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-dialog-centered mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('customer.addContact', ['id'=>$customer->id])}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add New Contact</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Name</span>
                        </label>
                        <!--end::Label-->
                        <input required type="text" class="form-control " placeholder="Enter Contact Name" name="name" />
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Email</span>
                        </label>
                        <!--end::Label-->
                        <input required type="text" class="form-control " placeholder="Enter Contact Email" name="email" />
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Phone</span>
                        </label>
                        <!--end::Label-->
                        <input required type="text" class="form-control " placeholder="Enter Contact Phone" name="phone" />
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="">Notes</span>
                        </label>
                        <!--end::Label-->
                        <input type="text" class="form-control " placeholder="Enter Contact Notes" name="notes" />
                    </div>




                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

@endsection





@section('js')
<script>
    
    $("#image").change(function(){
        $("#myform").submit();
    });
    
    
    
    $("#address_type").val('{{$customer->address_type}}');

    var table = $("#kt_table_users").DataTable({
        "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
        "paging": false, //Dont want paging                
        "bPaginate": false, //Dont want paging
    });

    $('#mySearch').on('input', function() {
        table.search($(this).val()).draw();
    })
</script>
@endsection