@extends('layouts.app')
@section('title', 'Projects')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <!--begin::Toolbar-->
    <style>
        .card-body {
            padding: 10px !important;
        }

        .page-heading {
            font-size: 24px !important;
        }
        
        .bg-danger-2{
            background: #ffcccc;
            border-color: #ffcccc;
        }
        
        .bg-success-2{
            background: #D2EA8E;
        }
        
        .text-red{
            color: red !important;
        }

    </style>
    <!--end::Toolbar-->
    <!--begin::Content-->

    <div id="kt_app_toolbar" class="app-toolbar pt-7 pt-lg-10">

        <!--begin::Toolbar container-->
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <!--begin::Toolbar wrapper-->
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <!--begin::Page title-->
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <!--begin::Title-->

                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">Projects - {{ $customer->company_name }}</h1>
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                        <li class="breadcrumb-item text-muted">
                            <a href="#!" class="text-muted text-hover-primary">List of all projects</a>
                        </li>


                    </ul>
                </div>
                <div class="ms-3 float-end">
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#kt_modal_new_target"><i class="ki-outline ki-plus-circle fs-2"></i> Add New Project</button>
                </div>
            </div>
            <!--end::Toolbar wrapper-->
        </div>
        <!--end::Toolbar container-->
    </div>
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            <div class="row g-5 g-xl-10 mb-xl-10">

                @if($projects->isEmpty())
                <div class="col-md-12">
                    <h3>No projects yet. Start creating one now.</h3>
                </div>
                @endif

                @if(session('success'))
                <div class="col-md-12">
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                </div>
                @endif

                @foreach($projects as $project)
                    @php
                        $currentDate = new \DateTime(date('Y-m-d'));
                        $upcomingDate = new \DateTime($project->end_date);
                        $interval = date_diff($currentDate, $upcomingDate);
                        $daysDifference = abs($interval->days);
                        $isPast = $upcomingDate < $currentDate;
                    @endphp
                <div class="col-md-4">
                    <!--begin::Card widget 14-->
                    <div class="card @if($daysDifference<1 || $isPast) bg-danger-2 @endif card-flush h-xl-100">
                        <!--begin::Body-->
                        <div class="card-body text-center pb-5">
                            <!--begin::Overlay-->

                            <div class="d-flex align-items-end flex-stack mb-3">
                                <!--begin::Title-->
                                <div class="text-start">

                                    <span class="text-gray-800 mt-1 fw-bold fs-6">{{ $project->status }}</span>
                                </div>
                                <!--end::Title-->
                                <!--begin::Total-->
                                @if(!$isPast)
                                <span class="text-gray-600 @if($daysDifference<1) text-red @endif text-end fw-bold fs-6">{{ $daysDifference }} {{ $daysDifference==1 ? 'day':'days' }} left</span>
                                @else
                                <span class="text-gray-600 text-red text-end fw-bold fs-6">{{ $daysDifference }} {{ $daysDifference==1 ? 'day':'days' }} ago</span>
                                @endif
                                <!--end::Total-->
                            </div>
                            <div style="position:relative">
                            <span class="like" data-id="{{$project->id}}" style="position:absolute;z-index:3;right:10px;top:10px"><i id="heart_{{$project->id}}" class="@if($project->favourite==1) ki-solid @else ki-outline @endif ki-heart fs-2x text-primary"></i></span>
                            <span class="" data-id="{{$project->id}}" style="position:absolute;z-index:9999;left:10px;bottom:10px"><span class="badge badge-light-success fs-base">
															{{$project->type}}</span></span>
                            <a class="d-block overlay" href="{{route('project.details', ['id' => $project->id])}}">
                                <!--begin::Image-->
                                <div class="overlay-wrapper bgi-no-repeat bgi-position-center bgi-size-cover card-rounded mb-7" style="height: 266px;background-image:url('{{asset('img/projects/'.$project->image)}}')"></div>
                                <!--end::Image-->
                                <!--begin::Action-->
                                <div class="overlay-layer card-rounded bg-dark bg-opacity-25">
                                    <i class="ki-outline ki-eye fs-3x text-white"></i>
                                </div>
                                <!--end::Action-->
                            </a></div>
                            <!--end::Overlay-->
                            <!--begin::Info-->
                            <div class="d-flex align-items-end flex-stack mb-1">
                                <!--begin::Title-->
                                <div class="text-start">
                                    <a href="{{route('project.details', ['id' => $project->id])}}"><span class="fw-bold text-gray-800 cursor-pointer text-hover-primary fs-4 d-block">{{ $project->company_name }}</span></a>
                                    <span class="text-gray-500 mt-1 fw-bold fs-6">Project ID: WG-{{str_pad($project->id, 4, '0', STR_PAD_LEFT);}}</span>
                                </div>
                                <!--end::Title-->
                                <!--begin::Total-->
                                <span class="text-gray-600 text-end fw-bold fs-6">{{ date('M d, Y', strtotime($project->created_at)) }}</span>
                                <!--end::Total-->
                            </div>
                            <!--end::Info-->
                        </div>
                        <!--end::Body-->
                        <!--begin::Footer-->

                        <!--end::Footer-->
                    </div>
                    <!--end::Card widget 14-->
                </div>
                @endforeach
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>


<div class="modal fade" id="kt_modal_new_target" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-dialog-centered mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('customer.addNewProject', ['id'=>$customer->id])}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add New Project</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->

                    <div class="row mb-8">
                        <div class="col-md-6">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Project Type</span>
                            </label>
                            <!--end::Label-->
                            <select id="project_type" name="project_type" aria-label="Select" data-control="select2" data-placeholder="Select project type" class="form-select  form-select-lg fw-semibold">
                                <option value="">Select Project Type</option>
                                @foreach($project_types as $type)
                                <option value="{{$type->id}}">{{$type->name}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Project Status</span>
                            </label>
                            <!--end::Label-->
                            <select id="project_status" name="project_status" aria-label="Select" data-control="select2" data-placeholder="Select project status" class="form-select  form-select-lg fw-semibold">
                                <option value="">Select Project Status</option>
                                @foreach($statusses as $status)
                                <option value="{{$status->id}}">{{$status->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="row mb-8">
                        <div class="col-md-6">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="">Customer Ref</span>
                            </label>
                            <!--end::Label-->
                            <input required type="text" class="form-control " placeholder="Enter Customer Ref" name="customer_ref" />
                        </div>
                        <div class="col-md-6">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Name</span>
                            </label>
                            <!--end::Label-->
                            <input required type="text" class="form-control " placeholder="Enter Name" name="name" />
                        </div>
                    </div>

                    <div class="row mb-8">
                        <div class="col-md-6">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Email</span>
                            </label>
                            <!--end::Label-->
                            <input required type="email" class="form-control " placeholder="Enter Email" name="email" />
                        </div>
                        <div class="col-md-6">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="">Phone</span>
                            </label>
                            <!--end::Label-->
                            <input required type="text" class="form-control " placeholder="Enter Phone" name="phone" />
                        </div>
                    </div>
                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

@endsection
