@extends('layouts.app')
@section('title', 'Clients')

@section('content')
<style>
    .form-check-cover.active {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.8), rgba(255, 255, 255, 0.8)), #93D500;
    }

    .form-check-input:checked {
        border-color: #93d500;
    }
    
    
    
</style>
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-7 pt-lg-10">
        <!--begin::Toolbar container-->
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <!--begin::Toolbar wrapper-->
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <!--begin::Page title-->
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <!--begin::Title-->
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">CRM</h1>
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                        <li class="breadcrumb-item text-muted">
                            <a href="#!" class="text-muted text-hover-primary">List of all clients and suppliers</a>
                        </li>
                    </ul>
                </div>
                <div class="ms-3 float-end">
                    <a href="{{route('customer.addNew')}}" class="btn btn-primary">Add New Client / Supplier</a>
                </div>
            </div>
            <!--end::Toolbar wrapper-->
        </div>
        <!--end::Toolbar container-->
    </div>
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <div class="card">
                <!--begin::Card header-->
                <div class="card-header border-0 pt-6">
                    <!--begin::Card title-->
                    <div class="d-flex align-items-center">
                        <!--begin::Search-->
                        <div class="d-flex align-items-center justify-between position-relative my-1 me-5">
                            <i class="ki-outline ki-magnifier fs-3 position-absolute ms-5"></i>
                            <input type="text" data-kt-user-table-filter="search" class="form-control form-control-solid w-250px ps-13" placeholder="Search clients" id="mySearch" />
                            
                        </div>
                        <div class="form-check me-5">
                            <input name="third_party" class="form-check-input" type="checkbox" value="1" id="showCustomer" checked />
                            <label class="form-check-label" for="showCustomer">
                                Clients
                            </label>
                        </div>
                        <div class="form-check me-3">
                            <input name="third_party" class="form-check-input" type="checkbox" value="1" id="showSupplier" />
                            <label class="form-check-label" for="showSupplier">
                                Suppliers
                            </label>
                        </div>
                        <!--end::Search-->
                    </div>
                    <!--begin::Card title-->
                    <!--begin::Card toolbar-->
                    
                    <!--end::Card toolbar-->
                </div>
                <!--end::Card header-->
                <!--begin::Card body-->
                <div class="card-body py-4">
                    <!--begin::Table-->
                    <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_table_users">
                        <thead>
                            <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">

                                <th class="min-w-125px">Name</th>
                                <th class="min-w-100px">Address</th>
                                <th class="min-w-100px">Email</th>
                                <th class="min-w-100px">Phone</th>
                                <th class="min-w-100px">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="text-gray-600 fw-semibold">
                            @foreach($customers as $customer)
                            <tr class="{{ $customer->type }}">
                                <td class="d-flex align-items-center">
                                    <!--begin:: Avatar -->
                                    <div class="symbol symbol-circle symbol-50px overflow-hidden me-3">
                                        <a href="{{route('customer.details', ['id' => $customer->id])}}">
                                            <div class="symbol-label">
                                                <img src="{{asset('img/customers/'.$customer->image)}}" class="w-100" />
                                            </div>
                                        </a>
                                    </div>
                                    <!--begin::User details-->
                                    <div class="d-flex flex-column">
                                        <a href="{{route('customer.details', ['id' => $customer->id])}}" class="text-gray-800 text-hover-primary mb-1">{{ $customer->company_name }}</a>
                                        <small>@if($customer->type=='customer') Client @else Supplier @endif</small>
                                    </div>
                                    <!--begin::User details-->
                                </td>
                                <td>
                                    {{ $customer->address_1 }}
                                </td>
                                <td>
                                    {{ $customer->email }}
                                </td>
                                <td>
                                    {{ $customer->phone }}
                                </td>
                                <td class="">
                                    <a href="#" class="btn btn-light btn-active-light-primary btn-flex btn-center btn-sm" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">Actions
                                        <i class="ki-outline ki-down fs-5 ms-1"></i></a>
                                    <!--begin::Menu-->
                                    <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-125px py-4" data-kt-menu="true">
                                        <div class="menu-item px-3">
                                            <a href="{{route('customer.projects', ['id' => $customer->id])}}" class="menu-link px-3">Projects</a>
                                            <a href="{{route('customer.details', ['id' => $customer->id])}}" class="menu-link px-3">View/Edit</a>
                                            <a href="messages?attorney_id=" class="menu-link px-3">Delete</a>
                                        </div>
                                        <!--begin::Menu item-->

                                        <!--end::Menu item-->
                                        <!--begin::Menu item-->

                                        <!--end::Menu item-->
                                    </div>
                                    <!--end::Menu-->
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <!--end::Table-->
                </div>
                <!--end::Card body-->
            </div>
        </div>
    </div>
    <!--end::Content-->
</div>
@endsection


@section('js')
<script>
    
var customer = 1;
var supplier = 0;
    
$(document).ready(function() {
    $(".supplier").hide();
});
    
$("#showSupplier").click(function(){
    if($(this).is(':checked')){
        $(".supplier").show();
        supplier = 1;
    }else{
        $(".supplier").hide();
        supplier = 0;
    }
    changePlaceHolder();
});
    
$("#showCustomer").click(function(){
    if($(this).is(':checked')){
        $(".customer").show();
        customer = 1;
    }else{
        $(".customer").hide();
        customer = 0;
    }
    changePlaceHolder();
});

function changePlaceHolder(){
    var message = "";
    if(customer==1 && supplier==0){
        message = 'Seach clients';
    }else if(customer==1 && supplier==1){
        message = 'Seach clients and suppliers';
    }else if(customer==0 && supplier==1){
        message = 'Seach suppliers';
    }
    
    $("#mySearch").attr('placeholder', message);
}
    
var table = $("#kt_table_users").DataTable({
    "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
    "paging": false,//Dont want paging                
    "bPaginate": false,//Dont want paging
});

$('#mySearch').on('input', function() {
  table.search($(this).val()).draw();
})
</script>
@endsection