@extends('layouts.app')
@section('title', 'Contract of Employment')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <!--begin::Toolbar-->
    <style>
        .bg-danger-2 {
            background: #ffcccc;
            border-color: #ffcccc;
        }


        table.table-bordered.dataTable {
            border: 0;
            border-bottom: 0;
        }

        .bg-success-2 {
            background: #D2EA8E;
        }

        .text-red {
            color: red !important;
        }

        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }

        .table td,
        .table th {
            vertical-align: middle;
        }

        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            text-align: center;
            color: #727879;
        }



        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }

        table.dataTable.no-footer {
            border-bottom: 0 !important;
        }
        
        
        .side-nav{
            padding: 15px;
            font-weight: 300 !important;
        }
       
        
        .text-gray-800{
            color: #556171 !important;
        }
        
         .active{
            background: #f0f6e1;
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
            border-bottom: 2px solid #93D500;
            font-weight: 600 !important;
            color: black !important;
        }
        
       .active .text-gray-800{
            color: black !important;
        }
        
        .text-gray{
            color: #556171 !important;
        }
        
        #pdf-container {
            width: 100%;

            position: relative;
        }

        #pdf-canvas {
            width: 100%;
            height: auto;
        }
        
        .loading-text{
            display: none;
        }

    </style>
    <!--end::Toolbar-->
    <!--begin::Content-->
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            @if(session('success'))
            <div class="col-md-12">
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            </div>
            @endif
            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif
            <div class="row">
               <div class="col-md-4">
                   @include('hr.sidenav')
               </div>
                <div class="col-md-8">
                    <div class="card">
                        <!--begin::Card header-->
                        <div class="card-header border-0 pt-6">
                            <!--begin::Card title-->
                            <div class="card-title justify-content-between">
                                <div class="d-flex align-items-center">
                                    <h3 class="fw-bold"> Contract of Employment</h3>

                                </div>




                            </div>
                            <div class="d-flex align-items-center">
                                <button id="upload_pdf" class="ms-5 btn btn-primary"><i class="fa fa-upload"></i> Upload PDF </button>
                            </div>
                            <!--begin::Card title-->
                            <!--begin::Card toolbar-->

                            <!--end::Card toolbar-->
                        </div>
                        <!--end::Card header-->
                        <!--begin::Card body-->
                        <div class="card-body py-4">
                            <div class="">
                        <div class="border">
                            <div id="pdf-container">
                                <!-- Pages will be appended here dynamically -->
                            </div>

                            <div id="loading" class="loading-text text-center p-3">
                                Loading PDF...
                            </div>
                        </div>
                    </div>
                        </div>
                        <!--end::Card body-->
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>

<div class="modal fade" id="uploadPdfModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form enctype="multipart/form-data" method="POST" class="form" action="{{ route('hr.uploadContract', ['id'=>$user->id]) }}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Upload PDF</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    
                    
                    
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Select Document</span>
                        </label>
                        <!--end::Label-->
                        <input type="file" class="form-control" name="document" required>
                    </div>
                    
                    
                    






                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

@include('hr.footer')


@endsection

@section('js')
@include('hr.footer')
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.9.359/pdf.min.js"></script>
<script>
    
    $("#upload_pdf").click(function() {
        $("#uploadPdfModal").modal("show");
    });
    
     
            var pdfUrl = "{{ asset('documents/'.$user->contract) }}";


            pdfjsLib.getDocument(pdfUrl).promise.then(pdf => {
                const pdfContainer = document.getElementById('pdf-container');
                const loadingMessage = document.getElementById('loading');
                
                // Function to render a page
                const renderPage = pageNumber => {
                    pdf.getPage(pageNumber).then(page => {
                        const scale = 0.8;
                        const viewport = page.getViewport({ scale: scale });
    
                        const canvas = document.createElement('canvas');
                        const context = canvas.getContext('2d');
                        canvas.height = viewport.height;
                        canvas.width = viewport.width;
                        pdfContainer.appendChild(canvas);
    
                        const renderContext = {
                            canvasContext: context,
                            viewport: viewport
                        };
    
                        page.render(renderContext).promise.then(() => {
                            if (pageNumber === pdf.numPages) {
                                loadingMessage.style.display = 'none';
                                pdfContainer.style.display = 'block';
                            }
                        });
                    });
                };
    
                // Loop through each page and render it
                for (let pageNum = 1; pageNum <= pdf.numPages; pageNum++) {
                    renderPage(pageNum);
                }
            });

            


</script>
@endsection
