@extends('layouts.app')
@section('title', 'Documents')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <!--begin::Toolbar-->
    <style>
        .bg-danger-2 {
            background: #ffcccc;
            border-color: #ffcccc;
        }


        table.table-bordered.dataTable {
            border: 0;
            border-bottom: 0;
        }

        .bg-success-2 {
            background: #D2EA8E;
        }

        .text-red {
            color: red !important;
        }

        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }

        .table td,
        .table th {
            vertical-align: middle;
        }

        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            text-align: center;
            color: #727879;
        }



        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }

        table.dataTable.no-footer {
            border-bottom: 0 !important;
        }
        
        .side-nav{
            padding: 15px;
            font-weight: 300 !important;
        }
       
        
        .text-gray-800{
            color: #556171 !important;
        }
        
         .active{
            background: #f0f6e1;
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
            border-bottom: 2px solid #93D500;
            font-weight: 600 !important;
            color: black !important;
        }
        
        .notify-box{
             background: #F0F0F0;
            border-radius: 4px;
        }
        
        .active-notify{
             background: #f0f6e1;
        }
        
       .active .text-gray-800{
            color: black !important;
        }
        
        .text-gray{
            color: #556171 !important;
        }
        
   
         .btn-outline i{
            color: #93D500 !important;
            font-size: 18px;
        }
        
        .btn-outline:hover{
            color: black !important;
        }
        
        .btn-outline:hover i{
            color: black !important;
        }
        .document-box{
            background: #FAFAFA;
            border-radius: 10px;
            border: 1px solid #E1E1E1;
        }
        
        .form-switch.form-check-solid .form-check-input:not(:checked) {
    background-color: #78829D;
}
        .btn-outline{
            border: 1px dashed #93D500 !important;
            background: #F5FFE0 !important;
            color: #93D500 !important;
        }
        
    </style>
    <!--end::Toolbar-->
    <!--begin::Content-->
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            @if(session('success'))
            <div class="col-md-12">
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            </div>
            @endif
            <div class="row g-5 g-xl-10 mb-xl-10">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            @include('hr.head')
                            
                        </div>
                    </div>
                </div>


            </div>
            <div class="row">
                <div class="col-md-4">
                @include('hr.sidenav')
                </div>
                <div class="col-md-8">
                    <div class="card">

                        <div class="card-body py-5">
                            <h3 class="mb-8 text-gray">Documents  <span class="float-end"><button  class="add-document btn btn-primary btn-sm">Add Document</button></span></h3>
                            <div class="row">
                                 <div class="col-md-12">
                                     @foreach($documents as $document)
                                     <div class="document-box p-3 mb-4">
                                         <div class="me-4 float-start">
                                             <img src="{{ asset('img/icons/license.svg') }}" alt="">
                                         </div>
                                         <div>
                                             <div class="row mb-5">
                                                 <div class="col-md-5">
                                                     <h3 class="mb-0">{{ $document->name }}</h3>
                                                     <p class="text-gray">{{ date('d M, Y H:i', strtotime($document->created_at)) }}</p>
                                                 </div>
                                                 <div class="col-md-5">
                                                      <p class="text-gray mb-0">Expiry Date</p>
                                                     <h3 class="mb-0">{{ date('d M, Y', strtotime($document->expiry_date)) }}</h3>
                                                    
                                                 </div>
                                                 <div class="col-md-2">
                                                     <div class="float-end"><a target="_blank" href="{{asset('documents/'.$document->file)}}"><i class="fa fa-download" style="font-size:20px"></i></a></div>
                                                 </div>
                                             </div>
                                             <div class="row">
                                                 <div class="col-md-12">
                                                     <div id="notify_box_{{$document->id}}" class="notify-box @if($document->notify==1) active-notify @endif p-3 mb-3">
                                                         <p class="fw-bold mb-0">Notify before Expiry?
                                                             <span class="float-end">
                                                                 <label class="form-check form-switch form-check-custom form-check-solid" id="showProjects">
                                                                     <input data-id="{{ $document->id }}" @if($document->notify==1) checked @endif class="form-check-input notify-switch w-30px h-20px" type="checkbox" value="1" name="" id="">

                                                                 </label>
                                                             </span>
                                                         </p>

                                                     </div>
                                                     <div id="staff_members_{{$document->id}}" class="staff-members" style="@if($document->notify==0) display:none @endif">
                                                         @foreach($document->staff as $staff)
                                                             <div class="card mb-3">
                                                                 <div class="p-3">
                                                                     <p class="mb-0 fw-bold">
                                                                     <img src="{{asset('img/default.png')}}" width="30px" />
                                                                     <span class="ms-2">{{ $staff->firstname }}  {{ $staff->lastname }}</span>
                                                                     <span class="float-end text-gray">{{ $staff->email }}</span>
                                                                     </p>
                                                                 </div>
                                                             </div>
                                                         @endforeach
                                                         <button data-id="{{ $document->id }}" class="btn btn-primary add-staff btn-outline w-100"><i class="ki-duotone ki-plus-circle fs-1"><span class="path1"></span><span class="path2"></span></i> Add Staff Members</button>
                                                     </div>
                                                 </div>
                                             </div>
                                         </div>
                                     </div>
                                     @endforeach
                                 </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>

<div class="modal fade" id="staffModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{ route('hr.addDocumentStaff', ['id'=>$user->id]) }}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add Staff Member</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    
                    
                    <input type="hidden" name="document_id" id="document_id">
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Select Staff Member</span>
                        </label>
                        <!--end::Label-->
                        <select required name="staff_id" class="form-select">
                            <option value="">Select</option>
                            @foreach($staffs as $staff)
                            <option value="{{ $staff->id }}">{{ $staff->firstname }} {{ $staff->lastname }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    
                    






                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

<div class="modal fade" id="addDocumentModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form enctype="multipart/form-data" method="POST" class="form" action="{{ route('hr.addDocument', ['id'=>$user->id]) }}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add Document</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    
                    
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Document Title</span>
                        </label>
                        <!--end::Label-->
                        <input type="text" class="form-control" name="title" required>
                    </div>
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Expiry Date</span>
                        </label>
                        <!--end::Label-->
                        <input type="date" class="form-control" name="expiry_date" required>
                    </div>
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Select Document</span>
                        </label>
                        <!--end::Label-->
                        <input type="file" class="form-control" name="document" required>
                    </div>
                    
                    
                    






                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


@include('hr.footer')
@endsection

@section('js')
@include('hr.scripts')
<script>
    
    toastr.options = {
      "closeButton": false,
      "debug": false,
      "newestOnTop": false,
      "progressBar": false,
      "positionClass": "toastr-top-right",
      "preventDuplicates": false,
      "onclick": null,
      "showDuration": "300",
      "hideDuration": "1000",
      "timeOut": "5000",
      "extendedTimeOut": "1000",
      "showEasing": "swing",
      "hideEasing": "linear",
      "showMethod": "fadeIn",
      "hideMethod": "fadeOut"
    };
    
    $(".notify-switch").click(function() {
        var id = $(this).data('id');
        if($(this).is(':checked')){
            var switch_status = 1;
        }else{
            var switch_status = 0;
        }
        $.ajax({
            url: "{{ route('hr.enableNotify', ['id'=>$user->id]) }}",
            type: 'POST',
            data: {
                document_id: id,
                switch_status: switch_status,
                _token: '{{ csrf_token() }}'
            },
            success: function(response){
                if(switch_status==1){
                    $("#notify_box_"+id).addClass('active-notify');
                    $("#staff_members_"+id).show();
                    toastr.success('Enabled successfully.');
                }else{
                    $("#notify_box_"+id).removeClass('active-notify');
                    $("#staff_members_"+id).hide();
                    toastr.success('Disabled successfully.');
                }
            },
            error: function(response){
                alert('Error: ' + response.responseJSON.message);
            }
        });
        
    });
    
    $(".add-document").click(function() {
        $("#addDocumentModal").modal("show");
    });
    
    $(".add-staff").click(function() {
        var id = $(this).data('id');
        $('#document_id').val(id);
        $("#staffModal").modal("show");
    });
</script>
@endsection