@extends('layouts.app')
@section('title', 'User Details')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <!--begin::Toolbar-->
    <style>
        .bg-danger-2 {
            background: #ffcccc;
            border-color: #ffcccc;
        }


        table.table-bordered.dataTable {
            border: 0;
            border-bottom: 0;
        }

        .bg-success-2 {
            background: #D2EA8E;
        }

        .text-red {
            color: red !important;
        }

        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }

        .table td,
        .table th {
            vertical-align: middle;
        }

        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            text-align: center;
            color: #727879;
        }



        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }

        table.dataTable.no-footer {
            border-bottom: 0 !important;
        }
        
        .side-nav{
            padding: 15px;
            font-weight: 300 !important;
        }
       
        
        .text-gray-800{
            color: #556171 !important;
        }
        
         .active{
            background: #f0f6e1;
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
            border-bottom: 2px solid #93D500;
            font-weight: 600 !important;
            color: black !important;
        }
        
       .active .text-gray-800{
            color: black !important;
        }
        
        .text-gray{
            color: #556171 !important;
        }
        
    </style>
    <!--end::Toolbar-->
    <!--begin::Content-->
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            @if(session('success'))
            <div class="col-md-12">
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            </div>
            @endif
            <div class="row g-5 g-xl-10 mb-xl-10">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            @include('hr.head')
                            
                        </div>
                    </div>
                </div>


            </div>
            <div class="row">
                <div class="col-md-4">
                @include('hr.sidenav')
                </div>
                <div class="col-md-8">
                    <div class="card">

                        <div class="card-body py-5">
                            
                            <form method="POST" class="form" action="{{route('hr.updateUser', ['id'=>$user->id])}}" id="userForm">
                                <!--begin::Heading-->
                                @csrf
                                <h3 class="mb-8 text-gray">Edit Personal Info <span class="float-end"><button  class="btn btn-primary btn-sm">Save</button></span></h3>
                                <!--end::Heading-->
                                <!--begin::Input group-->
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">First Name</span>
                                            </label>
                                            <!--end::Label-->
                                            <input required type="text" class="form-control " placeholder="Enter First Name" name="firstname" value="{{$user->firstname}}" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">Last Name</span>
                                            </label>
                                            <!--end::Label-->
                                            <input required type="text" class="form-control " placeholder="Enter Last Name" name="lastname" value="{{$user->lastname}}" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">Email Address</span>
                                            </label>
                                            <!--end::Label-->
                                            <input required type="email" class="form-control " placeholder="Enter Email" name="email" value="{{$user->email}}" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">Mobile Number</span>
                                            </label>
                                            <!--end::Label-->
                                            <input required type="text" class="form-control " placeholder="Enter Phone" name="phone" value="{{$user->phone}}" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                   
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="">Date of Birth</span>
                                            </label>
                                            <!--end::Label-->
                                            <input type="date" class="form-control" name="dob" value="{{$user->dob}}">
                                        </div>
                                    </div>
                                     <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="">Marital Status</span>
                                            </label>
                                            <!--end::Label-->
                                            <select name="marital_status" class="form-select" id="marital_status">
                                                <option value="">Select</option>
                                                <option value="married">Married</option>
                                                <option value="unmarried">Unmarried</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                   
                                    
                                     <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="">Gender</span>
                                            </label>
                                            <!--end::Label-->
                                            <select name="gender" class="form-select" id="gender">
                                                <option value="">Select</option>
                                                <option value="male">Male</option>
                                                <option value="female">Female</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="">Nationality</span>
                                            </label>
                                            <!--end::Label-->
                                            <input type="text" class="form-control " placeholder="" name="nationality" value="{{ $user->nationality }}" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                   
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="">Address</span>
                                            </label>
                                            <!--end::Label-->
                                            <input type="text" class="form-control " placeholder="" name="address" value="{{ $user->address }}" />
                                        </div>
                                    </div>
                                     <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="">City</span>
                                            </label>
                                            <!--end::Label-->
                                            <select name="city" class="form-select" id="city">
                                                <option value="">Select</option>
                                                <option value="london">London</option>
                                            </select>
                                        </div>
                                    </div>
                                    
                                </div>
                                
                                <div class="row">
                                   <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="">Country</span>
                                            </label>
                                            <!--end::Label-->
                                            <select name="country" class="form-select" id="country">
                                                <option value="">Select</option>
                                                <option value="uk">UK</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="">Postcode</span>
                                            </label>
                                            <!--end::Label-->
                                            <input type="text" class="form-control " placeholder="" name="postcode" value="{{ $user->postcode }}" />
                                        </div>
                                    </div>
                                     
                                    
                                </div>
                               
                                
                                
                                




                            </form>
                            
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>

<form method="post" action="{{route('dashboard.unlike')}}" id="unlikeForm" style="display:none">
    @csrf
    <input type="hidden" name="project_id" id="project_id">
</form>
@include('hr.footer')


@endsection

@section('js')
@include('hr.footer')
<script>
    $("#city").val('{{$user->city}}');
    $("#country").val('{{$user->country}}');
    $("#gender").val('{{$user->gender}}');
    $("#marital_status").val('{{$user->marital_status}}');
</script>
@endsection