@extends('layouts.app')
@section('title', 'Holidays')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <!--begin::Toolbar-->
    <style>
        .calendar-container {
            max-width: 800px;
            margin: 0 auto;
            text-align: center;
        }

        .navigation a {
            margin: 0 10px;
            text-decoration: none;
            color: #000;
        }

        .calendar-table {
            width: 100%;
            border-collapse: collapse;
            table-layout: fixed;
        }

        .calendar-table th {
            border: 3px solid #f1f5f5 !important;
            background: #E3E3E3;
            color: black !important;
            padding-top: 10px;
            padding-bottom: 10px;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }

        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }

        .calendar-table td {
            background: white;
            border: 3px solid #f1f5f5 !important;
            padding-top: 50px;
            padding-bottom: 50px;
            color: black !important;
            text-align: center;
            color: #727879;
        }

        .red {
            background-color: #FF0000;
            color: #FFF;
        }

        .orange {
            background-color: #FFA500;
            color: #FFF;
        }
        
        td.previous-month, td.next-month {
            background-color: #E1E1E1;
            color: #aaa;
        }

        .day {
            font-size: 20px;
            font-weight: 500;
        }

    </style>
    <!--end::Toolbar-->
    <!--begin::Content-->
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            @if(session('success'))
            <div class="col-md-12">
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            </div>
            @endif
            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif
            <div class="row g-5 g-xl-10 mb-xl-10">
                <div class="col-md-12">
                   <div class="nav-buttons mb-4">
                       <a href="{{ route('hr.showHolidays', ['action' => 'prev', 'year' => $year, 'month' => $month]) }}" class="btn btn-sm btn-icon btn-primary">
                            <i class="ki-duotone ki-left fs-1"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span></i>
                        </a>

                        <span class="mb-0 fw-bold mx-4" style="color:#5E5E5E">{{ $monthName }}</span>
                        <a href="{{ route('hr.showHolidays', ['action' => 'next', 'year' => $year, 'month' => $month]) }}" class="btn btn-icon btn-sm  btn-primary">
                            <i class="ki-duotone ki-right fs-1"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span></i>
                        </a>
                 
                    </div>
                    <div class="">
                        <div class="card-body">
                            <div class="">
                                <table class="calendar-table">
                                    <thead>
                                        <tr>
                                            <th>MON</th>
                                            <th>TUE</th>
                                            <th>WED</th>
                                            <th>THU</th>
                                            <th>FRI</th>
                                            <th>SAT</th>
                                            <th>SUN</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($calendar as $week)
                                            <tr>
                                                @foreach($week as $day)
                                                    @php
                                                        $class = '';
                                                        if ($day->month < $firstDayOfMonth->month) {
                                                            $class = 'previous-month';
                                                        } elseif ($day->month > $lastDayOfMonth->month) {
                                                            $class = 'next-month';
                                                        } else {
                                                            $class = 'current-month';
                                                        }
                                                        
                                                        
                                                        $absents = \App\Http\Controllers\HrController::getAbsents($day->format('Y-m-d'))
                                                    @endphp
                                                    <td class="{{ $class }}" style="position:relative">
                                                        <span class="day">{{ $day->day }} <br>@if($absents->count()!=0)
                                                        <div style="font-size:12px" class="text-danger">{{ $absents->count() }} 
                                                       @if($absents->count()==1) Person @else People @endif 
                                                        
                                                        Absent
                                                        @endif</span>
                                                        <br>
                                                        
                                                        <div style="position:absolute;left:0;right:0;bottom:10px">
                                                        <div class="symbol-group symbol-hover justify-content-center flex-nowrap mt-3">
                                                        @foreach($absents as $absent)
                                                            @if($absent->type=='full')
                                                                @php $absentTime = '('.date('d M, Y', strtotime($absent->from_date)).' - '. date('d M, Y', strtotime($absent->to_date)) .')'; @endphp
                                                            @else
                                                                @php $absentTime = '('. date('d M, Y', strtotime($absent->from_date)) .'  (Half Day - '. strtoupper($absent->time) .')'; @endphp
                                                            @endif
                                                        
                                                        <div class="symbol draggable-2 symbol-35px mt-5 symbol-circle" data-bs-toggle="tooltip" aria-label="Michael Eberon" data-bs-original-title="{{ $absent->firstname.' '.$absent->lastname }} {{ $absentTime }}" data-kt-initialized="1">
                                                            <img alt="Pic" src="{{asset('img/users/'.$absent->image)}}">
                                                        </div>
                                                        @endforeach
                                                            </div>
                                                        </div>
                                                        </div>
                                                        
                                                        
                                                        
                                                        
                                                        
                                                    </td>
                                                @endforeach
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>


                            </div>
                        </div>
                    </div>
                </div>

            </div>


        </div>
    </div>
    <!--end::Content-->
</div>




@endsection

@section('js')
<script>
    
    $(function() {
        $('[data-bs-toggle="tooltip"]').tooltip();
    });
    
    $("#upload_pdf").click(function() {
        $("#uploadPdfModal").modal("show");
    });

</script>
@endsection
