@extends('layouts.app')
@section('title', 'PPE Register')

@section('content')
<style>
    .text-gray {
        color: #556171 !important;
    }

    body,
    #kt_app_header {
        background: #f1f5f5 !important;
    }

    .table td,
    .table th {
        vertical-align: middle;
    }

    .table td {


        
        color: black !important;
        text-align: center;
        color: #727879;
    }



    .table th {

        background: #E3E3E3;
        color: black !important;
        font-weight: 600;
        font-size: 12px;
        margin: 10px !important;
        text-align: center;
    }

    table.dataTable.no-footer {
        border-bottom: 0 !important;
    }


    .side-nav {
        padding: 15px;
        font-weight: 300 !important;
    }


    .text-gray-800 {
        color: #556171 !important;
    }

    .active {
        background: #f0f6e1;
        border-top-left-radius: 10px;
        border-top-right-radius: 10px;
        border-bottom: 2px solid #93D500;
        font-weight: 600 !important;
        color: black !important;
    }

    .active .text-gray-800 {
        color: black !important;
    }

    .text-gray {
        color: #556171 !important;
    }

    .btn-outline {
        border: 1px dashed #93D500 !important;
        background: #F5FFE0 !important;
        color: #93D500 !important;
    }

    .btn-outline i {
        color: #93D500 !important;
    }

    .btn-outline:hover {
        color: black !important;
    }

    .btn-outline:hover i {
        color: black !important;
    }

</style>
<div class="d-flex flex-column flex-column-fluid">

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif

            <div class="row">
                <div class="col-md-4">
                    @include('hr.sidenav')
                </div>
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-body">
                            <h3 class="fw-bold text-gray mb-5"> PPE Register </h3>
                            <div style="border-radius:10px">
                                <table class="table table-striped">
                                    <thead>
                                        <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                            <th class="min-w-125px">Workwear</th>
                                            <th class="min-w-100px">Receiving</th>
                                            <th class="min-w-100px">Receiving Date</th>
                                        </tr>
                                    </thead>
                                    <tbody class="">
                                        @foreach($workwears as $workwear)
                                            <tr>
                                                <td>
                                                    <div class="text-center">
                                                        <b>{{ $workwear->name }}</b>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center">
                                                        <div class="form-check">
                                                            <input @if($workwear->received==1) checked disabled @endif class="form-check-input receiveWorkwear" type="checkbox" data-id="{{ $workwear->id }}" id="" />

                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                @if(!empty($workwear->received_date))
                                                {{ date('jS M, Y', strtotime($workwear->received_date)) }}
                                                @else
                                                -
                                                @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                <button onclick='$("#addWorkwearModal").modal("show");' class="btn btn-primary btn-outline w-100"><i class="ki-duotone ki-plus-circle fs-1"><span class="path1"></span><span class="path2"></span></i> Add Workwear</button>
                            </div>
                            
                            
                            <div class="mt-8" style="border-radius:10px">
                                <table class="table table-striped">
                                    <thead>
                                        <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                            <th class="min-w-125px">PPE</th>
                                            <th class="min-w-100px">Receiving</th>
                                            <th class="min-w-100px">Receiving Date</th>
                                        </tr>
                                    </thead>
                                    <tbody class="">
                                        @foreach($ppes as $ppe)
                                            <tr>
                                                <td>
                                                    <div class="text-center">
                                                        <b>{{ $ppe->name }}</b>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center">
                                                        <div class="form-check">
                                                            <input @if($ppe->received==1) checked disabled @endif class="form-check-input receivePPE" type="checkbox" data-id="{{ $ppe->id }}" id="" />

                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                @if(!empty($ppe->received_date))
                                                {{ date('jS M, Y', strtotime($ppe->received_date)) }}
                                                @else
                                                -
                                                @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                <button onclick='$("#addPPEModal").modal("show");' class="btn btn-primary btn-outline w-100"><i class="ki-duotone ki-plus-circle fs-1"><span class="path1"></span><span class="path2"></span></i> Add PPE</button>
                            </div>
                            
                        </div>
                        <!--end::Card body-->
                    </div>
                </div>
            </div>


        </div>
    </div>
    <!--end::Content-->
</div>

<div class="modal fade" id="addWorkwearModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('hr.addWorkwear', ['id'=>$user->id])}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add Workwear</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Name</span>
                        </label>
                        <!--end::Label-->
                        <input required type="text" class="form-control" name="name" />
                    </div>
                    


                    
                    

                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


<div class="modal fade" id="addPPEModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('hr.addPPE', ['id'=>$user->id])}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add PPE</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Name</span>
                        </label>
                        <!--end::Label-->
                        <input required type="text" class="form-control" name="name" />
                    </div>
                    


                    
                    

                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

<form method="post" action="{{ route('hr.updateWorkwear', ['id'=>$user->id]) }}" id="receivedWorkwearForm">
    @csrf
    <input type="hidden" name="workwear_id" id="workwear_id">
</form>

<form method="post" action="{{ route('hr.updatePPE', ['id'=>$user->id]) }}" id="receivedPPEForm">
    @csrf
    <input type="hidden" name="ppe_id" id="ppe_id">
</form>

@include('hr.footer')
@endsection


@section('js')
@include('hr.footer')
<script>
    
    $(".receiveWorkwear").click(function() {
        var id = $(this).data('id'); 
        $("#workwear_id").val(id);
        if($(this).is(":checked")){
            $("#receivedWorkwearForm").submit();
        }
    });
    
    $(".receivePPE").click(function() {
        var id = $(this).data('id'); 
        $("#ppe_id").val(id);
        if($(this).is(":checked")){
            $("#receivedPPEForm").submit();
        }
    });
    
    $(".edit").click(function() {
        var $row = $(this).closest('tr');
        var id = $(this).data('id');
        $("#e_code").val($row.find('.tr_code').text());
        $("#e_description").val($row.find('.tr_description').text());
        $("#e_labour").val($row.find('.tr_labour').text());
        $("#e_material").val($row.find('.tr_material').text());
        $("#e_plant").val($row.find('.tr_plant').text());
        $("#e_id").val(id);
        $("#editModal").modal("show");
    });

    var table = $("#kt_table_users").DataTable({
        "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
        "paging": false, //Dont want paging                
        "bPaginate": false, //Dont want paging
    });

</script>
@endsection
