<link rel="stylesheet" href="https://foliotek.github.io/Croppie/croppie.css">
<script src="https://foliotek.github.io/Croppie/croppie.js"></script>
<script>
    
    var image = "";
    
    function initCroppie(img){
        image = img;
        $("#cropImagePop").modal("show");
    }
    
    var croppieInstance;
    
    $('#cropImagePop').on('shown.bs.modal', function () {
        croppieInstance = $('#croppie').croppie({
            viewport: { width: 200, height: 200 },
            boundary: { width: 300, height: 300 },
            showZoomer: true
        });
        
        croppieInstance.croppie('bind', {
            url: image,
        }).then(function () {
            console.log('Image successfully loaded into Croppie');

            // Show the Croppie container after binding the image
            $('#cropImagePop').modal('show');
        });
    });
    
    $(document).ready(function () {
        $('#select_logo').on('change', function () {
            var reader = new FileReader();
            reader.onload = function (e) {
                initCroppie(e.target.result);
            }
            reader.readAsDataURL(this.files[0]);
        });
    });
    
    $('#cropImageBtn').on('click', function(ev) {
        croppieInstance.croppie('result', {
            type: 'base64',
            format: 'jpeg',
            size: {
                width: 250,
                height: 250
            }
        }).then(function(resp) {
            $.ajax({
                url: "{{ route('settings.uploadUserImage', ['id'=>$user->id]) }}",
                type: "POST",
                data: {
                    image: resp,
                    _token: '{{ csrf_token() }}',
                },
                success: function(data) {
                    $(".user-img").attr('src', '{{ asset("img/users") }}' +'/'+ data.image_url);
                    $('#cropImagePop').modal('hide');
                }
            });
        });
    });
</script>