<!DOCTYPE html>
<html lang="en">

<head>
    <title>@yield('title')</title>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta property="og:locale" content="en_US" />

    <link rel="shortcut icon" href="{{asset('media/logos/favicon.ico')}}" />
    <!--begin::Fonts(mandatory for all pages)-->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700" />
    <!--end::Fonts-->
    <!--begin::Vendor Stylesheets(used for this page only)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{asset('plugins/custom/vis-timeline/vis-timeline.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Vendor Stylesheets-->
    <!--begin::Global Stylesheets Bundle(mandatory for all pages)-->
    <link href="{{asset('plugins/global/plugins.bundle.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{asset('css/style.bundle.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{asset('css/custom.css')}}?{{time()}}" rel="stylesheet" type="text/css" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Fredoka:wght@300..700&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">
    <!--end::Global Stylesheets Bundle-->
    <script>
        // Frame-busting to prevent site from being loaded within a frame without permission (click-jacking) if (window.top != window.self) { window.top.location.replace(window.self.location.href); }
    </script>
    @yield('css')
    <style>
        
        body{
            font-family: "Roboto", sans-serif !important;
        }
        
        .h-250px {
            height: 200px !important;
        }

        /*.card-body {
            padding: 10px !important;
        }*/
        
        .menu-title{
            font-weight: 400 !important;
            font-size: 18px !important;
            color: #556171 !important; 
        }
        
        .menu-sub .menu-title{
            font-size: 15px !important;
        }
        
        .menu-link.active .menu-title{
            font-weight: 500 !important;
            color: white !important;
            font-family: "Roboto", sans-serif !important;
            font-size: 14px !important;
            padding-top: 5px;
            padding-bottom: 5px;
        }
        
        .menu-link .menu-title{
            font-weight: 500 !important;
            color: black !important;
            font-family: "Roboto", sans-serif !important;
            font-size: 14px !important;
        }
        
        .menu-item{
            margin-bottom: 10px;
        }
        
        /*.menu-link.active .menu-icon .ki-outline {
            color: black !important; 
        }*/
        
        .bg-danger-2{
            background: #ffcccc;
        }
        
        .text-primary {
            color: #93D500 !important;
        }
        
        .bg-success-2{
            background: #D2EA8E;
        }
        
        .page-heading{
            font-size: 24px !important;
        }
        
        .form-control, .form-select{
            background: rgba(147, 213, 0, 0.1);
            border-color: rgba(147, 213, 0, 0.1);
        }
        
        .search-input{
            background: white;
        }
        
        .form-check-input:checked{
            background-color: #93d500;
        }
        

        
        .menu-sub-accordion{
            padding: 1rem;
        }
        
        .menu-sub .menu-item .menu-link{
            background: white;
            margin-bottom: 5px;
        }
        
        .menu-bullet{
            display: none !important;
        }
        
        .menu-sub-accordion{
            
        }
        
        .menu-sub-indention .menu-item .menu-item .menu-link.active{
            margin-right: 0;
        }
        

        
    </style>
</head>
<!--end::Head-->
<!--begin::Body-->

<body id="kt_app_body" data-kt-app-header-fixed="true" data-kt-app-header-fixed-mobile="true" data-kt-app-sidebar-enabled="true" data-kt-app-sidebar-fixed="true" data-kt-app-sidebar-hoverable="true" data-kt-app-sidebar-push-header="true" data-kt-app-sidebar-push-toolbar="true" data-kt-app-sidebar-push-footer="true" data-kt-app-toolbar-enabled="true" class="app-default">
    <!--begin::Theme mode setup on page load-->
    <script>
        var defaultThemeMode = "light";
        var themeMode;
        if (document.documentElement) {
            if (document.documentElement.hasAttribute("data-bs-theme-mode")) {
                themeMode = document.documentElement.getAttribute("data-bs-theme-mode");
            } else {
                if (localStorage.getItem("data-bs-theme") !== null) {
                    themeMode = localStorage.getItem("data-bs-theme");
                } else {
                    themeMode = defaultThemeMode;
                }
            }
            if (themeMode === "system") {
                themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light";
            }
            document.documentElement.setAttribute("data-bs-theme", themeMode);
        }
    </script>
    <!--end::Theme mode setup on page load-->
    <!--begin::App-->
    <div class="d-flex flex-column flex-root app-root" id="kt_app_root">
        <!--begin::Page-->
        <div class="app-page flex-column flex-column-fluid" id="kt_app_page">
            <!--begin::Header-->
            @include('layouts.header')
            <!--end::Header-->
            <!--begin::Wrapper-->
            <div class="app-wrapper flex-column flex-row-fluid" id="kt_app_wrapper">
                <!--begin::Sidebar-->
                @include('layouts.sidebar')
                
                <!--end::Sidebar-->
                <!--begin::Main-->
                <div class="app-main flex-column flex-row-fluid" id="kt_app_main">
                    <!--begin::Content wrapper-->
                    @yield('content')
                    <!--end::Content wrapper-->
                    <!--begin::Footer-->
                    
                    <!--end::Footer-->
                </div>
                <!--end:::Main-->
            </div>
            <!--end::Wrapper-->
        </div>
        <!--end::Page-->
    </div>
    <!--end::App-->
    <!--begin::Drawers-->
    <!--begin::Activities drawer-->
    <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
        @csrf
    </form>
    <!--end::Chat drawer-->
    <!--end::Drawers-->
    <!--begin::Scrolltop-->
    <div id="kt_scrolltop" class="scrolltop" data-kt-scrolltop="true">
        <i class="ki-outline ki-arrow-up"></i>
    </div>
    
    <script>
        var hostUrl = "assets/";
    </script>
    <!--begin::Global Javascript Bundle(mandatory for all pages)-->
    <script src="{{ asset('plugins/global/plugins.bundle.js') }}"></script>
    <script src="{{ asset('js/scripts.bundle.js') }}"></script>
    <script src="{{ asset('plugins/custom/datatables/datatables.bundle.js') }}"></script>
    <script src="{{ asset('plugins/custom/vis-timeline/vis-timeline.bundle.js') }}"></script>
    <script src="https://cdn.amcharts.com/lib/5/index.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/xy.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/percent.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/radar.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/themes/Animated.js"></script>
    <!--end::Vendors Javascript-->
    <!--begin::Custom Javascript(used for this page only)-->
    <script src="{{ asset('js/widgets.bundle.js') }}"></script>
    <script src="{{ asset('js/custom/widgets.js') }}"></script>
    <script src="{{ asset('js/custom/apps/chat/chat.js') }}"></script>
    <script src="{{ asset('js/custom/utilities/modals/upgrade-plan.js') }}"></script>
    <script src="{{ asset('js/custom/utilities/modals/create-campaign.js') }}"></script>
    <script src="{{ asset('js/custom/utilities/modals/create-project/type.js') }}"></script>
    <script src="{{ asset('js/custom/utilities/modals/create-project/budget.js') }}"></script>
    <script src="{{ asset('js/custom/utilities/modals/create-project/settings.js') }}"></script>
    <script src="{{ asset('js/custom/utilities/modals/create-project/team.js') }}"></script>
    <script src="{{ asset('js/custom/utilities/modals/create-project/targets.js') }}"></script>
    <script src="{{ asset('js/custom/utilities/modals/create-project/files.js') }}"></script>
    <script src="{{ asset('js/custom/utilities/modals/create-project/complete.js') }}"></script>
    <script src="{{ asset('js/custom/utilities/modals/create-project/main.js') }}"></script>
    <script src="{{ asset('js/custom/utilities/modals/create-app.js') }}"></script>
    <script src="{{ asset('js/custom/utilities/modals/new-address.js') }}"></script>
    <script src="{{ asset('js/custom/utilities/modals/users-search.js') }}"></script>
    
    <script>
        $(document).ready(function(){
            $('#notif_btn').click(function(){
                $.ajax({
                    url: "{{ route('settings.readNotifications') }}",
                    type: 'POST',
                    data: {
                        // Any data you want to send
                    },
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        $("#notifs").hide();
                    },
                    error: function(xhr, status, error) {
                        alert('Error sending notification');
                        console.log(xhr.responseText);
                    }
                });
            });
        });
    
    </script>
    
    
    <!--end::Custom Javascript-->
    <!--end::Javascript-->
    @yield('js')
</body>
<!--end::Body-->

</html>