@extends('layouts.app')
@section('title', 'Asset Register')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <!--begin::Toolbar-->
    <style>
        .bg-danger-2 {
            background: #ffcccc;
            border-color: #ffcccc;
        }


        table.table-bordered.dataTable {
            border: 0;
            border-bottom: 0;
        }

        .bg-success-2 {
            background: #D2EA8E;
        }

        .text-red {
            color: red !important;
        }

        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }

        .table td,
        .table th {
            vertical-align: middle;
        }

        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            text-align: center;
            color: #727879;
        }



        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }

        table.dataTable.no-footer {
            border-bottom: 0 !important;
        }
        
        .side-nav{
            padding: 15px;
            font-weight: 300 !important;
        }
       
        
        .text-gray-800{
            color: #556171 !important;
        }
        
         .active{
            background: #f0f6e1;
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
            border-bottom: 2px solid #93D500;
            font-weight: 600 !important;
            color: black !important;
        }
        
        .notify-box{
             background: #F0F0F0;
            border-radius: 4px;
            display: flex;
    align-items: center;
    justify-content: space-between;
        }
        
        .active-notify{
             background: #f0f6e1;
            border: 1px solid #93D50033;
        }
        
       .active .text-gray-800{
            color: black !important;
        }
        
        .text-gray{
            color: #556171 !important;
        }
        
   
         .btn-outline i{
            color: #93D500 !important;
            font-size: 18px;
        }
        
        .btn-outline:hover{
            color: black !important;
        }
        
        .btn-outline:hover i{
            color: black !important;
        }
        .document-box{
            background: #FAFAFA;
            border-radius: 10px;
            border: 1px solid #E1E1E1;
        }
        
        .form-switch.form-check-solid .form-check-input:not(:checked) {
    background-color: #78829D;
}
        .btn-outline{
            border: 1px dashed #93D500 !important;
            background: #F5FFE0 !important;
            color: #93D500 !important;
        }
        
    </style>
    <!--end::Toolbar-->
    <!--begin::Content-->
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            @if(session('success'))
            <div class="col-md-12">
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            </div>
            @endif
            <div class="row g-5 g-xl-10 mb-xl-10">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            @include('hr.head')
                            
                        </div>
                    </div>
                </div>


            </div>
            <div class="row">
                <div class="col-md-4">
                @include('hr.sidenav')
                </div>
                <div class="col-md-8">
                    <div class="card">

                        <div class="card-body py-5">
                            <h3 class="mb-8 text-gray">Asset Register  <span class="float-end"><button  class="add-document btn btn-primary btn-sm">Add Asset</button></span></h3>
                            <div class="row">
                                 <div class="col-md-12">
                                     @foreach($assets as $asset)
                                     <div class="document-box p-3 mb-4">
                                         
                                         <div>
                                             <div class="row mb-8">
                                                 <div class="col-md-6">
                                                     <small>Item Name</small>
                                                     <h3 class="mb-0 fw-semibold">{{ $asset->item_name }}</h3>
                                                 </div>
                                                 <div class="col-md-6">
                                                     <small>Date</small>
                                                     <h3 class="mb-0 fw-semibold">{{ date('d M, Y', strtotime($asset->date)) }}</h3>
                                                 </div>
                                             </div>
                                             <div class="row mb-8">
                                                 <div class="col-md-12">
                                                     <small>Documentation</small>
                                                     <h3 class="mb-0 fw-semibold">{{ $asset->documentation }}</h3>
                                                 </div>
                                             </div>
                                             <div class="row mb-5">
                                                 <div class="col-md-12">
                                                     <div class="notify-box active-notify p-3 mb-3">
                                                         <p class="fw-bold mb-0 ">
                                                             <img src="{{ asset('img/icons/document.svg') }}" alt="">
                                                             <span class="ms-3">{{ $asset->document_name }}</span>
                                                         </p>
                                                         <span class="float-end">
                                                                 <label class="form-check form-switch form-check-custom form-check-solid" id="showProjects">
                                                                     <span class="me-4">Notify?</span>
                                                                     <input data-id="{{ $asset->id }}" @if($asset->notify==1) checked @endif class="form-check-input notify-switch w-30px h-20px" type="checkbox" value="1" name="" id="">

                                                                 </label>
                                                             </span>
                                                         

                                                     </div>
                                                     
                                                 </div>
                                             </div>
                                             @if(!empty($notes))
                                             <div class="row mb-5">
                                                 <div class="col-md-12">
                                                     <small>Notes</small>
                                                     <h3 class="mb-0 fw-semibold">{{ $asset->notes }}</h3>
                                                 </div>
                                             </div>
                                             @endif
                                             
                                             <div class="row">
                                                 <div class="col-md-12">
                                                     <div class="form-check">
                                                            <input @if($asset->routine_checks==1) checked disabled @endif class="form-check-input receivePPE" type="checkbox" data-id="{{ $asset->id }}" id="asset_{{ $asset->id }}" />
                                                            <label for="asset_{{ $asset->id }}" class="fw-bold">Routine Checks</label>

                                                        </div>
                                                 </div>
                                             </div>
                                             
                                         </div>
                                     </div>
                                     @endforeach
                                 </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>

<div class="modal fade" id="staffModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{ route('hr.addDocumentStaff', ['id'=>$user->id]) }}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add Staff Member</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    
                    
                    <input type="hidden" name="document_id" id="document_id">
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Select Staff Member</span>
                        </label>
                        <!--end::Label-->
                        
                        
                    </div>
                    
                    
                    






                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

<div class="modal fade" id="addDocumentModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form enctype="multipart/form-data" method="POST" class="form" action="{{ route('hr.addAsset', ['id'=>$user->id]) }}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add Asset</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    
                    
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Item Name</span>
                        </label>
                        <!--end::Label-->
                        <input type="text" class="form-control" name="item_name" required>
                    </div>
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Date</span>
                        </label>
                        <!--end::Label-->
                        <input type="date" class="form-control" name="date" required>
                    </div>
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Documentation</span>
                        </label>
                        <!--end::Label-->
                        <textarea required name="documentation" class="form-control" id="" cols="30" rows="3"></textarea>
                    </div>
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Select Document</span>
                        </label>
                        <!--end::Label-->
                        <input type="file" class="form-control" name="document" required>
                    </div>
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="">Notes</span>
                        </label>
                        <!--end::Label-->
                        <textarea name="notes" class="form-control" id="" cols="30" rows="3"></textarea>
                    </div>
                    
                    
                    






                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>



@endsection

@section('js')
<script>
    
    toastr.options = {
      "closeButton": false,
      "debug": false,
      "newestOnTop": false,
      "progressBar": false,
      "positionClass": "toastr-top-right",
      "preventDuplicates": false,
      "onclick": null,
      "showDuration": "300",
      "hideDuration": "1000",
      "timeOut": "5000",
      "extendedTimeOut": "1000",
      "showEasing": "swing",
      "hideEasing": "linear",
      "showMethod": "fadeIn",
      "hideMethod": "fadeOut"
    };
    
    $(".notify-switch").click(function() {
        var id = $(this).data('id');
        if($(this).is(':checked')){
            var switch_status = 1;
        }else{
            var switch_status = 0;
        }
        $.ajax({
            url: "{{ route('hr.enableAssetNotify', ['id'=>$user->id]) }}",
            type: 'POST',
            data: {
                document_id: id,
                switch_status: switch_status,
                _token: '{{ csrf_token() }}'
            },
            success: function(response){
                if(switch_status==1){
                    toastr.success('Enabled successfully.');
                }else{
                    toastr.success('Disabled successfully.');
                }
            },
            error: function(response){
                alert('Error: ' + response.responseJSON.message);
            }
        });
        
    });
    
    $(".add-document").click(function() {
        $("#addDocumentModal").modal("show");
    });
    
    $(".add-staff").click(function() {
        var id = $(this).data('id');
        $('#document_id').val(id);
        $("#staffModal").modal("show");
    });
</script>
@endsection