@extends('layouts.app')
@section('title', 'Attendance')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <!--begin::Toolbar-->
    <style>
        .bg-danger-2 {
            background: #ffcccc;
            border-color: #ffcccc;
        }


        table.table-bordered.dataTable {
            border: 0;
            border-bottom: 0;
        }

        .bg-success-2 {
            background: #D2EA8E;
        }

        .text-red {
            color: red !important;
        }

        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }

        .table td,
        .table th {
            vertical-align: middle;
        }

        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            text-align: center;
            color: #727879;
        }



        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }

        table.dataTable.no-footer {
            border-bottom: 0 !important;
        }
        
        .side-nav{
            padding: 15px;
            font-weight: 300 !important;
        }
       
        
        .text-gray-800{
            color: #556171 !important;
        }
        
         .active{
            background: #f0f6e1;
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
            border-bottom: 2px solid #93D500;
            font-weight: 600 !important;
            color: black !important;
        }
        
        .notify-box{
             background: #F0F0F0;
            border-radius: 4px;
        }
        
        .active-notify{
             background: #f0f6e1;
        }
        
       .active .text-gray-800{
            color: black !important;
        }
        
        .text-gray{
            color: #556171 !important;
        }
        
   
         .btn-outline i{
            color: #93D500 !important;
            font-size: 18px;
        }
        
        .btn-outline:hover{
            color: black !important;
        }
        
        .btn-outline:hover i{
            color: black !important;
        }
        .document-box{
            background: #FAFAFA;
            border-radius: 10px;
            border: 1px solid #E1E1E1;
        }
        
        .form-switch.form-check-solid .form-check-input:not(:checked) {
    background-color: #78829D;
}
        .btn-outline{
            border: 1px dashed #93D500 !important;
            background: #F5FFE0 !important;
            color: #93D500 !important;
        }
        
        
        .pending-holidays{
            border: 1px solid #E1E1E1;
            border-radius: 10px;
            box-shadow: 0px 6px 40px 0px #312D570F;
        }
        
        .holidays-box{
            border: 1px solid #EFEFEF;
            background: #fbfdf5;
            border-radius: 10px;

        }
        
        .holiday-box{
            border: 1px solid #EAEAEA;
            background: white;
            border-radius: 10px;
        }
        
        
    
    </style>
    <!--end::Toolbar-->
    <!--begin::Content-->
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            @if(session('success'))
            <div class="col-md-12">
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            </div>
            @endif
            <div class="row g-5 g-xl-10 mb-xl-10">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            @include('hr.head')
                            
                        </div>
                    </div>
                </div>


            </div>
            <div class="row">
                <div class="col-md-4">
                @include('hr.sidenav')
                </div>
                <div class="col-md-8">
                    <div class="card">

                        <div class="card-body py-5">
                            <h3 class="mb-8 text-gray text-center">1st Jan, 2024 <span class="fw-semibold text-muted mx-3">TO</span> 31 Dec, 2024</h3>
                            <div class="row">
                                 <div class="col-md-12">
                                     <p>Pending Holiday Approvals</p>
                                     @foreach($holidays as $holiday)
                                         @if($holiday->status=='pending')
                                         <div class="pending-holidays p-3 mb-3">
                                                <div class="row">
                                                    <div class="col-md-8">
                                                        <p class="text-gray fw-bold mb-2">{{ date('jS M, Y', strtotime($holiday->from_date)) }} <span class="mx-3 muted">TO</span> {{ date('jS M, Y', strtotime($holiday->to_date)) }}</p>
                                                        <p class="mb-0">{{ $holiday->description }}</p>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="float-end">
                                                            <button class="btn btn-sm btn-primary changeStatus" data-id="{{$holiday->id}}" data-status="accepted">Accept</button>
                                                            <button class="btn btn-sm btn-danger changeStatus" data-id="{{$holiday->id}}" data-status="declined">Decline</button>
                                                        </div>
                                                    </div>
      
                                                </div>
                                                
                                         </div>
                                         @endif
                                     @endforeach
                                     
                                     
                                     <div class="d-flex justify-content-center">
                                         <div class="btn-group justify-content-center mt-5 mb-8" role="group" aria-label="Basic outlined example">
                                             <a href="#!" class="btn  btn-primary" id="holiday_tab">Holidays</a>
                                             <a href="#!" class="btn  btn-light" id="sick_tab">Sick Leave</a>

                                         </div>
                                     </div>
                                     
                                     <div class="holidays-box px-3 py-5">
                                         <div class="row">
                                             <div class="col-md-4">
                                                 <p class="fw-bold text-center mb-3">Total Holidays - {{ $user->total_holidays }} <span onclick="$('#updateHolidaysModal').modal('show')" class="ms-3" style="cursor:pointer"><i class="fa fa-edit"></i></span></p>
                                                 <div style="background: #93D50033;border-radius:20px" class="text-center mb-3"><span class="fw-bold" style="font-size:45px;">{{ $totalHolidays }}</span> Days</div>
                                                 <p class="fw-bold text-center mb-0">Available Holidays - {{ $user->total_holidays - $totalHolidays }}</p>
                                             </div>
                                             <div class="col-md-8">
                                                 <?php $i = 1; ?>
                                                 @foreach($holidays as $holiday)
                                                     @if($holiday->status=='accepted')
                                                         <div class="holiday-box p-3 mb-3" style="position:relative">
                                                             <p class="text-dark fw-bold mb-0"><span class="me-3">{{ $i }}. </span>{{ date('jS M, Y', strtotime($holiday->from_date)) }} <span class="mx-3 text-muted">TO</span> {{ date('jS M, Y', strtotime($holiday->to_date)) }} </p>
                                                             <span data-from="{{ date('jS M, Y', strtotime($holiday->from_date)) }}" data-to="{{ date('jS M, Y', strtotime($holiday->to_date)) }}" data-description="{{ $holiday->description }}" class="holidayDetails" style="position:absolute;top:8px;right:15px;cursor:pointer"><i style="color:#93d500" class="ki-solid ki-eye fs-1"></i></span>
                                                         </div>
                                                         @php $i++; @endphp
                                                     @endif
                                                     
                                                 @endforeach
                                                 
                                                 <button onclick='$("#addHolidayModal").modal("show");' class="btn btn-primary btn-outline w-100"><i class="ki-duotone ki-plus-circle fs-1"><span class="path1"></span><span class="path2"></span></i> Add Holiday</button>
                                                 
                                             </div>
                                         </div>
                                     </div>
                                     
                                     <div class="sick-box px-3 py-5" style="display:none">
                                         <div class="row">
                                             <div class="col-md-4">
                                                 <p class="fw-bold text-center mb-3">Sick Leaves</p>
                                                 <div style="background: #93D50033;border-radius:20px" class="text-center mb-3"><span class="fw-bold" style="font-size:45px;">{{ $totalLeaves }}</span> Days</div>
                                                 
                                             </div>
                                             <div class="col-md-8">
                                                 <?php $i = 1; ?>
                                                 @foreach($sick_leaves as $leave)
                                                     
                                                         <div class="holiday-box p-3 mb-3" style="position:relative">
                                                             <p class="text-dark fw-bold mb-0"><span class="me-3">{{ $i }}. </span>{{ date('jS M, Y', strtotime($leave->from_date)) }} <span class="mx-3 text-muted">TO</span> {{ date('jS M, Y', strtotime($leave->to_date)) }} </p>
                                                             <span data-from="{{ date('jS M, Y', strtotime($leave->from_date)) }}" data-to="{{ date('jS M, Y', strtotime($leave->to_date)) }}" data-description="{{ $leave->description }}" class="leaveDetails" style="position:absolute;top:8px;right:15px;cursor:pointer"><i style="color:#93d500" class="ki-solid ki-eye fs-1"></i></span>
                                                         </div>
                                                         <?php $i++; ?>
                                                     
                                                     
                                                 @endforeach
                                                 
                                                 <button onclick='$("#addSickLeaveModal").modal("show");' class="btn btn-primary btn-outline w-100"><i class="ki-duotone ki-plus-circle fs-1"><span class="path1"></span><span class="path2"></span></i> Add Sick Leave</button>
                                                 
                                             </div>
                                         </div>
                                     </div>
                                     
                                 </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>

<div class="modal fade" id="addSickLeaveModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form enctype="multipart/form-data" method="POST" class="form" action="{{ route('hr.addSickLeave', ['id'=>$user->id]) }}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add Sick Leave</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Sick Leave Type</span>
                        </label>
                        <!--end::Label-->
                        <select name="type" required class="form-control" id="leave_type">
                            <option value="full" selected> Full Day</option>
                            <option value="half"> Half Day</option>
                        </select>
                    </div>
                    
                    <div class="row" id="half_day" style="display:none">
                        <div class="col-md-12">
                            <div class="d-flex flex-column mb-8  fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">Date</span>
                                </label>
                                <!--end::Label-->
                                <input type="date" class="form-control" name="date" id="half_date">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row" id="full_day">
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8  fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">From</span>
                                </label>
                                <!--end::Label-->
                                <input type="date" class="form-control" name="from" required id="full_from">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8  fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">To</span>
                                </label>
                                <!--end::Label-->
                                <input type="date" class="form-control" name="to" required id="full_to">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row" id="">
                        <div class="col-md-12">
                            <div class="d-flex flex-column mb-8  fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">Upload Document</span>
                                </label>
                                <!--end::Label-->
                                <input type="file" class="form-control" name="document" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="">Description</span>
                        </label>
                        <!--end::Label-->
                        <textarea name="description" class="form-control" id="" cols="30" rows="5"></textarea>
                    </div>
                    
                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


<div class="modal fade" id="updateHolidaysModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{ route('hr.updateHolidays', ['id'=>$user->id]) }}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Update Holidays</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Total Holidays</span>
                        </label>
                        <!--end::Label-->
                        <input type="number" required class="form-control" name="total_holidays" value="{{$user->total_holidays}}">
                    </div>

                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


<div class="modal fade" id="addHolidayModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form enctype="multipart/form-data" method="POST" class="form" action="{{ route('hr.addHoliday', ['id'=>$user->id]) }}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add Holiday</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Holiday Type</span>
                        </label>
                        <!--end::Label-->
                        <select name="type" required class="form-control" id="holiday_type">
                            <option value="full" selected> Full Day</option>
                            <option value="half"> Half Day</option>
                        </select>
                    </div>
                    <div class="row" id="holiday_half" style="display:none">
                        <div class="col-md-12">
                            <div class="d-flex flex-column mb-8  fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">Date</span>
                                </label>
                                <!--end::Label-->
                                <input type="date" class="form-control" name="date" id="holiday_half_date">
                            </div>
                        </div>
                    </div>
                    <div class="row" id="holiday_full">
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8  fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">From</span>
                                </label>
                                <!--end::Label-->
                                <input type="date" class="form-control" name="from" required id="holiday_full_from">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8  fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">To</span>
                                </label>
                                <!--end::Label-->
                                <input type="date" class="form-control" name="to" required id="holiday_full_to">
                            </div>
                        </div>
                    </div>
                    
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="">Description</span>
                        </label>
                        <!--end::Label-->
                        <textarea name="description" class="form-control" id="" cols="30" rows="5"></textarea>
                    </div>
                    
                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

<div class="modal fade" id="holidayDetailsModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form enctype="multipart/form-data" method="POST" class="form" action="{{ route('hr.addHoliday', ['id'=>$user->id]) }}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Holiday Details</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8  fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="">From</span>
                                </label>
                                <!--end::Label-->
                                <p id="h_from"></p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8  fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="">To</span>
                                </label>
                                <!--end::Label-->
                                <p id="h_to"></p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="">Description</span>
                        </label>
                        <!--end::Label-->
                        <p id="h_descrpition"></p>
                    </div>
                    
                    
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


<form action="{{ route('hr.changeHolidayStatus', ['id'=>$user->id]) }}" method="post" id="change_status_form">
    @csrf
    <input type="hidden" name="holiday_id" id="holiday_id">
    <input type="hidden" name="status" id="holiday_status">
</form>

@endsection

@section('js')
<script>
    
    $(".holidayDetails").click(function(){
        $("#h_from").html($(this).data('from'))
        $("#h_to").html($(this).data('to'))
        $("#h_descrpition").html($(this).data('description'));
        $("#holidayDetailsModal").modal("show");
    })
    
    
    $("#holiday_type").change(function(){
        var type = $(this).val();
        if(type=='half'){
            $("#holiday_half").show();
            $("#holiday_half_date").prop('required', true);
            $("#holiday_full_from").prop('required', false);
            $("#holiday_full_to").prop('required', false);
            $("#holiday_full").hide();
        }else{
            $("#holiday_half_date").prop('required', false);
            $("#holiday_full_from").prop('required', true);
            $("#holiday_full_to").prop('required', true);
            $("#holiday_half").hide();
            $("#holiday_full").show();
        }
    });
    
    
    $("#leave_type").change(function(){
        var type = $(this).val();
        if(type=='half'){
            $("#half_day").show();
            $("#half_date").prop('required', true);
            $("#full_from").prop('required', false);
            $("#full_to").prop('required', false);
            $("#full_day").hide();
        }else{
            $("#half_date").prop('required', false);
            $("#full_from").prop('required', true);
            $("#full_to").prop('required', true);
            $("#full_day").hide();
            $("#half_day").hide();
            $("#full_day").show();
        }
    });
    
    $("#sick_tab").click(function(){
        $("#holiday_tab").removeClass('btn-primary').addClass('btn-light');
        $("#sick_tab").removeClass('btn-light').addClass('btn-primary');
        $(".holidays-box").hide();
        $(".sick-box").show();
    })
    
    $("#holiday_tab").click(function(){
        $("#holiday_tab").addClass('btn-primary').removeClass('btn-light');
        $("#sick_tab").addClass('btn-light').removeClass('btn-primary');
        $(".sick-box").hide();
        $(".holidays-box").show();
    })
    
    $(".changeStatus").click(function(){
        var id = $(this).data('id');
        var status = $(this).data('status');
        if(confirm('Are you sure?')){
            $("#holiday_id").val(id);
            $("#holiday_status").val(status);
            $("#change_status_form").submit();
        }
    });
    
    toastr.options = {
      "closeButton": false,
      "debug": false,
      "newestOnTop": false,
      "progressBar": false,
      "positionClass": "toastr-top-right",
      "preventDuplicates": false,
      "onclick": null,
      "showDuration": "300",
      "hideDuration": "1000",
      "timeOut": "5000",
      "extendedTimeOut": "1000",
      "showEasing": "swing",
      "hideEasing": "linear",
      "showMethod": "fadeIn",
      "hideMethod": "fadeOut"
    };
    
    $(".notify-switch").click(function() {
        var id = $(this).data('id');
        if($(this).is(':checked')){
            var switch_status = 1;
        }else{
            var switch_status = 0;
        }
        $.ajax({
            url: "{{ route('hr.enableNotify', ['id'=>$user->id]) }}",
            type: 'POST',
            data: {
                document_id: id,
                switch_status: switch_status,
                _token: '{{ csrf_token() }}'
            },
            success: function(response){
                if(switch_status==1){
                    $("#notify_box_"+id).addClass('active-notify');
                    $("#staff_members_"+id).show();
                    toastr.success('Enabled successfully.');
                }else{
                    $("#notify_box_"+id).removeClass('active-notify');
                    $("#staff_members_"+id).hide();
                    toastr.success('Disabled successfully.');
                }
            },
            error: function(response){
                alert('Error: ' + response.responseJSON.message);
            }
        });
        
    });
    
    $(".add-document").click(function() {
        $("#addDocumentModal").modal("show");
    });
    
    $(".add-staff").click(function() {
        var id = $(this).data('id');
        $('#document_id').val(id);
        $("#staffModal").modal("show");
    });
</script>
@endsection