@extends('layouts.app')
@section('title', 'HR Dashboard')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <!--begin::Toolbar-->
    <style>
        .bg-danger-2 {
            background: #ffcccc;
            border-color: #ffcccc;
        }


        table.table-bordered.dataTable {
            border: 0;
            border-bottom: 0;
        }

        .bg-success-2 {
            background: #D2EA8E;
        }

        .text-red {
            color: red !important;
        }

        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }

        .table td,
        .table th {
            vertical-align: middle;
        }

        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            text-align: center;
            color: #727879;
        }



        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }

        table.dataTable.no-footer {
            border-bottom: 0 !important;
        }

    </style>
    <!--end::Toolbar-->
    <!--begin::Content-->
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            @if(session('success'))
            <div class="col-md-12">
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            </div>
            @endif
            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif
            <div class="row g-5 g-xl-10 mb-xl-10">
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <p class="fw-bold"><img width="30px" src="{{asset('img/icons/present.svg')}}" alt="">    <span class="ms-3">Total Workforce</span></p>
                            <h1 style="font-size:35px;">{{ $users->count() }}</h1>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <p class="fw-bold"><img width="30px" src="{{asset('img/icons/hr_present.svg')}}" alt="">  <span class="ms-3">Present Workforce</span></p>
                            <h1 style="font-size:35px;">{{ $users->count() }}</h1>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <p class="fw-bold"><img width="30px" src="{{asset('img/icons/hr_absent.svg')}}" alt=""><span class="ms-3">Absent Workforce</span></p>
                            <h1 style="font-size:35px;">0</h1>
                        </div>
                    </div>
                </div>


            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <!--begin::Card header-->
                        <div class="card-header border-0 pt-6">
                            <!--begin::Card title-->
                            <div class="card-title justify-content-between">
                                <div class="d-flex align-items-center">
                                    <h3 class="fw-bold"> Employee Handbook <button id="upload_pdf" class="ms-5 btn btn-primary"><i class="fa fa-upload"></i> Upload PDF </button> @if($handbook) <a target="_blank" href="{{asset('documents/'.$handbook->file)}}" class="btn btn-primary"><i class="fa fa-eye"></i> View PDF </a> @endif</h3>

                                </div>




                            </div>
                            <div class="d-flex align-items-center">
                                <!--begin::Search-->
                                <div class="d-flex align-items-center justify-between position-relative my-1 me-5">
                                    <i class="ki-outline ki-magnifier fs-3 position-absolute ms-5"></i>
                                    <input type="text" data-kt-user-table-filter="search" class="form-control  w-250px ps-13" placeholder="Search by name, type, department" id="mySearch" />

                                </div>
                                
                                <!--end::Search-->
                            </div>
                            <!--begin::Card title-->
                            <!--begin::Card toolbar-->

                            <!--end::Card toolbar-->
                        </div>
                        <!--end::Card header-->
                        <!--begin::Card body-->
                        <div class="card-body py-4">
                            <!--begin::Table-->
                            <table class="table table-bordered" id="kt_table_users">
                                <thead>
                                    <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">

                                        <th class="min-w-125px">Employee</th>
                                        <th class="min-w-100px">Occupation</th>
                                        <th class="min-w-100px">Type</th>
                                        <th class="min-w-100px">Vehicle</th>
                                        <th class="min-w-100px">MOT</th>
                                        <th class="min-w-100px">Insurance</th>
                                        <th class="min-w-100px">Holiday Left</th>
                                        <th class="min-w-100px">Status</th>
                                    </tr>
                                </thead>
                                <tbody class="">
                                    @foreach($users as $user)
                                    <tr class="">
                                        <td>
                                            <!--begin:: Avatar -->
                                            <div class="d-flex align-items-center">
                                                <div class="symbol symbol-circle symbol-50px overflow-hidden me-3">
                                                    <a href="{{route('hr.userDetails', ['id' => $user->id])}}">
                                                        <div class="symbol-label">
                                                            <img src="{{asset('img/default.png')}}"  width="50px" />
                                                        </div>
                                                    </a>
                                                </div>
                                                <!--begin::User details-->
                                                <div class="d-flex flex-column">
                                                    <a href="{{route('hr.userDetails', ['id' => $user->id])}}" class="text-gray-800 text-hover-primary mb-1">{{ $user->firstname }} {{ $user->lastname }}</a>
                                                </div>
                                            </div>

                                            <!--begin::User details-->
                                        </td>
                                         @php $skills = \App\Http\Controllers\PlanningController::getUserSkills($user->id) @endphp
                                        <td>{{ implode(', ', $skills) }}</td>
                                        <td>
                                            @if($user->third_party==0)
                                            <span class="">Full-Time</span>
                                            @else
                                            <span class="">Contract</span>
                                            @endif
                                            
                                        </td>
                                        <td><span class="text-primary">Yes</span></td>
                                        <td class="">15 Aug, 24</td>
                                        <td class="">24 Aug, 24</td>
                                        <td class="">12 Days</td>
                                        <td class="">
                                            <span class="badge badge-light-primary fs-base">
																	Present</span>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                            <!--end::Table-->
                        </div>
                        <!--end::Card body-->
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>

<div class="modal fade" id="uploadPdfModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form enctype="multipart/form-data" method="POST" class="form" action="{{ route('hr.uploadHandbook') }}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Upload PDF</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    
                    
                    
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Select Document</span>
                        </label>
                        <!--end::Label-->
                        <input type="file" class="form-control" name="document" required>
                    </div>
                    
                    
                    






                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>




@endsection

@section('js')
<script>
    $("#upload_pdf").click(function() {
        $("#uploadPdfModal").modal("show");
    });

</script>
@endsection
