@extends('layouts.app')
@section('title', 'Edit Professional Info')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <!--begin::Toolbar-->
    <style>
        .bg-danger-2 {
            background: #ffcccc;
            border-color: #ffcccc;
        }


        table.table-bordered.dataTable {
            border: 0;
            border-bottom: 0;
        }

        .bg-success-2 {
            background: #D2EA8E;
        }

        .text-red {
            color: red !important;
        }

        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }

        .table td,
        .table th {
            vertical-align: middle;
        }

        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            text-align: center;
            color: #727879;
        }



        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }

        table.dataTable.no-footer {
            border-bottom: 0 !important;
        }
        
        .side-nav{
            padding: 15px;
            font-weight: 300 !important;
        }
       
        
        .text-gray-800{
            color: #556171 !important;
        }
        
         .active{
            background: #f0f6e1;
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
            border-bottom: 2px solid #93D500;
            font-weight: 600 !important;
            color: black !important;
        }
        
       .active .text-gray-800{
            color: black !important;
        }
        
        .text-gray{
            color: #556171 !important;
        }
        
    </style>
    <!--end::Toolbar-->
    <!--begin::Content-->
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            @if(session('success'))
            <div class="col-md-12">
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            </div>
            @endif
            <div class="row g-5 g-xl-10 mb-xl-10">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            @include('hr.head')
                            
                        </div>
                    </div>
                </div>


            </div>
            <div class="row">
                <div class="col-md-4">
                @include('hr.sidenav')
                </div>
                <div class="col-md-8">
                    <div class="card">

                        <div class="card-body py-5">
                            
                            <form method="POST" class="form" action="{{route('hr.updateProfessionalInfo', ['id'=>$user->id])}}" id="userForm">
                                <!--begin::Heading-->
                                @csrf
                                <h3 class="mb-8 text-gray">Edit Professional Info <span class="float-end"><button  class="btn btn-primary btn-sm">Save</button></span></h3>
                                <!--end::Heading-->
                                <!--begin::Input group-->
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="">Employee ID</span>
                                            </label>
                                            <!--end::Label-->
                                            <input type="text" class="form-control " placeholder="" name="employee_id" value="{{$user->employee_id}}" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="">Work Email Address</span>
                                            </label>
                                            <!--end::Label-->
                                            <input type="email" class="form-control " placeholder="" name="work_email" value="{{$user->work_email}}" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="">Hourly Rate</span>
                                            </label>
                                            <!--end::Label-->
                                            <input type="number" step="any" class="form-control " placeholder="" name="hourly_rate" value="{{$user->hourly_rate}}" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="">Uplift Amount</span>
                                            </label>
                                            <!--end::Label-->
                                            <input type="number" step="any" class="form-control " placeholder="" name="uplift_amount" value="{{$user->uplift_amount}}" />
                                        </div>
                                    </div>
                                </div>
                                
                                
                                <div class="row">
                                   
                                    
                                     <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="">Employee Type</span>
                                            </label>
                                            <!--end::Label-->
                                            <select name="employee_type" class="form-select" id="employee_type">
                                                <option value="">Select</option>
                                                <option value="office">Office</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="">Department</span>
                                            </label>
                                            <!--end::Label-->
                                            <select name="department" class="form-select" id="department">
                                                <option value="">Select</option>
                                                <option value="site_manager">Site Manager</option>
                                                <option value="contracts_manager">Contracts Manager</option>
                                            </select>
                                        </div>
                                    </div>
                                    
                                </div>
                                <div class="row">
                                   
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="">Office Location</span>
                                            </label>
                                            <!--end::Label-->
                                            <select name="office_location" class="form-select" id="office_location">
                                                <option value="">Select</option>
                                                <option value="london">London</option>
                                            </select>
                                        </div>
                                    </div>
                                     <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="">Project Types Access</span>
                                            </label>
                                            <!--end::Label-->
                                            <select name="project_types[]" multiple class="form-select" id="project_types">
                                                @php
                                                      $selected = explode(',', $user->project_types_access);
                                                @endphp
                                                <option @if(in_array(0, $selected)) selected @endif value="0" selected>All Project Types</option>
                                                
                                                
                                                
                                                
                                                @foreach($project_types as $type)
                                                    <option @if(in_array($type->id, $selected)) selected @endif value="{{ $type->id }}">{{ $type->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    
                                </div>
                                
                                <div class="row">
                                   <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="">Working Days</span>
                                            </label>
                                            <!--end::Label-->
                                            <select name="working_days" class="form-select" id="working_days">
                                                <option value="">Select</option>
                                                <option value="1">1</option>
                                                <option value="2">2</option>
                                                <option value="3">3</option>
                                                <option value="4">4</option>
                                                <option value="5">5</option>
                                                <option value="6">6</option>
                                                <option value="7">7</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="">Joining Date</span>
                                            </label>
                                            <!--end::Label-->
                                            <input type="date" class="form-control " placeholder="" name="joining_date" value="{{ $user->joining_date }}" />
                                        </div>
                                    </div>
                                     
                                    
                                </div>
                               
                                
                                
                                




                            </form>
                            
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>

<form method="post" action="{{route('dashboard.unlike')}}" id="unlikeForm" style="display:none">
    @csrf
    <input type="hidden" name="project_id" id="project_id">
</form>



@endsection

@section('js')
<script>
    $('#project_types').select2();
    $("#working_days").val('{{$user->working_days}}');
    $("#office_location").val('{{$user->office_location}}');
    $("#department").val('{{$user->department}}');
    $("#employee_type").val('{{$user->employee_type}}');
</script>
@endsection