@extends('layouts.app')
@section('title', 'Professional Info')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <!--begin::Toolbar-->
    <style>
        .bg-danger-2 {
            background: #ffcccc;
            border-color: #ffcccc;
        }


        table.table-bordered.dataTable {
            border: 0;
            border-bottom: 0;
        }

        .bg-success-2 {
            background: #D2EA8E;
        }

        .text-red {
            color: red !important;
        }

        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }

        .table td,
        .table th {
            vertical-align: middle;
        }

        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            text-align: center;
            color: #727879;
        }



        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }

        table.dataTable.no-footer {
            border-bottom: 0 !important;
        }
        
        .side-nav{
            padding: 15px;
            font-weight: 300 !important;
        }
       
        
        .text-gray-800{
            color: #556171 !important;
        }
        
         .active{
            background: #f0f6e1;
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
            border-bottom: 2px solid #93D500;
            font-weight: 600 !important;
            color: black !important;
        }
        
       .active .text-gray-800{
            color: black !important;
        }
        
        .text-gray{
            color: #556171 !important;
        }
        
    </style>
    <!--end::Toolbar-->
    <!--begin::Content-->
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            @if(session('success'))
            <div class="col-md-12">
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            </div>
            @endif
            <div class="row g-5 g-xl-10 mb-xl-10">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            @include('hr.head')
                            
                        </div>
                    </div>
                </div>


            </div>
            <div class="row">
                <div class="col-md-4">
                @include('hr.sidenav')
                </div>
                <div class="col-md-8">
                    <div class="card">

                        <div class="card-body py-5">
                            <h3 class="mb-8 text-gray">Professional Info <span class="float-end"><a href="{{ route('hr.editProfessionalInfo', ['id'=>$user->id]) }}"><i class="fa fa-edit fs-2"></i></a></span></h3>
                            <div class="row">
                                <div class="col-md-6">
                                    <label for="">Employee ID</label>
                                    <h4 class="">{{ $user->employee_id }}</h4>
                                </div>
                                <div class="col-md-6">
                                    <label for="">Work Email Address</label>
                                    <h4 class="">{{ $user->work_email }}</h4>
                                </div>
                            </div>
                            <hr class="my-7" style="border: 1px solid #EAEAEA">
                            <div class="row">
                                <div class="col-md-6">
                                    <label for="">Employee Type</label>
                                    <h4 class="">{{ ucfirst($user->employee_type) }}</h4>
                                </div>
                                <div class="col-md-6">
                                    <label for="">Department</label>
                                    <h4 class="">
                                        @if($user->department=='site_manager')
                                            Site Manager
                                        @elseif($user->department=='contracts_manager')
                                            Contracts Manager
                                        @endif
                                    </h4>
                                </div>
                            </div>
                            
                            <hr class="my-7" style="border: 1px solid #EAEAEA">
                            <div class="row">
                                <div class="col-md-6">
                                    <label for="">Office Location</label>
                                    <h4 class="">{{ ucfirst($user->office_location) }}</h4>
                                </div>
                                <div class="col-md-6">
                                    <label for="">Project Types Access</label>
                                    <h4 class="">All Project Types</h4>
                                </div>
                            </div>
                            <hr class="my-7" style="border: 1px solid #EAEAEA">
                            <div class="row">
                                <div class="col-md-6">
                                    <label for="">Working Days</label>
                                    <h4 class="">{{ ucfirst($user->working_days) }}</h4>
                                </div>
                                <div class="col-md-6">
                                    <label for="">Joining Date</label>
                                    <h4 class="">{{ date('d M, Y', strtotime($user->joining_date)) }}</h4>
                                </div>
                            </div>
                            
                            
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>

<form method="post" action="{{route('dashboard.unlike')}}" id="unlikeForm" style="display:none">
    @csrf
    <input type="hidden" name="project_id" id="project_id">
</form>



@endsection

@section('js')
<script>
    $(".unlike").click(function() {
        var id = $(this).data('id');
        $('#project_id').val(id);
        $("#unlikeForm").submit();
    })
</script>
@endsection