@php use \App\Http\Controllers\PlanningController @endphp
@extends('layouts.app')
@section('title', 'Planning')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <style>
        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }

        .header,
        .timeline {
            display: flex;
        }

        .header .div {
            background: white;
            width: 170px;
            height: 50px;
            display: flex;
            align-items: center;
            margin: 3px;
            justify-content: center;
            border-radius: 8px;
            border: 1px solid #93D500;
        }

        .timeline .div {
            background: white;
            width: 170px;
            height: 100px;
            display: flex;
            align-items: center;
            margin: 3px;
            justify-content: center;
            text-align: center;
            border-radius: 8px;
            border: 1px solid #5E5E5E33;
            padding: 5px;

        }
        
        


        .clock {
            width: 80px !important;
            border: 1px solid #93D500 !important;
        }
        
        @if(request()->has('view'))
            .header .div, .timeline .div{
                width: 100px;    
            }
        
            .clock {
                width: 150px !important;
                border: 1px solid #93D500 !important;
            }
            
        @endif

        .header .div p,
        .timeline .div p {
            color: #556171;
            font-weight: 500;
            margin-bottom: 0;
        }

        .project-orange {
            border: 2px solid #FFCB33 !important;
            background: #f2f3eb !important;
        }

        .project-green {
            border: 2px solid #29CC39 !important;
            background: #29CC390D !important;
        }

        .project-purple {
            border: 2px solid #8833FF !important;
            background: #8833FF0D !important;
        }

        .project-grey {
            border: 2px solid grey !important;
            background: #ddd !important;
        }

        .project {
            display: block !important;
            text-align: left !important;
        }

        .calendar {
            overflow-x: auto;
        }

        .calendar-data {
            width: 150%;
        }

        .floating-div {
            position: fixed;

            right: 0;
            width: 300px;
            height: 100%;
            background-color: white;
            color: white;
            padding: 15px;

            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.5);
            z-index: 99;
            /* Box shadow */

        }

        .project {
            cursor: pointer;
        }

        .project-select {
            padding: 10px;
            background: #f4fbe5;
            border: 1px solid #e8f6c9;
            margin-bottom: 8px;
            border-radius: 8px;
        }

        .project-list {
            padding-bottom: 120px;
        }
        
        @if(request()->has('m'))
          .tooltip-inner {
                text-align: left !important;
            }
        @endif
        

    </style>


    <!--end::Toolbar-->
    <!--begin::Content-->
    <div id="floatingDiv" class="floating-div">
        <div class="mb-5 mt-3">
            <input type="text" style="background:#FCFFF5" class="form-control" placeholder="Search Projects" id="projectFilter">
        </div>
        <div class="project-list pt-5">
            @foreach($projects as $project)
            <!--begin::Item-->
            <div id="project_{{ $project->id }}" data-info="{{ $project->company_name }}" data-id="{{ $project->id }}" class="d-flex flex-stack project-item project-select draggable">
                <!--begin::Symbol-->
                <div class="symbol symbol-40px me-5">
                    <img src="{{ asset('img/projects/'.$project->image) }}" class="" alt="">
                </div>
                <!--end::Symbol-->
                <!--begin::Section-->
                <div class="d-flex align-items-start flex-row-fluid flex-wrap">
                    <!--begin:Author-->
                    <div class="flex-grow-1 me-2">
                        <a href="#!" class="text-gray-800 text-hover-primary fs-6 fw-bold user-name">{{ $project->company_name }}</a>
                        <span class="text-muted fw-semibold d-block fs-7 user-company">
                            Project ID: WG-{{str_pad($project->id, 4, '0', STR_PAD_LEFT);}}
                        </span>
                        <span class="text-muted fw-semibold d-block fs-7 user-company">
                            {{ $project->status }}
                        </span>
                    </div>
                </div>
                <!--end::Section-->
            </div>
            @endforeach
        </div>
    </div>
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->

        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            @if(!request()->has('view'))
            <!--Week View -->
            <div class="row g-5 g-xl-10 mb-xl-10">
                <div class="col-md-12">
                    <div class="mb-8">
                        <a href="?week={{ request()->week-1 }}" class="btn btn-sm btn-icon btn-light">
                            <i class="ki-duotone ki-left fs-1"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span></i>
                        </a>

                        <span class="mb-0 mx-4" style="font-size:15px;color:#5E5E5E">{{ date('jS M', strtotime($dates[0])) }} - {{ date('jS M', strtotime(end($dates))) }} {{ date('Y', strtotime(end($dates))) }}</span>
                        <a href="?week={{ request()->week+1 }}" class="btn btn-icon btn-sm btn-light">
                            <i class="ki-duotone ki-right fs-1"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span></i>
                        </a>


                        <div class="btn-group ms-8" role="group" aria-label="Basic outlined example">
                            <a href="{{ route('planning.showPlanning') }}" class="btn btn-sm btn-primary">Week</a>
                            @foreach($months as $month)
                            <a href="{{ route('planning.showPlanning') }}?view=month&m={{$month}}" class="btn btn-sm btn-light">{{ date('F Y', strtotime($month)) }}</a>
                            @endforeach
                        </div>
                        <div class="mt-5" style="display:flex">
                            <label class="form-check form-switch form-check-custom form-check-solid" id="showProjects">
                                <input class="form-check-input w-30px h-20px" type="checkbox" value="1" name="notifications" id="projectsSwitch" checked>
                                <span class="form-check-label text-muted fs-7">Projects</span>
                            </label>
                            <label class="form-check form-switch form-check-custom form-check-solid ms-8" id="showSiteManagers">
                                <input class="form-check-input w-30px h-20px" type="checkbox" value="1" name="" id="siteManagers">
                                <span class="form-check-label text-muted fs-7">Site Managers</span>
                            </label>
                        </div>

                    </div>
                    <div class="calendar">
                        <div class="calendar-data">
                            <div class="header">
                                <div class="clock div">
                                    <p><i class="fa fa-2x fa-clock" style="font-size:18px"></i></p>
                                </div>
                                @foreach($dates as $date)
                                <div class="div">
                                    <p>{{ date('l d', strtotime($date)) }}</p>
                                </div>
                                @endforeach
                            </div>
                            @foreach($users as $user)
                            <div class="timeline user_timeline_{{$user->department}}">
                                <div class="clock div">
                                    <p>{{ $user->firstname }} {{ $user->lastname }}</p>
                                </div>
                                @foreach($dates as $date)
                                @php $planning = PlanningController::getUserPlannings($user->id, $date) @endphp

                                @if($planning)
                                <div class="project-grey project div droppable-2 draggable" data-id="{{ $planning->project_id }}" data-date="{{ $date }}" data-dateFormated="{{ date('jS M Y', strtotime($date)) }}" data-projectId="WG-{{str_pad($planning->project_id, 4, '0', STR_PAD_LEFT)}}" data-customer="{{ $planning->company_name }}" data-info="{{ $planning->company_name }}" data-type="expandable">
                                    <p class="fw-bold text-dark">{{ $planning->company_name }}</p>
                                    <small>WG-{{str_pad($planning->project_id, 4, '0', STR_PAD_LEFT)}}</small>
                                    <div class="symbol-group symbol-hover flex-nowrap mt-3">
                                        @php $staffs = PlanningController::getProjectUsers($planning->project_id, $date) @endphp

                                        @foreach($staffs as $staff)
                                        <div class="symbol symbol-35px symbol-circle" data-bs-toggle="tooltip" aria-label="Michael Eberon" data-bs-original-title="{{ $staff->firstname.' '.$staff->lastname }}" data-kt-initialized="1">
                                            <img alt="Pic" src="{{asset('img/users/'.$staff->image)}}">
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                                @else
                                <div class="div droppable" data-id="{{ $user->id }}" data-date="{{ $date }}">
                                    <p></p>
                                </div>
                                @endif
                                @endforeach
                            </div>
                            @endforeach

                        </div>
                    </div>

                </div>
            </div>
            @else
            <!-- Month View -->
            <div class="row g-5 g-xl-10 mb-xl-10">
                <div class="col-md-12">
                    <div class="mb-8">
                       
                       @if(!request()->has('m'))
                        <a href="?week={{ request()->week-1 }}" class="btn btn-sm btn-icon btn-light">
                            <i class="ki-duotone ki-left fs-1"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span></i>
                        </a>

                        <span class="mb-0 @if(!request()->has('m')) mx-4 @endif" style="font-size:15px;color:#5E5E5E">{{ date('jS M', strtotime($dates[0])) }} - {{ date('jS M', strtotime(end($dates))) }} {{ date('Y', strtotime(end($dates))) }}</span>
                        <a href="?week={{ request()->week+1 }}" class="btn btn-icon btn-sm btn-light">
                            <i class="ki-duotone ki-right fs-1"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span></i>
                        </a>
                        @endif


                        <div class="btn-group ms-8" role="group" aria-label="Basic outlined example">
                            <a href="{{ route('planning.showPlanning') }}" class="btn btn-sm @if(request()->has('m')) btn-light @else btn-primary @endif">Week</a>
                            @foreach($months as $month)
                            <a href="{{ route('planning.showPlanning') }}?view=month&m={{$month}}" class="btn btn-sm @if(request()->has('m')) @if(request()->m==$month) btn-primary @else btn-light @endif @else btn-light @endif">{{ date('F Y', strtotime($month)) }}</a>
                            @endforeach
                        </div>
                        <div class="mt-5" style="display:flex">
                           @if(!request()->has('m'))
                            <label class="form-check form-switch form-check-custom form-check-solid" id="showProjects">
                                <input class="form-check-input w-30px h-20px" type="checkbox" value="1" name="notifications" id="projectsSwitch" checked>
                                <span class="form-check-label text-muted fs-7">Projects</span>
                            </label>
                            @endif
                            <label class="form-check form-switch form-check-custom form-check-solid ms-8" id="showSiteManagers">
                                <input class="form-check-input w-30px h-20px" type="checkbox" value="1" name="" id="siteManagers">
                                <span class="form-check-label text-muted fs-7">Site Managers</span>
                            </label>
                        </div>

                    </div>
                    <div class="calendar">
                        <div class="calendar-data">
                            <div class="header">
                                <div class="clock div">
                                    <p><i class="fa fa-2x fa-clock" style="font-size:18px"></i></p>
                                </div>
                                
                                @php $dates = PlanningController::getDatesOfMonth(request()->m) @endphp
                                
                                @foreach($dates as $date)
                                <div class="div">
                                    <p>{{ date('d', strtotime($date)) }}</p>
                                </div>
                                @endforeach
                            </div>
                            @foreach($users as $user)
                            <div class="timeline user_timeline_{{$user->department}}">
                                <div class="clock div">
                                    <p>{{ $user->firstname }} {{ $user->lastname }}</p>
                                </div>
                                @foreach($dates as $date)
                                @php $planning = PlanningController::getUserPlannings($user->id, $date) @endphp

                                @if($planning)
                                    <?php
                                        $staffs = PlanningController::getProjectUsers($planning->project_id, $date);
                                        $names = [];
                                        foreach ($staffs as $staff) {
                                            $names[] = $staff->firstname . ' ' . $staff->lastname;
                                        }
                                        $tooltip = '<b>Project:</b> '.$planning->company_name.' (WG-'.str_pad($planning->project_id, 4, '0', STR_PAD_LEFT).') <br><b>Date: </b>'.date('jS M Y', strtotime($date)).'<br><b>People working:</b> '.implode(', ', $names);
                                    ?>
                                <div class="bg-danger project div" data-id="{{ $planning->project_id }}" data-date="{{ $date }}" data-dateFormated="{{ date('jS M Y', strtotime($date)) }}" data-projectId="WG-{{str_pad($planning->project_id, 4, '0', STR_PAD_LEFT)}}" data-customer="{{ $planning->company_name }}" data-bs-toggle="tooltip" data-bs-original-title="{{ $tooltip }}" data-kt-initialized="1" data-bs-html="true">
                                    <p></p>
                                </div>
                                @else
                                <div class="div droppable" data-id="{{ $user->id }}" data-date="{{ $date }}" >
                                    <p></p>
                                </div>
                                @endif
                                @endforeach
                            </div>
                            @endforeach

                        </div>
                    </div>

                </div>
            </div>
            @endif
        </div>
    </div>
    <!--end::Content-->
</div>

<div class="modal fade" id="warningModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Warning</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="row mb-13">
                        <div class="col-md-12">
                            <div class="alert alert-warning">
                                Warning, <span id="booked_users"></span> are already booked on this date. <br> But you can still add <span id="all_users"></span>.
                            </div>
                        </div>
                    </div>


                    <input type="hidden" id="add_users">
                    <input type="hidden" id="add_users_project_id">
                    <input type="hidden" id="add_users_date">


                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" id="add_user_now" class="btn btn-primary">
                            Add Now

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


<div class="modal fade" id="projectModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-0">Diary Entry for</h1>
                        <p class="mb-3" id="project_date"></p>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="">Project</span>
                        </label>
                        <!--end::Label-->
                        <input readonly type="text" class="form-control " placeholder="Enter Name" value="" id="project_name" />
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="">Notes</span>
                        </label>
                        <!--end::Label-->
                        <textarea class="form-control" name="notes" id="notes" cols="30" rows="5"></textarea>
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">

                        <!--end::Label-->
                        <div id="project_users_list"></div>


                    </div>






                    <div class="text-end">
                        <button type="reset" id="removeProject" class="btn btn-danger me-3" >Delete</button>
                        <button type="button" id="save_note" class="btn btn-primary">
                            Save

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

@endsection
@section('js')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/smoothness/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script>
    
    
    
    var selected_project_id = 0;
    var selected_date = 0;
    

    $("#save_note").click(function() {
        var project_id = selected_project_id;
        var date = selected_date;
        $.ajax({
            url: "{{ route('planning.saveNote') }}",
            type: 'POST',
            data: {
                project_id: project_id,
                date: date,
                note: $("#notes").val(),
                _token: '{{ csrf_token() }}',
            },
            success: function(response) {
                $("#projectModal").modal("hide");
            },
            error: function(response) {
                alert('Error: ' + response.responseJSON.message);
            }
        });
    });

    $(".project").click(function() {
        var project_id = $(this).data('id');
        var projectId = $(this).data('projectid');
        var dateFormated = $(this).data('dateformated');
        var date = $(this).data('date');
        var customer = $(this).data('customer');
        selected_project_id = project_id;
        selected_date = date;
        $("#project_date").html(dateFormated);
        $("#project_name").val(customer + ' ' + projectId);

        $.ajax({
            url: "{{ route('planning.getPlanningDetails') }}",
            type: 'POST',
            data: {
                project_id: selected_project_id,
                date: selected_date,
                _token: '{{ csrf_token() }}',
            },
            success: function(response) {
                var data = JSON.parse(response);
                $("#notes").val(data.notes);
                var staffdata = '';
                for (var i = 0; i < data.staffs.length; i++) {
                    var type = "";
                    if (data.staffs[i].department == 'site_manager') {
                        type = 'Site Manager';
                    } else if (data.staffs[i].department == 'contracts_manager') {
                        type = 'Contracts Manager';
                    } else if (data.staffs[i].department == 'labourer') {
                        type = 'Labourer';
                    }
                    staffdata += '<div class="d-flex flex-stack user-item"><div class="symbol symbol-40px me-5"><img src="{{asset('img/users')}}/' + data.staffs[i].image + '" class="h-50 align-self-center" alt=""></div><div class="d-flex align-items-center flex-row-fluid flex-wrap"><div class="flex-grow-1 me-2"><a href="#!" class="text-gray-800 text-hover-primary fs-6 fw-bold user-name">' + data.staffs[i].firstname + ' ' + data.staffs[i].lastname + '</a><span class="text-muted fw-semibold d-block fs-7 user-company">' + type + '</span></div><i class="ki-outline text-danger ki-trash fs-2 removeFromProject" data-id="' + data.staffs[i].id + '"></i></div></div><div class="separator separator-dashed my-4"></div>';
                }

                $("#project_users_list").html(staffdata);
                $("#projectModal").modal("show");
            },
            error: function(response) {
                alert('Error: ' + response.responseJSON.message);
            }
        });

    });


    $(function() {
        $('[data-bs-toggle="tooltip"]').tooltip();
    });

    $("#projectsSwitch").change(function() {
        if ($('#projectsSwitch').is(":checked")) {
            $("#floatingDiv").show();
        } else {
            $("#floatingDiv").hide();
        }
    })

    $("#siteManagers").change(function() {
        if ($('#siteManagers').is(":checked")) {
            $(".user_type_labourer").removeClass('d-flex').hide().next('.separator').hide();
            $(".user_timeline_labourer").hide();
        } else {
            $(".user_type_labourer").addClass('d-flex').next('.separator').show();
            $(".user_timeline_labourer").show();
        }
    })


    $(document).on('click', '.removeFromProject', function() {
        var user_id = $(this).data('id');
        $.ajax({
            url: "{{ route('planning.removeFromProject') }}",
            type: 'POST',
            data: {
                project_id: selected_project_id,
                user_id: user_id,
                date: selected_date,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                location.reload();
            },
            error: function(response) {
                alert('Error: ' + response.responseJSON.message);
            }
        });
    });


    $(document).on('click', '#removeProject', function() {
        if (confirm('Are you sure want to remove?')) {
            $.ajax({
                url: "{{ route('planning.removeProject') }}",
                type: 'POST',
                data: {
                    project_id: selected_project_id,
                    date: selected_date,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    location.reload();
                },
                error: function(response) {
                    alert('Error: ' + response.responseJSON.message);
                }
            });
        }
    });

    $("#add_user_now").click(function() {
        $.ajax({
            url: "{{ route('planning.addPlanning') }}",
            type: 'POST',
            data: {
                project_id: $("#add_users_project_id").val(),
                user_id: $("#add_users").val(),
                date: $("#add_users_date").val(),
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                location.reload();
            },
            error: function(response) {
                alert('Error: ' + response.responseJSON.message);
            }
        });
    })

    $(function() {
        // Make elements draggable
        $('.draggable').draggable({
            revert: 'invalid', // Reverts if not dropped on a droppable
            helper: 'clone', // Use a clone of the element as the helper
            start: function(event, ui) {
                $(ui.helper).addClass('dragging'); // Optional: Add a class to the helper
            }
        });

        // Make elements droppable
        $('.droppable').droppable({
            accept: '.draggable',
            drop: function(event, ui) {
                var draggedElement = ui.helper;
                var dropZone = $(this);

                // Transfer the dragged element's content or other data to the drop zone
                if (!dropZone.hasClass('locked')) {
                    dropZone.append(draggedElement.clone().removeClass('dragging'));
                    dropZone.addClass('locked');
                    // Trigger custom event
                    handleDrop(draggedElement, dropZone, getRandomItem(items));
                }
            }
        });
    });

    function getRandomItem(array) {
        return array[Math.floor(Math.random() * array.length)];
    }

    // Example usage
    const items = ['project-grey'];


    function handleDrop(draggedElement, dropZone, projectClass) {
        var draggedData = draggedElement.data('info');
        var project_id = draggedElement.data('id');
        var dropZoneId = dropZone.attr('id');
        var user_id = dropZone.data('id');
        var date = dropZone.data('date');
        var type = draggedElement.data('type');
        var start_date = draggedElement.data('date');
        $.ajax({
            url: "{{ route('planning.addPlanning') }}",
            type: 'POST',
            data: {
                project_id: project_id,
                user_id: user_id,
                date: date,
                type: type,
                start_date: start_date,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                location.reload();
            },
            error: function(response) {
                alert('Error: ' + response.responseJSON.message);
            }
        });

        $(dropZone).addClass('project');
        $(dropZone).addClass(projectClass);

        $(dropZone).html('<p class="fw-bold text-dark">' + draggedData + '</p><small>Lorem Ipsum is simply...</small>');
        $(dropZone).removeClass('droppable');
        $(dropZone).removeClass('ui-droppable');

        // Example of handling data transfer
        console.log(`Dragged Element Data: ${draggedData}`);
        console.log(`Dropped on Element ID: ${dropZoneId}`);

        // You can perform further actions here, e.g., updating the server
    }



    $(function() {
        // Make elements draggable
        $('.draggable-2').draggable({
            scroll: true,
            scrollSensitivity: 50,
            scrollSpeed: 10,
            revert: 'invalid',
            helper: 'clone',
            appendTo: 'body',
            start: function(event, ui) {
                // Get the current scroll position of the container
                var scrollTop = $('.user-list').scrollTop();
                var scrollLeft = $('.user-list').scrollLeft();

                // Adjust the helper position to account for scrolling
                ui.helper.css({
                    position: 'absolute',
                    top: ui.offset.top - scrollTop,
                    left: ui.offset.left - scrollLeft
                }).addClass('dragging');
            },
            drag: function(event, ui) {
                // Adjust position during drag
                var scrollTop = $('.user-list').scrollTop();
                var scrollLeft = $('.user-list').scrollLeft();

                ui.position.top -= scrollTop;
                ui.position.left -= scrollLeft;
            },
            stop: function(event, ui) {
                // Hide the original element after drop
                if (ui.helper.hasClass('dropped')) {
                    $(this).hide();
                }
            }
        });

        // Make elements droppable
        $('.droppable-2').droppable({
            accept: '.draggable-2',
            drop: function(event, ui) {
                var draggedElement = ui.helper;
                var dropZone = $(this);

                if (!dropZone.hasClass('locked')) {
                    // Add a marker class to helper indicating it was dropped
                    ui.helper.addClass('dropped');

                    // Append the clone to the drop zone
                    //dropZone.append(draggedElement.clone().removeClass('dragging dropped').css({position: 'relative', top: 'auto', left: 'auto'}));
                    //dropZone.addClass('locked');
                    handleDrop2(draggedElement, dropZone);
                }
            }
        });
    });

    function handleDrop2(draggedElement, dropZone) {
        var user_id = draggedElement.data('id');
        var dropZoneId = dropZone.attr('id');
        var draggedDataInfo = dropZone.data('info');
        var date = dropZone.data('date');
        var project_id = dropZone.data('id');


        $.ajax({
            url: "{{ route('planning.checkExistingUsers') }}",
            type: 'POST',
            data: {
                project_id: project_id,
                user_id: user_id,
                date: date,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                var data = JSON.parse(response);
                if (data.booked.length == 0) {
                    $.ajax({
                        url: "{{ route('planning.addPlanning') }}",
                        type: 'POST',
                        data: {
                            project_id: project_id,
                            user_id: user_id,
                            date: date,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(response) {
                            location.reload();
                        },
                        error: function(response) {
                            alert('Error: ' + response.responseJSON.message);
                        }
                    });
                } else {
                    if (data.all_users.length == 0) {
                        alert('Sorry, the select user is already booked on this day.');
                    } else {
                        $("#warningModal").modal("show");
                        $("#booked_users").html(data.booked_names);
                        $("#all_users").html(data.unbooked_names);
                        $('#add_users').val(data.all_users.join(","));
                        $('#add_users_project_id').val(data.project_id);
                        $('#add_users_date').val(data.date);
                    }

                    //$("#booked_users").html(data.join(", "));
                    //alert(data.join(", "));
                }
            },
            error: function(response) {
                alert('Error: ' + response.responseJSON.message);
            }
        });


        //$(dropZone).removeClass('droppable');
        //$(dropZone).removeClass('ui-droppable');

        // Example of handling data transfer
        //console.log(`Dragged Element Data: ${draggedData}`);
        //console.log(`Dropped on Element ID: ${draggedDataInfo}`);

        // You can perform further actions here, e.g., updating the server
    }

</script>
<script>
    $(document).ready(function() {
        $("#userFilter").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            $(".user-item").each(function() {
                var name = $(this).find(".user-name").text().toLowerCase();
                var company = $(this).find(".user-company").text().toLowerCase();
                if (name.indexOf(value) > -1 || company.indexOf(value) > -1) {
                    $(this).attr("style", "display: flex !important");
                    $(this).next(".separator").attr("style", "display: block !important");
                } else {
                    $(this).attr("style", "display: none !important");
                    $(this).next(".separator").attr("style", "display: none !important");
                }
            });
        });

        $("#projectFilter").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            $(".project-item").each(function() {
                var name = $(this).find(".user-name").text().toLowerCase();
                var company = $(this).find(".user-company").text().toLowerCase();
                if (name.indexOf(value) > -1 || company.indexOf(value) > -1) {
                    $(this).attr("style", "display: flex !important");
                    $(this).next(".separator").attr("style", "display: block !important");
                } else {
                    $(this).attr("style", "display: none !important");
                    $(this).next(".separator").attr("style", "display: none !important");
                }
            });
        });
    });
    
    @if(request()->has('view'))
        $("#floatingDiv").hide();
        $("#kt_app_sidebar").hide();
        $("#kt_app_wrapper").css('margin-left', '0');
        $("#kt_app_header").css('left', '0');
    @endif

</script>
@endsection
