@php use \App\Http\Controllers\PlanningController @endphp
@extends('layouts.app')
@section('title', 'Planning')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <style>
        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }

        .header,
        .timeline {
            display: flex;
        }

        .header .div {
            background: white;
            width: 170px;
            height: 50px;
            display: flex;
            align-items: center;
            margin: 3px;
            justify-content: center;
            border-radius: 8px;
            border: 1px solid #93D500;
        }

        .timeline .div {
            background: white;
            width: 170px;
            height: 100px;
            display: flex;
            align-items: center;
            margin: 3px;
            justify-content: center;
            text-align: center;
            border-radius: 8px;
            border: 1px solid #5E5E5E33;
            @if(!request()->has('m'))
            padding: 5px;
            @endif

        }
        
        


        .clock {
            width: 80px !important;
            border: 1px solid #93D500 !important;
        }
        
        @if(request()->has('view'))
            .header .div, .timeline .div{
                width: 60px;    
            }
        
            .clock {
                width: 80px !important;
                border: 1px solid #93D500 !important;
            }
            
        @endif

        .header .div p,
        .timeline .div p {
            color: #556171;
            font-weight: 500;
            margin-bottom: 0;
        }

        .project-orange {
            border: 2px solid #FFCB33 !important;
            background: #f2f3eb !important;
        }

        .project-green {
            border: 2px solid #29CC39 !important;
            background: #29CC390D !important;
        }

        .project-purple {
            border: 2px solid #8833FF !important;
            background: #8833FF0D !important;
        }

        .project-grey {
            border: 2px solid grey !important;
            background: #ddd !important;
        }

        .project {
            display: block !important;
            text-align: left !important;
            z-index: 50;
            top: 0;
        }

        .calendar {
            overflow-x: auto;
        }

        .calendar-data {
            width: 180%;
        }

        .floating-div {
            display: none;
            position: fixed;

            right: 0;
            width: 300px;
            height: 100%;
            background-color: white;
            color: white;
            padding: 15px;

            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.5);
            z-index: 199;
            /* Box shadow */

        }

        
        .project {
            cursor: pointer;
            position: absolute !important;
        }
        

        .project-select {
            padding: 10px;
            /*background: #f4fbe5;
            border: 1px solid #e8f6c9;*/
            margin-bottom: 8px;
            border-radius: 8px;
        }

        .project-list {
            padding-bottom: 120px;
        }
        
        
        .project-box{
            position: relative;
        }
        
        
        @if(request()->has('m'))
          .tooltip-inner {
                text-align: left !important;
            }
        @endif
        
            .hidden{
                display: none !important;
        }
        
        .deletePlanning{
            display: none;
        }
        
        @if(!request()->has('m'))
       .timeline .next-same {
            width: 180px;
            border-right: 0  !important;
            border-top-right-radius: 0  !important;
            border-bottom-right-radius: 0  !important;
        }
        
        .prev-same p, .prev-same small{
            opacity: 0;
        }
        
        .prev-same{
            border-left: 0  !important;
            padding-left: 10px !important;
            border-top-left-radius: 0  !important;
            border-bottom-left-radius: 0  !important;
        }
        
        @else
            .next-same{
                width: 66px !important;
                border-right: 0  !important;
                border-top-right-radius: 0  !important;
                border-bottom-right-radius: 0  !important;
            }

            .prev-same p, .prev-same small{
                opacity: 0;
            }

            .prev-same{
                border-left: 0  !important;
                /*padding-left: 10px !important;*/
                border-top-left-radius: 0  !important;
                border-bottom-left-radius: 0  !important;
            }
            
        @endif
        
        .draggable-2{
            z-index: 51;
        }
        
        .project-info p{
            width: 100%; /* Set a fixed width */
            white-space: nowrap; /* Prevent text from wrapping */
            overflow: hidden; /* Hide overflow */
            text-overflow: ellipsis; /* Add ellipsis */
        }
        
        .next-same .project-info p{
            width: 100%;
        }

    </style>


    <!--end::Toolbar-->
    <!--begin::Content-->
    <div id="floatingDiv" class="floating-div">
        <div class="mb-5 mt-3">
            <input type="text" style="background:#FCFFF5" class="form-control" placeholder="Search Projects" id="projectFilter">
        </div>
        <div class="project-list pt-5">
            @foreach($projects as $project)
            <!--begin::Item-->
            <div id="project_{{ $project->id }}" style="background:{{$project->background}};border:1px solid {{$project->border}}" data-info="{{ $project->company_name }}" data-id="{{ $project->id }}" class="d-flex flex-stack project-item project-select draggable">
                <!--begin::Symbol-->
                <div class="symbol symbol-40px me-5">
                    <img src="{{ asset('img/projects/'.$project->image) }}" class="" alt="">
                </div>
                <!--end::Symbol-->
                <!--begin::Section-->
                <div class="d-flex align-items-start flex-row-fluid flex-wrap">
                    <!--begin:Author-->
                    <div class="flex-grow-1 me-2">
                        <a href="#!" class="text-gray-800 text-hover-primary fs-6 fw-bold user-name">{{ $project->company_name }}</a>
                        <span class="text-muted fw-semibold d-block fs-7 user-company">
                            Project ID: WG-{{str_pad($project->id, 4, '0', STR_PAD_LEFT);}}
                        </span>
                        <span class="text-muted fw-semibold d-block fs-7 user-company">
                            {{ $project->status }}
                        </span>
                    </div>
                </div>
                <!--end::Section-->
            </div>
            @endforeach
        </div>
    </div>
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->

        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            @if(!request()->has('view'))
            <!--Week View -->
            <div class="row g-5 g-xl-10 mb-xl-10">
                <div class="col-md-12">
                    <div class="mb-8">
                        <a href="?week={{ request()->week-1 }}" class="btn btn-sm btn-icon btn-light">
                            <i class="ki-duotone ki-left fs-1"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span></i>
                        </a>

                        <span class="mb-0 mx-4" style="font-size:15px;color:#5E5E5E">{{ date('jS M', strtotime($dates[0])) }} - {{ date('jS M', strtotime(end($dates))) }} {{ date('Y', strtotime(end($dates))) }}</span>
                        <a href="?week={{ request()->week+1 }}" class="btn btn-icon btn-sm btn-light">
                            <i class="ki-duotone ki-right fs-1"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span></i>
                        </a>


                        <div class="btn-group ms-8" role="group" aria-label="Basic outlined example">
                            <a href="{{ route('planning.showPlanning') }}" class="btn btn-sm btn-primary">Week</a>
                            @foreach($months as $month)
                            <a href="{{ route('planning.showPlanning') }}?view=month&m={{$month}}" class="btn btn-sm btn-light">{{ date('F Y', strtotime($month)) }}</a>
                            @endforeach
                        </div>
                        <div class="mt-5" style="display:flex">
                            <label class="form-check form-switch form-check-custom form-check-solid" id="showProjects">
                                <input class="form-check-input w-30px h-20px" type="checkbox" value="1" name="notifications" id="projectsSwitch" >
                                <span class="form-check-label text-muted fs-7">Projects</span>
                            </label>
                            <label class="form-check form-switch form-check-custom form-check-solid ms-8" id="showSiteManagers">
                                <input class="form-check-input w-30px h-20px" type="checkbox" value="1" name="" id="siteManagers">
                                <span class="form-check-label text-muted fs-7">Site Managers</span>
                            </label>
                        </div>
                    </div>
                    <div class="calendar">
                        <div class="calendar-data">
                            <div class="header">
                                <div class="clock div">
                                    <p><i class="fa fa-2x fa-clock" style="font-size:18px"></i></p>
                                </div>
                                @foreach($dates as $date)
                                <div class="div">
                                    <p>{{ date('l d', strtotime($date)) }}</p>
                                </div>
                                @endforeach
                            </div>
                            @foreach($users as $user)
                            <div class="timeline user_timeline_{{$user->department}}" id="user_{{$user->id}}">
                                <div class="clock div">
                                    <p>{{ $user->firstname }} {{ $user->lastname }}</p>
                                </div>
                                @php $i = 1; $next_class = ''; $sequence = 1; $k =0;  @endphp
                                @foreach($dates as $date)
                                @php 
                                $k++;
                                $planning = PlanningController::getUserPlannings($user->id, $date);
                                $otherPlanning = PlanningController::getOtherPlannings($user->id, $date);
                                @endphp
                                @php 
                                    $resizable = 'resizable';
                                    $class = "";
                                    if(isset($dates[$i])){ 
                                        $planning_next = PlanningController::getUserPlannings($user->id, $dates[$i]);
                                        $nextBookings = PlanningController::checkBookings($user->id, $dates[$i]);
                                        if($nextBookings==2){
                                            $class = "";
                                        }else{
                                            if($planning_next && isset($planning->project_id)){
                                                if($planning_next->project_id==$planning->project_id){
                                                    $class = "next-same";
                                                }elseif($planning_next->project_id!=$planning->project_id){
                                                    //$resizable = '';
                                                }
                                            }
                                        }
                                        
                                        /*if($nextBookings>0){
                                            $resizable = '';
                                        }*/
                                        
                                    }
                                    
                                    
                                    
                                @endphp
                                
                                @php 
                                    $dayName = date('l', strtotime($date)); 
                                    $droppable = '';
                                    if(!$planning){
                                        $droppable = 'droppable';
                                    }
                                    
                                    if($planning && $otherPlanning->project_id==$planning->project_id){
                                        $droppable = 'droppable';
                                    }
                                
                                @endphp
                                <div class="project-box" id="my_project_{{$k}}">
                                   <div class="div {{ $droppable }} " data-id="{{ $user->id }}" data-date="{{ $date }}">
                                        <p></p>
                                    </div>
                                    @if($planning)
                                       @php
                                        if($otherPlanning->project_id!=$planning->project_id){
                                            $resizable = '';
                                            $class = "";
                                            $next_class = '';
                                        }
                                        
                                        
                                        
                                        @endphp
                                       
                                        @if($planning->confirmed==0)
                                            @php $style = 'background:#ddd;border:2px solid grey'; @endphp
                                        @else
                                            @php $style = 'background:'.$planning->background.'.;border:2px solid '.$planning->border.';'; @endphp
                                        @endif
                                    <div class="project div {{$class}} {{$next_class}} droppable-2 {{ $resizable }}" data-id="{{ $planning->project_id }}" data-date="{{ $date }}" data-dateFormated="{{ date('jS M Y', strtotime($date)) }}" data-projectId="WG-{{str_pad($planning->project_id, 4, '0', STR_PAD_LEFT)}}" data-customer="{{ $planning->company_name }}" data-info="{{ $planning->company_name }}" data-user_id="{{$user->id}}" id="planning_{{$planning->project_id}}_{{$user->id}}_{{$date}}" style="position:relative;{{$style}}" data-customid="planning_{{$planning->project_id}}_{{$user->id}}_{{$sequence}}" data-confirmed="{{$planning->confirmed}}" data-start="{{$planning->start_date}}" data-end="{{$planning->end_date}}">
                                        @if($planning->confirmed==0 && $otherPlanning->project_id==$planning->project_id)
                                        <span style="position:absolute;right:5px;bottom:10px;z-index:99" class="deletePlanning" data-date="{{$date}}" data-user_id="{{$user->id}}" data-project_id="{{$planning->project_id}}"><i class="fa text-danger fa-trash fa-2x"></i></span>
                                        @endif
                                        
                                        @php $staffs = PlanningController::getProjectUsers($planning->project_id, $date) @endphp
                                        
                                        <div class="project-info">
                                            <?php
                                                $merged = array($planning, $otherPlanning);

                                                // Convert to array (if needed)
                                                //$mergedArray = $merged->toArray();

                                                // Sort the merged array based on the 'period' key
                                                usort($merged, function($a, $b) {
                                                    return $a->period <=> $b->period; // Ascending order
                                                });
                                            ?>
                                            @if($otherPlanning->project_id!=$planning->project_id)
                                            
                                            
                                            @php $planning = $merged[0] @endphp
                                            @php $otherPlanning = $merged[1] @endphp
                                            <div style="position:relative" class="pro-1">
                                                <p class="fw-bold text-dark">{{ $planning->company_name }} </p>
                                                <small>WG-{{str_pad($planning->project_id, 4, '0', STR_PAD_LEFT)}}</small>
                                                
                                                @foreach($staffs as $staff)
                                                <div data-id="{{$staff->id}}" data-current_project_date="{{ $date }}" class="symbol draggable-2 symbol-20px symbol-circle" data-bs-toggle="tooltip" aria-label="Michael Eberon" data-bs-original-title="{{ $staff->firstname.' '.$staff->lastname }}" data-kt-initialized="1">
                                                    <img alt="Pic" src="{{asset('img/users/'.$staff->image)}}">
                                                </div>
                                                
                                                @endforeach
                                                <span style="position:absolute;right:5px;bottom:0px;z-index:99" class="deletePlanning" data-date="{{$date}}" data-user_id="{{$user->id}}" data-project_id="{{$planning->project_id}}"><i class="fa text-danger fa-trash fa-2x"></i></span>
                                                
                                            </div>
                                            @endif
                                            
                                            @if($otherPlanning->project_id!=$planning->project_id)
                                            
                                            <hr class="my-1">
                                            <div style="position:relative" class="pro-2">
                                                <p class="fw-bold text-dark">{{ $otherPlanning->company_name }} </p>
                                                <small>WG-{{str_pad($otherPlanning->project_id, 4, '0', STR_PAD_LEFT)}}</small>
                                                @php $otherStaffs = PlanningController::getProjectUsers($otherPlanning->project_id, $date) @endphp
                                               
                                                @foreach($otherStaffs as $staff)
                                                <div data-id="{{$staff->id}}" data-current_project_date="{{ $date }}" class="symbol draggable-2 symbol-20px symbol-circle" data-bs-toggle="tooltip" aria-label="Michael Eberon" data-bs-original-title="{{ $staff->firstname.' '.$staff->lastname }}" data-kt-initialized="1">
                                                    <img alt="Pic" src="{{asset('img/users/'.$staff->image)}}">
                                                </div>
                                                @endforeach
                                                <span style="position:absolute;right:5px;bottom:0px;z-index:99" class="deletePlanning" data-date="{{$date}}" data-user_id="{{$user->id}}" data-project_id="{{$otherPlanning->project_id}}"><i class="fa text-danger fa-trash fa-2x"></i></span>
                                                <span style="position:absolute;right:20px;bottom:0px;z-index:99"><i data-p1_id="{{ $planning->project_id }}" data-p2_id="{{ $otherPlanning->project_id }}" data-date="{{$date}}" data-user_id="{{$user->id}}" data-project_id="{{$otherPlanning->project_id}}" class="fa text-dark fa-refresh swapProjects fa-2x"></i></span>
                                            </div>
                                            
                                                
                                            
                                            @endif
                                            
                                            
                                                
                                            @if($otherPlanning->project_id==$planning->project_id)
                                            <div style="position:relative" class="pro-1">
                                                <p class="fw-bold text-dark">{{ $planning->company_name }} </p>
                                                <small>WG-{{str_pad($planning->project_id, 4, '0', STR_PAD_LEFT)}}</small>
                                                <div class="symbol-group symbol-hover flex-nowrap mt-3">
                                                    @foreach($staffs as $staff)
                                                    <div data-id="{{$staff->id}}" data-current_project_date="{{ $date }}" class="symbol draggable-2 symbol-35px symbol-circle" data-bs-toggle="tooltip" aria-label="Michael Eberon" data-bs-original-title="{{ $staff->firstname.' '.$staff->lastname }}" data-kt-initialized="1">
                                                        <img alt="Pic" src="{{asset('img/users/'.$staff->image)}}">
                                                    </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                            @endif
                                            
                                        </div>
                                    </div>
                                    @endif
                                </div>
                                @php 
                                    $i++; if($class=='next-same'){ $next_class = 'prev-same'; }else{ $next_class=''; $sequence++; } 
                                @endphp
                                @endforeach
                            </div>
                            @endforeach

                        </div>
                    </div>

                </div>
            </div>
            @else
            <!-- Month View -->
            <div class="row g-5 g-xl-10 mb-xl-10">
                <div class="col-md-12">
                    <div class="mb-8">
                       
                       @if(!request()->has('m'))
                        <a href="?week={{ request()->week-1 }}" class="btn btn-sm btn-icon btn-light">
                            <i class="ki-duotone ki-left fs-1"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span></i>
                        </a>

                        <span class="mb-0 @if(!request()->has('m')) mx-4 @endif" style="font-size:15px;color:#5E5E5E">{{ date('jS M', strtotime($dates[0])) }} - {{ date('jS M', strtotime(end($dates))) }} {{ date('Y', strtotime(end($dates))) }}</span>
                        <a href="?week={{ request()->week+1 }}" class="btn btn-icon btn-sm btn-light">
                            <i class="ki-duotone ki-right fs-1"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span></i>
                        </a>
                        @endif


                        <div class="btn-group ms-8" role="group" aria-label="Basic outlined example">
                            <a href="{{ route('planning.showPlanning') }}" class="btn btn-sm @if(request()->has('m')) btn-light @else btn-primary @endif">Week</a>
                            @foreach($months as $month)
                            <a href="{{ route('planning.showPlanning') }}?view=month&m={{$month}}" class="btn btn-sm @if(request()->has('m')) @if(request()->m==$month) btn-primary @else btn-light @endif @else btn-light @endif">{{ date('F Y', strtotime($month)) }}</a>
                            @endforeach
                        </div>
                        <div class="mt-5" style="display:flex">
                           @if(!request()->has('m'))
                            <label class="form-check form-switch form-check-custom form-check-solid" id="showProjects">
                                <input class="form-check-input w-30px h-20px" type="checkbox" value="1" name="notifications" id="projectsSwitch" >
                                <span class="form-check-label text-muted fs-7">Projects</span>
                            </label>
                            @endif
                            <label class="form-check form-switch form-check-custom form-check-solid ms-8" id="showSiteManagers">
                                <input class="form-check-input w-30px h-20px" type="checkbox" value="1" name="" id="siteManagers">
                                <span class="form-check-label text-muted fs-7">Site Managers</span>
                            </label>
                        </div>

                    </div>
                    <div class="calendar">
                        <div class="calendar-data">
                            <div class="header">
                                <div class="clock div">
                                    <p><i class="fa fa-2x fa-clock" style="font-size:18px"></i></p>
                                </div>
                                
                                @php $dates = PlanningController::getDatesOfMonth(request()->m) @endphp
                                
                                @foreach($dates as $date)
                                <div class="div">
                                    <p>{{ date('d', strtotime($date)) }}</p>
                                </div>
                                @endforeach
                            </div>
                            @foreach($users as $user)
                            <div class="timeline user_timeline_{{$user->department}}" id="user_{{$user->id}}">
                                <div class="clock div">
                                    <p>{{ $user->firstname }} {{ $user->lastname }}</p>
                                </div>
                                @php $i = 1; $next_class = ''; @endphp
                                @foreach($dates as $date)
                                @php $planning = PlanningController::getUserPlannings($user->id, $date) @endphp
                                @php 
                                    $resizable = 'resizable';
                                    $class = "";
                                    if(isset($dates[$i])){ 
                                        $planning_next = PlanningController::getUserPlannings($user->id, $dates[$i]);
                                        if($planning_next && isset($planning->project_id)){
                                            if($planning_next->project_id==$planning->project_id){
                                                $class = "next-same";
                                                $resizable = '';
                                            }elseif($planning_next->project_id!=$planning->project_id){
                                                $resizable = '';
                                            }
                                        }
                                    }
                                @endphp
                                

                                <div class="project-box">
                                   <div class="div droppable" data-id="{{ $user->id }}" data-date="{{ $date }}" >
                                        <p></p>
                                    </div>
                                    @if($planning)
                                    @php
                                        $staffs = PlanningController::getProjectUsers($planning->project_id, $date);
                                        $names = [];
                                        foreach ($staffs as $staff) {
                                            $names[] = $staff->firstname . ' ' . $staff->lastname;
                                        }
                                        $tooltip = '<b>Project:</b> '.$planning->company_name.' (WG-'.str_pad($planning->project_id, 4, '0', STR_PAD_LEFT).') <br><b>Date: </b>'.date('jS M Y', strtotime($date)).'<br><b>People working:</b> '.implode(', ', $names);
                                    @endphp
                                    <div style="background:{{$planning->border}}" class="project div calendar-project {{$next_class}} {{$class}} {{$resizable}}" data-id="{{ $planning->project_id }}" data-date="{{ $date }}" data-dateFormated="{{ date('jS M Y', strtotime($date)) }}" data-projectId="WG-{{str_pad($planning->project_id, 4, '0', STR_PAD_LEFT)}}" data-customer="{{ $planning->company_name }}" data-bs-toggle="tooltip" data-bs-original-title="{{ $tooltip }}" data-kt-initialized="1" data-bs-html="true" id="planning_{{$planning->project_id}}_{{$user->id}}_{{$date}}" data-user_id="{{$user->id}}">
                                        <div class="project-details p-3" style="display:none">
                                            <p class="fw-bold text-dark">{{ $planning->company_name }}</p>
                                            <small>WG-{{str_pad($planning->project_id, 4, '0', STR_PAD_LEFT)}}</small>
                                        </div>
                                    </div>
                                    @endif
                                </div>
                                @php 
                                    $i++; if($class=='next-same'){ $next_class = 'prev-same'; }else{ $next_class=''; } 
                                @endphp
                                @endforeach
                            </div>
                            @endforeach

                        </div>
                    </div>

                </div>
            </div>
            @endif
        </div>
    </div>
    <!--end::Content-->
</div>

<div class="modal fade" id="warningModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Warning</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="row mb-13">
                        <div class="col-md-12">
                            <div class="alert alert-warning">
                                Warning, <span id="booked_users"></span> are already booked on this date. <br> But you can still add <span id="all_users"></span>.
                            </div>
                        </div>
                    </div>


                    <input type="hidden" id="add_users">
                    <input type="hidden" id="add_users_project_id">
                    <input type="hidden" id="add_users_date">


                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" id="add_user_now" class="btn btn-primary">
                            Add Now

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


<div class="modal fade" id="projectModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-0">Diary Entry for</h1>
                        <p class="mb-3" id="project_date"></p>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="">Project</span>
                        </label>
                        <!--end::Label-->
                        <input readonly type="text" class="form-control " placeholder="Enter Name" value="" id="project_name" />
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <div class="row mb-5">
                            <div class="col-md-6">
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="">From</span>
                                </label>
                                <!--end::Label-->
                                <input type="date" class="form-control" id="sequence_start" />
                            </div>
                            <div class="col-md-6">
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="">To</span>
                                </label>
                                <!--end::Label-->
                                <input type="date" class="form-control" id="sequence_end" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <button class="btn btn-primary" id="updateDateRange" type="button">Update</button>
                            </div>
                        </div>
                        
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="">Notes</span>
                        </label>
                        <!--end::Label-->
                        <textarea class="form-control" name="notes" id="notes" cols="30" rows="5"></textarea>
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">

                        <!--end::Label-->
                        <div id="project_users_list"></div>


                    </div>




                    

                    <div class="text-end">
                        <button type="reset" id="revokeConfirmation" class="btn btn-warning me-3" >Revoke Confirmation</button>
                        <button type="reset" id="removeProject" class="btn btn-danger me-3" >Delete</button>
                        <button type="button" id="save_note" class="btn btn-primary">
                            Save

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

@endsection
@section('js')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/smoothness/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script>
    
    $('.fa-refresh').click(function() {
        // Get the contents of both divs
        var parent = $(this).parent().parent().parent();
        var content1 = parent.find('.pro-1').html();
        var content2 = parent.find('.pro-2').html();

        // Swap the contents
        parent.find('.pro-1').html(content2);
        parent.find('.pro-2').html(content1);
    });
    
    $(document).ready(function() {
        var groupedData = {};

        // Select all .project divs
        $('.project').each(function() {
            var customId = $(this).data('customid');
            var date = $(this).data('date');


            // Group by data-customid
            if (!groupedData[customId]) {
                groupedData[customId] = [];
            }
            groupedData[customId].push({ date: date, element: $(this) });
        });

        // Iterate through each group
        $.each(groupedData, function(customId, items) {
            // Sort dates if needed
            items.sort(function(a, b) {
                return new Date(a.date) - new Date(b.date);
            });

            // Get the first and last date
            var startDate = items[0].date;
            var endDate = items[items.length - 1].date;

            // Update each element with startdate and enddate
            $.each(items, function(index, item) {
                item.element.attr('data-startdate', startDate);
                item.element.attr('data-enddate', endDate);
                if (index === items.length - 1) {
                    if(item.element.data('confirmed')==0){
                        item.element.append('<span class="confirmDates" data-start="'+startDate+'" data-end="'+endDate+'" data-user_id="'+item.element.data('user_id')+'" style="position:absolute;top:5px;right:5px;z-index:99"><i class="fa fa-check-circle" style="font-size:15px"></i></span>');
                    }
                }
            });
        });
    });
    

    $(document).on('click', '.confirmDates', function(e){
        e.stopPropagation();
        var start = $(this).data('start');
        var end = $(this).data('end');
        var user_id = $(this).data('user_id');
        if(confirm('Are you sure want to confirm these dates?')){
            $.ajax({
                url: "{{ route('planning.confirmPlanning') }}",
                type: 'POST',
                data: {
                    start: start,
                    end: end,
                    user_id: user_id,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    location.reload();
                },
                error: function(response) {
                    alert('Error: ' + response.responseJSON.message);
                }
            });
        }
        
    });
    
    
    @if(!request()->has('m'))
    let isResizing = false;
    let gridChangeCounter = 0;
    let lastWidth = 170; // Initial width
    const gridSize = 173; // Define the grid size for snapping
    var startWidth = 0; // To keep track of the width at the start of the resize
    $(".resizable").resizable({
        handles: 'e,w',
        grid: [173, 0], // Snap to grid for width and very high value for height to prevent vertical snap
        start: function(event, ui) {
            // Store the width at the start of resizing
            startWidth = ui.size.width;
            isResizing = true;
        },
        resize: function(event, ui) {
            

            // Calculate the new width as original width + 173
            var originalWidth = 173; // Set this to your original width
            var newWidth = originalWidth + Math.round((ui.size.width - originalWidth) / 173) * 173;
            ui.size.width = newWidth;
            if (newWidth !== lastWidth) {
                gridChangeCounter += (newWidth > lastWidth) ? 1 : -1;
                lastWidth = newWidth;
                //console.log(gridChangeCounter);
            }
        },stop: function(event, ui) {
            var direction = '';
            if (ui.position.left < 0) {
                direction = 'left'; // Moved to the left, so resizing west
            }else{
                direction = 'right';
            }
            
            var date = $(this).data('date');
            var project_id = $(this).data('id');
            var user_id = $(this).data('user_id');
            addDays(date,project_id,user_id,gridChangeCounter,direction);
            //isResizing = false;
            
        }
    });
    
    $(document).ready(function() {
        $(".project-box").each(function() {
            var $thisBox = $(this);
            if($thisBox.prev(".project-box").find(".project").length>0){
                $thisBox.find(".project").find('.ui-resizable-w').hide();
            }
            
            if($thisBox.next(".project-box").find(".project").length>0){
                $thisBox.find(".project").find('.ui-resizable-e').hide();
            }
            
            if($thisBox.prev(".project-box").length==0){
                $thisBox.find(".project").find('.ui-resizable-w').hide();
            }
            
            
            var $resizable = $thisBox.find(".resizable");

            // Check if there is a resizable element in this box
            /*if ($resizable.length) {
                var $nextBox = $thisBox.next(".project-box");
                var $prevBox = $thisBox.prev(".project-box");
                if ($prevBox.find(".project").length>0) {
                    $resizable.find(".ui-resizable-w").hide();
                }
                // Check if the next box contains a resizable element
                if ($nextBox.find(".resizable").length) {
                    // Remove resizable class and disable resizable functionality
                    $resizable.removeClass("ui-resizable").resizable("destroy");
                }
            }*/
        });
    });
    
    @else
    let isResizing = false;
    let gridChangeCounter = 0;
    let lastWidth = 60; // Initial width
    const gridSize = 66; // Define the grid size for snapping
    var startWidth = 0; // To keep track of the width at the start of the resize
    $(".resizable").resizable({
        handles: 'e',
        grid: [60, 10000], // Snap to grid for width and very high value for height to prevent vertical snap
        start: function(event, ui) {
            // Store the width at the start of resizing
            startWidth = ui.size.width;
            isResizing = true;
        },
        resize: function(event, ui) {
            
            // Calculate the new width as original width + 173
            var originalWidth = 60; // Set this to your original width
            var newWidth = originalWidth + Math.round((ui.size.width - originalWidth) / 66) * 66;
            ui.size.width = newWidth;
            if (newWidth !== lastWidth) {
                gridChangeCounter += (newWidth > lastWidth) ? 1 : -1;
                lastWidth = newWidth;
                console.log(gridChangeCounter);
            }
        },stop: function(event, ui) {
            var resizingDirection = ui.size.width > startWidth ? 'right' : 'left';
            if(resizingDirection=='left'){
                return false;
            }
            var date = $(this).data('date');
            var project_id = $(this).data('id');
            var user_id = $(this).data('user_id');
            addDays(date,project_id,user_id,gridChangeCounter);
            //isResizing = false;
            
        }
    });
    
    @endif
    
    
    
    function addDays(date,project_id,user_id,gridChangeCounter,direction){
        $.ajax({
            url: "{{ route('planning.addPlanning') }}",
            type: 'POST',
            data: {
                project_id: project_id,
                user_id: user_id,
                date: date,
                days: gridChangeCounter,
                direction: direction,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                location.reload();
            },
            error: function(response) {
                alert('Error: ' + response.responseJSON.message);
            }
        });
    }
    
    $(".swapProjects").click(function(e){
        e.stopPropagation();
        var date = $(this).data('date');
        var project_id_1 = $(this).data('p1_id');
        var project_id_2 = $(this).data('p2_id');
        var user_id = $(this).data('user_id');
        $.ajax({
            url: "{{ route('planning.swapProjects') }}",
            type: 'POST',
            data: {
                project_id_1: project_id_1,
                project_id_2: project_id_2,
                user_id: user_id,
                date: date,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                location.reload();
            },
            error: function(response) {
                alert('Error: ' + response.responseJSON.message);
            }
        });
    });
    
    $(".deletePlanning").click(function(e){
        e.stopPropagation();
        var date = $(this).data('date');
        var project_id = $(this).data('project_id');
        var user_id = $(this).data('user_id');
        if (confirm('Are you sure want to remove?')) {
            $.ajax({
                url: "{{ route('planning.removeProject') }}",
                type: 'POST',
                data: {
                    project_id: project_id,
                    user_id: user_id,
                    date: date,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    location.reload();
                },
                error: function(response) {
                    alert('Error: ' + response.responseJSON.message);
                }
            });
        }
        
    })
    
    
    $('.project').hover(
        function() {
            // Mouse enter
            $(this).find('.deletePlanning').stop().fadeIn();
        },
        function() {
            // Mouse leave
            $(this).find('.deletePlanning').stop().fadeOut();
        }
    );
    
    
    @if(request()->has('m'))
    @foreach($users as $user)
        /*$(document).ready(function() {
            var $boxes = $('#user_{{$user->id}} .project');
            
            $boxes.each(function(index) {
                var hiddenCount = 1;
                var $currentBox = $(this);
                var currentBoxId = $currentBox.attr('id');
                console.log(currentBoxId);
                var currentId = $currentBox.data('id');
                var nextIndex = index + 1;

                while (nextIndex < $boxes.length && $boxes.eq(nextIndex).data('id') === currentId) {
                    $boxes.eq(nextIndex).addClass('hidden');
                    hiddenCount++;
                    nextIndex++;
                }
                
                @if(request()->has('m'))
                    if(hiddenCount==1){
                        var total_width = (hiddenCount*100);
                    }else{
                        var total_width = (hiddenCount*100)+(hiddenCount*6);
                        if(hiddenCount>2){
                           $("#"+currentBoxId).find('.project-details').css('display', 'block');
                        }
                    }
                    
                    $("#"+currentBoxId).css('width', (total_width)+'px');
                @else
                    var total_width = (hiddenCount*170)+((hiddenCount-1)*6);
                    $("#"+currentBoxId).css('width', (total_width)+'px');
                @endif
                
            });
        });*/
    @endforeach
    @endif
    
    
    var selected_project_id = 0;
    var selected_date = 0;
    var selected_current_date = 0;
    
    
    $("#save_note").click(function() {
        var project_id = selected_project_id;
        var date = selected_date;
        $.ajax({
            url: "{{ route('planning.saveNote') }}",
            type: 'POST',
            data: {
                project_id: project_id,
                date: date,
                note: $("#notes").val(),
                _token: '{{ csrf_token() }}',
            },
            success: function(response) {
                $("#projectModal").modal("hide");
            },
            error: function(response) {
                alert('Error: ' + response.responseJSON.message);
            }
        });
    });

    $(document).on('click', '.project', function() {
        if (isResizing) {
            return false;
        }
        var project_id = $(this).data('id');
        var projectId = $(this).data('projectid');
        var dateFormated = $(this).data('dateformated');
        var date = $(this).data('date');
        var customer = $(this).data('customer');
        var user_id = $(this).data('user_id');
        $("#updateDateRange").attr('data-user_id', user_id);
        $("#updateDateRange").attr('data-project_id', project_id);
        
        $("#sequence_start").val($(this).data('startdate'));
        $("#sequence_end").val($(this).data('enddate'));
        
        if($(this).data('confirmed')==1){
            $("#revokeConfirmation").attr('data-user_id', user_id);
            $("#revokeConfirmation").attr('data-start', $(this).data('start'));
            $("#revokeConfirmation").attr('data-end', $(this).data('end'));
            $("#revokeConfirmation").show();
            $("#removeProject").hide();
        }else{
            $("#revokeConfirmation").attr('data-user_id', "");
            $("#revokeConfirmation").attr('data-start', "");
            $("#revokeConfirmation").attr('data-end', "");
            $("#revokeConfirmation").hide();
            $("#removeProject").show();
        }
        
        selected_project_id = project_id;
        selected_date = date;
        $("#project_date").html(dateFormated);
        $("#project_name").val(customer + ' ' + projectId);

        $.ajax({
            url: "{{ route('planning.getPlanningDetails') }}",
            type: 'POST',
            data: {
                project_id: selected_project_id,
                date: selected_date,
                _token: '{{ csrf_token() }}',
            },
            success: function(response) {
                var data = JSON.parse(response);
                $("#notes").val(data.notes);
                var staffdata = '';
                for (var i = 0; i < data.staffs.length; i++) {
                    var type = "";
                    if (data.staffs[i].department == 'site_manager') {
                        type = 'Site Manager';
                    } else if (data.staffs[i].department == 'contracts_manager') {
                        type = 'Contracts Manager';
                    } else if (data.staffs[i].department == 'labourer') {
                        type = 'Labourer';
                    }
                    staffdata += '<div class="d-flex flex-stack user-item"><div class="symbol symbol-40px me-5"><img src="{{asset('img/users')}}/' + data.staffs[i].image + '" class="h-50 align-self-center" alt=""></div><div class="d-flex align-items-center flex-row-fluid flex-wrap"><div class="flex-grow-1 me-2"><a href="#!" class="text-gray-800 text-hover-primary fs-6 fw-bold user-name">' + data.staffs[i].firstname + ' ' + data.staffs[i].lastname + '</a><span class="text-muted fw-semibold d-block fs-7 user-company">' + type + '</span></div><i class="ki-outline text-danger ki-trash fs-2 removeFromProject" data-id="' + data.staffs[i].id + '"></i></div></div><div class="separator separator-dashed my-4"></div>';
                }

                $("#project_users_list").html(staffdata);
                $("#projectModal").modal("show");
            },
            error: function(response) {
                alert('Error: ' + response.responseJSON.message);
            }
        });

    });
    
    
    $("#updateDateRange").click(function(){
        if(confirm('Are you sure want to update the date range?')){
            var start = $("#sequence_start").val();
            var end = $("#sequence_end").val();
            var user_id = $(this).data('user_id');
            var project_id = $(this).data('project_id');
            $.ajax({
                url: "{{ route('planning.updateDateRange') }}",
                type: 'POST',
                data: {
                    start: start,
                    end: end,
                    user_id: user_id,
                    project_id: project_id,
                    _token: '{{ csrf_token() }}',
                },
                success: function(response) {
                    location.reload();
                },
                error: function(response) {
                    alert('Error: ' + response.responseJSON.message);
                }
            });
        }
    })
    
    
    $("#revokeConfirmation").click(function(){
        if(confirm('Are you sure want to revoke confirmation from this date range?')){
            var start = $(this).data('start');
            var end = $(this).data('end');
            var user_id = $(this).data('user_id');
            $.ajax({
                url: "{{ route('planning.revokeConfirmation') }}",
                type: 'POST',
                data: {
                    start: start,
                    end: end,
                    user_id: user_id,
                    _token: '{{ csrf_token() }}',
                },
                success: function(response) {
                    location.reload();
                },
                error: function(response) {
                    alert('Error: ' + response.responseJSON.message);
                }
            });
        }
    })


    $(function() {
        $('[data-bs-toggle="tooltip"]').tooltip();
    });

    $("#projectsSwitch").change(function() {
        if ($('#projectsSwitch').is(":checked")) {
            $("#floatingDiv").show();
        } else {
            $("#floatingDiv").hide();
        }
    })

    $("#siteManagers").change(function() {
        if ($('#siteManagers').is(":checked")) {
            $(".user_type_labourer").removeClass('d-flex').hide().next('.separator').hide();
            $(".user_timeline_labourer").hide();
        } else {
            $(".user_type_labourer").addClass('d-flex').next('.separator').show();
            $(".user_timeline_labourer").show();
        }
    })


    $(document).on('click', '.removeFromProject', function() {
        var user_id = $(this).data('id');
        $.ajax({
            url: "{{ route('planning.removeFromProject') }}",
            type: 'POST',
            data: {
                project_id: selected_project_id,
                user_id: user_id,
                date: selected_date,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                location.reload();
            },
            error: function(response) {
                alert('Error: ' + response.responseJSON.message);
            }
        });
    });


    $(document).on('click', '#removeProject', function() {
        if (confirm('Are you sure want to remove?')) {
            $.ajax({
                url: "{{ route('planning.removeProject') }}",
                type: 'POST',
                data: {
                    project_id: selected_project_id,
                    date: selected_date,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    location.reload();
                },
                error: function(response) {
                    alert('Error: ' + response.responseJSON.message);
                }
            });
        }
    });

    $("#add_user_now").click(function() {
        $.ajax({
            url: "{{ route('planning.addPlanning') }}",
            type: 'POST',
            data: {
                project_id: $("#add_users_project_id").val(),
                user_id: $("#add_users").val(),
                date: $("#add_users_date").val(),
                user_current_project: selected_current_date,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                location.reload();
            },
            error: function(response) {
                alert('Error: ' + response.responseJSON.message);
            }
        });
    })

    $(function() {
        // Make elements draggable
        $('.draggable').draggable({
            revert: 'invalid', // Reverts if not dropped on a droppable
            helper: 'clone', // Use a clone of the element as the helper
            start: function(event, ui) {
                $(ui.helper).addClass('dragging'); // Optional: Add a class to the helper
            }
        });

        // Make elements droppable
        $('.droppable').droppable({
            accept: '.draggable',
            drop: function(event, ui) {
                var draggedElement = ui.helper;
                var dropZone = $(this);

                // Transfer the dragged element's content or other data to the drop zone
                if (!dropZone.hasClass('locked')) {
                    dropZone.append(draggedElement.clone().removeClass('dragging'));
                    dropZone.addClass('locked');
                    // Trigger custom event
                    handleDrop(draggedElement, dropZone, getRandomItem(items));
                }
            }
        });
    });

    function getRandomItem(array) {
        return array[Math.floor(Math.random() * array.length)];
    }

    // Example usage
    const items = ['project-grey'];


    function handleDrop(draggedElement, dropZone, projectClass) {
        var draggedData = draggedElement.data('info');
        var project_id = draggedElement.data('id');
        var dropZoneId = dropZone.attr('id');
        var user_id = dropZone.data('id');
        var date = dropZone.data('date');
        var type = draggedElement.data('type');
        var start_date = draggedElement.data('date');
        $.ajax({
            url: "{{ route('planning.addPlanning') }}",
            type: 'POST',
            data: {
                project_id: project_id,
                user_id: user_id,
                date: date,
                type: type,
                start_date: start_date,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                location.reload();
            },
            error: function(response) {
                alert('Error: ' + response.responseJSON.message);
            }
        });

        $(dropZone).addClass('project');
        $(dropZone).addClass(projectClass);

        $(dropZone).html('<p class="fw-bold text-dark">' + draggedData + '</p><small>Lorem Ipsum is simply...</small>');
        $(dropZone).removeClass('droppable');
        $(dropZone).removeClass('ui-droppable');

        // Example of handling data transfer
        console.log(`Dragged Element Data: ${draggedData}`);
        console.log(`Dropped on Element ID: ${dropZoneId}`);

        // You can perform further actions here, e.g., updating the server
    }



    $(function() {
        // Make elements draggable
        $('.draggable-2').draggable({
            scroll: true,
            scrollSensitivity: 50,
            scrollSpeed: 10,
            revert: 'invalid',
            helper: 'clone',
            appendTo: 'body',
            start: function(event, ui) {
                // Get the current scroll position of the container
                var scrollTop = $('.user-list').scrollTop();
                var scrollLeft = $('.user-list').scrollLeft();

                // Adjust the helper position to account for scrolling
                ui.helper.css({
                    position: 'absolute',
                    top: ui.offset.top - scrollTop,
                    left: ui.offset.left - scrollLeft
                }).addClass('dragging');
            },
            drag: function(event, ui) {
                // Adjust position during drag
                var scrollTop = $('.user-list').scrollTop();
                var scrollLeft = $('.user-list').scrollLeft();

                ui.position.top -= scrollTop;
                ui.position.left -= scrollLeft;
            },
            stop: function(event, ui) {
                // Hide the original element after drop
                if (ui.helper.hasClass('dropped')) {
                    $(this).hide();
                }
            }
        });

        // Make elements droppable
        $('.droppable-2').droppable({
            accept: '.draggable-2',
            drop: function(event, ui) {
                var draggedElement = ui.helper;
                var dropZone = $(this);

                if (!dropZone.hasClass('locked')) {
                    // Add a marker class to helper indicating it was dropped
                    ui.helper.addClass('dropped');

                    // Append the clone to the drop zone
                    //dropZone.append(draggedElement.clone().removeClass('dragging dropped').css({position: 'relative', top: 'auto', left: 'auto'}));
                    //dropZone.addClass('locked');
                    handleDrop2(draggedElement, dropZone);
                }
            }
        });
    });

    function handleDrop2(draggedElement, dropZone) {
        var user_id = draggedElement.data('id');
        var user_current_project = draggedElement.data('current_project_date');
        selected_current_date = user_current_project;
        var dropZoneId = dropZone.attr('id');
        var draggedDataInfo = dropZone.data('info');
        var date = dropZone.data('date');
        var project_id = dropZone.data('id');


        $.ajax({
            url: "{{ route('planning.checkExistingUsers') }}",
            type: 'POST',
            data: {
                project_id: project_id,
                user_id: user_id,
                date: date,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                var data = JSON.parse(response);
                if (data.booked.length == 0) {
                    $.ajax({
                        url: "{{ route('planning.addPlanning') }}",
                        type: 'POST',
                        data: {
                            project_id: project_id,
                            user_id: user_id,
                            date: date,
                            user_current_project: user_current_project,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(response) {
                            location.reload();
                        },
                        error: function(response) {
                            alert('Error: ' + response.responseJSON.message);
                        }
                    });
                } else {
                    if (data.all_users.length == 0) {
                        alert('Sorry, the select user is already booked on this day.');
                    } else {
                        $("#warningModal").modal("show");
                        $("#booked_users").html(data.booked_names);
                        $("#all_users").html(data.unbooked_names);
                        $('#add_users').val(data.all_users.join(","));
                        $('#add_users_project_id').val(data.project_id);
                        $('#add_users_date').val(data.date);
                    }

                    //$("#booked_users").html(data.join(", "));
                    //alert(data.join(", "));
                }
            },
            error: function(response) {
                alert('Error: ' + response.responseJSON.message);
            }
        });


        //$(dropZone).removeClass('droppable');
        //$(dropZone).removeClass('ui-droppable');

        // Example of handling data transfer
        //console.log(`Dragged Element Data: ${draggedData}`);
        //console.log(`Dropped on Element ID: ${draggedDataInfo}`);

        // You can perform further actions here, e.g., updating the server
    }

</script>
<script>
    $(document).ready(function() {
        $("#userFilter").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            $(".user-item").each(function() {
                var name = $(this).find(".user-name").text().toLowerCase();
                var company = $(this).find(".user-company").text().toLowerCase();
                if (name.indexOf(value) > -1 || company.indexOf(value) > -1) {
                    $(this).attr("style", "display: flex !important");
                    $(this).next(".separator").attr("style", "display: block !important");
                } else {
                    $(this).attr("style", "display: none !important");
                    $(this).next(".separator").attr("style", "display: none !important");
                }
            });
        });

        $("#projectFilter").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            $(".project-item").each(function() {
                var name = $(this).find(".user-name").text().toLowerCase();
                var company = $(this).find(".user-company").text().toLowerCase();
                if (name.indexOf(value) > -1 || company.indexOf(value) > -1) {
                    $(this).attr("style", "display: flex !important");
                    $(this).next(".separator").attr("style", "display: block !important");
                } else {
                    $(this).attr("style", "display: none !important");
                    $(this).next(".separator").attr("style", "display: none !important");
                }
            });
        });
    });
    
    @if(request()->has('view'))
        $("#floatingDiv").hide();
        $("#kt_app_sidebar").hide();
        $("#kt_app_wrapper").css('margin-left', '0');
        $("#kt_app_header").css('left', '0');
    @endif

</script>
@endsection
