@extends('layouts.app')
@section('title', 'Time Sheet')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <style>
        .project-image {
            width: 100%;
            height: 428px;
            object-fit: cover;
        }

        iframe {
            width: 100% !important;
            height: 300px !important;
            margin: 0 !important;
            border-radius: 10px;
        }

        .nav-link {
            font-size: 18px;
            color: #5E5E5E;
        }

        .nav-pills .nav-link.active,
        .nav-pills .show>.nav-link {
            border: 1px solid #93D50066;
            background: white;
            color: black;
            font-weight: 500;
        }

        .page-heading {
            font-size: 24px !important;
        }

        .project-id {
            font-size: 18px;
            color: #556171 !important;
        }

        .image-container {
            position: relative;
            /*display: inline-block;*/
        }



        .overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transition: opacity 0.5s ease;
        }

        .image-container:hover .overlay {
            opacity: 1;
        }

        .upload-btn {
            background-color: #93D500;
            border: none;
            color: white;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 16px;
            margin: 4px 2px;
            cursor: pointer;
            border-radius: 12px;
        }

        .project-image {
            width: 100%;
            height: 428px;
            object-fit: cover;
        }


        .select2-container--bootstrap5 .select2-selection--multiple .select2-selection__rendered .select2-selection__choice {
            background-color: #93D500;
            color: black;
        }

        .correspondence {
            border: 1px solid #E1E1E1;
            background: #FAFAFA;
            padding: 15px;
            border-radius: 10px;
        }

        .cr-title {
            font-size: 16px;
            font-weight: 500;
        }

        .cr-description {
            color: #5E5E5E;
            font-size: 14px;
            font-weight: 400;
        }

        .cr-time {
            color: #556171;
            font-size: 16px;
            font-weight: 400;
        }

        table p {
            margin-bottom: 0;
        }

        .table td,
        .table th {
            vertical-align: middle;
        }

        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 14px !important;
            color: black !important;
            text-align: center;
            color: #727879;
            font-size: 16px;
        }



        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            padding: 15px;
            text-align: center;
        }





        table.table-bordered.dataTable {
            border: 0;
            border-bottom: 0;
        }

        input[readonly] {
            background-color: #E3E3E3;
            /* Change this to your desired color */
        }

        table.dataTable.no-footer {
            border-bottom: 0 !important;
        }

        .table-field {
            display: none;
        }

        .form-check-input:checked {
            border-color: #93d500;
        }

        .form-check-input {
            border-color: grey;
        }

        .table-checkbox {
            /*display: none;*/
        }



        .form-check {
            display: flex;
            justify-content: center;
        }
        
        tr{
            cursor: pointer;
        }
        
        .accept-btn{
            color: #008C0E !important;
            border: 1px solid #008C0E33 !important;
            background: #e5f3e7 !important;
            font-size: 15px;
        }
        
        .accept-btn i{
            color: #008C0E !important;
            font-size: 20px;
            font-weight: bold;
        }
        
        .third_party{
            display: none;
        }

    </style>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">



            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif
            
            @if(session('danger'))
            <div class="alert alert-danger">
                {{ session('danger') }}
            </div>
            @endif

            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif

            <div class="card mb-8">
                <div class="card-body">
                    <form action="" method="get">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="" class="form-label">Filter by <span class="type_name">Staff</span></label>
                                <select name="user_id" class="form-control mb-3" id="user_id">
                                    <option value="" id="select_staff">Select Staff</option>
                                    @foreach($users as $user)
                                    <option value="{{ $user->id }}" class="@if($user->third_party==1) third_party @else staff @endif">{{ $user->firstname }} {{ $user->lastname }}</option>
                                    @endforeach
                                </select>
                                <div class="text-start">
                                    <label class="form-check form-switch form-check-custom form-check-solid" id="showProjects">
                                        <input class="form-check-input w-30px h-20px" type="checkbox" value="1" name="showContractors" id="showContractors">
                                        <span class="form-check-label text-muted fs-7">Contractors</span>
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="" class="form-label">Filter by Date Range</label>
                                <input class="form-control " placeholder="Pick date rage" id="kt_daterangepicker_2" />
                            </div>

                            <div class="col-md-3">
                                <label for="" class="form-label">Filter by Project ID</label>
                                <select name="project_id" class="form-control" id="project_id">
                                    <option value="">Select Project ID</option>
                                    @foreach($projects as $project)
                                    <option value="{{ $project->id }}">WG-{{str_pad($project->id, 4, '0', STR_PAD_LEFT)}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <input type="hidden" id="start-date" name="start_date" value="{{$start}}">
                            <input type="hidden" id="end-date" name="end_date" value="{{$end}}">
                            <div class="col-md-2">
                                <label for="" class="form-label" style="opacity:0">Filter by Project ID</label>
                                <input type="hidden" name="filter" value="1">
                                <button class="btn btn-primary">Filter</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="card mb-7">
                <div class="card-header " id="kt_chat_contacts_header">
                    <!--begin::Card title-->
                    <div class="card-title justify-content-between">
                        <div class="d-flex align-items-center">
                            <h3 class="fw-bold"><i class="fa-solid fa-clock me-2 text-dark" style="font-size:18px"></i> Time Sheet</h3>
                            
                             
                        </div>
                       
                    </div>
                    <div class="align-self-center">
                        <button class="btn btn-primary btn-sm" id="addUser">Add User</button>
                    </div>

                    <!--end::Card title-->
                </div>
                <div class="card-body py-2 px-2">
                    <div class="" style="border-radius:10px">
                        <!--begin::Table-->
                        <div class="">
                            <table class="table table-bordered financial-table" id="kt_table_users">
                                <thead>
                                    <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                        <th>Name</th>
                                        <th>Project ID</th>
                                        <th>Miles Travelled</th>
                                        <th>Date</th>
                                        <th>Start time</th>
                                        <th>End time</th>
                                        <th>Total hours</th>
                                        <th>Approved</th>
                                    </tr>
                                </thead>
                                <tbody class="text-gray-600 fw-semibold">
                                    @foreach($records as $record)
                                    <tr class="time-row" data-id="{{ $record->id }}" data-project="WG-{{str_pad($record->project_id, 4, '0', STR_PAD_LEFT)}}" data-date="{{ date('jS M Y', strtotime($record->date)) }}" data-user="{{ $record->firstname }} {{ $record->lastname }}" data-start="{{ $record->start_time }}" data-end="{{ $record->end_time }}" data-mins="{{ $record->mins_travelled }}" data-miles="{{ $record->miles_travelled}}">
                                        <td>{{ $record->firstname }} {{ $record->lastname }}</td>
                                        <td>WG-{{str_pad($record->project_id, 4, '0', STR_PAD_LEFT)}}</td>
                                        <td>{{ $record->miles_travelled }}</td>
                                        <td>{{ date('jS M Y', strtotime($record->date)) }}</td>
                                        <td>{{ $record->start_time }}</td>
                                        <td>{{ $record->end_time }}</td>
                                        <td>
                                            @if(!empty($record->start_time))
                                                @php
                                                $hour = \App\Http\Controllers\PlanningController::calculateHours($record->start_time, $record->end_time)
                                                @endphp
                                                {{ number_format($hour, 2) }} Hours
                                            @endif
                                        </td>
                                        <td>
                                            @if(!empty($record->start_time))
                                                <div class="form-check">
                                                    <input class="form-check-input approval" @if($record->approved==1) checked @endif data-id="{{ $record->id }}" type="checkbox"  />
                                                </div>
                                            @endif
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!--end::Table-->
            </div>
        </div>
    </div>
    <!--end::Content-->
</div>

<div class="modal fade" id="timesheetModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" action="{{ route('planning.addTimeData') }}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-0">Add Time Data</h1>
                        <p class="mb-3" id="project_date"></p>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="">Project</span>
                        </label>
                        <!--end::Label-->
                        <input readonly type="text" class="form-control " placeholder="Enter Name" value="" id="project_name" />
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="">Start Time</span>
                                </label>
                                <!--end::Label-->
                                <input required type="text" class="form-control timePicker" name="start_time" id="modal_start_time">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="">End Time</span>
                                </label>
                                <!--end::Label-->
                                <input required type="text" name="end_time" class="form-control timePicker" id="modal_end_time">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="">Miles Travelled</span>
                                </label>
                                <!--end::Label-->
                                <input type="number" class="form-control" name="miles_travelled" id="modal_miles">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="">Mins Travelled</span>
                                </label>
                                <!--end::Label-->
                                <input type="number" class="form-control" name="mins_travelled" id="modal_mins">
                                <input type="hidden" class="form-control" name="planning_id" id="planning_id">
                            </div>
                        </div>
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">

                        <!--end::Label-->
                        <div id="project_users_list"></div>


                    </div>
                    <div class="text-end">
                        <button type="reset"  class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="" class="btn btn-primary">
                            Save

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

<div class="modal fade" id="addUserModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" action="{{ route('planning.addUserTimesheet') }}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-0">Add User to Time Sheet</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="">Project</span>
                        </label>
                        <!--end::Label-->
                        <select required id="select_project" name="project_id" data-placeholder="Select project" class="form-select">
                            <option value="">Select Project</option>
                            @foreach($projects as $project)
                            <option value="{{$project->id}}">{{$project->company_name}} (WG-{{str_pad($project->id, 4, '0', STR_PAD_LEFT) }})</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="">User</span>
                                </label>
                                <!--end::Label-->
                                <select required id="select_user" name="user_id" data-placeholder="Select user" class="form-select">
                                    <option value="">Select User</option>
                                    @foreach($users as $user)
                                    <option value="{{$user->id}}">{{$user->firstname}} {{ $user->lastname }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="">Date</span>
                                </label>
                                <!--end::Label-->
                                <input required type="date" name="date" class="form-control " placeholder="Select Date" />
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="">Start Time</span>
                                </label>
                                <!--end::Label-->
                                <input required type="text" class="form-control timePicker" name="start_time">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="">End Time</span>
                                </label>
                                <!--end::Label-->
                                <input required type="text" name="end_time" class="form-control timePicker">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="">Miles Travelled</span>
                                </label>
                                <!--end::Label-->
                                <input type="number" class="form-control" name="miles_travelled" id="modal_miles">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="">Mins Travelled</span>
                                </label>
                                <!--end::Label-->
                                <input type="number" class="form-control" name="mins_travelled" id="modal_mins">
                                <input type="hidden" class="form-control" name="planning_id" id="planning_id">
                            </div>
                        </div>
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">

                        <!--end::Label-->
                        <div id="project_users_list"></div>


                    </div>
                    <div class="text-end">
                        <button type="reset"  class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="" class="btn btn-primary">
                            Save

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


@endsection


@section('js')
<script>
    
    toastr.options = {
      "closeButton": false,
      "debug": false,
      "newestOnTop": false,
      "progressBar": false,
      "positionClass": "toastr-top-right",
      "preventDuplicates": false,
      "onclick": null,
      "showDuration": "300",
      "hideDuration": "1000",
      "timeOut": "5000",
      "extendedTimeOut": "1000",
      "showEasing": "swing",
      "hideEasing": "linear",
      "showMethod": "fadeIn",
      "hideMethod": "fadeOut"
    };
    
    
    @if(request()->has('showContractors'))
        $("#showContractors").prop('checked', true);
        $(".third_party").show();
        $(".staff").hide();
        $(".type_name").html("Contractor");
        $("#select_staff").text('Select Contractor');
        
    @endif
    
    $("#showContractors").change(function(){
        if($(this).is(":checked")){
            $(".third_party").show();
            $(".staff").hide();
            $(".type_name").html("Contractor");
            $("#select_staff").text('Select Contractor');
        }else{
            $(".third_party").hide();
            $(".staff").show();
            $(".type_name").html("Staff");
            $("#select_staff").text('Select Staff');
        }
    })
    
    $(".approval").click(function(e){
        e.stopPropagation();
        var approved = 0;
        if($(this).is(':checked')){
            approved = 1;
        }else{
            approved = 0;
        }
        
        var planning_id = $(this).data('id');
        $.ajax({
            url: '{{route("planning.approvePlanning")}}', // Replace with your server endpoint
            method: 'POST',
            data: { approved: approved, planning_id: planning_id,  },
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
            },
            success: function(response) {
                if(approved==1){
                    toastr.success('Approved Successfully.');
                }else{
                    toastr.success('Unapproved Successfully.');
                }
            }
        }); 
    });
    
    $('#select_user, #select_project').select2({
        dropdownParent: $('#addUserModal')
    });
    
    $("#addUser").click(function(){
        $("#addUserModal").modal("show");
    })
    
    $(".time-row").click(function() {
        var id = $(this).data('id');
        $("#project_name").val($(this).data('project'));
        $("#modal_start_time").val($(this).data('start'));
        $("#modal_end_time").val($(this).data('end'));
        $("#modal_mins").val($(this).data('mins'));
        $("#modal_miles").val($(this).data('miles'));
        $("#project_name").val($(this).data('project'));
        $("#project_date").html($(this).data('date')+' | '+$(this).data('user'));
        $("#planning_id").val($(this).data('id'));
        $('#timesheetModal').modal("show");
    });

    @if(request()->has('filter'))
        $("#user_id").val('{{ request()->user_id }}');
        $("#project_id").val('{{ request()->project_id }}');
    @endif

    $("#kt_daterangepicker_2").daterangepicker({
        timePicker: true,
        startDate: '{{ date("d-m-Y", strtotime($start)) }}',
        endDate: '{{ date("d-m-Y", strtotime($end)) }}',
        locale: {
            format: "DD-MM-Y",
            separator: ' / '
        },
        timePicker: false
    }, function(start, end) {
        $('#start-date').val(start.format('YYYY-MM-DD'));
        $('#end-date').val(end.format('YYYY-MM-DD'));
    });

</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/5.0.9/jquery.inputmask.min.js"></script>
<script>
    $(document).ready(function(){
         $(".timePicker").inputmask("99:99", {
            placeholder: "HH:MM",
            insertMode: false,
            showMaskOnHover: false,
            hourFormat: 24
        });
    });
</script>
@endsection
