@extends('layouts.app')
@section('title', 'Project Details')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <style>
        .project-image {
            width: 100%;
            height: 428px;
            object-fit: cover;
        }

        iframe {
            width: 100% !important;
            height: 300px !important;
            margin: 0 !important;
            border-radius: 10px;
        }

        .nav-link {
            font-size: 18px;
            color: #5E5E5E;
        }

        .nav-pills .nav-link.active,
        .nav-pills .show>.nav-link {
            border: 1px solid #93D50066;
            background: white;
            color: black;
            font-weight: 500;
        }

        .page-heading {
            font-size: 24px !important;
        }

        .project-id {
            font-size: 18px;
            color: #556171 !important;
        }

        .image-container {
            position: relative;
            /*display: inline-block;*/
        }



        .overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transition: opacity 0.5s ease;
        }

        .image-container:hover .overlay {
            opacity: 1;
        }

        .upload-btn {
            background-color: #93D500;
            border: none;
            color: white;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 16px;
            margin: 4px 2px;
            cursor: pointer;
            border-radius: 12px;
        }

        .project-image {
            width: 100%;
            height: 428px;
            object-fit: cover;
        }
        
        
        .select2-container--bootstrap5 .select2-selection--multiple .select2-selection__rendered .select2-selection__choice{
            background-color: #93D500;
            color: black;
        }
        
        .correspondence{
            border: 1px solid #E1E1E1;
            background: #FAFAFA;
            padding: 15px;
            border-radius: 10px;
        }
        
        .cr-title{
            font-size: 16px;
            font-weight: 500;
        }
        
        .cr-description{
            color: #5E5E5E;
            font-size: 14px;
            font-weight: 400;
        }
        
        .cr-time{
            color: #556171;
            font-size: 16px;
            font-weight: 400;
        }
        
        

    </style>
    @include('project.head')
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <div class="row align-items-center mb-7">
                <div class="col-md-12">
                    @include('project.nav')
                </div>

            </div>


            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif

            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif

            <div class="card mb-7">




                <div class="card-header " id="kt_chat_contacts_header">
                    <!--begin::Card title-->
                    <div class="card-title justify-content-between">
                        <i class="ki-outline ki-file fs-1 me-2"></i>
                        <div class="d-flex align-items-center">
                            <h3 class="fw-bold">Correspondence</h3>
                            <button data-bs-toggle="modal" data-bs-target="#kt_modal_new_target" class="btn ms-5 btn-sm btn-primary align-self-center">Add Correspondence</button>
                        </div>
                        



                    </div>
                    <a href="{{route('project.emails', ['id'=>$project->id])}}" class="btn btn-sm btn-primary align-self-center"><i class="ki-outline fs-2  ki-sms"></i> All Emails</a>
                    <!--end::Card title-->
                </div>
                
                <div class="card-body">
                    @foreach($correspondence as $cr)
                    <div class="correspondence mb-5">
                        <p class="fw-bold cr-title">{{$cr->title}} <span class="float-end cr-time">{{$cr->created_at}} <i class="ki-outline fs-2 ms-7 ki-notepad-edit"></i></span></p>
                        <p class="cr-description">{{$cr->notes}}</p>
                    </div>
                    @endforeach
                </div>





            </div>

        </div>
    </div>
    <!--end::Content-->
</div>

<div class="modal fade" id="kt_modal_new_target" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('project.addCorrespondence', ['id'=>$project->id])}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add Correspondence</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Title</span>
                        </label>
                        <!--end::Label-->
                        <input required type="text" class="form-control " placeholder="Enter Title" name="title" />
                    </div>

                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Add People</span>
                        </label>
                        <!--end::Label-->
                        <select required name="users[]" class="form-select" multiple id="add_people" data-placeholder="Select people">
                            <option></option>
                            @foreach($users as $user)
                            <option value="{{$user->id}}">{{$user->firstname}} {{$user->lastname}}</option>
                            @endforeach
                        </select>

                    </div>

                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Notes</span>
                        </label>
                        <!--end::Label-->
                        <textarea required name="notes" class="form-control" id="" cols="30" rows="5"></textarea>

                    </div>






                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


@endsection


@section('js')
<script>
    
    $('#add_people').select2({
        dropdownParent: $('#kt_modal_new_target')
    });
    
    $(".assign-manager").click(function() {
        $("#manager_type_heading").html($(this).data('type'));
        $("#manager_type").val($(this).data('type'));
    })

    /*
var table = $("#kt_table_users").DataTable({
    "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
    "paging": false,//Dont want paging                
    "bPaginate": false,//Dont want paging
});

$('#mySearch').on('input', function() {
  table.search($(this).val()).draw();
})*/

</script>
@endsection
