@extends('layouts.app')
@section('title', 'Project Details')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <style>
        .project-image {
            width: 100%;
            height: 428px;
            object-fit: cover;
        }

        iframe {
            width: 100% !important;
            height: 300px !important;
            margin: 0 !important;
            border-radius: 10px;
        }

        .nav-link {
            font-size: 18px;
            color: #5E5E5E;
        }

        .nav-pills .nav-link.active,
        .nav-pills .show>.nav-link {
            border: 1px solid #93D50066;
            background: white;
            color: black;
            font-weight: 500;
        }

        .page-heading {
            font-size: 24px !important;
        }

        .project-id {
            font-size: 18px;
            color: #556171 !important;
        }

        .image-container {
            position: relative;
            /*display: inline-block;*/
        }



        .overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transition: opacity 0.5s ease;
        }

        .image-container:hover .overlay {
            opacity: 1;
        }

        .upload-btn {
            background-color: #93D500;
            border: none;
            color: white;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 16px;
            margin: 4px 2px;
            cursor: pointer;
            border-radius: 12px;
        }

        .project-image {
            width: 100%;
            height: 428px;
            object-fit: cover;
        }

    </style>
    @include('project.head')
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <div class="row align-items-center mb-7">
                <div class="col-md-12">
                    @include('project.nav')
                </div>

            </div>


            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif
            
            @if(session('danger'))
            <div class="alert alert-danger">
                {{ session('danger') }}
            </div>
            @endif

            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif
            <div class="card mb-7">
                <div class="card-body p-0">
                    <div class="p-3">
                        <div class="image-container">
                            <img class="project-image" src="{{asset('img/projects/'.$project->image)}}" alt="">
                            <div class="overlay">
                                <button class="upload-btn" onclick="$('#project_image').trigger('click')">Update Image</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <form id="image_form" style="display:none" action="{{route('project.uploadImage', ['id'=>$project->id])}}" enctype="multipart/form-data" method="post">
                @csrf
                <input type="file" name="image" id="project_image" onchange="$('#image_form').submit();">
            </form>
            
            <div class="card mb-7">
                <div class="card-header " id="kt_chat_contacts_header">
                    <!--begin::Card title-->
                    <div class="card-title justify-content-between">
                        <i class="ki-outline ki-file fs-1 me-2"></i>
                        <h3 class="fw-bold">Project 
                        
                        @if($project->rams==0)
                        <button id="create_rams_btn" class="btn ms-5 btn-sm btn-primary">Create RAMS Document</button>
                        @else
                        <span style="margin-left:15px;font-size:13px;font-style:italic;font-weight:normal">Rams document created on {{ date('d M Y', strtotime($project->rams_date)) }} 
                        
                        @if(!empty($project->rams_last_updated))
                        (Last updated on {{ date('d M Y', strtotime($project->rams_last_updated)) }})
                        @endif
                        
                        </span>
                        @endif
                        
                        </h3>

                    </div>
                    
                    <div class="align-self-center">
                        @if($project->rams==1)
                        <button id="update_rams_btn" class="btn btn-sm btn-primary mr-3">Update Rams Document</button>
                        <button id="rams_pdf_btn" class="btn btn-sm btn-primary mr-3">Rams Latest PDF</button>
                        @endif

                        
                    </div>
                    <!--end::Card title-->
                </div>
                <div class="card-body">
                    <form action="{{route('project.updateProject', ['id'=>$project->id])}}" method="post" id="updateProjectForm">
                        @csrf
                        <div class="row mb-5">
                            <div class="col-md-6">
                                <label class="col-form-label fw-semibold fs-6">Title</label>
                                <input name="title" type="text" class="form-control form-control-lg " value="{{$project->title}}">
                            </div>
                            <div class="col-md-6">
                                <label class="col-form-label fw-semibold fs-6">Project Type</label>
                                <select required id="project_type" name="project_type" data-placeholder="Select Project Type" class="form-select">
                                    <option value="">Select Project Type</option>
                                    @foreach($project_types as $type)
                                    <option @if($project->project_type==$type->id) selected @endif value="{{$type->id}}">{{$type->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="float-end">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                </div>
                            </div>
                        </div>
                        
                    </form>
                </div>
            </div>
            
            <div class="card mb-7">
                <div class="card-header " id="kt_chat_contacts_header">
                    <!--begin::Card title-->
                    <div class="card-title">
                        <i class="ki-outline ki-badge fs-1 me-2"></i>
                        <h3 class="fw-bold">Client</h3>
                        
                    </div>
                    <button onclick="$('#customerForm').submit()" class="btn btn-sm btn-secondary align-self-center">Update</button>
                    <!--end::Card title-->
                </div>
                <div class="card-body">
                    <form action="{{route('project.updateCustomer', ['id'=>$project->id])}}" method="post" id="customerForm">
                       @csrf
                        <div class="row mb-5">
                            <div class="col-md-4">
                                <label class="col-form-label fw-semibold fs-6">Client</label>
                                <select required id="customer" name="customer_id" aria-label="Select" data-control="select2" data-placeholder="Select customer" class="form-select  form-select-lg fw-semibold">
                                    <option value="">Select Client</option>
                                    @foreach($customers as $customer)
                                    <option @if($customer->id==$project->customer_id) selected @endif value="{{$customer->id}}">{{$customer->company_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label fw-semibold fs-6">Client Ref</label>
                                <input name="customer_ref" type="text" class="form-control form-control-lg " value="{{$project->customer_ref}}">
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label fw-semibold fs-6">Status <span>(<a href="#!" id="update_status">Update Status</a>)</span></label>
                                <input readonly type="text" class="form-control form-control-lg " value="{{$project->status}}">
                            </div>
                        </div>
                        <div class="row mb-5">
                            <div class="col-md-4">
                                <label class="col-form-label fw-semibold fs-6">Name</label>
                                <input name="name" required type="text" class="form-control form-control-lg " value="{{$project->customer_name}}">
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label fw-semibold fs-6">Email</label>
                                <input name="email" required type="email" class="form-control form-control-lg " value="{{$project->customer_email}}">
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label fw-semibold fs-6">Phone</label>
                                <input name="phone" type="text" class="form-control form-control-lg " value="{{$project->customer_phone}}">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <label class="col-form-label fw-semibold fs-6">Address</label>
                                <input name="name" required type="text" class="form-control form-control-lg " value="{{$customer->address_1}}">
                            </div>
                            
                        </div>
                    </form>
                </div>
            </div>
            <div class="card mb-7">
                <div class="card-header " id="kt_chat_contacts_header">
                    <!--begin::Card title-->
                    <div class="card-title justify-content-between">
                        <i class="ki-outline ki-user fs-1 me-2"></i>
                        <h3 class="fw-bold">End Client</h3>

                    </div>
                    <button onclick="$('#endCustomerForm').submit()" class="btn btn-sm btn-secondary align-self-center">Update</button>
                    <!--end::Card title-->
                </div>
                <div class="card-body">
                    <form action="{{route('project.updateEndCustomer', ['id'=>$project->id])}}" method="post" id="endCustomerForm">
                        @csrf
                        <div class="row mb-5">
                            <div class="col-md-4">
                                <label class="col-form-label fw-semibold fs-6">Name</label>
                                <input name="name" type="text" class="form-control form-control-lg " value="{{$project->end_customer_name}}" required>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label fw-semibold fs-6">Phone</label>
                                <input name="phone" type="text" class="form-control form-control-lg " value="{{$project->end_customer_phone}}" required>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label fw-semibold fs-6">Email</label>
                                <input name="email" type="text" class="form-control form-control-lg " value="{{$project->end_customer_email}}" required>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label class="col-form-label fw-semibold fs-6">Address</label>
                                <input name="address" type="text" class="form-control form-control-lg " value="{{$project->end_customer_address}}" required>
                            </div>
                            <div class="col-md-6">
                                <label class="col-form-label fw-semibold fs-6">City</label>
                                <input name="city" type="text" class="form-control form-control-lg " value="{{$project->end_customer_city}}" required>
                            </div>
                            <div class="col-md-6">
                                <label class="col-form-label fw-semibold fs-6">Postcode</label>
                                <input name="postcode" type="text" class="form-control form-control-lg " value="{{$project->end_customer_postcode}}" required>
                            </div>
                            <div class="col-md-6">
                                <label class="col-form-label fw-semibold fs-6">Account No.</label>
                                <input name="account_no" type="text" class="form-control form-control-lg " value="{{$project->end_customer_account_no}}" required>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
            <div class="card mb-7">
                <div class="card-header " id="kt_chat_contacts_header">
                    <!--begin::Card title-->
                    <div class="card-title justify-content-between">
                        <i class="ki-outline ki-map fs-1 me-2"></i>
                        <h3 class="fw-bold">Location</h3>

                    </div>

                    @if(empty($project->location))
                    <button data-bs-toggle="modal" data-bs-target="#kt_modal_new_target" class="btn btn-sm btn-secondary align-self-center">Set Location</button>
                    @else
                    <button data-bs-toggle="modal" data-bs-target="#kt_modal_new_target" class="btn btn-sm btn-secondary align-self-center">Update Location</button>
                    @endif

                    <!--end::Card title-->
                </div>
                <div class="card-body p-3">
                    {!! $project->location !!}
                </div>
            </div>
            <div class="card mb-7">
                <div class="card-header " id="kt_chat_contacts_header">
                    <!--begin::Card title-->
                    <div class="card-title justify-content-between">
                        <i class="ki-outline ki-briefcase fs-1 me-2"></i>
                        <h3 class="fw-bold">Contracts Manager</h3>

                    </div>
                    @if($project->contracts_manager==0)
                    <button class="btn btn-sm btn-secondary assignContractsManager align-self-center" data-type="Contracts" data-bs-toggle="modal" data-bs-target="#kt_modal_new_target_2">Assign</button>
                    @else
                    <button class="btn btn-sm btn-secondary assignContractsManager align-self-center" data-type="Contracts" data-bs-toggle="modal" data-bs-target="#kt_modal_new_target_2">Update</button>
                    @endif
                    <!--end::Card title-->
                </div>
                <div class="card-body">
                    <!--begin::Table container-->
                    <div class="table-responsive">
                        <!--begin::Table-->
                        <table class="table align-middle gs-0 gy-4">
                            <!--begin::Table head-->
                            <thead>
                                <tr class="fw-bold text-muted bg-light">
                                    <th class="ps-4 min-w-200px rounded-start">Name</th>
                                    <th class="min-w-125px">Email</th>
                                    <th class="min-w-125px">Phone</th>
                                </tr>
                            </thead>
                            <!--end::Table head-->
                            <!--begin::Table body-->
                            <tbody>
                                    @if(!empty($contracts_manager))
                                    <tr>
                                        <td>{{$contracts_manager->firstname}} {{$contracts_manager->lastname}}</td>
                                        <td>{{$contracts_manager->email}}</td>
                                        <td>{{$contracts_manager->phone}}</td>
                                    </tr>
                                    @endif
                            </tbody>
                            <!--end::Table body-->
                        </table>
                        <!--end::Table-->
                    </div>
                    <!--end::Table container-->
                </div>
            </div>
            <div class="card mb-7">
                <div class="card-header " id="kt_chat_contacts_header">
                    <!--begin::Card title-->
                    <div class="card-title justify-content-between">
                        <i class="ki-outline ki-briefcase fs-1 me-2"></i>
                        <h3 class="fw-bold">Site Manager</h3>

                    </div>
                    @if($project->site_manager==0)
                    <button class="btn btn-sm btn-secondary  align-self-center assignSiteManager">Assign</button>
                    @else
                    <button class="btn btn-sm btn-secondary assignSiteManager align-self-center">Update</button>
                    @endif
                    
                    <!--end::Card title-->
                </div>
                <div class="card-body">
                    <!--begin::Table container-->
                    <div class="table-responsive">
                        <!--begin::Table-->
                        <table class="table align-middle gs-0 gy-4">
                            <!--begin::Table head-->
                            <thead>
                                <tr class="fw-bold text-muted bg-light">
                                    <th class="ps-4 min-w-200px rounded-start">Name</th>
                                    <th class="min-w-125px">Email</th>
                                    <th class="min-w-125px">Phone</th>
                                </tr>
                            </thead>
                            <!--end::Table head-->
                            <!--begin::Table body-->
                            <tbody>
                                    @if(!empty($site_manager))
                                    <tr>
                                        <td>{{$site_manager->firstname}} {{$site_manager->lastname}}</td>
                                        <td>{{$site_manager->email}}</td>
                                        <td>{{$site_manager->phone}}</td>
                                    </tr>
                                    @endif
                            </tbody>
                            <!--end::Table body-->
                        </table>
                        <!--end::Table-->
                    </div>
                    <!--end::Table container-->
                </div>
            </div>
        </div>
    </div>
    <!--end::Content-->
</div>

<div class="modal fade" id="kt_modal_new_target" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-dialog-centered mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('project.updateLocation', ['id'=>$project->id])}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Update Project Location</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Enter Embed Code</span>
                        </label>
                        <!--end::Label-->
                        <textarea required name="location" class="form-control" id="" cols="30" rows="10">{{$project->location}}</textarea>
                    </div>






                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Save Changes

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>
<div class="modal fade" id="assignContractsManager" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body  px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('project.assignManager', ['id'=>$project->id])}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Assign Contracts Manager</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="row mb-8">
                        
                        
                    </div>
                    <div class="row mb-8">
                        <div class="col-md-12">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Select</span>
                            </label>
                            <!--end::Label-->
                            <select required id="contract_manager_id" name="manager_id" class="form-select  form-select-lg fw-semibold">
                                <option value="">Select User</option>
                                @foreach($users as $user)
                                    @if($user->department=='contracts_manager')
                                        <option value="{{$user->id}}">{{$user->firstname}} {{$user->lastname}}</option>
                                    @endif
                                @endforeach
                            </select>
                            <input type="hidden" name="manager_type" value="Contracts">
                        </div>
                    </div>
                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

<div class="modal fade" id="assignSiteManager" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body  px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('project.assignManager', ['id'=>$project->id])}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Assign Site Manager</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="row mb-8">
                        
                        
                    </div>
                    <div class="row mb-8">
                        <div class="col-md-12">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Select</span>
                            </label>
                            <!--end::Label-->
                            <select required id="site_manager_id" name="manager_id" class="form-select  form-select-lg fw-semibold">
                                <option value="">Select User</option>
                                @foreach($users as $user)
                                    @if($user->department=='site_manager')
                                        <option value="{{$user->id}}">{{$user->firstname}} {{$user->lastname}}</option>
                                    @endif
                                @endforeach
                            </select>
                            <input type="hidden" name="manager_type" value="Site">
                        </div>
                    </div>
                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

<div class="modal fade" id="status_modal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body  px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('project.updateStatus', ['id'=>$project->id])}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Update Project Status</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="row mb-8">
                        
                        
                    </div>
                    <div class="row mb-8">
                        <div class="col-md-12">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Select</span>
                            </label>
                            <!--end::Label-->
                            <select required id="status_id" name="status_id"  class="form-select  form-select-lg fw-semibold">
                                <option value="">Select New Status</option>
                                @foreach($statuses as $status)
                                    @if($status->id!=$project->project_status)
                                    <option value="{{$status->id}}">{{$status->name}}</option>
                                    @endif
                                @endforeach
                            </select>
                            <input type="hidden" name="manager_type" id="manager_type">
                        </div>
                    </div>
                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

<form action="{{ route('projects.createRamsDocument', ['id'=>$project->id]) }}" method="post" id="create_rams_form">
    @csrf
    <input type="hidden" name="createRams" value="1">
</form>

<form action="{{ route('projects.updateRams', ['id'=>$project->id]) }}" method="post" id="update_rams_form">
    @csrf
    <input type="hidden" name="updateRams" value="1">
</form>

<form action="{{ route('projects.ramsPDF', ['id'=>$project->id]) }}" method="post" id="rams_pdf_form">
    @csrf
    <input type="hidden" name="ramsPdf" value="1">
</form>

@endsection


@section('js')
<script>
    
    $("#rams_pdf_btn").click(function(){
        $("#rams_pdf_form").submit();
    });
    
    
    $("#create_rams_btn").click(function(){
        if(confirm('Are you sure?')){
            $("#create_rams_form").submit();
        }
    });
    
    $("#update_rams_btn").click(function(){
        if(confirm('Are you sure?')){
            $("#update_rams_form").submit();
        }
    });
    
    
    $("#update_status").click(function(){
        $("#status_modal").modal("show");
    });
    
    $('#contract_manager_id').select2({
        dropdownParent: $('#assignContractsManager')
    });
    
    $('#site_manager_id').select2({
        dropdownParent: $('#assignSiteManager')
    });
    
    
    $(".assignContractsManager").click(function(){
        $("#assignContractsManager").modal("show");
    })
    
    $(".assignSiteManager").click(function(){
        $("#assignSiteManager").modal("show");
    })
    
    /*
var table = $("#kt_table_users").DataTable({
    "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
    "paging": false,//Dont want paging                
    "bPaginate": false,//Dont want paging
});

$('#mySearch').on('input', function() {
  table.search($(this).val()).draw();
})*/

</script>
@endsection
