@extends('layouts.app')
@section('title', 'Documents | Project Details')

@section('content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.2/min/dropzone.min.css">
<div class="d-flex flex-column flex-column-fluid">
    <style>
        .project-image {
            width: 100%;
            height: 428px;
            object-fit: cover;
        }

        iframe {
            width: 100% !important;
            height: 300px !important;
            margin: 0 !important;
            border-radius: 10px;
        }

        .nav-link {
            font-size: 18px;
            color: #5E5E5E;
        }

        .nav-pills .nav-link.active,
        .nav-pills .show>.nav-link {
            border: 1px solid #93D50066;
            background: white;
            color: black;
            font-weight: 500;
        }

        .page-heading {
            font-size: 24px !important;
        }

        .project-id {
            font-size: 18px;
            color: #556171 !important;
        }

        .dropzone {
            border: 2px dashed #007bff;
            border-radius: 5px;
            background: #f8f9fa;

            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            text-align: center;
            cursor: pointer;
        }

        .dropzone .dz-message {
            font-size: 20px;
            font-weight: bold;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .dropzone .dz-message img {
            max-width: 100px;
            margin-bottom: 20px;
        }

        .dropzone .dz-message h3 {
            font-size: 24px;
            margin: 10px 0;
        }

        .dropzone .dz-message p {
            font-size: 16px;
            color: #6c757d;
        }

        .uploaded-files {
            margin-top: 20px;
        }

        .uploaded-file {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-top: 10px;
            background: #fff;
            padding: 15px;
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            width: 100%;
        }

        .uploaded-file .file-info {
            display: flex;
            align-items: center;
            justify-content: space-between;
            width: 100%;
        }

        .uploaded-file img {
            max-width: 50px;
            margin-right: 15px;
        }

        .uploaded-file .file-name {
            flex-grow: 1;
        }

        .uploaded-file .progress {
            width: 100%;
            background: #e9ecef;
            border-radius: 5px;
            overflow: hidden;
            margin: 10px 0;
        }

        .uploaded-file .progress-bar {
            height: 10px;
            background: #007bff;
            transition: width 0.4s;
        }

        .uploaded-file .notes {
            width: 100%;
            margin: 10px 0;
        }

        .nav-pills .nav-link {
            font-size: 16px;
        }

        .uploaded-file .save-notes {
            background: #28a745;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            cursor: pointer;
        }

        .fixed-width {
            width: 160px;
            /* Adjust this as needed */
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .file-name {
            font-size: 17px;
            font-weight: 500;
        }

        .form-check-cover {
            margin-bottom: 10px;
            padding: 8px;
            border-radius: 8px;
            color: black;
            background: linear-gradient(0deg, rgba(255, 255, 255, 0.94), rgba(255, 255, 255, 0.94)), #5E5E5E;
        }
        
        .form-check-label{
            color: black;
        }

        .form-check-cover.active {
            background: linear-gradient(0deg, rgba(255, 255, 255, 0.8), rgba(255, 255, 255, 0.8)), #93D500;
        }

        .form-check-input:checked {
            border-color: #93d500;
        }

    </style>
    @include('project.head')
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <div class="row align-items-center mb-7">
                <div class="col-md-12">
                    @include('project.nav')
                </div>

            </div>


            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif

            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif

            <div class="card mb-7">

                <div class="card-body" id="uploadForm" style="display:none">
                    <div class="dropzone" id="my-dropzone">
                        <div class="dz-message">
                            <img src="{{asset('img/cloud.svg')}}" alt="Upload">
                            <h3>Upload Documents</h3>
                            <p>Browse or drag documents to begin</p>
                        </div>
                    </div>
                    <div class="uploaded-files" id="uploaded-files"></div>
                </div>


                <div class="card-header " id="kt_chat_contacts_header">
                    <!--begin::Card title-->
                    <div class="card-title justify-content-between">
                        <i class="ki-outline ki-file fs-1 me-2"></i>
                        <h3 class="fw-bold">Documents</h3>


                    </div>
                    <button onclick="$('#uploadForm').slideToggle();" class="btn btn-sm btn-primary align-self-center">Add Document</button>
                    <!--end::Card title-->
                </div>


                <div class="card-body">
                    <div class="row" id="documents_box">
                       
                       @if($rams_pdf)
                       <div class="col-md-4 mb-6">
                            <!--begin::Card-->
                            <div class="card h-100" style="border:1px solid #93D500">
                                <!--begin::Card body-->
                                <div class="card-body d-flex   flex-column p-3">
                                    <div>
                                        <a target="_blank" style="position:absolute;right:10px" href="{{asset('documents/'.$rams_pdf->file)}}"><i class="ki-outline ki-file-down fs-1 text-primary me-2"></i></a>
                                        
                                        <span class="like" data-id="{{$rams_pdf->id}}" style="position:absolute;z-index:3;right:45px;top:8px"><i id="heart_{{$rams_pdf->id}}" class="@if($rams_pdf->favourite==1) ki-solid @else ki-outline @endif ki-heart fs-2x text-primary"></i></span>
                                       @if($rams_pdf->employee_access==1)    
                                       <span data-bs-toggle="tooltip" title="Employee Access" class=""  style="position:absolute;z-index:3;right:45px;bottom:6px"><i class=" ki-solid ki-check-circle fs-2x text-primary"></i></span>
                                       @endif
                                       
                                        <div class="card-toolbar" style="position:absolute;right:10px;bottom:0">
                                            <!--begin::Menu-->
                                            <button class="btn btn-icon btn-color-gray-500 btn-active-color-primary justify-content-end" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end" data-kt-menu-overflow="true">
                                                <i class="ki-outline ki-dots-square fs-1 me-2 text-gray-500 "></i>
                                            </button>
                                            <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-800 menu-state-bg-light-primary fw-semibold w-200px" data-kt-menu="true" style="">

                                                <div class="menu-item px-3">
                                                    <a href="#!" class="menu-link p-3 m-1 editNotes" data-id="{{$rams_pdf->id}}">Edit Notes</a>
                                                </div>
                                                <div class="menu-item px-3">
                                                    <a href="#!" class="menu-link p-3 m-1 permissions" data-id="{{$rams_pdf->id}}" data-access="{{$rams_pdf->employee_access}}">Permissions</a>
                                                </div>

                                                <div class="menu-item px-3">
                                                    <a href="#!" class="menu-link p-3 m-1 delete" data-id="{{$rams_pdf->id}}">Delete</a>
                                                </div>




                                            </div>
                                            <!--begin::Menu 2-->

                                            <!--end::Menu 2-->
                                            <!--end::Menu-->
                                        </div>
                                        <div class="mb-5 d-flex">

                                            @if($rams_pdf->type=='jpg' || $rams_pdf->type=='jpeg' || $rams_pdf->type=='gif' || $rams_pdf->type=='png')

                                            <img style="width:40px" src="{{asset('img/icons/image.png')}}" class="theme-light-show" alt="">

                                            @else
                                            <img style="width:40px" src="{{asset('img/icons/'.$rams_pdf->type.'.png')}}" class="theme-light-show" alt="">
                                            @endif
                                            <div class="ms-3">
                                                <p class="mb-0 fixed-width" style="font-size:15px;font-weight:500">{{$rams_pdf->name}}</p>
                                                <small class="text-muted">{{ date('jS M Y h:ia', strtotime($rams_pdf->created_at)) }}</small>

                                            </div>
                                        </div>
                                        <div>
                                            <label style="font-size:14px;color:#5E5E5E">Note:</label>
                                            <p style="font-size:14px;font-weight:400" id="note_{{$rams_pdf->id}}">{{$rams_pdf->notes}}</p>
                                        </div>
                                    </div>
                                </div>
                                <!--end::Card body-->
                            </div>
                            <!--end::Card-->
                        </div>
                       @endif
                       
                        @foreach($documents as $document)
                        <div class="col-md-4 mb-6">
                            <!--begin::Card-->
                            <div class="card h-100">
                                <!--begin::Card body-->
                                <div class="card-body d-flex   flex-column p-3">
                                    <div>
                                        <a target="_blank" style="position:absolute;right:10px" href="{{asset('documents/'.$document->file)}}"><i class="ki-outline ki-file-down fs-1 text-primary me-2"></i></a>
                                        
                                        <span class="like" data-id="{{$document->id}}" style="position:absolute;z-index:3;right:45px;top:8px"><i id="heart_{{$document->id}}" class="@if($document->favourite==1) ki-solid @else ki-outline @endif ki-heart fs-2x text-primary"></i></span>
                                       @if($document->employee_access==1)    
                                       <span data-bs-toggle="tooltip" title="Employee Access" class="" d style="position:absolute;z-index:3;right:45px;bottom:6px"><i class=" ki-solid ki-check-circle fs-2x text-primary"></i></span>
                                       @endif
                                       
                                        <div class="card-toolbar" style="position:absolute;right:10px;bottom:0">
                                            <!--begin::Menu-->
                                            <button class="btn btn-icon btn-color-gray-500 btn-active-color-primary justify-content-end" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end" data-kt-menu-overflow="true">
                                                <i class="ki-outline ki-dots-square fs-1 me-2 text-gray-500 "></i>
                                            </button>
                                            <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-800 menu-state-bg-light-primary fw-semibold w-200px" data-kt-menu="true" style="">

                                                <div class="menu-item px-3">
                                                    <a href="#!" class="menu-link p-3 m-1 editNotes" data-id="{{$document->id}}">Edit Notes</a>
                                                </div>
                                                <div class="menu-item px-3">
                                                    <a href="#!" class="menu-link p-3 m-1 permissions" data-id="{{$document->id}}" data-access="{{$document->employee_access}}">Permissions</a>
                                                </div>

                                                <div class="menu-item px-3">
                                                    <a href="#!" class="menu-link p-3 m-1 delete" data-id="{{$document->id}}">Delete</a>
                                                </div>




                                            </div>
                                            <!--begin::Menu 2-->

                                            <!--end::Menu 2-->
                                            <!--end::Menu-->
                                        </div>
                                        <div class="mb-5 d-flex">

                                            @if($document->type=='jpg' || $document->type=='jpeg' || $document->type=='gif' || $document->type=='png')

                                            <img style="width:40px" src="{{asset('img/icons/image.png')}}" class="theme-light-show" alt="">

                                            @else
                                            <img style="width:40px" src="{{asset('img/icons/'.$document->type.'.png')}}" class="theme-light-show" alt="">
                                            @endif
                                            <div class="ms-3">
                                                <p class="mb-0 fixed-width" style="font-size:15px;font-weight:500">{{$document->name}}</p>
                                                <small class="text-muted">{{ date('jS M Y h:ia', strtotime($document->created_at)) }}</small>

                                            </div>
                                        </div>
                                        <div>
                                            <label style="font-size:14px;color:#5E5E5E">Note:</label>
                                            <p style="font-size:14px;font-weight:400" id="note_{{$document->id}}">{{$document->notes}}</p>
                                        </div>
                                    </div>
                                </div>
                                <!--end::Card body-->
                            </div>
                            <!--end::Card-->
                        </div>
                        @endforeach
                    </div>
                </div>



            </div>



        </div>
    </div>
    <!--end::Content-->
</div>
<form action="{{route('project.deleteDocument')}}" method="post" id="deleteForm">
    @csrf
    <input type="hidden" name="document_id" id="document_id">
</form>

<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('project.updateDocumentNotes')}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Edit Document Notes</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Notes</span>
                        </label>
                        <!--end::Label-->
                        <textarea name="notes" class="form-control" id="e_notes" cols="30" rows="3"></textarea>
                        <input type="hidden" name="document_id" id="document_notes_id">
                    </div>




                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


<div class="modal fade" id="permissionModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('project.updateDocumentAccess')}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Permissions</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">

                        <div class="form-check-cover form-check-inline">
                            <div class="form-check me-2">
                                <input name="employee_access" class="form-check-input" type="checkbox" value="1" id="employee_access" />
                                <label class="form-check-label" for="employee_access">
                                    Employee Access
                                </label>
                            </div>
                        </div>
                        <input type="hidden" name="document_id" id="document_permission_id">
                    </div>




                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Update

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


@endsection


@section('js')


<script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.2/min/dropzone.min.js"></script>
<script type="text/javascript">
    
    $(document).ready(function(){
        $('.like').click(function(){
            var id = $(this).data('id');
            
            $.ajax({
                url: "{{ route('project.bookmarkDocument') }}",
                type: 'POST',
                data: {
                    document_id: id,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response){
                    if(response.success){
                        toastr.success(response.message);
                        if(response.status==1){
                            $("#heart_"+id).removeClass('ki-outline').addClass('ki-solid');
                        }else{
                            $("#heart_"+id).removeClass('ki-solid').addClass('ki-outline');
                        }
                    } else {
                        alert('Something went wrong.');
                    }
                },
                error: function(response){
                    alert('Error: ' + response.responseJSON.message);
                }
            });
        });
    });
    
    
    
    $(".delete").click(function() {
        var id = $(this).data('id');
        $("#document_id").val(id);
        if (confirm('Are you sure want to delete this document?')) {
            $("#deleteForm").submit();
        }
    });

    $(".editNotes").click(function() {
        var id = $(this).data('id');
        $("#document_notes_id").val(id);
        $("#e_notes").val($("#note_" + id).text());
        $("#editModal").modal("show");
    });

    $(".permissions").click(function() {
        var id = $(this).data('id');
        $("#document_permission_id").val(id);
        var access = $(this).data('access');
        if(access==1){
            $("#employee_access").prop('checked', true);
        }else{
            $("#employee_access").prop('checked', false);
        }
        
        
        //$("#e_permission").val($("#note_"+id).text());
        $("#permissionModal").modal("show");
    });

    Dropzone.autoDiscover = false;

    var myDropzone = new Dropzone("#my-dropzone", {
        url: "{{route('project.uploadDocument', ['id'=>$project->id])}}",
        maxFilesize: 2, // MB
        acceptedFiles: ".jpeg,.jpg,.png,.gif,.pdf,.doc,.docx,.xls,.xlsx,.ppt,.pptx,.zip",
        previewsContainer: false,
        clickable: true,
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
        },
        init: function() {
            this.on("addedfile", function(file) {
                const uploadedFilesDiv = document.getElementById('uploaded-files');
                const fileDiv = document.createElement('div');
                fileDiv.classList.add('uploaded-file');

                let fileIcon = 'https://upload.wikimedia.org/wikipedia/commons/e/e1/Cloud_upload_font_awesome.svg';
                if (file.type.includes('image')) {
                    fileIcon = '{{asset("img/icons/image.png")}}';
                } else if (file.type.includes('pdf')) {
                    fileIcon = '{{asset("img/icons/pdf.png")}}';
                } else if (file.type.includes('word')) {
                    fileIcon = '{{asset("img/icons/docx.png")}}';
                }

                fileDiv.innerHTML = `
                        <div class="file-info">
                            <img src="${fileIcon}" alt="File Icon">
                            <div class="file-name">${file.name} (${(file.size / 1024 / 1024).toFixed(2)} MB)</div>
                            
                        </div>
                        <div class="progress" role="progressbar" aria-label="Basic example" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
                          <div class="progress-bar" style="width: 0%"></div>
                        </div>
                        <div class="notes">
                            <label style="font-size:14px;font-weight:400" class="mb-3" for="notes-${file.name}">Note:</label>
                            <textarea id="notes-${file.name}" class="note-textarea form-control" placeholder="Type here"></textarea>
                        </div>
                        <button class="save-notes">Save</button>
                    `;
                uploadedFilesDiv.insertBefore(fileDiv, uploadedFilesDiv.firstChild);

                const progressBar = fileDiv.querySelector('.progress-bar');
                this.on("uploadprogress", function(file, progress) {
                    progressBar.style.width = progress + '%';
                    if (progress == 100) {
                        progressBar.classList.add('bg-primary');
                    }
                });
            });

            this.on("success", function(file, response) {
                const uploadedFilesDiv = document.getElementById('uploaded-files');
                const fileDiv = Array.from(uploadedFilesDiv.querySelectorAll('.uploaded-file')).find(element => element.textContent.includes(file.name));

                if (fileDiv) {
                    const saveButton = fileDiv.querySelector('.save-notes');
                    saveButton.addEventListener('click', function() {
                        const notes = fileDiv.querySelector('.note-textarea').value;
                        $.post('{{route("project.documents.saveNote")}}', {
                            _token: '{{ csrf_token() }}',
                            file_id: response.success.file_id,
                            notes: notes
                        }).done(function(response) {
                            if (fileDiv) {
                                fileDiv.remove();
                            }
                            var document = response.success;
                            var assetUrl = "{{ asset('img/icons/') }}/";
                            var documentUrl = "{{ asset('documents/') }}/";


                            var data = '<div class="col-md-4 mb-6"><div class="card h-100"><div class="card-body d-flex justify-content-center  flex-column p-3"><div><a target="_blank" style="position:absolute;right:0" href="' + documentUrl + document.file + '"><i class="ki-outline ki-file-down fs-1 text-primary me-2"></i></a><div class="mb-5 d-flex">';

                            if (document.type == 'jpg' || document.type == 'jpeg' || document.type == 'gif' || document.type == 'png') {
                                data += '<img style="width:40px" src="' + assetUrl + 'image.png" class="theme-light-show" alt="">';
                            } else {
                                data += '<img style="width:40px" src="' + assetUrl + document.type + '.png" class="theme-light-show" alt="">';
                            }

                            data += '<div class="ms-3"><p class="mb-0 fixed-width" style="font-size:15px;font-weight:500">' + document.name + '</p><small class="text-muted">' + document.created_at + '</small></div></div><div><label style="font-size:14px;color:#5E5E5E">Note:</label><p style="font-size:14px;font-weight:400">' + document.notes + '</p></div></div></div></div></div>';

                            $("#documents_box").prepend(data);
                        }).fail(function(xhr, status, error) {
                            alert('Error saving notes');
                        });
                    });
                }
            });

            this.on("removedfile", function(file) {
                const uploadedFilesDiv = document.getElementById('uploaded-files');
                const fileDiv = Array.from(uploadedFilesDiv.querySelectorAll('.uploaded-file')).find(element => element.textContent.includes(file.name));
                if (fileDiv) {
                    fileDiv.remove();
                }
            });
        }
    });

</script>
<script>
    $(".markcomplete").click(function() {
        var id = $(this).data('id');
        $("#milestone_c_id").val(id)
        $("#myModal").modal("show");
    });


    /*
var table = $("#kt_table_users").DataTable({
    "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
    "paging": false,//Dont want paging                
    "bPaginate": false,//Dont want paging
});

$('#mySearch').on('input', function() {
  table.search($(this).val()).draw();
})*/

</script>
@endsection
