<!DOCTYPE html>
<html>
<head>
    <title>Laravel Dropzone File Upload</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.2/min/dropzone.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .dropzone {
            border: 2px dashed #007bff;
            border-radius: 5px;
            background: #f8f9fa;
            padding: 50px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            text-align: center;
            cursor: pointer;
        }
        .dropzone .dz-message {
            font-size: 20px;
            font-weight: bold;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        .dropzone .dz-message img {
            max-width: 100px;
            margin-bottom: 20px;
        }
        .dropzone .dz-message h3 {
            font-size: 24px;
            margin: 10px 0;
        }
        .dropzone .dz-message p {
            font-size: 16px;
            color: #6c757d;
        }
        .uploaded-files {
            margin-top: 20px;
        }
        .uploaded-file {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-top: 10px;
            background: #fff;
            padding: 15px;
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            width: 100%;
        }
        .uploaded-file .file-info {
            display: flex;
            align-items: center;
            justify-content: space-between;
            width: 100%;
        }
        .uploaded-file img {
            max-width: 50px;
            margin-right: 15px;
        }
        .uploaded-file .file-name {
            flex-grow: 1;
        }
        .uploaded-file .progress {
            width: 100%;
            background: #e9ecef;
            border-radius: 5px;
            overflow: hidden;
            margin: 10px 0;
        }
        .uploaded-file .progress-bar {
            height: 10px;
            background: #007bff;
            transition: width 0.4s;
        }
        .uploaded-file .notes {
            width: 100%;
            margin: 10px 0;
        }
        .uploaded-file .save-notes {
            background: #28a745;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            cursor: pointer;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2 class="text-center">Laravel Dropzone File Upload</h2>
        <div class="dropzone" id="my-dropzone">
            <div class="dz-message">
                <img src="https://upload.wikimedia.org/wikipedia/commons/e/e1/Cloud_upload_font_awesome.svg" alt="Upload">
                <h3>Upload Documents</h3>
                <p>Browse or drag documents to begin</p>
            </div>
        </div>
        <div class="uploaded-files" id="uploaded-files"></div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.2/min/dropzone.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script type="text/javascript">
        Dropzone.autoDiscover = false;

        var myDropzone = new Dropzone("#my-dropzone", {
            url: "{{route('project.uploadDocument', ['id'=>$project->id])}}",
            maxFilesize: 2, // MB
            acceptedFiles: ".jpeg,.jpg,.png,.gif,.pdf,.doc,.docx",
            previewsContainer: false,
            clickable: true,
            init: function() {
                this.on("addedfile", function(file) {
                    const uploadedFilesDiv = document.getElementById('uploaded-files');
                    const fileDiv = document.createElement('div');
                    fileDiv.classList.add('uploaded-file');

                    let fileIcon = 'https://upload.wikimedia.org/wikipedia/commons/e/e1/Cloud_upload_font_awesome.svg';
                    if (file.type.includes('image')) {
                        fileIcon = 'https://upload.wikimedia.org/wikipedia/commons/a/ac/No_image_available.svg';
                    } else if (file.type.includes('pdf')) {
                        fileIcon = 'https://upload.wikimedia.org/wikipedia/commons/8/87/PDF_file_icon.svg';
                    } else if (file.type.includes('word')) {
                        fileIcon = 'https://upload.wikimedia.org/wikipedia/commons/f/f1/Microsoft_Word_logo.svg';
                    }

                    fileDiv.innerHTML = `
                        <div class="file-info">
                            <img src="${fileIcon}" alt="File Icon">
                            <div class="file-name">${file.name} (${(file.size / 1024 / 1024).toFixed(2)} MB)</div>
                            <button class="remove-file">✖</button>
                        </div>
                        <div class="progress">
                            <div class="progress-bar"></div>
                        </div>
                        <div class="notes">
                            <label for="notes-${file.name}">Note:</label>
                            <textarea id="notes-${file.name}" class="note-textarea" placeholder="Type here"></textarea>
                        </div>
                        <button class="save-notes">Save</button>
                    `;
                    uploadedFilesDiv.appendChild(fileDiv);

                    const progressBar = fileDiv.querySelector('.progress-bar');
                    this.on("uploadprogress", function(file, progress) {
                        progressBar.style.width = progress + '%';
                    });
                });

                this.on("success", function(file, response) {
                    const uploadedFilesDiv = document.getElementById('uploaded-files');
                    const fileDiv = uploadedFilesDiv.querySelector(`.uploaded-file:contains(${file.name})`);

                    if (fileDiv) {
                        const saveButton = fileDiv.querySelector('.save-notes');
                        saveButton.addEventListener('click', function() {
                            const notes = fileDiv.querySelector('.note-textarea').value;
                            $.post('xyz', {
                                _token: '{{ csrf_token() }}',
                                file_id: response.file_id,
                                notes: notes
                            }).done(function(data) {
                                alert('Notes saved successfully');
                            }).fail(function(xhr, status, error) {
                                alert('Error saving notes');
                            });
                        });
                    }
                });

                this.on("removedfile", function(file) {
                    const uploadedFilesDiv = document.getElementById('uploaded-files');
                    const fileDiv = uploadedFilesDiv.querySelector(`.uploaded-file:contains(${file.name})`);
                    if (fileDiv) {
                        uploadedFilesDiv.removeChild(fileDiv);
                    }
                });
            }
        });
    </script>
    <script type="text/javascript">
    Dropzone.options.myDropzone = {
        maxFilesize: 2, // MB
        acceptedFiles: ".jpeg,.jpg,.png,.gif,.zip,.pdf",
        init: function() {
            this.on("success", function(file, response) {
                
                var document = response.success;
                var assetUrl = "{{ asset('img/icons/') }}/";
                var documentUrl = "{{ asset('documents/') }}/";
                
                
                var data = '<div class="col-md-4 mb-6"><div class="card h-100"><div class="card-body d-flex justify-content-center  flex-column p-3"><div><a target="_blank" style="position:absolute;right:0" href="'+documentUrl+document.file+'"><i class="ki-outline ki-file-down fs-1 text-primary me-2"></i></a><div class="mb-5 d-flex">';
                                           
                    if(document.type=='jpg' || document.type=='jpeg' || document.type=='gif' || document.type=='png'){
                         data += '<img style="width:40px" src="'+assetUrl+'image.png" class="theme-light-show" alt="">';
                    }else{
                         data += '<img style="width:40px" src="'+assetUrl+document.type+'.png" class="theme-light-show" alt="">';   
                    }

                data += '<div class="ms-3"><p class="mb-0 fixed-width" style="font-size:15px;font-weight:500">'+document.name+'</p><small class="text-muted">'+document.created_at+'</small></div></div><div><label for="" class="form-label">Note:</label></div></div></div></div></div>';
                
                $("#documents_box").prepend(data);
            });
        }
    };

</script>
</body>
</html>