@extends('layouts.app')
@section('title', 'Financial Items')

@section('content')
<style>
    #kt_app_sidebar{
        display: none;
    }
    
    
    #kt_app_header{
        left: 0;
    }
    
    .app-wrapper{
        margin-left: 0 !important;
    }
    
    table p {
            margin-bottom: 0;
        }

        .table td,
        .table th {
            vertical-align: middle;
        }

        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            text-align: center;
            color: #727879;
        }

        .table .tr-credit td {
            background: #ffcccc;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            text-align: center;
            color: #727879;
        }

        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }



        .showPoDetails{
            cursor: pointer;
        }

        table.table-bordered.dataTable {
            border: 0 !important;
            border-bottom: 0 !important;
        }
    
    .form-check-input:checked {
            border-color: #93d500;
        }
    
    td{
        
    }

</style>
<div class="d-flex flex-column flex-column-fluid">
   <form action="{{ route('project.importExcel') }}" method="post" id="myForm">
    @csrf
    <div id="kt_app_toolbar" class="app-toolbar pt-7 pt-lg-10">
        <!--begin::Toolbar container-->
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <!--begin::Toolbar wrapper-->
            <div class="gap-4 w-100">
                <!--begin::Page title-->
                <div class="page-title ">
                    <!--begin::Title-->
                    
                    <div class="row align-items-center">
                        <div class="col-md-3">
                            <p for="" class="form-label">&nbsp;</p>
                            <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">Edit Spreadsheet</h1>
                        </div>
                        <input type="hidden" name="project_id" value="{{ $project_id }}">
                        <div class="col-md-7">
                            <div class="row">
                               <div class="col-md-2">
                                   <label for="" class="form-label">Plant</label>
                                   <input type="number" step="any" class="form-control" name="plant" placeholder="Plant" required id="plant">
                               </div>
                               <div class="col-md-2">
                                   <label for="" class="form-label">Labour</label>
                                   <input type="number" step="any" class="form-control" name="labour" placeholder="Labour" required id="labour">
                               </div>
                               <div class="col-md-2">
                                   <label for="" class="form-label">Material</label>
                                   <input type="number" step="any" class="form-control" name="material" placeholder="Material" required id="material">
                               </div>
                               <div class="col-md-2">
                                   <label for="" class="form-label">Sub Contractor</label>
                                   <input type="number" step="any" class="form-control" name="sub_contract" placeholder="Sub Contractor" required id="sub_contractor">
                               </div>
                               <div class="col-md-2">
                                   <label for="" class="form-label">Other</label>
                                   <input type="number" step="any" class="form-control" name="other" placeholder="Other" required id="other">
                               </div>
                                <div class="col-md-2">
                                    <p for="" class="form-label">&nbsp;</p>
                                    <button class="btn btn-primary" id="importBtn">Import</button>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <p for="" class="form-label">&nbsp;</p>
                            <h2 class="mb-0">Total: <span id="totalSum">0.00</span></h2>
                        </div>
                    </div>
                </div>
                
            </div>
            <!--end::Toolbar wrapper-->
        </div>
        <!--end::Toolbar container-->
    </div>
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif
            <div class="card">
                <div class="card-body p-2">
                    <table class="table table-bordered mb-0">
                        <thead>
                            <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                <th></th>
                                <th>Code</th>
                                <th>Description</th>
                                <th>UoM</th>
                                <th>Qty</th>
                                <th>Rate</th>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody class="text-gray-600 fw-semibold" id="table-body">
                            @foreach ($data as $index => $row)
                                <?php if ($row[0] == 'Code'){ continue; } ?>
                            <tr>
                                <td>
                                    <div class="form-check text-center m-0">
                                        <input class="form-check-input rowCheckbox" type="checkbox" value="" checked id="flexCheckDefault">
                                    </div>
                                </td>
                                <td width="10%"><input type="text" class="form-control form-control-sm" value="{{ $row[0] }}" name="code[]"></td>
                                <td width="40%"><textarea name="description[]" class="form-control form-control-sm" id="" cols="30" rows="4">{{ $row[1] }}</textarea></td>
                                <td><input type="text" class="form-control form-control-sm" name="uom[]" value="{{ $row[3] }}"></td>
                                <td><input type="number" step="any" class="form-control form-control-sm qty" name="qty[]" value="{{ $row[2] }}"></td>
                                <td><input type="number" step="any" class="form-control form-control-sm rate" name="rate[]" value="{{ $row[4] }}"></td>
                                <td><input type="text" disabled class="form-control form-control-sm row-total" value="{{ $row[5] }}"></td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <!--end::Table-->
                </div>
                <!--end::Card body-->
            </div>
        </div>
    </div>
    </form>
    <!--end::Content-->
</div>




@endsection


@section('js')
<script>
    
    var totalAmount = 0;
    
    
    function calculateRowTotal(row) {
        if(!$(row).find('.qty').is(':disabled')){
            var qty = parseFloat($(row).find('.qty').val()) || 0;
            var rate = parseFloat($(row).find('.rate').val()) || 0;
            var total = qty * rate;
            $(row).find('.row-total').val(total.toFixed(2));
            return total;
        }else{
            return 0;
        }
    }

    function calculateGrandTotal() {
        var grandTotal = 0;
        $('#table-body tr').each(function() {
            grandTotal += calculateRowTotal(this);
        });
        $('#totalSum').text(grandTotal.toFixed(2));
        totalAmount = parseFloat(grandTotal.toFixed(2));
        validateForm();
    }

    $(document).on('input', '.qty, .rate', function() {
        calculateGrandTotal();
    });

    $(document).ready(function() {
        calculateGrandTotal(); // Calculate total on page load
    });
    
    
    function calculateTotal() {
        let sum = 0;

        $('input[name="total[]"]').each(function() {
            if (!$(this).is(':disabled')) {
                sum += parseFloat($(this).val()) || 0; // Add the value or 0 if NaN
            }
        });

        totalAmount = parseFloat(sum.toFixed(2));
        $('#totalSum').text(totalAmount);
        validateForm();
    }
    
    //calculateTotal();

    // Event listener for input changes
    /*$(document).ready(function() {
        $('input[name="total[]"]').on('input', calculateTotal);
        calculateTotal(); // Initial calculation
    });*/
    
    function validateForm() {
        var plant = parseFloat($('#plant').val()) || 0;
        var labour = parseFloat($('#labour').val()) || 0;
        var material = parseFloat($('#material').val()) || 0;
        var sub_contract = parseFloat($('#sub_contractor').val()) || 0;
        var other = parseFloat($('#other').val()) || 0;

        var sum = plant + labour + material + sub_contract + other;

        if (sum === totalAmount) {
            $('#errorMessage').hide();
            $('#importBtn').prop('disabled', false);
        } else {
            $('#errorMessage').show();
            $('#importBtn').prop('disabled', true);
        }
    }
    
    
    $(document).ready(function() {
        // Disable form submit by default
        $('#importBtn').prop('disabled', true);

        

        // Listen for changes in the input fields
        $('#plant, #labour, #material, #other, #sub_contractor').on('input', function() {
            validateForm();
        });

        // Initial validation
        validateForm();
    });
    
    $(document).on('change', '.rowCheckbox', function() {
        const row = $(this).closest('tr'); // Get the row containing the clicked checkbox
        if ($(this).is(':checked')) {
            // If checkbox is checked, enable the inputs
            row.find('input[type="text"]').prop('disabled', false);
            row.find('input[type="number"]').prop('disabled', false);
            row.find('textarea').prop('disabled', false);
        } else {
            // If checkbox is unchecked, disable the inputs
            row.find('input[type="text"]').prop('disabled', true);
            row.find('input[type="number"]').prop('disabled', true);
            row.find('textarea').prop('disabled', true);
        }
        calculateGrandTotal();
    });
    
    $(document).on('click', '.delete', function(){
        var id = $(this).data('id');
        $("#delete_id").val(id);
        if(confirm('Are you sure?')){
            $("#deleteForm").submit();
        }
    });
    
    $(".edit").click(function() {
        var $row = $(this).closest('tr');
        var id = $(this).data('id');
        $("#e_code").val($row.find('.tr_code').text());
        $("#e_description").val($row.find('.tr_description').text());
        $("#e_labour").val($row.find('.tr_labour').text());
        $("#e_material").val($row.find('.tr_material').text());
        $("#e_plant").val($row.find('.tr_plant').text());
        $("#e_id").val(id);
        $("#editModal").modal("show");
    });

    var table = $("#kt_table_users").DataTable({
        "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
        "paging": false, //Dont want paging                
        "bPaginate": false, //Dont want paging
    });

    $('#mySearch').on('input', function() {
        table.search($(this).val()).draw();
    });

</script>
@endsection
