@extends('layouts.app')
@section('title', 'Images | Project Details')

@section('content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.2/min/dropzone.min.css">
<link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
<div class="d-flex flex-column flex-column-fluid">
    <style>
        .project-image {
            width: 100%;
            height: 428px;
            object-fit: cover;
        }

        iframe {
            width: 100% !important;
            height: 300px !important;
            margin: 0 !important;
            border-radius: 10px;
        }

        .nav-link {
            font-size: 18px;
            color: #5E5E5E;
        }

        .nav-pills .nav-link.active,
        .nav-pills .show>.nav-link {
            border: 1px solid #93D50066;
            background: white;
            color: black;
            font-weight: 500;
        }

        .page-heading {
            font-size: 24px !important;
        }

        .project-id {
            font-size: 18px;
            color: #556171 !important;
        }

        .dropzone {
            border: 2px dashed #007bff;
            border-radius: 5px;
            background: #f8f9fa;
            padding: 0 !important;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            text-align: center;
            cursor: pointer;
        }

        .dropzone .dz-message {
            font-size: 20px;
            font-weight: bold;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .dropzone .dz-message img {
            max-width: 100px;
            margin-bottom: 20px;
        }

        .dropzone .dz-message h3 {
            font-size: 24px;
            margin: 10px 0;
        }

        .dropzone .dz-message p {
            font-size: 16px;
            color: #6c757d;
        }

        .uploaded-files {
            margin-top: 20px;
        }

        .uploaded-file {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-top: 10px;
            background: #fff;
            padding: 15px;
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            width: 100%;
        }

        .uploaded-file .file-info {
            display: flex;
            align-items: center;
            justify-content: space-between;
            width: 100%;
        }

        .uploaded-file img {
            max-width: 50px;
            margin-right: 15px;
        }

        .uploaded-file .file-name {
            flex-grow: 1;
        }

        .uploaded-file .progress {
            width: 100%;
            background: #e9ecef;
            border-radius: 5px;
            overflow: hidden;
            margin: 10px 0;
        }

        .uploaded-file .progress-bar {
            height: 10px;
            background: #007bff;
            transition: width 0.4s;
        }

        .uploaded-file .notes {
            width: 100%;
            margin: 10px 0;
        }

        .nav-pills .nav-link {
            font-size: 16px;
        }

        .uploaded-file .save-notes {
            background: #28a745;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            cursor: pointer;
        }

        .fixed-width {
            width: 200px;
            /* Adjust this as needed */
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .file-name {
            font-size: 17px;
            font-weight: 500;
        }

        .image-box {
            background: #EEEEEE;
            padding: 20px;
            border-radius: 10px;
        }

        .image-box a {
            color: #3C72FF !important;
        }

        .image-box p {
            color: #5E5E5E;
        }

        .img-fluid {
            width: 100%;
            height: 190px;
            object-fit: cover;

            /*border-radius: 10px;*/
        }

        .more-images {
            position: absolute;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            color: white;
            display: flex;
            top: 0;
            border-radius: 10px;
            justify-content: center;
            align-items: center;
            font-size: 20px;
        }

        .form-check-input:checked {
            border-color: #93d500;
        }

        .form-check {
            display: none;
        }

        .swiper-container {
            width: 100%;
            max-width: 1200px;
            overflow: hidden;
            /* Ensure the container does not overflow */
            position: relative;
        }

        .swiper-wrapper {
            display: flex;
        }

        .swiper-slide {
            flex-shrink: 0;
            width: calc(25% - 10px);
            /* Adjust width to fit 4 images with space */
            margin-right: 10px;
            /* Space between slides */
            background: #fff;
            display: flex;
            justify-content: center;
            align-items: center;

            background: transparent;

        }

        .swiper-slide img {
            border-radius: 10px;
            border: 1px solid #ddd;
        }

        .swiper-button-next,
        .swiper-button-prev {
            background-color: rgba(128, 128, 128, 0.8);
            /* Grey background */
            border-radius: 50%;
            /* Circular buttons */
            width: 30px;
            /* Small size */
            height: 30px;
            /* Small size */
            display: flex;
            justify-content: center;
            align-items: center;
            position: absolute;
            top: 50%;
            /*transform: translateY(-50%);*/
            z-index: 10;
            /* Ensure buttons are above other elements */
        }

        .swiper-button-prev {
            left: 10px;
            /* Adjusted for better positioning */
        }

        .swiper-button-next {
            right: 10px;
            /* Adjusted for better positioning */
        }

        .swiper-button-next:after,
        .swiper-button-prev:after {
            font-size: 12px;
            /* Smaller font size for the arrows */
            font-weight: bold;
            color: #000;
            /* Black color for the arrows */
        }

        .swiper-pagination {
            display: none;
        }

        /*.btn{
            color: black !important;
            font-size: 16px;
        }*/

        .comming_soon {
            border-radius: 10px;
        }
        
        
        .img-container {
            position: relative;
            display: inline-block;
            margin: 10px;
            width: 100%;
        }
        
        .form-check-input{
            border-color:grey;
        }
        
        .overlay {
            position: absolute;
            top: 0;
            bottom: 0;
            left: 0;
            right: 0;
            height: 100%;
            width: 100%;
            opacity: 0;
            transition: .5s ease;
            background: rgba(250, 250, 250, 0.8);
            display: flex;
            align-items: center;
            border-radius: 10px;
            justify-content: center;
        }
        
        .img-container:hover .overlay {
            opacity: 1;
        }
        
        .buttons {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        
        
        
        
        
        .btn:hover {
            background-color: #8DD03C; /* Hover color */
        }
        
        .btn-img{
            background: rgba(147, 213, 0, 0.4) !important;
            color: black !important;
        }

    </style>

    @include('project.head')
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <div class="row align-items-center mb-7">
                <div class="col-md-12">
                    @include('project.nav')
                </div>

            </div>


            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif

            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif

            <div class="card mb-7">
                <div class="card-header " id="kt_chat_contacts_header">
                    <!--begin::Card title-->
                    <div class="card-title justify-content-between">
                        <i class="ki-outline ki-picture fs-1 me-2"></i>
                        <h3 class="fw-bold">Images
                            <button data-bs-toggle="modal" data-bs-target="#kt_modal_new_target" class="btn btn-sm btn-primary align-self-center ms-3">Add Images</button>
                        </h3>
                    </div>

                    <button id="report" class="btn btn-sm btn-primary align-self-center">Report</button>
                    <!--end::Card title-->
                </div>


                <div class="card-body">

                    <div style="display:none" class="mb-7 " id="report_btns">
                        <div class="row">
                            <div class="col-md-3">
                                <select name="" class="form-select" id="images_per_screen">
                                    <option value="">Images per screen</option>
                                    <option value="1">1</option>
                                    <option value="2">2</option>
                                    <option value="3">3</option>
                                    <option value="4">4</option>
                                    <option value="5">5</option>
                                    <option value="6">6</option>
                                    <option value="7">7</option>
                                    <option value="8">8</option>
                                </select>
                            </div>
                            <div class="col-md-9">
                                <div class="float-end">
                                    <button class="btn btn-primary btn-sm" id="clearAll">Clear</button>
                                    <button class="btn btn-primary btn-sm" id="selectAll">Select All Images</button>
                                    <button class="btn btn-primary btn-sm" id="export">Export Report</button>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        </div>

                    </div>

                    <div class="image-box mb-7">

                        <div style="display:flex;align-items:center" class="mb-3">
                            <p class="mb-0" style="font-size:16px;font-weight:500"><a href="{{route('project.showBeforeImages', ['id'=>$project->id])}}">Before</a></p>
                            <div class="form-check ms-3">
                                <input class="form-check-input selectAllCheckbox" data-type="before" type="checkbox">
                            </div>
                        </div>
                        <span class="float-end"></span>
                        @php
                        $totalImages = count($before_images);
                        @endphp



                        @if($totalImages>0)
                        <div class="swiper-container before-swiper">
                            <div class="swiper-wrapper">
                                @foreach ($before_images as $bi)
                                <div class="swiper-slide">

                                   <div class="img-container">
                                       <img class="img-fluid image" src="{{ asset('img/projects/'.$bi->file) }}">
                                       <div class="overlay">
                                            <div class="buttons">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <button data-id="{{$bi->id}}" data-type="{{$bi->type}}" class="btn btn-img edit-img btn-primary w-100"><i class="ki-solid text-dark  ki-notepad-edit fs-2"></i></button>
                                                    </div>
                                                    <div class="col-md-6"><button data-id="{{$bi->id}}" class="btn btn-img delete-img btn-primary w-100"><i class="ki-solid text-dark  ki-trash fs-2"></i></button></div>
                                                </div>
                                            </div>
                                        </div>
                                   </div>
                                    
                                    <div class="form-check me-2" style="position:absolute;top:20px;right:10px">
                                        <input name="before[]" class="form-check-input" type="checkbox" value="{{$bi->id}}" id="flexCheckDefault">
                                    </div>

                                </div>
                                @endforeach
                            </div>
                            <!-- Add Pagination -->
                            <div class="swiper-pagination"></div>
                            <!-- Add Navigation -->
                            <div class="swiper-button-next"></div>
                            <div class="swiper-button-prev"></div>
                        </div>
                        @else
                        <div class="row">
                            <div class="col-md-3"><img src="{{asset('img/comming_soon.svg')}}" class="img-fluid comming_soon" alt=""></div>
                            <div class="col-md-3"><img src="{{asset('img/comming_soon.svg')}}" class="img-fluid comming_soon" alt=""></div>
                            <div class="col-md-3"><img src="{{asset('img/comming_soon.svg')}}" class="img-fluid comming_soon" alt=""></div>
                            <div class="col-md-3"><img src="{{asset('img/comming_soon.svg')}}" class="img-fluid comming_soon" alt=""></div>
                        </div>
                        @endif
                    </div>
                    <div class="image-box mb-7">
                        <div style="display:flex;align-items:center" class="mb-3">
                            <p class="mb-0" style="font-size:16px;font-weight:500"><a href="{{route('project.showFirstSiteImages', ['id'=>$project->id])}}">1st Site Visit</a></p>
                            <div class="form-check ms-3">
                                <input class="form-check-input selectAllCheckbox" data-type="first_site" type="checkbox">
                            </div>
                        </div>

                        @php
                        $totalImages = count($first_site_visit);
                        @endphp

                        @if($totalImages>0)
                        <div class="swiper-container fs-swiper">
                            <div class="swiper-wrapper">
                                @foreach($first_site_visit as $fs)
                                <div class="swiper-slide">
                                    <div class="img-container">
                                       <img class="img-fluid image" src="{{ asset('img/projects/'.$fs->file) }}">
                                       <div class="overlay">
                                            <div class="buttons">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <button data-id="{{$fs->id}}" data-type="{{$fs->type}}" class="btn btn-img edit-img btn-primary w-100"><i class="ki-solid text-dark  ki-notepad-edit fs-2"></i></button>
                                                    </div>
                                                    <div class="col-md-6"><button data-id="{{$fs->id}}" class="btn btn-img delete-img btn-primary w-100"><i class="ki-solid text-dark  ki-trash fs-2"></i></button></div>
                                                </div>
                                            </div>
                                        </div>
                                   </div>
                                    <div class="form-check me-2" style="position:absolute;top:10px;right:0">
                                        <input name="first_site[]" class="form-check-input" type="checkbox" value="{{$fs->id}}" id="flexCheckDefault">

                                    </div>
                                </div>
                                @endforeach
                            </div>
                            <!-- Add Pagination -->
                            <div class="swiper-pagination"></div>
                            <!-- Add Navigation -->
                            <div class="swiper-button-next"></div>
                            <div class="swiper-button-prev"></div>
                        </div>
                        @else
                        <div class="row">
                            <div class="col-md-3"><img src="{{asset('img/comming_soon.svg')}}" class="img-fluid comming_soon" alt=""></div>
                            <div class="col-md-3"><img src="{{asset('img/comming_soon.svg')}}" class="img-fluid comming_soon" alt=""></div>
                            <div class="col-md-3"><img src="{{asset('img/comming_soon.svg')}}" class="img-fluid comming_soon" alt=""></div>
                            <div class="col-md-3"><img src="{{asset('img/comming_soon.svg')}}" class="img-fluid comming_soon" alt=""></div>
                        </div>

                        @endif
                    </div>

                    <div class="image-box mb-7">
                        <div style="display:flex;align-items:center" class="mb-3">
                            <p class="mb-0" style="font-size:16px;font-weight:500"><a href="{{route('project.showDuringImages', ['id'=>$project->id])}}">During</a></p>
                            <div class="form-check ms-3">
                                <input class="form-check-input selectAllCheckbox" data-type="during" type="checkbox">
                            </div>
                        </div>

                        @php
                        $totalImages = count($during);
                        @endphp

                        @if($totalImages>0)
                        <div class="swiper-container du-swiper">
                            <div class="swiper-wrapper">
                                @foreach($during as $du)
                                <div class="swiper-slide">
                                    <div class="img-container">
                                       <img class="img-fluid image" src="{{ asset('img/projects/'.$du->file) }}">
                                       <div class="overlay">
                                            <div class="buttons">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <button data-id="{{$du->id}}" data-type="{{$du->type}}" class="btn btn-img edit-img btn-primary w-100"><i class="ki-solid text-dark  ki-notepad-edit fs-2"></i></button>
                                                    </div>
                                                    <div class="col-md-6"><button data-id="{{$du->id}}" class="btn btn-img delete-img btn-primary w-100"><i class="ki-solid text-dark  ki-trash fs-2"></i></button></div>
                                                </div>
                                            </div>
                                        </div>
                                   </div>
                                    <div class="form-check me-2" style="position:absolute;top:10px;right:0">
                                        <input name="during[]" class="form-check-input" type="checkbox" value="{{$du->id}}" id="flexCheckDefault">

                                    </div>
                                </div>
                                @endforeach
                            </div>
                            <!-- Add Pagination -->
                            <div class="swiper-pagination"></div>
                            <!-- Add Navigation -->
                            <div class="swiper-button-next"></div>
                            <div class="swiper-button-prev"></div>
                        </div>
                        @else
                        <div class="row">
                            <div class="col-md-3"><img src="{{asset('img/comming_soon.svg')}}" class="img-fluid comming_soon" alt=""></div>
                            <div class="col-md-3"><img src="{{asset('img/comming_soon.svg')}}" class="img-fluid comming_soon" alt=""></div>
                            <div class="col-md-3"><img src="{{asset('img/comming_soon.svg')}}" class="img-fluid comming_soon" alt=""></div>
                            <div class="col-md-3"><img src="{{asset('img/comming_soon.svg')}}" class="img-fluid comming_soon" alt=""></div>
                        </div>
                        @endif


                    </div>
                    <div class="image-box mb-7">
                        <div style="display:flex;align-items:center" class="mb-3">
                            <p class="mb-0" style="font-size:16px;font-weight:500"><a href="{{route('project.showCompletedImages', ['id'=>$project->id])}}">Project Completed</a></p>
                            <div class="form-check ms-3">
                                <input class="form-check-input selectAllCheckbox" data-type="completed" type="checkbox">
                            </div>
                        </div>

                        @php
                        $totalImages = count($completed);
                        @endphp

                        @if($totalImages>0)
                        <div class="swiper-container pc-swiper">
                            <div class="swiper-wrapper">
                                @foreach($completed as $pc)
                                <div class="swiper-slide">
                                    <div class="img-container">
                                       <img class="img-fluid image" src="{{ asset('img/projects/'.$pc->file) }}">
                                       <div class="overlay">
                                            <div class="buttons">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <button data-id="{{$pc->id}}" data-type="{{$pc->type}}" class="btn btn-img edit-img btn-primary w-100"><i class="ki-solid text-dark  ki-notepad-edit fs-2"></i></button>
                                                    </div>
                                                    <div class="col-md-6"><button data-id="{{$pc->id}}" class="btn btn-img delete-img btn-primary w-100"><i class="ki-solid text-dark  ki-trash fs-2"></i></button></div>
                                                </div>
                                            </div>
                                        </div>
                                   </div>
                                    <div class="form-check me-2" style="position:absolute;top:10px;right:0">
                                        <input name="completed[]" class="form-check-input" type="checkbox" value="{{$pc->id}}" id="flexCheckDefault">

                                    </div>
                                </div>
                                @endforeach
                            </div>
                            <!-- Add Pagination -->
                            <div class="swiper-pagination"></div>
                            <!-- Add Navigation -->
                            <div class="swiper-button-next"></div>
                            <div class="swiper-button-prev"></div>
                        </div>
                        @else

                        <div class="row">
                            <div class="col-md-3"><img src="{{asset('img/comming_soon.svg')}}" class="img-fluid comming_soon" alt=""></div>
                            <div class="col-md-3"><img src="{{asset('img/comming_soon.svg')}}" class="img-fluid comming_soon" alt=""></div>
                            <div class="col-md-3"><img src="{{asset('img/comming_soon.svg')}}" class="img-fluid comming_soon" alt=""></div>
                            <div class="col-md-3"><img src="{{asset('img/comming_soon.svg')}}" class="img-fluid comming_soon" alt=""></div>
                        </div>


                        @endif


                    </div>
                </div>



            </div>



        </div>
    </div>
    <!--end::Content-->
</div>


<div class="modal fade" id="kt_modal_new_target" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body  px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form id="form-data" action="{{route('project.uploadProjectImages', ['id'=>$project->id])}}" method="post">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add Images</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Select Type</span>
                        </label>
                        <!--end::Label-->
                        <select id="images_type" name="type" class="form-select  form-select-lg fw-semibold">
                            <option value="">Select</option>
                            <option value="before">Before</option>
                            <option value="1st_site_visit">1st Site Visit</option>
                            <option value="during">During</option>
                            <option value="project_completed">Project Completed</option>
                        </select>
                    </div>

                    <div class="d-flex flex-column mb-8 fv-row" style="display:none" id="zone">
                        <div class="dropzone" id="my-dropzone">
                            <div class="dz-message">
                                <img src="{{asset('img/cloud.svg')}}" alt="Upload">
                                <h3>Upload Images</h3>
                                <p>Browse or drag images to begin</p>
                            </div>
                        </div>
                    </div>






                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>



<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body  px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form id="form-data" action="{{route('project.updateImage')}}" method="post" enctype="multipart/form-data">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Update Image</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Select Type</span>
                        </label>
                        <!--end::Label-->
                        <select required id="edit_image_type" name="type" class="form-select  form-select-lg fw-semibold">
                            <option value="">Select</option>
                            <option value="before">Before</option>
                            <option value="1st_site_visit">1st Site Visit</option>
                            <option value="during">During</option>
                            <option value="project_completed">Project Completed</option>
                        </select>
                    </div>
                    
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Select Image</span>
                        </label>
                        <input type="file" name="image" required class="form-control">
                    </div>

                    






                    <div class="text-center">
                        <input type="hidden" name="image_id" id="edit_image_id">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

<form action="{{route('project.exportImages', ['id'=>$project->id])}}" method="post" style="display:none" id="exportForm">
    @csrf
    <input type="hidden" name="before_images" id="before_images">
    <input type="hidden" name="first_site" id="first_site">
    <input type="hidden" name="during" id="during">
    <input type="hidden" name="completed" id="completed">
    <input type="hidden" name="images_per_screen" id="images_per_screen_input">
</form>


<form action="{{route('project.deleteImage')}}" method="post" style="display:none" id="deleteform">
    @csrf
    <input type="hidden" name="image_id" id="delete_image_id">
</form>

@endsection


@section('js')


<script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.2/min/dropzone.min.js"></script>

<script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
<script type="text/javascript">
    
    $(document).on('click', '.edit-img', function(){
        var id = $(this).data('id');
        var type = $(this).data('type');
        $("#edit_image_id").val(id);
        $("#edit_image_type").val(type);
        $("#editModal").modal("show");
    });
    
    $(document).on('click', '.delete-img', function(){
       var id = $(this).data('id');
        if(confirm('Are you sure want to delete this image?')){
            $('#delete_image_id').val(id);
            $('#deleteform').submit();
        }
    });
    
    $(".selectAllCheckbox").change(function() {
        var type = $(this).data('type');
        if ($(this).is(":checked")) {
            $('input[name="' + type + '[]"]').prop('checked', true);
        } else {
            $('input[name="' + type + '[]"]').prop('checked', false);
        }
    });

    var swiper = new Swiper('.before-swiper', {
        slidesPerView: 4,
        spaceBetween: 10,
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
        pagination: {
            el: '.swiper-pagination',
            clickable: false,
        },
        loop: false,
    });

    var swiper2 = new Swiper('.fs-swiper', {
        slidesPerView: 4,
        spaceBetween: 10,
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
        pagination: {
            el: '.swiper-pagination',
            clickable: false,
        },
        loop: false,
    });

    var swiper3 = new Swiper('.du-swiper', {
        slidesPerView: 4,
        spaceBetween: 10,
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
        pagination: {
            el: '.swiper-pagination',
            clickable: false,
        },
        loop: false,
    });

    var swiper4 = new Swiper('.pc-swiper', {
        slidesPerView: 4,
        spaceBetween: 10,
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
        pagination: {
            el: '.swiper-pagination',
            clickable: false,
        },
        loop: false,
    });


    $(document).ready(function() {
        $('#selectAll').click(function() {
            $('input[name="before[]"]').prop('checked', true);
            $('input[name="first_site[]"]').prop('checked', true);
            $('input[name="during[]"]').prop('checked', true);
            $('input[name="completed[]"]').prop('checked', true);
        });
    });

    $(document).ready(function() {
        $('#clearAll').click(function() {
            $('input[name="before[]"]').prop('checked', false);
            $('input[name="first_site[]"]').prop('checked', false);
            $("#report_btns").hide();
            $("#kt_chat_contacts_header").show();
        });
    });


    $("#export").click(function() {

        //BEFORE
        var checkboxValues = $('input[name^="before\\[\\]"]:checked').map(function() {
            return $(this).val();
        }).get();
        var commaSeparatedValues = checkboxValues.join(',');
        $('#before_images').val(commaSeparatedValues);


        //FIRST SITE
        var checkboxValues = $('input[name^="first_site\\[\\]"]:checked').map(function() {
            return $(this).val();
        }).get();
        var commaSeparatedValues = checkboxValues.join(',');
        $('#first_site').val(commaSeparatedValues);

        //DURING
        var checkboxValues = $('input[name^="during\\[\\]"]:checked').map(function() {
            return $(this).val();
        }).get();
        var commaSeparatedValues = checkboxValues.join(',');
        $('#during').val(commaSeparatedValues);

        //COMPLETED
        var checkboxValues = $('input[name^="completed\\[\\]"]:checked').map(function() {
            return $(this).val();
        }).get();
        var commaSeparatedValues = checkboxValues.join(',');
        $('#completed').val(commaSeparatedValues);


        if($('#images_per_screen').val()==""){
            alert('Please select images per screen!');
            return false;
        }

        $("#images_per_screen_input").val($('#images_per_screen').val());
        $("#exportForm").submit();
    });

    Dropzone.autoDiscover = false;

    // Initialize Dropzone
    var myDropzone = new Dropzone("#my-dropzone", {
        url: "{{route('project.uploadProjectImages', ['id'=>$project->id])}}", // Set the url for your upload script
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
        },
        autoProcessQueue: false, // Prevent Dropzone from uploading automatically
        addRemoveLinks: true,
        parallelUploads: 100 // Allow multiple uploads at the same time
    });

    // Handle the form submission
    document.querySelector("#form-data").addEventListener("submit", function(e) {
        e.preventDefault();

        // Get extra data
        var extraFieldData = $("#images_type").val();
        if (extraFieldData == "") {
            alert('Please select type!');
            return false;
        }

        // Append extra data to the form
        myDropzone.on("sending", function(file, xhr, formData) {
            formData.append("images_type", extraFieldData);
        });

        // Process the Dropzone queue
        myDropzone.processQueue();
    });

    // Event listener for when all files have been processed
    myDropzone.on("queuecomplete", function() {
        // You can do additional tasks here, like showing a success message or redirecting
        alert("All files have been uploaded successfully!");
        window.location.reload();
    });

    // Event listener for handling errors
    myDropzone.on("error", function(file, errorMessage) {
        alert("Error uploading file: " + errorMessage);
    });

</script>
<script>
    $(".markcomplete").click(function() {
        var id = $(this).data('id');
        $("#milestone_c_id").val(id)
        $("#myModal").modal("show");
    });


    /*
var table = $("#kt_table_users").DataTable({
    "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
    "paging": false,//Dont want paging                
    "bPaginate": false,//Dont want paging
});

$('#mySearch').on('input', function() {
  table.search($(this).val()).draw();
})*/

    $("#report").click(function() {
        $("#kt_chat_contacts_header").hide();
        $("#report_btns").show();
        $(".form-check").show();
    })

</script>
@endsection
