@extends('layouts.app')
@section('title', 'Invoice')

@section('css')
<style>
    #kt_app_sidebar {
        display: none;
    }

    #kt_app_header {
        display: none;
    }

    #kt_app_wrapper {
        margin: 0;
    }
    
    @media print {
        .no-print-style {
            background-color: white !important;
            border: none !important;
            box-shadow: none !important;
            padding: 0 !important;
            margin: 0 !important;
        }
        
        body, 
            * {
                margin: 0;
                padding: 0;
                box-sizing: border-box;
            }
        
        .no-print-style-body{
            background: white;
        }
        
        #kt_app_body{
            background: white;
        }
        
        .btn-primary{
            display: none !important;
        }
    }

</style>
@endsection

@section('content')

<style>
    .table td,
    .table th {
        vertical-align: middle;
    }

    .table td {
        background: #93D5001A;
        border: 3px solid white !important;
        padding: 8px !important;
        color: black !important;
        text-align: center;
        color: #727879;
    }

    .table th {
        border: 3px solid white !important;
        background: #E3E3E3;
        color: #5E5E5E !important;
        font-weight: 500;
        font-size: 12px;
        margin: 10px !important;
        text-align: center;
    }



    .price-column {
        background: #E3E3E3 !important;
    }


    table.table-bordered.dataTable {
        border: 0;
        border-bottom: 0;
    }

    .price-table td {
        font-size: 16px;
        padding-bottom: 15px;
        text-align: right;
    }

    .price-table th {
        font-size: 16px;
        font-weight: bold;
        padding-right: 25px;
        padding-bottom: 15px;
    }
    
    

</style>

<div class="d-flex flex-column flex-column-fluid">

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card no-print-style">
                        <!-- begin::Body-->
                        <div class="card-body py-20">
                            <!-- begin::Wrapper-->
                            <div class="mw-lg-950px mx-auto w-100">
                                <!-- begin::Header-->
                                <div class="mb-19" style="position:relative">
                                    <div style="position:absolute;right:20px;top:-25px"><img width="150px" src="{{asset('img/walker.png')}}"></div>
                                    <h4 style="font-size:16px;" class="fw-bolder text-gray-800 fs-2qx pe-5 pb-7 text-center">@if($invoice->credit_note==1) Credit Note @else Invoice @endif</h4>
                                    <!--end::Logo-->

                                </div>
                                <!--end::Header-->
                                <!--begin::Body-->
                                <div class="pb-12">
                                    <!--begin::Wrapper-->
                                    <div class="d-flex flex-column gap-7 gap-md-10">
                                        <!--begin::Message-->
                                        <div class="text-dark mb-3">
                                            <span style="font-weight:500">
                                                Walker Builders Ltd <br>
                                                Ashlar House <br>
                                                230 Cumberworth Lane <br>
                                                Denby Dale <br>
                                                Huddersfield <br>
                                                HD8 8PR <br>
                                                AT Reg No: 721758725 <br>
                                            </span>
                                        </div>

                                        <div class="text-dark" style="display:flex;justify-content:space-between">
                                            <div style="font-weight:500">
                                                {{$customer->company_name}} <br>
                                                {{$customer->address_1}} <br>
                                                
                                                
                                                {{$customer->postcode}} <br>

                                                VAT Reg No: <br>
                                            </div>

                                            <div style="font-weight:500">
                                                <div class="mb-3">
                                                    <span class="fw-bold">Invoice No. </span> WGI-{{str_pad($invoice->id, 4, '0', STR_PAD_LEFT)}}
                                                </div>
                                                <div class="mb-3">
                                                    <span class="fw-bold">Invoice Date. </span>{{ date('d/m/Y', strtotime($invoice->created_at)) }}
                                                </div>
                                                <div class="mb-3">
                                                    <span class="fw-bold">Project ID. </span>WG-{{str_pad($project->id, 4, '0', STR_PAD_LEFT)}}
                                                </div>
                                                <div class="mb-3">
                                                    <span class="fw-bold">Cust Order No. </span> {{ $project->customer_ref }}
                                                </div>
                                                <div class="mb-3">
                                                    <span class="fw-bold">Account Ref. </span> {{ $customer->account_no }}
                                                </div>
                                            </div>

                                        </div>
                                        <!--begin::Message-->
                                        <!--begin::Separator-->
                                        <div class="separator"></div>
                                        @php
                                            $totalNet = 0;
                                            $totalVat = 0;
                                        @endphp
                                        @if($invoice->hide_items==0)
                                        <table class="table table-bordered" id="">
                                            <thead>
                                                <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                                    <th>Quantity</th>
                                                    <th>Details</th>
                                                    <th>Sales Net</th>
                                                    <th>VAT</th>
                                                    <th>Gross</th>
                                                </tr>
                                            </thead>
                                            <tbody class="text-gray-600 fw-semibold">
                                            
                                            @php $totalSales = 0; $totalVat = 0; @endphp
                                            
                                            @foreach($items as $item)
                                                <tr>
                                                    @php
                                                        $percentage = 20; // Percentage to calculate
                                                        
                                                        if($project->tender==0){
                                                            $plant = $item->plant*$item->quantity;
                                                            $labour = $item->labour*$item->quantity;
                                                            $material = $item->material*$item->quantity;
                                                            $sales_price = $plant+$labour+$material;
                                                        }else{
                                                            $sales_price = $item->sales_price*$item->quantity;
                                                        }
                                                        
                                                        $vat = ($sales_price) * ($percentage / 100);

                                                        $totalSales += $sales_price;
                                                        $totalVat += $vat;
                                                    @endphp
                                                    <td width="15%">{{ $item->quantity }}</td>
                                                    <td width="30%">{{ $item->description }}</td>
                                                    <td width="10%" class="price-column">£{{ number_format($sales_price, 2) }}</td>
                                                    <td width="10%" class="price-column">£{{ number_format($vat, 2) }}</td>
                                                    <td width="10%" class="price-column">£{{ number_format($sales_price+$vat, 2) }}</td>
                                                </tr>
                                                @endforeach

                                            </tbody>
                                        </table>
                                        @else
                                            <table class="table table-bordered" id="">
                                            <thead>
                                                <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                                    <th class="text-start">Details</th>
                                                    
                                                </tr>
                                            </thead>
                                            <tbody class="text-gray-600 fw-semibold">
                                                <td class="text-start">
                                                    {{$invoice->notes}}
                                                </td>

                                            </tbody>
                                        </table>
                                            
                                        @endif
                                        <div style="display:flex;justify-content:space-between">
                                            <div class="text-dark mb-3">
                                                <span style="font-weight:500">
                                                    Bank Details <br>
                                                    Handelsbanken <br>
                                                    Account: 25634001 <br>
                                                    S/C: 40-51-62 <br>
                                                    Payment Terms: Strictly 30 Day
                                                </span>
                                            </div>
                                            <div>
                                                <table class="price-table">
                                                    <tr>
                                                        <th>Total Net Amount</th>
                                                        <td>£{{ number_format($totalSales, 2) }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Total VAT Amount</th>
                                                        <td>£{{ number_format($totalVat, 2) }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Total Gross Amount</th>
                                                        <td>£{{ number_format($totalSales+$totalVat, 2) }}</td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>


                                    </div>
                                    <!--end::Wrapper-->
                                </div>
                                <!--end::Body-->
                                <!-- begin::Footer-->

                                <!-- end::Footer-->
                            </div>
                            <!-- end::Wrapper-->
                        </div>
                        <!-- end::Body-->
                    </div>
                    <div class="text-center mt-5 mb-5" >
                        <button id="'printButton" class="btn btn-primary" onclick="window.print()">Print</button>
                    </div>
                </div>
            </div>


        </div>
    </div>
    <!--end::Content-->
</div>


@endsection


@section('js')
<script>
    var table = $("#kt_table_users").DataTable({
        "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
        "paging": false, //Dont want paging                
        "bPaginate": false, //Dont want paging
    });

    $(".edit").click(function() {
        var id = $(this).data('id');
        var name = $(this).data('name');
        $("#e_name").val(name);
        $("#e_id").val(id);
        $("#editModal").modal("show");
    })

    $('#mySearch').on('input', function() {
        table.search($(this).val()).draw();
    })

</script>
@endsection
