@extends('layouts.app')
@section('title', 'Milestones | Project Details')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <style>
        .project-image {
            width: 100%;
            height: 428px;
            object-fit: cover;
        }

        iframe {
            width: 100% !important;
            height: 300px !important;
            margin: 0 !important;
            border-radius: 10px;
        }

        .nav-link {
            font-size: 18px;
            color: #5E5E5E;
        }

        .nav-pills .nav-link.active,
        .nav-pills .show>.nav-link {
            border: 1px solid #93D50066;
            background: white;
            color: black;
            font-weight: 500;
        }

        .page-heading {
            font-size: 24px !important;
        }

        .project-id {
            font-size: 18px;
            color: #556171 !important;
        }

        .form-check-input:checked {
            border-color: #93d500;
        }

    </style>
    @include('project.head')
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <div class="row align-items-center mb-7">
                <div class="col-md-12">
                    @include('project.nav')
                </div>

            </div>


            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif

            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif

            <div class="card mb-7">
                <div class="card-header " id="kt_chat_contacts_header">
                    <!--begin::Card title-->
                    <div class="card-title justify-content-between">
                        <i class="ki-outline ki-data fs-1 me-2"></i>
                        <h3 class="fw-bold">Milestones</h3>

                    </div>
                    <button style="display:none" data-bs-toggle="modal" data-bs-target="#kt_modal_new_target" class="btn btn-sm btn-primary align-self-center">Add Milestone</button>
                    <!--end::Card title-->
                </div>
                <div class="card-body">
                    <!--begin::Table container-->
                    <div class="table-responsive">
                        <!--begin::Table-->
                        <table class="table align-middle table-row-dashed fs-6 gy-5">
                            <!--begin::Table head-->
                            <thead>
                                <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                    <th class="ps-4 min-w-200px rounded-start">Milestone</th>
                                    <th class="min-w-125px">Date & Time</th>
                                    <th class="min-w-125px">Completed by</th>
                                </tr>
                            </thead>
                            <!--end::Table head-->
                            <!--begin::Table body-->
                            <tbody>
                                @foreach($milestones as $milestone)
                                <tr>
                                    <td>
                                        <div class="form-check @if($milestone->completed==0) markcomplete @endif" data-id="{{$milestone->milestone_id}}">
                                            <input @if($milestone->completed==1) checked disabled @endif class="form-check-input" type="checkbox" value="{{$milestone->milestone_id}}" id="flexCheckDefault_{{$milestone->id}}" />
                                            <label class="form-check-label text-dark fw-bold" for="flexCheckDefault_{{$milestone->id}}">
                                                {{$milestone->milestone_name}}
                                            </label>
                                        </div>
                                    </td>
                                    <td class="fw-bold">@if($milestone->completed==1) {{ date('F d, Y - h:ia', strtotime($milestone->completion_date)) }} @endif</td>
                                    <td class="fw-bold"> @if($milestone->completed==1) {{ $milestone->firstname }} {{ $milestone->lastname }} @endif</td>
                                </tr>
                                @endforeach
                            </tbody>
                            <!--end::Table body-->
                        </table>
                        <!--end::Table-->
                    </div>
                    <!--end::Table container-->
                </div>
            </div>

            @foreach($milestones as $milestone)
            @if($milestone->milestone_id==0)
            <div class="card mb-7">
                <div class="card-header " id="kt_chat_contacts_header">
                    <!--begin::Card title-->
                    <div class="card-title justify-content-between">

                        <h3 class="fw-bold">{{$milestone->milestone_name}}</h3>
                    </div>
                    <button onclick="$('#notes_{{$milestone->id}}').submit()" class="btn btn-sm btn-secondary align-self-center">Update</button>

                    <!--end::Card title-->
                </div>
                <div class="card-body">
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Notes</span>
                        </label>
                        <!--end::Label-->
                        <form action="{{route('project.updateMilestoneNotes')}}" method="post" id="notes_{{$milestone->id}}">
                            @csrf
                            <input type="hidden" name="milestone_id" value="{{$milestone->id}}">
                            <input type="hidden" name="project_id" value="{{$project->id}}">
                            <textarea name="notes" class="form-control" id="" cols="30" rows="5">{{$milestone->notes}}</textarea>
                        </form>
                    </div>
                </div>
            </div>
            @endif
            @endforeach

        </div>
    </div>
    <!--end::Content-->
</div>

<div class="modal fade" id="kt_modal_new_target" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('project.addMilestone', ['id'=>$project->id])}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add Milestones</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Select</span>
                        </label>
                        <!--end::Label-->
                        <select id="milestone_id" name="milestone_id" aria-label="Select" data-control="select2" data-placeholder="Select" class="form-select  form-select-lg fw-semibold">
                            <option value="">Select</option>
                            @foreach($project_milestones as $pm)
                            <option value="{{$pm->id}}">{{$pm->name}}</option>
                            @endforeach
                        </select>
                    </div>






                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Save Changes

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

<div class="modal fade" id="myModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-dialog-centered mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('project.completeMilestone')}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Milestone Completion</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <h3 class="text-danger text-center">Are you sure want to mark this milestone as completed?</h3>
                        <!--end::Label-->
                        <input type="hidden" id="milestone_c_id" name="milestone_id" style="display:none">
                        <input type="hidden" name="project_id" value="{{$project->id}}" style="display:none">

                    </div>






                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

@endsection


@section('js')
<script>
    $(".markcomplete").click(function() {
        var id = $(this).data('id');
        $("#milestone_c_id").val(id)
        $("#myModal").modal("show");
    });


    /*
var table = $("#kt_table_users").DataTable({
    "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
    "paging": false,//Dont want paging                
    "bPaginate": false,//Dont want paging
});

$('#mySearch').on('input', function() {
  table.search($(this).val()).draw();
})*/

</script>
@endsection
