@extends('layouts.app')
@section('title', 'Projects')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <!--begin::Toolbar-->
    <style>
        .card-body {
            padding: 10px !important;
        }

        .page-heading {
            font-size: 24px !important;
        }
        
        .bg-danger-2{
            background: #ffcccc;
            border-color: #ffcccc;
        }
        
        .bg-success-2{
            background: #D2EA8E;
        }
        
        .text-red{
            color: red !important;
        }
        
        .bg-danger-2 .text-gray-500{
            color: grey !important;
        }

    </style>
    <!--end::Toolbar-->
    <!--begin::Content-->

    <div id="kt_app_toolbar" class="app-toolbar pt-7 pt-lg-10">

        <!--begin::Toolbar container-->
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <!--begin::Toolbar wrapper-->
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <!--begin::Page title-->
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <!--begin::Title-->

                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">Projects</h1>
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                        <li class="breadcrumb-item text-muted">
                            <a href="#!" class="text-muted text-hover-primary">List of all projects</a>
                        </li>


                    </ul>
                </div>
                <div class="ms-3 float-end">
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addNewModal"><i class="ki-outline ki-plus-circle fs-2"></i> Add New Project</button>
                </div>
            </div>
            <!--end::Toolbar wrapper-->
        </div>
        <!--end::Toolbar container-->
    </div>
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            <div class="row g-5 g-xl-10 mb-xl-10">

                

                @if(session('success'))
                <div class="col-md-12">
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                </div>
                @endif
                
                @foreach($new_projects as $project)
                    @php
                        $currentDate = new \DateTime(date('Y-m-d'));
                        $upcomingDate = new \DateTime($project->end_date);
                        $interval = date_diff($currentDate, $upcomingDate);
                        $daysDifference = abs($interval->days);
                    @endphp
                    
                    <?php $isPast = $upcomingDate < $currentDate; ?>
                    
                <div class="col-md-4">
                    <!--begin::Card widget 14-->
                    <div class="card @if($daysDifference<1 || $isPast) bg-danger-2 @endif  card-flush h-xl-100">
                        <!--begin::Body-->
                        <div class="card-body text-center pb-5">
                            <!--begin::Overlay-->

                            <div class="d-flex align-items-end flex-stack mb-3">
                                <!--begin::Title-->
                                <div class="text-start">
                                    

                                    <span class="text-gray-800 mt-1 fw-bold fs-6">{{ $project->status }}</span>
                                </div>
                                <!--end::Title-->
                                <!--begin::Total-->
                                
                                @if(!$isPast)
                                <span class="text-gray-600 @if($daysDifference<1) text-red @endif text-end fw-bold fs-6">{{ $daysDifference }} {{ $daysDifference==1 ? 'day':'days' }} left</span>
                                @else
                                <span class="text-gray-600 text-red text-end fw-bold fs-6">{{ $daysDifference }} {{ $daysDifference==1 ? 'day':'days' }} ago</span>
                                @endif
                                
                                <!--end::Total-->
                            </div>
                            <div style="position:relative">
                            <span class="like" data-id="{{$project->id}}" style="position:absolute;z-index:3;right:10px;top:10px"><i id="heart_{{$project->id}}" class="@if($project->is_favorite==1) ki-solid @else ki-outline @endif ki-heart fs-2x text-primary"></i></span>
                            <span class="" data-id="{{$project->id}}" style="position:absolute;z-index:2;left:10px;bottom:10px"><span class="badge badge-light-success fs-base">
															{{$project->type}}</span></span>
                            <a class="d-block overlay" href="{{route('project.details', ['id' => $project->id])}}">
                                <!--begin::Image-->
                                <div class="overlay-wrapper bgi-no-repeat bgi-position-center bgi-size-cover card-rounded mb-7" style="height: 266px;background-image:url('{{asset('img/projects/'.$project->image)}}')"></div>
                                <!--end::Image-->
                                <!--begin::Action-->
                                <div class="overlay-layer card-rounded bg-dark bg-opacity-25">
                                    <i class="ki-outline ki-eye fs-3x text-white"></i>
                                </div>
                                <!--end::Action-->
                            </a></div>
                            <!--end::Overlay-->
                            <!--begin::Info-->
                            <div class="d-flex align-items-end flex-stack mb-1">
                                <!--begin::Title-->
                                <div class="text-start">
                                    <a href="{{route('project.details', ['id' => $project->id])}}"><span class="fw-bold text-gray-800 cursor-pointer text-hover-primary fs-4 d-block">{{ $project->title==""?'Untitled':$project->title }}</span></a>
                                    <div class="text-gray-500 mt-1 fw-bold fs-6">{{ $project->company_name }}</div>
                                    <div class="text-gray-500 mt-1 fw-bold fs-6">Project ID: WG-{{str_pad($project->id, 4, '0', STR_PAD_LEFT);}}</div>
                                </div>
                                <!--end::Title-->
                                <!--begin::Total-->
                                <span class="text-gray-600 text-end fw-bold fs-6">{{ date('jS M Y', strtotime($project->created_at)) }}</span>
                                <!--end::Total-->
                            </div>
                            <!--end::Info-->
                        </div>
                        <!--end::Body-->
                        <!--begin::Footer-->

                        <!--end::Footer-->
                    </div>
                    <!--end::Card widget 14-->
                </div>
                @endforeach

                @foreach($projects as $project)
                    @php
                        $currentDate = new \DateTime(date('Y-m-d'));
                        $upcomingDate = new \DateTime($project->end_date);
                        $interval = date_diff($currentDate, $upcomingDate);
                        $daysDifference = abs($interval->days);
                    @endphp
                    
                    <?php $isPast = $upcomingDate < $currentDate; ?>
                    
                <div class="col-md-4">
                    <!--begin::Card widget 14-->
                    <div class="card @if($daysDifference<1 || $isPast) bg-danger-2 @endif  card-flush h-xl-100">
                        <!--begin::Body-->
                        <div class="card-body text-center pb-5">
                            <!--begin::Overlay-->

                            <div class="d-flex align-items-end flex-stack mb-3">
                                <!--begin::Title-->
                                <div class="text-start">
                                    

                                    <span class="text-gray-800 mt-1 fw-bold fs-6">{{ $project->status }}</span>
                                </div>
                                <!--end::Title-->
                                <!--begin::Total-->
                                
                                @if(!$isPast)
                                <span class="text-gray-600 @if($daysDifference<1) text-red @endif text-end fw-bold fs-6">{{ $daysDifference }} {{ $daysDifference==1 ? 'day':'days' }} left</span>
                                @else
                                <span class="text-gray-600 text-red text-end fw-bold fs-6">{{ $daysDifference }} {{ $daysDifference==1 ? 'day':'days' }} ago</span>
                                @endif
                                
                                <!--end::Total-->
                            </div>
                            <div style="position:relative">
                            <span class="like" data-id="{{$project->id}}" style="position:absolute;z-index:3;right:10px;top:10px"><i id="heart_{{$project->id}}" class="@if($project->is_favorite==1) ki-solid @else ki-outline @endif ki-heart fs-2x text-primary"></i></span>
                            <span class="" data-id="{{$project->id}}" style="position:absolute;z-index:2;left:10px;bottom:10px"><span class="badge badge-light-success fs-base">
															{{$project->type}}</span></span>
                            <a class="d-block overlay" href="{{route('project.details', ['id' => $project->id])}}">
                                <!--begin::Image-->
                                <div class="overlay-wrapper bgi-no-repeat bgi-position-center bgi-size-cover card-rounded mb-7" style="height: 266px;background-image:url('{{asset('img/projects/'.$project->image)}}')"></div>
                                <!--end::Image-->
                                <!--begin::Action-->
                                <div class="overlay-layer card-rounded bg-dark bg-opacity-25">
                                    <i class="ki-outline ki-eye fs-3x text-white"></i>
                                </div>
                                <!--end::Action-->
                            </a></div>
                            <!--end::Overlay-->
                            <!--begin::Info-->
                            <div class="d-flex align-items-end flex-stack mb-1">
                                <!--begin::Title-->
                                <div class="text-start">
                                    <a href="{{route('project.details', ['id' => $project->id])}}"><span class="fw-bold text-gray-800 cursor-pointer text-hover-primary fs-4 d-block">{{ $project->title }}</span></a>
                                    <span class="text-gray-500 mt-1 fw-bold fs-6">Project ID: WG-{{str_pad($project->id, 4, '0', STR_PAD_LEFT);}}</span>
                                </div>
                                <!--end::Title-->
                                <!--begin::Total-->
                                <span class="text-gray-600 text-end fw-bold fs-6">{{ date('jS M Y', strtotime($project->created_at)) }}</span>
                                <!--end::Total-->
                            </div>
                            <!--end::Info-->
                        </div>
                        <!--end::Body-->
                        <!--begin::Footer-->

                        <!--end::Footer-->
                    </div>
                    <!--end::Card widget 14-->
                </div>
                @endforeach
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>


<div class="modal fade" id="addNewModal" >
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-dialog-centered mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body  px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('project.addNewProject')}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add New Project</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="row mb-8">
                        
                        
                    </div>
                    <div class="row mb-8">
                        <div class="col-md-12">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Project Title</span>
                            </label>
                            <!--end::Label-->
                            <input type="text" class="form-control" required name="title">
                        </div>
                    </div>
                    <div class="row mb-8">
                        <div class="col-md-12">
                            <label class="form-check form-switch form-check-custom form-check-solid" id="showSiteManagers">
                                <input class="form-check-input w-30px h-20px" type="checkbox" value="1" name="tenderProject" id="siteManagers">
                                <span class="form-check-label text-muted fs-7">Tender Project</span>
                            </label>
                        </div>
                    </div>
                    <div class="row mb-8">
                        <div class="col-md-6">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Project Type</span>
                            </label>
                            <!--end::Label-->
                            <select required id="project_type" name="project_type" data-placeholder="Select Project Type" class="form-select">
                                <option value="">Select Project Type</option>
                                @foreach($project_types as $type)
                                <option value="{{$type->id}}">{{$type->name}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Select Client</span>
                            </label>
                            <!--end::Label-->
                            <select required id="customer" name="customer_id" class="form-select  form-select-lg fw-semibold" data-placeholder="Select Client">
                                <option value="">Select</option>
                                @foreach($customers as $customer)
                                <option value="{{$customer->id}}">{{$customer->company_name}}</option>
                                @endforeach
                            </select>
                        </div>
                        
                    </div>

                    <div class="row mb-8">
                        <div class="col-md-6">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="">Client Ref</span>
                            </label>
                            <!--end::Label-->
                            <input type="text" class="form-control " placeholder="Enter Client Ref" name="customer_ref" />
                        </div>
                        <div class="col-md-6">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Status</span>
                            </label>
                            <!--end::Label-->
                            <select required id="project_status" name="project_status" class="form-select  form-select-lg fw-semibold">
                                
                                @foreach($statusses as $status)
                                <option @if($status->id==1) selected @endif value="{{$status->id}}">{{$status->name}}</option>
                                @endforeach
                            </select>
                        </div>
                        
                    </div>

                    <div class="row mb-8">
                       <div class="col-md-6">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Contact Name</span>
                            </label>
                            <!--end::Label-->
                            <input required type="text" class="form-control " placeholder="Enter Name" name="name" />
                        </div>
                        <div class="col-md-6">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Contact Email</span>
                            </label>
                            <!--end::Label-->
                            <input required type="email" class="form-control " placeholder="Enter Email" name="email" />
                        </div>
                        
                    </div>
                    <div class="row mb-8">
                        <div class="col-md-6">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="">Contact Phone</span>
                            </label>
                            <!--end::Label-->
                            <input type="text" class="form-control " placeholder="Enter Phone" name="phone" />
                        </div>
                    </div>
                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-secondary me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

@endsection

@section('js')
<script>
    
toastr.options = {
  "closeButton": false,
  "debug": false,
  "newestOnTop": false,
  "progressBar": false,
  "positionClass": "toastr-top-right",
  "preventDuplicates": false,
  "onclick": null,
  "showDuration": "300",
  "hideDuration": "1000",
  "timeOut": "5000",
  "extendedTimeOut": "1000",
  "showEasing": "swing",
  "hideEasing": "linear",
  "showMethod": "fadeIn",
  "hideMethod": "fadeOut"
};

$(document).ready(function() {
  $("#project_status, #customer, #project_type").select2({
      dropdownParent: $("#addNewModal .modal-content"),
      placeholder: "Select",
  });
});
    
$(document).ready(function(){
        $('.like').click(function(){
            var id = $(this).data('id');
            
            $.ajax({
                url: "{{ route('project.addToFavourites') }}",
                type: 'POST',
                data: {
                    project_id: id,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response){
                    if(response.success){
                        toastr.success(response.message);
                        if(response.status==1){
                            $("#heart_"+id).removeClass('ki-outline').addClass('ki-solid');
                        }else{
                            $("#heart_"+id).removeClass('ki-solid').addClass('ki-outline');
                        }
                    } else {
                        alert('Something went wrong.');
                    }
                },
                error: function(response){
                    alert('Error: ' + response.responseJSON.message);
                }
            });
        });
    });
</script>
@endsection
